/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.evaluation;

import com.mathworks.jmi.diagnostic.IssuedWarningEvent;
import com.mathworks.mde.embeddedoutputs.OutputDataType;
import com.mathworks.mde.embeddedoutputs.outputhandlers.TextOutputData;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.eventmgr.MvmListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class OutputEventSupport {
    private final MvmListener fWarningEventListener = this.createWarningEventListener();
    private final List<OutputDataType> fWarningsList = new ArrayList<OutputDataType>();
    private final MVM fMVM;

    public OutputEventSupport(MVM mVM) {
        this.fMVM = mVM;
        this.fMVM.getEventMgr().addMvmListener(this.fWarningEventListener, IssuedWarningEvent.class);
    }

    private MvmListener createWarningEventListener() {
        return new MvmListener<IssuedWarningEvent>(){

            public void mvmChanged(IssuedWarningEvent issuedWarningEvent) {
                if (issuedWarningEvent.getWarning().getWasDisabled()) {
                    return;
                }
                String string = issuedWarningEvent.getWarning().getMessage();
                OutputEventSupport.this.fWarningsList.add(new OutputDataType("warning", new TextOutputData(string)));
            }
        };
    }

    public List<OutputDataType> getOutputs() {
        return Collections.unmodifiableList(this.fWarningsList);
    }

    public void dispose() {
        this.fMVM.getEventMgr().removeMvmListener(this.fWarningEventListener, IssuedWarningEvent.class);
        this.fWarningsList.clear();
    }
}

