/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.find;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.mde.find.FileExtensionFilter;
import com.mathworks.mde.find.FindFilesPrefs;
import com.mathworks.mde.find.FindResultsPanel;
import com.mathworks.mde.find.Grep;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import org.jetbrains.annotations.Nullable;

public final class FindFiles
extends MJFrame {
    static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.find.resources.RES_FindFiles");
    private static final String CURRENT_DIRECTORY = sRes.getString("filter.CurrentDirectory");
    private static final String EDITOR_CURRENT_FILE = sRes.getString("filter.EditorCurrentFile");
    private static final String EDITOR_ALL_OPEN_FILES = sRes.getString("filter.EditorAllOpenFiles");
    private static final String MATLAB_PATH = sRes.getString("filter.EntireMATLABPath");
    private static final String BROWSE = sRes.getString("filter.Browse");
    private static final String MAX_TABS = "MaxTabs";
    private static final String FIND_PREFS = "FindFiles";
    private static FindFiles sFindFiles;
    private static MyCheckbox sPathNamesCheckbox;
    private static String sCurrentEditorFile;
    private static MJComboBox sLookInComboBox;
    private static Color sBackgroundColor;
    private static Color sForegroundColor;
    private static Font sTextFont;
    private static boolean sTesting;
    private MJComboBox fFilesNamedCombo;
    private MJComboBox fFilesContainingCombo;
    private MJCheckBox fSubDirCheckbox;
    private MJCheckBox fCaseCheckbox;
    private MJComboBox fFileTypeCombo;
    private MJComboBox fSearchTypeCombo;
    private MJLabel fFileTypeLabel;
    private MJTabbedPane fTabbedPane;
    private Matlab fMatlab;
    private FindResultsPanel fResultsPanel;
    private MJPanel fRightPanel;
    private FindResultsPanel fEmptyPanel;
    private MJButton fXButton;
    private MJButton fFindButton;
    private MJButton fCloseButton;
    private MJButton fCloseAllButton;
    private MJButton fHelpButton;
    private MJButton fClearTextButton;
    private StopAction fStopFindAction;
    private FindAction fStartFindAction;
    private MJCheckBox fExcludeExtCheck;
    private MJButton fEditExtButton;
    private MJCheckBox fFileSizeCheck;
    private MJFormattedTextField fFileSizeLimitField;
    private MJLabel fFileSizeLimitLabel;
    private static RemoveTabAction sRemoveTabAction;
    private int fNumHits;
    private int fMaxTabs;
    private Thread fFindThread;
    private boolean fThreadInProgress = false;
    private boolean fInterruptFind = false;
    private String fFindString;
    private String fTabString;
    private String fNameString;
    private String fCurrentMatlabDir;
    private int fLookInCurrentItem;
    private int fTypeCurrentItem;
    private boolean fFindFileNameOnly = false;
    private Vector<Object> fDirListSearched;
    private FileExtensionFilter fExtFilter;
    private Collection<String> fCurrentExclusions;
    private Grep fGrep = null;
    private MJPopupMenu fPopupMenu;
    private CloseTabsAction fCloseTabsAction;
    private EditorApplicationListener fEditorApplicationListener = FindFiles.createMLEditorApplicationListener();

    public FindFiles() {
        Object object;
        Object object2;
        MaskFormatter maskFormatter;
        Accessible accessible;
        AccessibleContext accessibleContext;
        Object object3;
        Accessible accessible2;
        Object object4;
        Object object5;
        Object object6;
        if (sFindFiles == null) {
            this.fMatlab = new Matlab();
            sFindFiles = this;
        }
        this.setTitle(sRes.getString("title.FindFiles"));
        this.setName("FindFilesFrame");
        this.getAccessibleContext().setAccessibleName(sRes.getString("title.FindFiles"));
        this.fRightPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fRightPanel.setName("RightSidePanel");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setName("LeftSidePanel");
        MJSplitPane mJSplitPane = new MJSplitPane(1, (Component)mJPanel, (Component)this.fRightPanel);
        mJSplitPane.setName("Splitpane");
        MJLabel mJLabel = new MJLabel(sRes.getString("label.FindFileNamed"));
        MJLabel mJLabel2 = new MJLabel(sRes.getString("label.Findwhat"));
        MJLabel mJLabel3 = new MJLabel(sRes.getString("label.Lookin"));
        this.fFilesNamedCombo = new MJComboBox();
        this.fFilesNamedCombo.getEditor().getEditorComponent().addKeyListener(new FileNameKeyListener());
        this.fFilesNamedCombo.addItemListener((ItemListener)new MyItemChangedListener());
        this.fFilesNamedCombo.setEditable(true);
        this.fFilesNamedCombo.setName("FindFilesNamedCombo");
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fFilesNamedCombo, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        Component component = this.fFilesNamedCombo.getEditor().getEditorComponent();
        if (component instanceof Accessible && (object6 = (object5 = (Accessible)((Object)component)).getAccessibleContext()) != null) {
            ((AccessibleContext)object6).setAccessibleName(sRes.getString("acc.FindFileNamed"));
        }
        this.fFilesContainingCombo = new MJComboBox();
        object5 = new FileNameKeyListener();
        this.fFilesContainingCombo.getEditor().getEditorComponent().addKeyListener((KeyListener)object5);
        this.fFilesContainingCombo.setEditable(true);
        this.fFilesContainingCombo.addItemListener((ItemListener)new MyContainsItemChangedListener());
        this.fFilesContainingCombo.setName("FindFilesContainingCombo");
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fFilesContainingCombo, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        this.fFilesNamedCombo.setName("FindFilesNamedCombo");
        object6 = this.fFilesContainingCombo.getEditor().getEditorComponent();
        if (object6 instanceof Accessible && (object4 = (accessible2 = (Accessible)object6).getAccessibleContext()) != null) {
            ((AccessibleContext)object4).setAccessibleName(sRes.getString("acc.Findwhat"));
        }
        sLookInComboBox = new MJComboBox();
        sLookInComboBox.setPrototypeDisplayValue((Object)StringUtils.repeat((String)"a", (int)18));
        int n = 0;
        if (!MLEditorServices.getEditorApplication().getOpenEditors().isEmpty() && !sTesting) {
            if (Matlab.isMatlabAvailable()) {
                sLookInComboBox.insertItemAt((Object)CURRENT_DIRECTORY, n++);
            }
            sLookInComboBox.insertItemAt((Object)EDITOR_CURRENT_FILE, n++);
            sLookInComboBox.insertItemAt((Object)EDITOR_ALL_OPEN_FILES, n++);
            if (Matlab.isMatlabAvailable()) {
                sLookInComboBox.insertItemAt((Object)MATLAB_PATH, n++);
            }
        } else if (Matlab.isMatlabAvailable() || sTesting) {
            sLookInComboBox.insertItemAt((Object)CURRENT_DIRECTORY, n++);
            sLookInComboBox.insertItemAt((Object)MATLAB_PATH, n++);
        }
        sLookInComboBox.insertItemAt((Object)BROWSE, n++);
        object4 = FindFilesPrefs.getUserLookins();
        String string = "";
        if (object4 != null) {
            int n2;
            for (int i = n2 = ((String[])(object3 = StringUtils.stringToArray((String)object4, (String)"\t"))).length > 8 ? ((String[])object3).length - 8 : 0; i < ((String[])object3).length; ++i) {
                sLookInComboBox.insertItemAt((Object)object3[i], n++);
                string = string.concat(object3[i] + "\t");
            }
        }
        FindFilesPrefs.setUserLookins(string);
        if (PlatformInfo.isMacintosh()) {
            sLookInComboBox.addItemListener((ItemListener)new LookInListener());
        }
        sLookInComboBox.addMouseListener((MouseListener)new LookInListener());
        sLookInComboBox.getEditor().getEditorComponent().addFocusListener(new LookInFocusAdapter());
        sLookInComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                FindFiles.this.lookInEvent();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        sLookInComboBox.getEditor().getEditorComponent().addKeyListener(new FileNameKeyListener());
        sLookInComboBox.setEditable(true);
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)sLookInComboBox, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        sLookInComboBox.setName("LookinCombo");
        object3 = sLookInComboBox.getEditor().getEditorComponent();
        if (object3 instanceof Accessible && (accessibleContext = (accessible = (Accessible)object3).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleName(sRes.getString("acc.Lookin"));
        }
        sLookInComboBox.setLightWeightPopupEnabled(true);
        sLookInComboBox.setSelectedIndex(0);
        this.fSubDirCheckbox = new MJCheckBox(sRes.getString("option.Subdirectories"));
        this.fSubDirCheckbox.setName("ShowSubdirsCheckbox");
        this.fSubDirCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("option.Subdirectories"));
        this.fSubDirCheckbox.setSelected(FindFilesPrefs.isSearchSubdirs());
        sPathNamesCheckbox = new MyCheckbox(sRes.getString("option.ShowFullPathnames"));
        sPathNamesCheckbox.addActionListener(new ShowPathNamesListener());
        sPathNamesCheckbox.setName("ShowFullPathNamesCheckbox");
        sPathNamesCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("option.ShowFullPathnames"));
        sPathNamesCheckbox.setSelected(FindFilesPrefs.isShowFullPath());
        this.fStopFindAction = new StopAction();
        this.fStartFindAction = new FindAction();
        this.fFindButton = new MJButton((Action)this.fStartFindAction);
        this.fFindButton.setName("FindButton");
        this.fFindButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.Find"));
        this.fFindButton.setEnabled(false);
        this.fFileSizeCheck = new MJCheckBox(sRes.getString("check.fileSize"));
        this.fFileSizeCheck.setEnabled(false);
        this.fFileSizeCheck.setName("fileSizeCheckbox");
        this.fFileSizeCheck.getAccessibleContext().setAccessibleName(sRes.getString("check.fileSize"));
        this.fFileSizeLimitLabel = new MJLabel("MB");
        try {
            maskFormatter = new MaskFormatter("#####");
            maskFormatter.setValidCharacters("0123456789");
            this.fFileSizeLimitField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)maskFormatter);
        }
        catch (ParseException parseException) {
            this.fFileSizeLimitField = new MJFormattedTextField();
        }
        this.fFileSizeLimitField.setFocusLostBehavior(0);
        this.fFileSizeLimitField.setColumns(5);
        this.fFileSizeLimitField.setText(String.valueOf(FindFilesPrefs.getMaxFileSize()));
        this.fFileSizeLimitField.setName("FileSizeField");
        this.fFileSizeLimitField.getAccessibleContext().setAccessibleName(sRes.getString("acc.FileSizeLimitField"));
        this.fFileSizeLimitLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.fFileSizeCheck.addActionListener((ActionListener)new FileSizeCheckboxList());
        this.fFileSizeCheck.setSelected(FindFilesPrefs.isFileSizeState());
        this.fFileSizeLimitField.setEnabled(FindFilesPrefs.isFileSizeState());
        maskFormatter = new MJPanel((LayoutManager)new BorderLayout());
        maskFormatter.add((Component)this.fFileSizeCheck, "West");
        maskFormatter.add((Component)this.fFileSizeLimitField, "Center");
        maskFormatter.add((Component)this.fFileSizeLimitLabel, "East");
        this.fFileTypeLabel = new MJLabel(sRes.getString("label.FileTypeLabel"));
        this.fFileTypeLabel.setName("FileTypeLabel");
        MJLabel mJLabel4 = new MJLabel(sRes.getString("label.SearchTypeLabel"));
        Object[] objectArray = StringUtils.stringToArray((String)FindFilesPrefs.getFilters(), (String)"\t");
        if (objectArray[0].equals("*")) {
            objectArray[0] = sRes.getString("filter.AllFiles");
        }
        this.fFileTypeCombo = new MJComboBox(objectArray);
        this.fFileTypeCombo.setSelectedItem((Object)0);
        this.fTypeCurrentItem = this.fFileTypeCombo.getSelectedIndex();
        ((JTextComponent)this.fFilesContainingCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FindFiles.this.enableDisableFindClear();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FindFiles.this.enableDisableFindClear();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FindFiles.this.enableDisableFindClear();
            }
        });
        this.fFileTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FindFiles.this.enableDisableExclusions();
                if (FindFiles.this.fFileTypeCombo.getSelectedItem().toString().isEmpty()) {
                    FindFiles.this.fFileTypeCombo.setSelectedIndex(FindFiles.this.fTypeCurrentItem);
                } else if (FindFiles.this.fFileTypeCombo.getSelectedIndex() != -1) {
                    FindFiles.this.fTypeCurrentItem = FindFiles.this.fFileTypeCombo.getSelectedIndex();
                }
                FindFiles.this.enableDisableFindClear();
            }
        });
        this.fFileTypeCombo.getEditor().getEditorComponent().addKeyListener((KeyListener)object5);
        this.fFileTypeCombo.setName("FileTypeCombo");
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fFileTypeCombo, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        Component component2 = this.fFileTypeCombo.getEditor().getEditorComponent();
        if (component2 instanceof Accessible && (object2 = (object = (Accessible)((Object)component2)).getAccessibleContext()) != null) {
            ((AccessibleContext)object2).setAccessibleName(sRes.getString("label.FileTypeLabel"));
        }
        this.fFileTypeCombo.setEditable(true);
        this.fExcludeExtCheck = new MJCheckBox(sRes.getString("check.excludeExt"));
        this.fExcludeExtCheck.setSelected(FindFilesPrefs.isExclusionState());
        this.fExcludeExtCheck.setToolTipText(sRes.getString("check.excludeExtTooltip"));
        this.fExcludeExtCheck.setName("FileExclusionCheckbox");
        this.fExcludeExtCheck.getAccessibleContext().setAccessibleName(sRes.getString("check.excludeExtTooltip"));
        this.fEditExtButton = new MJButton((Action)((Object)new EditExclusionsAction()));
        this.fEditExtButton.setName("FileExclusionEditButton");
        this.fEditExtButton.setToolTipText(null);
        this.fEditExtButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.editExclusions"));
        this.fExcludeExtCheck.addActionListener((ActionListener)new ExclusionCheckboxList());
        this.enableDisableExclusions();
        this.fClearTextButton = new MJButton((Action)new ClearAction());
        this.fClearTextButton.setName("ClearButton");
        this.fClearTextButton.getAccessibleContext().setAccessibleName(sRes.getString("button.Clear"));
        this.fClearTextButton.setEnabled(false);
        object = new GridBagLayout();
        object2 = new GridBagConstraints();
        MJPanel mJPanel2 = new MJPanel((LayoutManager)object);
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).insets = new Insets(2, 2, 2, 2);
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)object).setConstraints((Component)mJLabel, (GridBagConstraints)object2);
        mJPanel2.add((Component)mJLabel);
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagLayout)object).setConstraints((Component)this.fFilesNamedCombo, (GridBagConstraints)object2);
        mJPanel2.add((Component)this.fFilesNamedCombo);
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagLayout)object).setConstraints((Component)mJLabel2, (GridBagConstraints)object2);
        mJPanel2.add((Component)mJLabel2);
        ((GridBagConstraints)object2).gridy = 3;
        ((GridBagLayout)object).setConstraints((Component)this.fFilesContainingCombo, (GridBagConstraints)object2);
        mJPanel2.add((Component)this.fFilesContainingCombo);
        ((GridBagConstraints)object2).gridy = 6;
        ((GridBagLayout)object).setConstraints((Component)mJLabel3, (GridBagConstraints)object2);
        mJPanel2.add((Component)mJLabel3);
        ((GridBagConstraints)object2).gridy = 7;
        ((GridBagLayout)object).setConstraints((Component)sLookInComboBox, (GridBagConstraints)object2);
        mJPanel2.add((Component)sLookInComboBox);
        ((GridBagConstraints)object2).gridy = 8;
        ((GridBagConstraints)object2).insets = new Insets(0, 10, 2, 2);
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagLayout)object).setConstraints((Component)this.fSubDirCheckbox, (GridBagConstraints)object2);
        mJPanel2.add((Component)this.fSubDirCheckbox);
        ((GridBagConstraints)object2).insets = new Insets(2, 2, 0, 2);
        ((GridBagConstraints)object2).gridy = 4;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)object).setConstraints((Component)this.fFileTypeLabel, (GridBagConstraints)object2);
        mJPanel2.add((Component)this.fFileTypeLabel);
        ((GridBagConstraints)object2).gridy = 5;
        ((GridBagLayout)object).setConstraints((Component)this.fFileTypeCombo, (GridBagConstraints)object2);
        mJPanel2.add((Component)this.fFileTypeCombo);
        ((GridBagConstraints)object2).insets = new Insets(2, 2, 2, 2);
        ((GridBagConstraints)object2).anchor = 10;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).gridy = 9;
        ((GridBagConstraints)object2).weightx = 2.0;
        ((GridBagConstraints)object2).weighty = 2.0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        MJPanel mJPanel3 = new MJPanel((LayoutManager)gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints((Component)this.fFindButton, gridBagConstraints);
        mJPanel3.add((Component)this.fFindButton);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints((Component)this.fClearTextButton, gridBagConstraints);
        mJPanel3.add((Component)this.fClearTextButton);
        ((GridBagLayout)object).setConstraints((Component)mJPanel3, (GridBagConstraints)object2);
        mJPanel2.add((Component)mJPanel3);
        mJPanel.add((Component)mJPanel2, (Object)"North");
        MJPanel mJPanel4 = new MJPanel((LayoutManager)object);
        this.fSearchTypeCombo = new MJComboBox((Object[])new String[]{sRes.getString("searchType.ContainsWord"), sRes.getString("searchType.MatchWholeWord")});
        this.fSearchTypeCombo.setName("SearchTypeCombo");
        this.fSearchTypeCombo.setSelectedIndex(FindFilesPrefs.getSearchType());
        this.fSearchTypeCombo.getAccessibleContext().setAccessibleName(sRes.getString("label.SearchTypeLabel"));
        this.fCaseCheckbox = new MJCheckBox(sRes.getString("option.Matchcase"));
        this.fCaseCheckbox.setName("MatchCaseCheckbox");
        this.fCaseCheckbox.setSelected(FindFilesPrefs.isMatchCase());
        this.fCaseCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("option.Matchcase"));
        ((GridBagConstraints)object2).gridwidth = 2;
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagLayout)object).setConstraints((Component)((Object)maskFormatter), (GridBagConstraints)object2);
        mJPanel4.add((Component)((Object)maskFormatter));
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = new Insets(2, 5, 2, 5);
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagLayout)object).setConstraints((Component)mJLabel4, (GridBagConstraints)object2);
        mJPanel4.add((Component)mJLabel4);
        ((GridBagConstraints)object2).gridy = 3;
        ((GridBagLayout)object).setConstraints((Component)this.fSearchTypeCombo, (GridBagConstraints)object2);
        mJPanel4.add((Component)this.fSearchTypeCombo);
        ((GridBagConstraints)object2).insets = new Insets(2, 0, 2, 5);
        ((GridBagConstraints)object2).gridy = 4;
        ((GridBagLayout)object).setConstraints((Component)this.fCaseCheckbox, (GridBagConstraints)object2);
        mJPanel4.add((Component)this.fCaseCheckbox);
        mJPanel4.setName("AdvancedPanel");
        ((GridBagConstraints)object2).gridy = 5;
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridwidth = 1;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagLayout)object).setConstraints((Component)this.fExcludeExtCheck, (GridBagConstraints)object2);
        mJPanel4.add((Component)this.fExcludeExtCheck);
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).gridy = 5;
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagLayout)object).setConstraints((Component)this.fEditExtButton, (GridBagConstraints)object2);
        mJPanel4.add((Component)this.fEditExtButton);
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new BorderLayout());
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel6.setName("EtchedPanel");
        mJPanel6.setBorder((Border)BorderFactory.createTitledBorder(null, sRes.getString("title.panelTitle"), 1, 2));
        mJPanel6.add((Component)mJPanel4, (Object)"Center");
        MJPanel mJPanel7 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel7.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        mJPanel7.add((Component)mJPanel6, (Object)"Center");
        mJPanel7.setName("OptionsPanel");
        mJPanel5.add((Component)mJPanel7);
        mJPanel.add((Component)mJPanel5, (Object)"South");
        mJPanel.repaint();
        FindColorListener findColorListener = new FindColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)findColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)findColorListener);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        MJPanel mJPanel8 = new MJPanel((LayoutManager)gridBagLayout2);
        sRemoveTabAction = new RemoveTabAction();
        this.fXButton = new MJButton((Action)((Object)sRemoveTabAction));
        this.fXButton.setDefaultCapable(false);
        if (PlatformInfo.isWindows()) {
            this.fXButton.setPreferredSize(new Dimension(12, 12));
        }
        this.fXButton.setEnabled(false);
        this.fXButton.setName("xButton");
        this.fXButton.getAccessibleContext().setAccessibleName(sRes.getString("button.ClosePanel"));
        this.fXButton.setFlyOverAppearance(true);
        gridBagConstraints2.weightx = 2.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 12;
        mJPanel8.add((Component)this.fXButton, (Object)gridBagConstraints2);
        this.fTabbedPane = new MJTabbedPane(3);
        this.fTabbedPane.setName("TabbedPane");
        this.fTabbedPane.getAccessibleContext().setAccessibleName(sRes.getString("acc.ResultsTabbedPane"));
        this.fTabbedPane.addMouseListener((MouseListener)new MouseTabListener());
        this.fEmptyPanel = new FindResultsPanel(false);
        this.fEmptyPanel.setName("EmptyResultsPanel");
        this.fEmptyPanel.getAccessibleContext().setAccessibleName(sRes.getString("acc.Empty"));
        this.fRightPanel.add((Component)mJPanel8, (Object)"North");
        this.fEmptyPanel.setPreferredSize(new Dimension(400, 100));
        this.fRightPanel.add((Component)((Object)this.fEmptyPanel), (Object)"Center");
        MJPanel mJPanel9 = new MJPanel((LayoutManager)new BorderLayout());
        MJPanel mJPanel10 = new MJPanel((LayoutManager)new FlowLayout(2));
        mJPanel9.add((Component)((Object)sPathNamesCheckbox), (Object)"West");
        this.fCloseButton = new MJButton((Action)new CloseAction());
        this.fCloseButton.setName("CloseButton");
        this.fCloseTabsAction = new CloseTabsAction();
        this.fCloseAllButton = new MJButton((Action)this.fCloseTabsAction);
        this.fCloseAllButton.getAccessibleContext().setAccessibleName(sRes.getString("button.CloseResults"));
        this.fCloseAllButton.setName("CloseTabsButton");
        this.fCloseAllButton.setEnabled(false);
        this.fCloseButton.getAccessibleContext().setAccessibleName(sRes.getString("button.Close"));
        mJPanel10.add((Component)this.fCloseAllButton);
        mJPanel10.add((Component)this.fCloseButton);
        this.fHelpButton = new MJButton((Action)new HelpAction());
        this.fHelpButton.setName("HelpButton");
        this.fHelpButton.getAccessibleContext().setAccessibleName(sRes.getString("button.Help"));
        mJPanel10.add((Component)this.fHelpButton);
        mJPanel9.setBorder(BorderFactory.createEtchedBorder());
        mJPanel9.add((Component)mJPanel10, (Object)"East");
        this.fRightPanel.add((Component)mJPanel9, (Object)"South");
        this.getContentPane().add((Component)mJSplitPane);
        sTextFont = FontPrefs.getTextFont();
        this.setTextColor();
        this.setBackgroundColor();
        this.addWindowListener(new WindowCloseListener());
        MyFontListener myFontListener = new MyFontListener();
        FontPrefs.addTextFontListener((FontListener)myFontListener);
        this.fMaxTabs = Prefs.getIntegerPref((String)"FindFilesMaxTabs", (int)10);
        this.createPopupMenu();
        MyFocusTraversalPolicy myFocusTraversalPolicy = new MyFocusTraversalPolicy();
        myFocusTraversalPolicy.populateTraversalItems();
        this.setFocusTraversalPolicy(myFocusTraversalPolicy);
    }

    private void enableDisableExclusions() {
        boolean bl;
        String string = this.fFilesNamedCombo.getEditor().getItem().toString();
        boolean bl2 = bl = string.contains("*.") && !string.equals("*.*");
        if (!bl) {
            boolean bl3 = bl = this.fFileTypeCombo.getEditor().getItem().toString().contains("*.") && !this.isFileTypeAll();
        }
        if (!bl) {
            this.fExcludeExtCheck.setEnabled(true);
            this.fEditExtButton.setEnabled(this.fExcludeExtCheck.isSelected());
        } else {
            this.fExcludeExtCheck.setEnabled(false);
            this.fEditExtButton.setEnabled(false);
        }
    }

    public static void invoke() {
        FindFiles.invoke(null, null);
    }

    public static void invoke(final String string, final String string2, final @Nullable String string3) {
        if (SwingUtilities.isEventDispatchThread()) {
            boolean bl;
            boolean bl2 = bl = sFindFiles == null;
            if (sFindFiles == null) {
                new FindFiles();
            }
            if (sFindFiles.isVisible()) {
                FindFiles.setComboBoxValues(string, string2);
                if (string3 != null) {
                    sLookInComboBox.setSelectedItem((Object)string3);
                }
                sFindFiles.toFront();
            } else {
                MLEditorServices.getEditorApplication().addEditorApplicationListener(sFindFiles.getEditorApplicationListener());
                FindFiles.adjustEditorLookIns();
                FindFiles.setComboBoxValues(string, string2);
                if (bl) {
                    sFindFiles.pack();
                    sFindFiles.setMinimumSize(sFindFiles.getSize());
                    if (FindFilesPrefs.getWindowSize() != null) {
                        sFindFiles.setSize(new Dimension(FindFilesPrefs.getWindowSize().width, FindFilesPrefs.getWindowSize().height));
                    }
                    Point point = new Point(FindFilesPrefs.getWindowLoc().width, FindFilesPrefs.getWindowLoc().height);
                    sFindFiles.setLocation(WindowUtils.ensureOnScreen((Rectangle)WindowUtils.getVirtualScreenBounds(), (Point)point, (Dimension)sFindFiles.getSize(), (int)10));
                } else {
                    sFindFiles.setLocation(WindowUtils.ensureOnScreen((Rectangle)WindowUtils.getVirtualScreenBounds(), (Point)sFindFiles.getLocation(), (Dimension)sFindFiles.getSize(), (int)10));
                }
                if (string2 != null) {
                    FindFiles.sFindFiles.fFilesContainingCombo.getEditor().selectAll();
                }
                sFindFiles.enableDisableFindClear();
                FindFiles.sFindFiles.fFilesNamedCombo.requestFocus();
                if (string3 != null) {
                    sLookInComboBox.setSelectedItem((Object)string3);
                }
                sFindFiles.setVisible(true);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.invoke(string, string2, string3);
                }
            });
        }
    }

    private static void invoke(@Nullable String string, @Nullable String string2) {
        FindFiles.invoke(string, string2, null);
    }

    public static void invoke(String string) {
        FindFiles.invoke(null, string);
    }

    private static void setComboBoxValues(String string, String string2) {
        if (string == null && string2 == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (string != null) {
                FindFiles.sFindFiles.fFilesNamedCombo.setSelectedItem((Object)string);
            }
            if (string2 != null) {
                FindFiles.sFindFiles.fFilesContainingCombo.setSelectedItem((Object)FindFiles.formatSearchString(string2));
            }
        } else {
            final String string3 = string;
            final String string4 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.setComboBoxValues(string3, string4);
                }
            });
        }
    }

    private static String formatSearchString(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            if (stringTokenizer.hasMoreTokens()) {
                return stringTokenizer.nextToken();
            }
            return null;
        }
        return string;
    }

    private boolean isFileNameSearchOnly() {
        String string = this.fFilesContainingCombo.getEditor().getItem().toString();
        return string == null || string.isEmpty();
    }

    private static String fixFindString(String string) {
        String string2 = StringUtils.replaceAllStrings((String)string, (String)"\\", (String)"\\\\");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)".", (String)"\\.");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"?", (String)"\\?");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"^", (String)"\\^");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"$", (String)"\\$");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"+", (String)"\\+");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"*", (String)"\\*");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"(", (String)"\\(");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)")", (String)"\\)");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"|", (String)"\\|");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"[", (String)"\\[");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"]", (String)"\\]");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"{", (String)"\\{");
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"}", (String)"\\}");
        return string2;
    }

    private int findInFiles(Set<File> set, String string, boolean bl, boolean bl2, int n) {
        int n2;
        File file;
        File file2 = new File(string);
        try {
            file = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file2;
        }
        if (!set.add(file)) {
            return 0;
        }
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(sRes.getString("msg.SearchingString"), objectArray);
        this.setSearchLabel(string2);
        this.fDirListSearched.addElement(string);
        if (!file2.exists() || !file2.isDirectory()) {
            return 0;
        }
        Object[] objectArray2 = file2.list();
        String string3 = (String)this.fFilesNamedCombo.getSelectedItem();
        Pattern pattern = null;
        boolean bl3 = false;
        if (string3 != null && !string3.isEmpty()) {
            pattern = !bl ? Pattern.compile(StringUtils.fileNamePatternToRegex((String)string3), 2) : Pattern.compile(StringUtils.fileNamePatternToRegex((String)string3));
            n2 = string3.indexOf(42);
            int n3 = string3.indexOf(46);
            boolean bl4 = bl3 = n2 == 0 && n3 < 0 || n2 < 0 && n3 < 0;
        }
        if (objectArray2 != null) {
            if (PlatformInfo.getPlatform() != 0) {
                Arrays.sort(objectArray2);
            }
            for (n2 = 0; n2 < objectArray2.length && !this.fInterruptFind; ++n2) {
                File file3 = new File(string, (String)objectArray2[n2]);
                Object object = objectArray2[n2];
                String string4 = file3.getAbsolutePath();
                if (bl2 && file3.isDirectory()) {
                    n = this.findInFiles(set, string4, bl, bl2, n);
                }
                if (file3.isDirectory() || !this.shouldGrepFile((String)object, pattern, bl3)) continue;
                if (this.fFindFileNameOnly && this.fileSizeOK(file3)) {
                    String[] stringArray = new String[]{object, file3.getPath(), "", ""};
                    this.fResultsPanel.addResult(stringArray, false);
                    ++this.fNumHits;
                    ++n;
                    continue;
                }
                if (this.grepFile(string4) <= 0) continue;
                ++n;
            }
        }
        return n;
    }

    private boolean fileSizeOK(File file) {
        return !this.fFileSizeCheck.isSelected() || this.fFileSizeCheck.isSelected() && file.length() < (long)(FindFilesPrefs.getMaxFileSize() * 1024 * 1024);
    }

    private boolean shouldGrepFile(String string, Pattern pattern, boolean bl) {
        int n;
        boolean bl2 = true;
        if (pattern != null && !(bl2 = pattern.matcher(string).matches()) && bl && (n = string.lastIndexOf(46)) > 0) {
            bl2 = pattern.matcher(string.substring(0, n)).matches();
        }
        if (bl2) {
            n = string.lastIndexOf(46);
            String string2 = "";
            if (n > -1) {
                string2 = string.substring(n, string.length());
            }
            bl2 = this.shouldGrepForFileType(string2);
        }
        return bl2;
    }

    public boolean shouldGrepForFileType(String string) {
        if (!this.fFileTypeCombo.isEnabled()) {
            return true;
        }
        if (this.fExcludeExtCheck.isEnabled() && this.fExcludeExtCheck.isSelected() && this.fCurrentExclusions != null && this.fCurrentExclusions.contains(string)) {
            return false;
        }
        return this.isFileTypeAll() || this.checkFileTypeListFor(string);
    }

    public boolean checkFileTypeListFor(String string) {
        String string2 = (String)this.fFileTypeCombo.getSelectedItem();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",; ");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            if (!string4.contains(".") || !this.containsNoPeriod(string4) || !Pattern.matches(string3 = string4.replace("*", ".*"), string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean containsNoPeriod(String string) {
        String string2 = string.substring(string.indexOf(46) + 1);
        return !string2.contains(".");
    }

    private void setResultsLabel(String string, Vector<Object> vector) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fResultsPanel.getResultsLabel().setText(string);
            this.fResultsPanel.getResultsLabel().setToolTipText(string);
            this.fResultsPanel.setSpinnerList(vector);
            this.fResultsPanel.getDirPanel().setVisible(true);
            this.fResultsPanel.interruptUpdateThread();
        } else {
            final String string2 = string;
            final Vector<Object> vector2 = vector;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.this.setResultsLabel(string2, vector2);
                }
            });
        }
    }

    private void setSearchLabel(String string) {
        MJLabel mJLabel;
        if (this.fResultsPanel != null && (mJLabel = this.fResultsPanel.getResultsLabel()) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.fResultsPanel.getResultsLabel().setText(string);
            } else {
                SwingUtilities.invokeLater(new SetResultsMsg(string));
            }
        }
    }

    private void addNewSearchPanel(FindResultsPanel findResultsPanel) {
        if (this.fEmptyPanel != null) {
            this.fRightPanel.remove((Component)((Object)this.fEmptyPanel));
            this.fEmptyPanel = null;
            this.fRightPanel.add((Component)this.fTabbedPane);
            this.fXButton.setEnabled(true);
            this.fXButton.setDefaultCapable(false);
            this.fCloseAllButton.setEnabled(true);
        }
        if (this.fTabString == null || this.fTabString.isEmpty()) {
            this.fTabString = this.fNameString;
        }
        String string = FindFiles.formatTabString(this.fTabString);
        findResultsPanel.setName("ResultsPanel:" + string.trim());
        findResultsPanel.getAccessibleContext().setAccessibleName(sRes.getString("acc.ResultsPanel") + " " + this.fTabString);
        if (this.fTabbedPane.getComponentCount() >= this.fMaxTabs) {
            this.fTabbedPane.remove(0);
        }
        this.fTabbedPane.add(string, (Component)((Object)findResultsPanel));
        this.fTabbedPane.setBorder(BorderFactory.createEmptyBorder());
        this.fTabbedPane.setSelectedIndex(this.fTabbedPane.getTabCount() - 1);
        findResultsPanel.setTableRowHeight(sTextFont);
    }

    static MyCheckbox getPathnamesCheckbox() {
        return sPathNamesCheckbox;
    }

    static boolean isShowingFullPathnames() {
        return FindFiles.getPathnamesCheckbox().isSelected();
    }

    private void showFullPathNames(boolean bl) {
        for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
            FindResultsPanel findResultsPanel = (FindResultsPanel)((Object)this.fTabbedPane.getComponent(i));
            findResultsPanel.showFullPathnames(bl);
        }
    }

    private int grepFile(String string) {
        File file = new File(string);
        if (!this.fileSizeOK(file)) {
            return 0;
        }
        String string2 = file.getName();
        List<String[]> list = this.fGrep.grepFile(file);
        int n = 0;
        if (list != null) {
            int n2 = list.size();
            String[] stringArray = new String[4];
            stringArray[0] = string2;
            stringArray[1] = string;
            Iterator<String[]> iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray2;
                String[] stringArray3 = stringArray2 = iterator.next();
                stringArray[2] = stringArray3[0];
                stringArray[3] = stringArray3[1].length() > 200 ? stringArray3[1].substring(0, 200) : stringArray3[1];
                this.fResultsPanel.addResult(stringArray, false);
            }
            this.fNumHits += n2;
            n += n2;
        }
        return n;
    }

    private void alertUser(String string) {
        MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)string, (String)sRes.getString("title.FindFiles"), (int)-1, (int)0);
    }

    private void stopSearch() {
        this.fInterruptFind = true;
        if (this.fGrep != null) {
            Grep.setStop(true);
        }
    }

    private void abortFind() {
        FindFiles.setMyCursor(Cursor.getDefaultCursor());
        this.fThreadInProgress = false;
        if (SwingUtilities.isEventDispatchThread()) {
            this.fFindButton.setAction((Action)this.fStartFindAction);
            this.setSearchLabel(sRes.getString("msg.FindCancelledByUser"));
        } else {
            SwingUtilities.invokeLater(new SetFindButtonAction(this.fStartFindAction, true));
        }
        if (this.fResultsPanel != null) {
            this.fResultsPanel.interruptUpdateThread();
        }
    }

    private static void setMyCursor(final Cursor cursor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                sFindFiles.setCursor(cursor);
            }
        };
        FindFiles.doNowOnEDT(runnable);
    }

    private static void doNowOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    private boolean isFileTypeAll() {
        return this.fFileTypeCombo.getEditor().getItem().toString().equals(sRes.getString("filter.AllFiles")) || this.fFileTypeCombo.getEditor().getItem().toString().equals("*.*") || this.fFileTypeCombo.getEditor().getItem().toString().equals("*");
    }

    private void doFind() {
        List list;
        this.fNumHits = 0;
        this.fNameString = this.fFilesNamedCombo.getEditor().getItem().toString();
        this.fTabString = this.fFindString = this.fFilesContainingCombo.getEditor().getItem().toString();
        this.fCurrentExclusions = FindFiles.prefStringToArrayList(FindFilesPrefs.getExclusionSelections(), ";");
        if (this.fNameString != null && !this.fCaseCheckbox.isSelected()) {
            this.fNameString = this.fNameString.toLowerCase(Locale.getDefault());
        }
        if ((this.fNameString == null || this.fNameString.isEmpty()) && !sFindFiles.isFileTypeAll()) {
            this.fNameString = this.fFileTypeCombo.getEditor().getItem().toString();
        }
        this.updateComboBoxes();
        String string = ((JTextComponent)sLookInComboBox.getEditor().getEditorComponent()).getText();
        if ((string.equals(EDITOR_ALL_OPEN_FILES) || string.equals(EDITOR_CURRENT_FILE)) && (list = MLEditorServices.getEditorApplication().getOpenEditors()).isEmpty()) {
            this.alertUser(sRes.getString("error.NoOpenEditorFiles"));
            FindFiles.adjustEditorLookIns();
            FindFiles.setMyCursor(Cursor.getDefaultCursor());
            return;
        }
        if (string.equals(CURRENT_DIRECTORY)) {
            this.fMatlab.eval("cd", (CompletionObserver)new CwdCallback());
        } else if (string.equals(EDITOR_CURRENT_FILE)) {
            assert (Matlab.isMatlabAvailable()) : "About to check current directory, MATLAB should be available.";
            this.fMatlab.eval("cd", (CompletionObserver)new CwdCallback());
        } else {
            if (this.fThreadInProgress) {
                return;
            }
            this.fFindThread = new Thread(new FindInFiles(this.fFindString, string));
            this.fFindThread.start();
        }
    }

    private static String formatTabString(String string) {
        String string2 = string;
        if (string.length() > 12) {
            string2 = string.substring(0, 10) + "...";
        }
        if (string.length() <= 12) {
            while (string2.length() <= 12) {
                string2 = string2.concat(" ");
            }
        }
        return string2;
    }

    private void closeWindow() {
        if (this.fFindThread != null && this.fThreadInProgress) {
            this.stopSearch();
        }
        if (this.fExtFilter != null && this.fExtFilter.isShowing()) {
            this.fExtFilter.hide();
        }
        this.saveOptions();
        this.setVisible(false);
        this.removeAllTabs();
        this.clearText();
        MLEditorServices.getEditorApplication().removeEditorApplicationListener(sFindFiles.getEditorApplicationListener());
    }

    private void createPopupMenu() {
        this.fPopupMenu = new MJPopupMenu();
        this.fPopupMenu.add((Action)((Object)new CloseCurrentTabAction()));
        this.fPopupMenu.add((Action)this.fCloseTabsAction);
    }

    private void saveOptions() {
        FindFilesPrefs.setMatchCase(this.fCaseCheckbox.isSelected());
        FindFilesPrefs.setSearchType(this.fSearchTypeCombo.getSelectedIndex());
        FindFilesPrefs.setSearchSubdirs(this.fSubDirCheckbox.isSelected());
        if (!this.fFileSizeLimitField.getText().trim().isEmpty()) {
            FindFilesPrefs.setMaxFileSize(Integer.parseInt(this.fFileSizeLimitField.getText().trim()));
        }
        FindFilesPrefs.setFileSizeState(this.fFileSizeCheck.isSelected());
        FindFilesPrefs.setShowFullPath(sPathNamesCheckbox.isSelected());
        FindFilesPrefs.setExclusionState(this.fExcludeExtCheck.isSelected());
        FindFilesPrefs.setWindowLoc(new Rectangle(FindFiles.sFindFiles.getLocation().x, FindFiles.sFindFiles.getLocation().y));
        FindFilesPrefs.setWindowSize(new Rectangle(FindFiles.sFindFiles.getSize().width, FindFiles.sFindFiles.getSize().height));
    }

    private void clearText() {
        this.fFilesContainingCombo.setSelectedItem((Object)"");
        this.fFilesNamedCombo.setSelectedItem((Object)"");
    }

    private void removeCurrentTab() {
        if (this.fTabbedPane.getTabCount() > 0) {
            int n = this.fTabbedPane.getSelectedIndex();
            this.fTabbedPane.remove(n);
            if (this.fTabbedPane.getTabCount() == 0) {
                this.fRightPanel.remove((Component)this.fTabbedPane);
                this.fEmptyPanel = new FindResultsPanel(false);
                this.fRightPanel.add((Component)((Object)this.fEmptyPanel), (Object)"Center");
                this.fXButton.setEnabled(false);
                this.fCloseAllButton.setEnabled(false);
            }
        }
    }

    private void removeAllTabs() {
        int n = this.fTabbedPane.getTabCount();
        for (int i = n - 1; i >= 0; --i) {
            this.removeCurrentTab();
        }
    }

    public static void restoreDefaults() {
        if (SwingUtilities.isEventDispatchThread()) {
            sFindFiles.clearText();
            FindFiles.sFindFiles.fSearchTypeCombo.setSelectedIndex(0);
            FindFiles.sFindFiles.fFileTypeCombo.setSelectedIndex(0);
            FindFiles.sFindFiles.fCaseCheckbox.setSelected(false);
            if (sPathNamesCheckbox.isSelected()) {
                sPathNamesCheckbox.setSelected(false);
                sFindFiles.showFullPathNames(false);
            }
            sLookInComboBox.setSelectedIndex(0);
            FindFiles.sFindFiles.fSubDirCheckbox.setSelected(false);
            FindFiles.sFindFiles.fFileSizeCheck.setSelected(true);
            FindFiles.sFindFiles.fFileSizeLimitField.setEnabled(true);
            FindFiles.sFindFiles.fFileSizeLimitField.setText("500");
            FindFiles.sFindFiles.fExcludeExtCheck.setEnabled(true);
            FindFiles.sFindFiles.fExcludeExtCheck.setSelected(true);
            FindFiles.sFindFiles.fEditExtButton.setEnabled(true);
            FindFiles.sFindFiles.fFileSizeLimitField.setText(String.valueOf(FindFilesPrefs.sMaxFileSizeDefault));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.restoreDefaults();
                }
            });
        }
    }

    private void updateComboBoxes() {
        String string;
        String string2 = this.fFilesContainingCombo.getEditor().getItem().toString();
        if (string2 != null && !string2.isEmpty()) {
            FindFiles.setComboBoxText(string2, this.fFilesContainingCombo);
        }
        if ((string = this.fFilesNamedCombo.getEditor().getItem().toString()) != null && !string.isEmpty()) {
            FindFiles.setComboBoxText(string, this.fFilesNamedCombo);
        }
    }

    private static void setComboBoxText(String string, MJComboBox mJComboBox) {
        int n = FindFiles.getComboIndex(string, mJComboBox);
        if (n != -1) {
            mJComboBox.removeItemAt(n);
            mJComboBox.insertItemAt((Object)string, 0);
            mJComboBox.setSelectedIndex(0);
        } else {
            mJComboBox.insertItemAt((Object)string, 0);
            mJComboBox.setSelectedIndex(0);
        }
    }

    private static int getComboIndex(String string, MJComboBox mJComboBox) {
        int n = -1;
        int n2 = mJComboBox.getItemCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)mJComboBox.getItemAt(i);
            if (!string2.equals(string)) continue;
            n = i;
        }
        return n;
    }

    static MJAbstractAction getRemoveTabAction() {
        return sRemoveTabAction;
    }

    public static void setEditorFilename(String string) {
        sCurrentEditorFile = string;
    }

    private static void adjustEditorLookIns() {
        if (SwingUtilities.isEventDispatchThread()) {
            int n = FindFiles.getComboIndex(EDITOR_CURRENT_FILE, sLookInComboBox);
            if (!MLEditorServices.getEditorApplication().getOpenEditors().isEmpty() && n == -1) {
                sLookInComboBox.insertItemAt((Object)EDITOR_CURRENT_FILE, 1);
                sLookInComboBox.insertItemAt((Object)EDITOR_ALL_OPEN_FILES, 2);
            } else if (MLEditorServices.getEditorApplication().getOpenEditors().isEmpty() && n > -1) {
                sLookInComboBox.removeItemAt(n);
                int n2 = FindFiles.getComboIndex(EDITOR_ALL_OPEN_FILES, sLookInComboBox);
                if (n2 > -1) {
                    sLookInComboBox.removeItemAt(n2);
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.adjustEditorLookIns();
                }
            });
        }
    }

    private static void addItemToLookInComboOnEventThread(String string, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (FindFiles.getComboIndex(string, sLookInComboBox) == -1) {
                sLookInComboBox.addItem((Object)string);
                FindFilesPrefs.setUserLookins(FindFilesPrefs.getUserLookins().concat("\t" + string));
            }
            if (bl) {
                sLookInComboBox.setSelectedIndex(FindFiles.getComboIndex(string, sLookInComboBox));
            }
        } else {
            final String string2 = string;
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFiles.addItemToLookInComboOnEventThread(string2, bl2);
                }
            });
        }
    }

    private void checkFileTypeComboEnabledState() {
        String string = this.fFilesNamedCombo.getEditor().getItem().toString();
        if (string != null && string.contains(".")) {
            if (this.fFileTypeCombo != null) {
                this.fFileTypeCombo.setEnabled(false);
                this.fFileTypeLabel.setEnabled(false);
            }
        } else if (this.fFileTypeCombo != null) {
            this.fFileTypeCombo.setEnabled(true);
            this.fFileTypeLabel.setEnabled(true);
        }
        this.enableDisableExclusions();
    }

    private void enableDisableFindClear() {
        this.fFindButton.setEnabled(!((JTextComponent)this.fFilesNamedCombo.getEditor().getEditorComponent()).getText().isEmpty() || !((JTextComponent)this.fFilesContainingCombo.getEditor().getEditorComponent()).getText().isEmpty() || !this.isFileTypeAll() && !((JTextComponent)this.fFileTypeCombo.getEditor().getEditorComponent()).getText().isEmpty());
        this.fClearTextButton.setEnabled(!((JTextComponent)this.fFilesNamedCombo.getEditor().getEditorComponent()).getText().isEmpty() || !((JTextComponent)this.fFilesContainingCombo.getEditor().getEditorComponent()).getText().isEmpty());
        boolean bl = this.isFileNameSearchOnly();
        this.fFileSizeCheck.setEnabled(!bl);
        this.fFileSizeLimitLabel.setEnabled(!bl);
        this.fFileSizeLimitField.setEnabled(!bl);
    }

    private void lookInEvent() {
        String string = (String)sLookInComboBox.getSelectedItem();
        if (string.equals(BROWSE) && !sTesting) {
            sLookInComboBox.setSelectedIndex(0);
            FindFiles.chooseAndAddItemToLookInCombo();
        } else if (string.isEmpty()) {
            sLookInComboBox.setSelectedIndex(this.fLookInCurrentItem);
        } else if (sLookInComboBox.getSelectedIndex() != -1) {
            this.fLookInCurrentItem = sLookInComboBox.getSelectedIndex();
        }
    }

    private static void chooseAndAddItemToLookInCombo() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file;
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(sRes.getString("msg.ChooseFolder"));
                mJFileChooserPerPlatform.setFileSelectionMode(1);
                mJFileChooserPerPlatform.showOpenDialog((Component)((Object)sFindFiles));
                if (mJFileChooserPerPlatform.getState() == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                    FindFiles.addItemToLookInComboOnEventThread(file.getAbsolutePath(), true);
                }
            }
        });
    }

    private void setBackgroundColor() {
        sBackgroundColor = ColorPrefs.getBackgroundColor();
        if (this.fResultsPanel != null) {
            this.fResultsPanel.setBackgroundColor(sBackgroundColor);
        }
        if (this.fEmptyPanel != null) {
            this.fEmptyPanel.setBackgroundColor(sBackgroundColor);
        }
        int n = this.fTabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((FindResultsPanel)((Object)this.fTabbedPane.getComponentAt(i))).setBackgroundColor(sBackgroundColor);
        }
    }

    private void setTableFont(Font font) {
        int n = this.fTabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((FindResultsPanel)((Object)this.fTabbedPane.getComponentAt(i))).setTableRowHeight(font);
        }
    }

    static Color getBackgroundColor() {
        return sBackgroundColor;
    }

    static Color getTextColor() {
        return sForegroundColor;
    }

    private void setTextColor() {
        sForegroundColor = ColorPrefs.getTextColor();
        int n = this.fTabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((FindResultsPanel)((Object)this.fTabbedPane.getComponentAt(i))).setForegroundColor(sForegroundColor);
        }
    }

    static Font getTextFont() {
        return sTextFont;
    }

    private static Collection<String> prefStringToArrayList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static String comboItemsToPrefString(MJComboBox mJComboBox, String string) {
        String string2 = "";
        for (int i = 0; i < mJComboBox.getItemCount(); ++i) {
            string2 = string2.concat(mJComboBox.getItemAt(i) + string);
        }
        return string2;
    }

    private EditorApplicationListener getEditorApplicationListener() {
        return this.fEditorApplicationListener;
    }

    private static EditorApplicationListener createMLEditorApplicationListener() {
        return new EditorApplicationListener(){

            public void editorOpened(Editor editor) {
                FindFiles.adjustEditorLookIns();
            }

            public void editorClosed(Editor editor) {
                FindFiles.adjustEditorLookIns();
            }
        };
    }

    private void initializeForTestingFileNames(String string) {
        this.fDirListSearched = new Vector();
        this.fFilesNamedCombo.setSelectedItem((Object)string);
        this.fFindFileNameOnly = true;
        this.fNameString = "foo";
        this.fResultsPanel = new FindResultsPanel(true);
        this.addNewSearchPanel(this.fResultsPanel);
    }

    private static void setTestingFlag(boolean bl) {
        sTesting = bl;
    }

    private static void cleanUpTesting() throws InterruptedException {
        if (FindFiles.sFindFiles.fFindThread != null) {
            FindFiles.sFindFiles.fFindThread.join();
        }
        sFindFiles = null;
    }

    static {
        sBackgroundColor = Color.white;
        sForegroundColor = Color.black;
        sTesting = false;
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private List<Component> iTraversalItems = new ArrayList<Component>(19);

        private MyFocusTraversalPolicy() {
        }

        private void populateTraversalItems() {
            this.iTraversalItems.add(0, (Component)FindFiles.this.fFilesNamedCombo);
            this.iTraversalItems.add(1, (Component)FindFiles.this.fFilesContainingCombo);
            this.iTraversalItems.add(2, (Component)FindFiles.this.fFileTypeCombo);
            this.iTraversalItems.add(3, (Component)sLookInComboBox);
            this.iTraversalItems.add(4, (Component)FindFiles.this.fSubDirCheckbox);
            this.iTraversalItems.add(5, (Component)FindFiles.this.fFindButton);
            this.iTraversalItems.add(6, (Component)FindFiles.this.fClearTextButton);
            this.iTraversalItems.add(7, (Component)FindFiles.this.fFileSizeCheck);
            this.iTraversalItems.add(8, (Component)FindFiles.this.fFileSizeLimitField);
            this.iTraversalItems.add(9, (Component)FindFiles.this.fSearchTypeCombo);
            this.iTraversalItems.add(10, (Component)FindFiles.this.fCaseCheckbox);
            this.iTraversalItems.add(11, (Component)FindFiles.this.fExcludeExtCheck);
            this.iTraversalItems.add(12, (Component)FindFiles.this.fEditExtButton);
            this.iTraversalItems.add(13, (Component)FindFiles.this.fTabbedPane);
            this.iTraversalItems.add(14, (Component)((Object)sPathNamesCheckbox));
            this.iTraversalItems.add(15, (Component)FindFiles.this.fCloseAllButton);
            this.iTraversalItems.add(16, (Component)FindFiles.this.fCloseButton);
            this.iTraversalItems.add(17, (Component)FindFiles.this.fHelpButton);
            this.iTraversalItems.add(18, (Component)FindFiles.this.fXButton);
            this.iTraversalItems.add(19, (Component)FindFiles.this.fFilesNamedCombo);
        }

        private Component findNextElement(Component component) {
            ListIterator<Component> listIterator = this.iTraversalItems.listIterator();
            while (listIterator.hasNext()) {
                Component component2 = listIterator.next();
                if (!component2.equals(component)) continue;
                while (listIterator.hasNext()) {
                    Component component3 = listIterator.next();
                    if (!component3.isShowing() || !component3.isEnabled()) continue;
                    return component3;
                }
            }
            return null;
        }

        private Component findPreviousElement(Component component) {
            ListIterator<Component> listIterator = this.iTraversalItems.listIterator(this.iTraversalItems.size());
            while (listIterator.hasPrevious()) {
                Component component2 = listIterator.previous();
                if (!component2.equals(component)) continue;
                while (listIterator.hasNext()) {
                    Component component3 = listIterator.previous();
                    if (!component3.isShowing() || !component3.isEnabled()) continue;
                    return component3;
                }
            }
            return null;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            Container container2 = component.getParent();
            if (component.equals(FindFiles.this.fTabbedPane)) {
                if (FindFiles.this.fResultsPanel.getTable().getRowCount() > 0) {
                    return FindFiles.this.fResultsPanel.getTable();
                }
                return sPathNamesCheckbox;
            }
            if (component instanceof JTable) {
                return FindFiles.this.fResultsPanel.getSpinner();
            }
            if (component instanceof JSpinner) {
                return sPathNamesCheckbox;
            }
            if (container2 instanceof MJComboBox) {
                ((JComboBox)container2).hidePopup();
                return this.findNextElement(container2);
            }
            return this.findNextElement(component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            Container container2 = component.getParent();
            if (component instanceof JTable) {
                return FindFiles.this.fTabbedPane;
            }
            if (component instanceof JSpinner) {
                return FindFiles.this.fResultsPanel.getTable();
            }
            if (component.equals((Object)sPathNamesCheckbox) && FindFiles.this.fResultsPanel != null) {
                return FindFiles.this.fTabbedPane;
            }
            if (container2 instanceof MJComboBox) {
                ((JComboBox)container2).hidePopup();
                return this.findPreviousElement(container2);
            }
            return this.findPreviousElement(component);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return FindFiles.this.fFilesNamedCombo;
        }

        @Override
        public Component getLastComponent(Container container) {
            return FindFiles.this.fXButton;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return FindFiles.this.fFilesNamedCombo;
        }
    }

    private class MouseTabListener
    extends MouseAdapter {
        private MouseTabListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        void showPopup(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.isPopupTrigger() && (n = FindFiles.this.fTabbedPane.getSelectedIndex()) >= 0) {
                Rectangle rectangle = FindFiles.this.fTabbedPane.getUI().getTabBounds((JTabbedPane)FindFiles.this.fTabbedPane, n);
                Point point = rectangle.contains(mouseEvent.getPoint()) ? mouseEvent.getPoint() : new Point((int)rectangle.getX(), (int)rectangle.getY());
                FindFiles.this.fPopupMenu.show((Component)FindFiles.this.fTabbedPane, (int)point.getX(), (int)point.getY());
            }
        }
    }

    private class FileSizeCheckboxList
    implements ActionListener {
        private FileSizeCheckboxList() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.fFileSizeLimitField.setEnabled(FindFiles.this.fFileSizeCheck.isSelected());
        }
    }

    private class ExclusionCheckboxList
    implements ActionListener {
        private ExclusionCheckboxList() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.fEditExtButton.setEnabled(FindFiles.this.fExcludeExtCheck.isSelected());
        }
    }

    private class EditExclusionsAction
    extends MJAbstractAction {
        EditExclusionsAction() {
            super(sRes.getString("button.editExclusions"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FindFiles.this.fExtFilter == null) {
                FindFiles.this.fExtFilter = new FileExtensionFilter((Frame)((Object)sFindFiles));
            }
            FindFiles.this.fExtFilter.show();
        }
    }

    private class MyFontListener
    implements FontListener {
        private MyFontListener() {
        }

        public void fontChanged(Font font) {
            sTextFont = font;
            FindFiles.this.setTableFont(font);
        }
    }

    private class FindColorListener
    implements PrefListener {
        private FindColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                FindFiles.this.setTextColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                FindFiles.this.setBackgroundColor();
            }
        }
    }

    static class MyCheckbox
    extends MJCheckBox {
        MyCheckbox(String string) {
            super(string);
        }

        public void fireStateChanged() {
            super.fireStateChanged();
        }
    }

    private class CloseCurrentTabAction
    extends MJAbstractAction {
        CloseCurrentTabAction() {
            super(sRes.getString("popup.ClosePanel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.removeCurrentTab();
        }
    }

    private class RemoveTabAction
    extends MJAbstractAction {
        RemoveTabAction() {
            this.setButtonOnlyIcon(new ImageIcon(((Object)((Object)sFindFiles)).getClass().getResource("/com/mathworks/mwswing/resources/closebox.gif")));
            this.setTip(sRes.getString("button.ClosePanel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.removeCurrentTab();
        }
    }

    private class FindAction
    extends AbstractAction {
        FindAction() {
            super(sRes.getString("button.Find"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FindFiles.this.fFileSizeLimitField.getText() == null || FindFiles.this.fFileSizeLimitField.getText().trim().isEmpty()) {
                FindFiles.this.fFileSizeLimitField.setText(String.valueOf(FindFilesPrefs.getMaxFileSize()));
            }
            FindFiles.this.saveOptions();
            FindFiles.setMyCursor(Cursor.getPredefinedCursor(3));
            FindFiles.this.fFindButton.setAction((Action)FindFiles.this.fStopFindAction);
            FindFiles.this.fInterruptFind = false;
            FindFiles.this.doFind();
        }
    }

    private class ClearAction
    extends AbstractAction {
        ClearAction() {
            super(sRes.getString("button.Clear"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.clearText();
            FindFiles.this.enableDisableFindClear();
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            super(sRes.getString("button.Help"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"findfiles");
        }
    }

    private class StopAction
    extends AbstractAction {
        StopAction() {
            super(sRes.getString("button.StopFind"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.setMyCursor(Cursor.getDefaultCursor());
            FindFiles.this.stopSearch();
            FindFiles.this.fFindButton.setAction((Action)FindFiles.this.fStartFindAction);
        }
    }

    private class CloseTabsAction
    extends AbstractAction {
        CloseTabsAction() {
            super(sRes.getString("button.CloseResults"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.removeAllTabs();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(sRes.getString("button.Close"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.closeWindow();
        }
    }

    private class ShowPathNamesListener
    implements ActionListener {
        private ShowPathNamesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.this.showFullPathNames(sPathNamesCheckbox.isSelected());
        }
    }

    private class LookInFocusAdapter
    extends FocusAdapter {
        private LookInFocusAdapter() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string = (String)sLookInComboBox.getEditor().getItem();
            if (string.isEmpty()) {
                sLookInComboBox.getEditor().setItem(sLookInComboBox.getItemAt(FindFiles.this.fLookInCurrentItem));
            }
        }
    }

    private class LookInListener
    extends MouseAdapter
    implements ItemListener {
        private LookInListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            FindFiles.this.lookInEvent();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                FindFiles.this.lookInEvent();
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            FindFiles.this.closeWindow();
        }
    }

    private class FileNameKeyListener
    extends KeyAdapter {
        private FileNameKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            String string = (String)sLookInComboBox.getSelectedItem();
            if (!PlatformInfo.isMacintosh() && keyEvent.getKeyCode() == 10 && string.equals(BROWSE) && !sTesting) {
                sLookInComboBox.setSelectedIndex(0);
                FindFiles.chooseAndAddItemToLookInCombo();
            } else if (keyEvent.getKeyCode() == 10 && FindFiles.this.fFindButton.isEnabled() && FindFiles.this.fFindButton.getAction().equals(FindFiles.this.fStartFindAction)) {
                FindFiles.this.fStartFindAction.actionPerformed(new ActionEvent(this, 1, "the event"));
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            FindFiles.this.checkFileTypeComboEnabledState();
            FindFiles.this.enableDisableExclusions();
            FindFiles.this.enableDisableFindClear();
        }
    }

    private class MyItemChangedListener
    implements ItemListener {
        private MyItemChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            FindFiles.this.checkFileTypeComboEnabledState();
            FindFiles.this.enableDisableFindClear();
        }
    }

    private class MyContainsItemChangedListener
    implements ItemListener {
        private MyContainsItemChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            FindFiles.this.enableDisableFindClear();
        }
    }

    private class CwdCallback
    implements CompletionObserver {
        private CwdCallback() {
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            FindFiles.this.fCurrentMatlabDir = string.trim();
            if (!FindFiles.this.fInterruptFind) {
                FindFiles.this.fFindThread = new Thread(new FindInFiles(FindFiles.this.fFindString, (String)sLookInComboBox.getSelectedItem()));
                FindFiles.this.fFindThread.start();
            }
        }
    }

    private class SetResultsMsg
    implements Runnable {
        private String fLabel;

        SetResultsMsg(String string) {
            this.fLabel = string;
        }

        @Override
        public void run() {
            FindFiles.this.fResultsPanel.getResultsLabel().setText(this.fLabel);
        }
    }

    private class SetFindButtonAction
    implements Runnable {
        private FindAction fAction;
        private boolean fAborted;

        SetFindButtonAction(FindAction findAction, boolean bl) {
            this.fAction = findAction;
            this.fAborted = bl;
        }

        @Override
        public void run() {
            FindFiles.this.fFindButton.setAction((Action)this.fAction);
            if (FindFiles.this.fResultsPanel != null) {
                FindFiles.this.fResultsPanel.interruptUpdateThread();
            }
            if (this.fAborted) {
                FindFiles.this.setSearchLabel(sRes.getString("msg.FindCancelledByUser"));
            }
        }
    }

    private class FindInFiles
    implements Runnable {
        private String fSearchStr;
        private String fSearchIn;

        FindInFiles(String string, String string2) {
            this.fSearchStr = string;
            this.fSearchIn = string2;
        }

        @Override
        public void run() {
            Object object;
            Object[] objectArray;
            FindFiles.this.fThreadInProgress = true;
            if (this.fSearchIn.equals(CURRENT_DIRECTORY)) {
                objectArray = new Object[]{FindFiles.this.fCurrentMatlabDir};
            } else if (this.fSearchIn.equals(MATLAB_PATH)) {
                object = MatlabPath.getPathEntries();
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    MatlabPath.PathEntry pathEntry = (MatlabPath.PathEntry)iterator.next();
                    arrayList.add(pathEntry.getDisplayValue());
                }
                objectArray = arrayList.toArray(new Object[arrayList.size()]);
            } else if (this.fSearchIn.equals(EDITOR_ALL_OPEN_FILES)) {
                object = MLEditorServices.getEditorApplication().getOpenEditors();
                String[] stringArray = new String[object.size()];
                for (int i = 0; i < object.size(); ++i) {
                    stringArray[i] = ((Editor)object.get(i)).getLongName();
                }
                objectArray = stringArray;
            } else if (this.fSearchIn.equals(EDITOR_CURRENT_FILE)) {
                objectArray = new Object[1];
                if (sCurrentEditorFile == null) {
                    sCurrentEditorFile = MLEditorServices.getEditorApplication().getActiveEditor().getLongName();
                }
                object = new File(sCurrentEditorFile);
                objectArray[0] = ((File)object).getParent();
                if (objectArray[0] == null) {
                    assert (Matlab.isMatlabAvailable()) : "MATLAB should be available.";
                    objectArray[0] = FindFiles.this.fCurrentMatlabDir;
                }
            } else {
                FindFiles.addItemToLookInComboOnEventThread(this.fSearchIn, false);
                object = new StringTokenizer(this.fSearchIn, ";");
                if (((StringTokenizer)object).countTokens() > 0) {
                    objectArray = new Object[((StringTokenizer)object).countTokens()];
                    int n = 0;
                    while (((StringTokenizer)object).hasMoreElements()) {
                        objectArray[n] = ((StringTokenizer)object).nextToken().trim();
                        File file = new File((String)objectArray[n]);
                        if (!file.exists()) {
                            Object[] objectArray2 = new Object[]{(String)objectArray[n]};
                            String string = MessageFormat.format(sRes.getString("error.DoesNotExist"), objectArray2);
                            FindFiles.this.alertUser(string);
                            FindFiles.this.abortFind();
                            return;
                        }
                        ++n;
                    }
                } else {
                    File file = new File(this.fSearchIn);
                    if (file.exists()) {
                        objectArray = new Object[]{this.fSearchIn};
                    } else {
                        Object[] objectArray3 = new Object[]{this.fSearchIn};
                        String string = MessageFormat.format(sRes.getString("error.DoesNotExist"), objectArray3);
                        FindFiles.this.alertUser(string);
                        FindFiles.this.abortFind();
                        return;
                    }
                }
            }
            if (objectArray == null) {
                FindFiles.this.alertUser(sRes.getString("error.NothingToSearch"));
                FindFiles.this.abortFind();
                return;
            }
            object = new Runnable(){

                @Override
                public void run() {
                    FindFiles.this.fResultsPanel = new FindResultsPanel(true);
                    FindFiles.this.addNewSearchPanel(FindFiles.this.fResultsPanel);
                }
            };
            FindFiles.doNowOnEDT((Runnable)object);
            this.doFind(objectArray);
            FindFiles.setMyCursor(Cursor.getDefaultCursor());
            FindFiles.doNowOnEDT(new SetFindButtonAction(FindFiles.this.fStartFindAction, FindFiles.this.fInterruptFind));
            FindFiles.this.fThreadInProgress = false;
        }

        private void doFind(Object[] objectArray) {
            String string;
            Object[] objectArray2;
            Object object;
            Object object2;
            String string2;
            if (FindFiles.this.fDirListSearched == null) {
                FindFiles.this.fDirListSearched = new Vector();
            } else {
                FindFiles.this.fDirListSearched.removeAllElements();
            }
            FindFiles.this.fFindFileNameOnly = FindFiles.this.isFileNameSearchOnly();
            String string3 = (String)FindFiles.this.fSearchTypeCombo.getSelectedItem();
            boolean bl = string3.equals(sRes.getString("searchType.MatchWholeWord"));
            FindFiles.this.fFindString = FindFiles.fixFindString(FindFiles.this.fFindString);
            if (FindFiles.this.fGrep == null) {
                FindFiles.this.fGrep = new Grep();
            }
            if (bl) {
                FindFiles.this.fFindString = "\\b" + FindFiles.this.fFindString + "\\b";
            }
            FindFiles.this.fGrep.compile(FindFiles.this.fFindString, !FindFiles.this.fCaseCheckbox.isSelected());
            HashSet hashSet = new HashSet();
            int n = 0;
            String[] stringArray = new String[4];
            for (int i = 0; i < objectArray.length && !FindFiles.this.fInterruptFind; ++i) {
                string2 = (String)objectArray[i];
                object2 = new File(string2);
                if (((File)object2).isDirectory()) {
                    n += sFindFiles.findInFiles(hashSet, string2, FindFiles.this.fCaseCheckbox.isSelected(), FindFiles.this.fSubDirCheckbox.isSelected(), 0);
                } else {
                    FindFiles.this.fDirListSearched.addElement(objectArray[i]);
                    int n2 = 0;
                    if (FindFiles.this.fFindFileNameOnly) {
                        object = ((File)object2).getName();
                        objectArray2 = ((File)object2).getAbsolutePath();
                        if (string2.equals(FindFiles.this.fNameString)) {
                            stringArray[0] = object;
                            stringArray[1] = objectArray2;
                            stringArray[2] = "";
                            stringArray[3] = "";
                            FindFiles.this.fResultsPanel.addResult(stringArray, false);
                            FindFiles.this.fNumHits++;
                            ++n2;
                        }
                    } else {
                        n2 = FindFiles.this.grepFile(string2);
                    }
                    objectArray[i] = ((File)object2).getName();
                    if (n2 > 0) {
                        ++n;
                    }
                    if (FindFiles.this.fInterruptFind) {
                        return;
                    }
                }
                if (!FindFiles.this.fInterruptFind) continue;
                return;
            }
            if (FindFiles.this.fInterruptFind) {
                return;
            }
            String string4 = "";
            if (FindFiles.this.fCaseCheckbox.isSelected()) {
                string4 = sRes.getString("option.Matchcase") + " ";
            }
            string2 = "";
            if (bl) {
                string2 = sRes.getString("option.Wholeword") + " ";
            }
            object2 = "";
            if (FindFiles.this.fSubDirCheckbox.isSelected()) {
                object2 = sRes.getString("label.IncludingSubdirectories") + " ";
            }
            if (n == 0) {
                String string5;
                stringArray[0] = string5 = sRes.getString("msg.NoResults");
                stringArray[1] = string5;
                stringArray[2] = "";
                stringArray[3] = "";
                FindFiles.this.fResultsPanel.addResult(stringArray, false);
            }
            if (FindFiles.this.fNameString == null || FindFiles.this.fNameString.isEmpty()) {
                object = new Object[]{Integer.toString(FindFiles.this.fNumHits), this.fSearchStr, Integer.toString(n)};
                objectArray2 = sRes.getString("msg.XmatchesofYinZfiles");
                string = MessageFormat.format((String)objectArray2, object) + " " + (String)object2 + string4 + string2;
            } else {
                object = new Object[]{Integer.toString(FindFiles.this.fNumHits), this.fSearchStr, FindFiles.this.fNameString, Integer.toString(n)};
                objectArray2 = sRes.getString("msg.XmatchesofYAndVinZfiles");
                string = MessageFormat.format((String)objectArray2, object) + " " + (String)object2 + string4 + string2;
            }
            if (FindFiles.this.fFindFileNameOnly) {
                object = sRes.getString("msg.FoundXFilesNamed");
                objectArray2 = new Object[]{Integer.toString(FindFiles.this.fNumHits), FindFiles.this.fNameString};
                string = MessageFormat.format((String)object, objectArray2) + " " + (String)object2 + string4 + string2;
            }
            if (FindFiles.this.fDirListSearched != null) {
                FindFiles.this.setResultsLabel(string, FindFiles.this.fDirListSearched);
            }
        }
    }
}

