/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityNameComparator;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceSearchRequest;
import com.mathworks.mde.functionbrowser.FunctionSearchObserver;
import com.mathworks.mde.functionbrowser.FunctionSearcher;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mde.functionbrowser.SearchStringStatus;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.SearchStringParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingWorker;

class DocCenterFunctionSearcher
implements FunctionSearcher {
    private final FunctionSearchObserver<FunctionTableModel.ReferenceDataResult> fObserver;

    DocCenterFunctionSearcher(FunctionSearchObserver<FunctionTableModel.ReferenceDataResult> functionSearchObserver) {
        this.fObserver = functionSearchObserver;
    }

    @Override
    public void search(String string) {
        new SearchWorker(string).execute();
    }

    private static ReferenceRequest buildRequest(String string, boolean bl) throws SearchStringParseException {
        SearchExpression searchExpression = DocCenterFunctionSearcher.buildBasicExpression(string, bl);
        searchExpression.addSearchField((SearchField)DocumentationSearchField.TITLE_SEARCH);
        searchExpression.addSearchField((SearchField)DocumentationSearchField.SUMMARY);
        ReferenceSearchRequest referenceSearchRequest = new ReferenceSearchRequest(searchExpression);
        referenceSearchRequest.addReferenceTypes(new RefEntityType[]{RefEntityType.FUNCTION, RefEntityType.METHOD});
        referenceSearchRequest.setResultComparator((Comparator)new ReferenceEntityNameComparator(string));
        return referenceSearchRequest;
    }

    private static SearchExpression buildBasicExpression(String string, boolean bl) throws SearchStringParseException {
        if (bl) {
            string = string + '*';
        }
        return SearchStringParser.buildExpression((String)string);
    }

    private static SearchStringStatus getSearchStringStatus(String string) {
        int n;
        String[] stringArray;
        if ((string = string.trim()).matches("^\".*\"$")) {
            return SearchStringStatus.EXACT_PHRASE;
        }
        String[] stringArray2 = stringArray = HelpUtils.isEnglish() ? string.split("[^a-zA-Z0-9]") : string.split("[\\s\\_\\.]+");
        if (stringArray == null || stringArray.length == 0) {
            return SearchStringStatus.NO_WORD_CHARS;
        }
        String string2 = stringArray[stringArray.length - 1];
        int n2 = n = HelpUtils.isEnglish() ? 3 : 2;
        if (string2.length() < n) {
            return SearchStringStatus.TOO_FEW_CHARS;
        }
        if (!string.matches("\\b[\\w ]+\\b") && HelpUtils.isEnglish()) {
            return SearchStringStatus.INVALID_CHARS;
        }
        return SearchStringStatus.WILDCARDABLE;
    }

    private static class ReferenceDataResultIterator
    implements Iterator<FunctionTableModel.ReferenceDataResult> {
        private final Iterator<ReferenceData> iData;

        private ReferenceDataResultIterator(List<ReferenceData> list) {
            this.iData = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iData.hasNext();
        }

        @Override
        public FunctionTableModel.ReferenceDataResult next() {
            return new FunctionTableModel.ReferenceDataResult(this.iData.next());
        }

        @Override
        public void remove() {
        }
    }

    private static class ReferenceDataResultIterable
    implements Iterable<FunctionTableModel.ReferenceDataResult> {
        private final List<ReferenceData> iData;

        private ReferenceDataResultIterable(List<ReferenceData> list) {
            this.iData = list;
        }

        @Override
        public Iterator<FunctionTableModel.ReferenceDataResult> iterator() {
            return new ReferenceDataResultIterator(this.iData);
        }
    }

    private class SearchWorker
    extends SwingWorker<Iterable<FunctionTableModel.ReferenceDataResult>, Object> {
        private final String iSearchString;
        private final SearchStringStatus iSearchStringStatus;

        private SearchWorker(String string) {
            this.iSearchString = string;
            this.iSearchStringStatus = DocCenterFunctionSearcher.getSearchStringStatus(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Iterable<FunctionTableModel.ReferenceDataResult> doInBackground() {
            ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
            try {
                ReferenceRequest referenceRequest = DocCenterFunctionSearcher.buildRequest(this.iSearchString, this.iSearchStringStatus == SearchStringStatus.WILDCARDABLE);
                List list = referenceDataRetriever.getReferenceData(referenceRequest);
                ReferenceDataResultIterable referenceDataResultIterable = new ReferenceDataResultIterable(list);
                return referenceDataResultIterable;
            }
            catch (SearchStringParseException searchStringParseException) {
                List<FunctionTableModel.ReferenceDataResult> list = Collections.emptyList();
                return list;
            }
            finally {
                try {
                    referenceDataRetriever.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        protected void done() {
            DocCenterFunctionSearcher.this.fObserver.searchComplete(this.getResults(), this.iSearchStringStatus);
        }

        private Iterable<FunctionTableModel.ReferenceDataResult> getResults() {
            try {
                return (Iterable)this.get();
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
    }
}

