/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.jidesoft.grid.Row;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.basic.BasicStyledLabelUI;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionbrowser.FunctionBrowserFontPrefs;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.table.TableCellRenderer;

class FunctionCellRenderer
implements TableCellRenderer {
    ImageIcon fCatagoryIconOpen = new ImageIcon(FunctionBrowser.class.getResource("resources/folder_grey_open_16.png"));
    ImageIcon fCatagoryIconClosed = new ImageIcon(FunctionBrowser.class.getResource("resources/folder_grey_closed_16.png"));
    ImageIcon fFunctionIcon = new ImageIcon(FunctionBrowser.class.getResource("resources/fx_icon_grey.png"));
    private MJPanel underlayerPane = new MJPanel((LayoutManager)new BorderLayout());
    private StyledLabel fRenderer = new StyledLabel();
    private String fFilterString;
    private String[] fKeywordArray;
    private boolean fShowDivider = true;
    private static Font sTextFont = FontPrefs.getFontForComponent((String)FunctionBrowserFontPrefs.DISPLAY_NAME);
    private static String sFunctionSuffix = "";
    private static Color SELECTION_COLOR = new Color(211, 221, 231);
    private static Color HIGHLIGHT_COLOR = new Color(153, 255, 255);
    private static Color FOREGROUND_COLOR = ColorPrefs.getTextColor();

    public FunctionCellRenderer(String string) {
        this.setFilterString(string);
        this.fRenderer.setName("CellLabel");
        this.fRenderer.setUI((LabelUI)((Object)new FunctionTableRendererUI()));
        this.fRenderer.setOpaque(true);
        if (MJUtilities.isHighContrast()) {
            FOREGROUND_COLOR = Color.white;
            SELECTION_COLOR = new Color(179, 187, 196);
        }
        FontPrefs.addFontListener((String)FunctionBrowserFontPrefs.DISPLAY_NAME, (FontListener)new FunctionTableFontListener());
    }

    static void setFunctionSuffix(String string) {
        sFunctionSuffix = string;
    }

    static void setForegroundColor(Color color) {
        FOREGROUND_COLOR = color;
    }

    void showDivider(boolean bl) {
        this.fShowDivider = bl;
    }

    boolean isDividerShowing() {
        return this.fShowDivider;
    }

    static void setDefaultFont(Font font) {
        sTextFont = font;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = jTable.isCellSelected(n, n2);
        TreeTable treeTable = (TreeTable)jTable;
        Row row = treeTable.getRowAt(n);
        this.fRenderer.setHorizontalAlignment(2);
        this.underlayerPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.fRenderer.setOpaque(true);
        this.fRenderer.setForeground(FOREGROUND_COLOR);
        this.fRenderer.setStyleRanges(null);
        this.fRenderer.setFont(sTextFont.deriveFont(sTextFont.getStyle(), sTextFont.getSize()));
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        int n3 = rectangle.width;
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.fRenderer.getFontMetrics(this.fRenderer.getFont());
        dimension.width = n3;
        dimension.height = fontMetrics.getHeight();
        if (bl3) {
            if (jTable.hasFocus()) {
                this.fRenderer.setBackground(UIManager.getColor("List.selectionBackground"));
                this.fRenderer.setForeground(UIManager.getColor("List.selectionForeground"));
                this.underlayerPane.setBackground(UIManager.getColor("List.selectionBackground"));
                this.underlayerPane.setForeground(UIManager.getColor("List.selectionForeground"));
            } else if (SwingUtilities.getWindowAncestor(jTable).isActive()) {
                this.fRenderer.setBackground(SELECTION_COLOR);
                this.underlayerPane.setBackground(SELECTION_COLOR);
            } else {
                this.fRenderer.setBackground(jTable.getBackground());
                this.underlayerPane.setBackground(jTable.getBackground());
            }
        } else {
            this.fRenderer.setBackground(jTable.getBackground());
            this.underlayerPane.setBackground(jTable.getBackground());
        }
        if (row instanceof FunctionTableModel.CategoryRow) {
            if (n2 == 1) {
                this.fRenderer.setOpaque(false);
            }
            FunctionTableModel.CategoryRow categoryRow = (FunctionTableModel.CategoryRow)row;
            if (n2 == 0) {
                int n4 = 5 + row.getLevel() * 20;
                this.underlayerPane.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
                this.fRenderer.setPreferredSize(new Dimension(n3 - n4, dimension.height));
                this.fRenderer.setIcon((Icon)(((FunctionTableModel.CategoryRow)row).isExpanded() ? this.fCatagoryIconOpen : this.fCatagoryIconClosed));
            } else {
                this.fRenderer.setIcon(null);
            }
            this.fRenderer.setText((String)categoryRow.getValueAt(n2));
            this.fRenderer.getAccessibleContext().setAccessibleName((String)categoryRow.getValueAt(0));
        } else if (row instanceof FunctionTableModel.FunctionRow) {
            FunctionTableModel.FunctionRow functionRow = (FunctionTableModel.FunctionRow)row;
            if (n2 == 0) {
                this.fRenderer.setIcon((Icon)this.fFunctionIcon);
            } else {
                this.fRenderer.setIcon(null);
            }
            FunctionTableModel.FunctionSearchResult functionSearchResult = (FunctionTableModel.FunctionSearchResult)functionRow.getValueAt(0);
            String string = functionSearchResult.getProduct().trim();
            String string2 = functionSearchResult.getRefPageFunction();
            if (string2 == null) {
                string2 = functionSearchResult.getTitle();
            }
            String string3 = string.equalsIgnoreCase("matlab") ? string2 + sFunctionSuffix : string2 + sFunctionSuffix + " (" + string + ")";
            this.fRenderer.getAccessibleContext().setAccessibleName(string3 + functionRow.getValueAt(1));
            if (n2 == 1) {
                this.fRenderer.setText((String)functionRow.getValueAt(n2));
                if (!jTable.hasFocus() || !bl3) {
                    this.fRenderer.setForeground(Color.gray);
                    this.fRenderer.setPreferredSize(new Dimension(n3, dimension.height));
                } else {
                    this.underlayerPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.white), BorderFactory.createEmptyBorder(0, 4, 0, 0)));
                    this.fRenderer.setPreferredSize(new Dimension(n3 - 4, dimension.height));
                }
                if (this.fShowDivider) {
                    this.underlayerPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.white), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
                    this.fRenderer.setPreferredSize(new Dimension(n3 - 3, dimension.height));
                }
            } else if (n2 == 0) {
                int n5 = 5 + row.getLevel() * 20;
                this.underlayerPane.setBorder(BorderFactory.createEmptyBorder(0, n5, 0, 1));
                this.fRenderer.setPreferredSize(new Dimension(n3 - n5, dimension.height));
                this.fRenderer.setText(string3);
            }
        } else if (row != null) {
            if (n2 == 1) {
                this.fRenderer.setOpaque(false);
            }
            int n6 = 5;
            this.underlayerPane.setBorder(BorderFactory.createEmptyBorder(0, n6, 0, 0));
            this.fRenderer.setPreferredSize(new Dimension(n3 - n6, dimension.height));
            this.fRenderer.setIcon(null);
            this.fRenderer.setText((String)row.getValueAt(n2));
            int n7 = Integer.parseInt("616D7E", 16);
            Color color = new Color(n7);
            this.fRenderer.setForeground(color);
            this.fRenderer.setFont(new Font(sTextFont.getFontName(), 1, sTextFont.getSize()));
            this.fRenderer.setBackground(jTable.getBackground());
            this.underlayerPane.add((Component)this.fRenderer, (Object)"West");
            return this.underlayerPane;
        }
        if (!jTable.hasFocus() || !bl3) {
            this.hilight();
        } else {
            this.dohilight();
        }
        this.underlayerPane.add((Component)this.fRenderer, (Object)"West");
        return this.underlayerPane;
    }

    String getFilterString() {
        return this.fFilterString;
    }

    void setFilterString(String string) {
        if (string == null) {
            this.fFilterString = "";
            this.fKeywordArray = new String[0];
            return;
        }
        this.fFilterString = string;
        this.fKeywordArray = ActionBrowserUtils.getKeywordArray((String)string);
    }

    private StyleRange[] getHiLightedStyleRanges(String string) {
        string = string.toLowerCase().trim();
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        for (String string2 : this.fKeywordArray) {
            if (string2.length() < 2) continue;
            int n = 0;
            while (string.indexOf(string2, n) >= 0) {
                n = string.indexOf(string2, n);
                StyleRange styleRange = new StyleRange(n, string2.length(), this.fRenderer.getFont().getStyle(), this.fRenderer.getForeground(), HIGHLIGHT_COLOR, 0);
                arrayList.add(styleRange);
                n += string2.length();
            }
        }
        return arrayList.toArray(new StyleRange[0]);
    }

    private void hilight() {
        String string = this.fRenderer.getText();
        if (string != null) {
            StyleRange[] styleRangeArray = this.getHiLightedStyleRanges(string);
            this.fRenderer.setStyleRanges(styleRangeArray);
        }
    }

    private void dohilight() {
        this.fRenderer.clearStyleRanges();
    }

    private static class FunctionTableFontListener
    implements FontListener {
        private FunctionTableFontListener() {
        }

        public void fontChanged(Font font) {
            sTextFont = font;
        }
    }

    private static class FunctionTableRendererUI
    extends BasicStyledLabelUI {
        public void update(Graphics graphics, JComponent jComponent) {
            try {
                super.update(graphics, jComponent);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

