/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.SearchPanelHeaderColumn;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.table.SortedTableHeaderRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class SearchPanelHeader {
    private DefaultSortableTable fTable;
    private List<SortListener> fListeners = new ArrayList<SortListener>();

    SearchPanelHeader() {
        this.createTable();
    }

    void addSortListener(SortListener sortListener) {
        this.fListeners.add(sortListener);
    }

    private void createTable() {
        this.fTable = new DefaultSortableTable(0, SearchPanelHeaderColumn.values().length){

            protected int getDefaultSortDirection(int n) {
                SearchPanelHeaderColumn searchPanelHeaderColumn = SearchPanelHeaderColumn.values()[n];
                return SearchPanelHeader.getDefaultSortOrder(searchPanelHeaderColumn);
            }
        };
        for (SearchPanelHeaderColumn searchPanelHeaderColumn : SearchPanelHeaderColumn.values()) {
            TableColumn tableColumn = this.fTable.getColumnModel().getColumn(searchPanelHeaderColumn.ordinal());
            tableColumn.setHeaderValue((Object)searchPanelHeaderColumn);
        }
        TableCellRenderer tableCellRenderer = this.fTable.getTableHeader().getDefaultRenderer();
        this.fTable.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new SortHeaderRenderer(tableCellRenderer)));
    }

    JComponent getComponent() {
        this.fTable.addSortingChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = SearchPanelHeader.this.fTable.getSortColumn();
                SearchPanelHeaderColumn searchPanelHeaderColumn = SearchPanelHeaderColumn.values()[n];
                boolean bl = SearchPanelHeader.this.fTable.getSortDirection() == 1;
                boolean bl2 = bl != searchPanelHeaderColumn.isDescendingByDefault();
                for (SortListener sortListener : SearchPanelHeader.this.fListeners) {
                    sortListener.sortChanged(searchPanelHeaderColumn, bl2);
                }
            }
        });
        this.fTable.setAutoResizeMode(3);
        this.fTable.setPreferredScrollableViewportSize(this.fTable.getPreferredSize());
        this.fTable.getTableHeader().setReorderingAllowed(false);
        this.fTable.getTableHeader().setFocusable(false);
        this.fTable.setBorder(null);
        this.fTable.setFocusable(false);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTable);
        mJScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 0));
        mJScrollPane.setBorder((Border)new EmptyBorder(new Insets(0, 0, 0, 0)));
        mJScrollPane.setFocusable(false);
        return mJScrollPane;
    }

    void sortByRelevance() {
        this.sortDefaultDirection(SearchPanelHeaderColumn.RELEVANCE);
    }

    private void sortDefaultDirection(SearchPanelHeaderColumn searchPanelHeaderColumn) {
        this.sortByColumn(searchPanelHeaderColumn, SearchPanelHeader.getDefaultSortOrder(searchPanelHeaderColumn));
    }

    private void sortByColumn(SearchPanelHeaderColumn searchPanelHeaderColumn, int n) {
        this.fTable.sortByColumn(searchPanelHeaderColumn.ordinal(), n);
    }

    private static int getDefaultSortOrder(SearchPanelHeaderColumn searchPanelHeaderColumn) {
        return searchPanelHeaderColumn.isDescendingByDefault() ? 1 : 0;
    }

    private static class SortHeaderRenderer
    extends SortedTableHeaderRenderer {
        private SortHeaderRenderer(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer);
        }

        protected void modifyRenderer(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.modifyRenderer(component, jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && object instanceof SearchPanelHeaderColumn) {
                JLabel jLabel = (JLabel)component;
                SearchPanelHeaderColumn searchPanelHeaderColumn = (SearchPanelHeaderColumn)((Object)object);
                jLabel.setName("SearchResultsHeader_" + searchPanelHeaderColumn.toString());
                if (searchPanelHeaderColumn.getText() != null) {
                    jLabel.setText(searchPanelHeaderColumn.getText());
                } else {
                    jLabel.setText(null);
                    jLabel.setIcon(searchPanelHeaderColumn.getIcon());
                    SortHeaderRenderer.fixLabelBorder(jLabel);
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                    tableColumn.setResizable(false);
                    tableColumn.setMaxWidth(jLabel.getPreferredSize().width);
                }
            }
        }

        private static void fixLabelBorder(JLabel jLabel) {
            Border border = jLabel.getBorder();
            if (border != null && border instanceof EmptyBorder) {
                EmptyBorder emptyBorder = (EmptyBorder)border;
                Insets insets = emptyBorder.getBorderInsets();
                if (insets.left > 3) {
                    insets.left = 3;
                }
                if (insets.right > 5) {
                    insets.right = 5;
                }
                jLabel.setBorder(new EmptyBorder(insets));
            }
        }
    }

    public static interface SortListener {
        public void sortChanged(SearchPanelHeaderColumn var1, boolean var2);
    }
}

