/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.suggestion;

import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.mde.help.suggestion.SuggestionClickAction;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.factory.TSFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ToolstripSuggestionUtils {
    public static List<ListItem> getWordSuggestionList(SearchSuggestions searchSuggestions) {
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        if (searchSuggestions.getTotal() > 0) {
            arrayList.add(ListItem.newHeader((String)HelpUtils.getLocalizedString((String)"doccenter.words.suggestions"), (ListStyle)ListStyle.TEXT_ONLY));
            for (SearchHighlight searchHighlight : searchSuggestions.getSuggestions()) {
                arrayList.add(ToolstripSuggestionUtils.createWordSuggestionListItem(searchHighlight.getOriginalText()));
            }
        }
        return arrayList;
    }

    public static List<ListItem> getPageSuggestionList(Map<InformationType, SearchResults<PageSuggestion>> map, String string) {
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        for (Map.Entry<InformationType, SearchResults<PageSuggestion>> entry : map.entrySet()) {
            try {
                arrayList.addAll(ToolstripSuggestionUtils.getListItemsForInfoType(string, entry.getKey(), entry.getValue()));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private static List<ListItem> getListItemsForInfoType(String string, InformationType informationType, SearchResults<PageSuggestion> searchResults) {
        LinkedList<ListItem> linkedList = new LinkedList<ListItem>();
        if (searchResults.getFullResultCount() > 0) {
            int n;
            linkedList.add(ListItem.newHeader((String)HelpUtils.getLocalizedString((String)("doccenter.pages." + informationType.getFacetId())), (ListStyle)ListStyle.SINGLE_LINE_DESCRIPTION));
            for (PageSuggestion pageSuggestion : searchResults) {
                linkedList.add(ToolstripSuggestionUtils.createPageSuggestionListItem(pageSuggestion, informationType));
            }
            int n2 = searchResults.getFullResultCount();
            int n3 = n2 - (n = searchResults.getNumIncluded());
            if (n3 > 0) {
                ListItem listItem = ListItem.newItem((String)"MorePageSuggestions", (String)HelpUtils.getLocalizedString((String)"doccenter.pages.moresuggestions"));
                listItem.getAttributes().setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
                listItem.getAttributes().setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)new SuggestionClickAction(DocCenterUtils.buildDocCenterFacetSearchUrl((String)string, (InformationType)informationType)));
                linkedList.add(listItem);
            }
        }
        return linkedList;
    }

    private static ListItem createPageSuggestionListItem(PageSuggestion pageSuggestion, InformationType informationType) {
        ImageIcon imageIcon = ToolstripSuggestionUtils.getListIcon(informationType);
        ListItem listItem = ListItem.newItem((String)("PageSuggestion." + pageSuggestion.getTitle()), (String)pageSuggestion.getTitle(), (String)pageSuggestion.getSummary(), (Icon)imageIcon).setAttribute((Attribute)ListItem.SHORTCUT_KEY, (Object)pageSuggestion.getDocSetItem().getDisplayName());
        DocRoot docRoot = DocCenterDocConfig.getInstance().getDocRoot();
        String string = docRoot.buildDocSetItemUrl(pageSuggestion.getDocSetItem(), pageSuggestion.getPath()).toString();
        listItem.getAttributes().setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)new SuggestionClickAction(string));
        return listItem;
    }

    private static ListItem createWordSuggestionListItem(String string) {
        ListItem listItem = ListItem.newItem((String)("WordSuggestion." + string), (String)string);
        listItem.getAttributes().setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)new SuggestionClickAction(DocCenterUtils.buildDocCenterSearchUrl((String)string)));
        return listItem;
    }

    private static ImageIcon getListIcon(InformationType informationType) {
        switch (informationType) {
            case FUNCTIONS: {
                return ProvisionalIcon.BROWSE_FUNCTIONS.getIcon();
            }
        }
        return null;
    }
}

