/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.mde.richeditor.RichCodeFileExtensionFilterContributor;
import com.mathworks.mde.richeditor.RichDocumentBackingStore;
import com.mathworks.mde.richeditor.RichEditor;
import com.mathworks.mde.richeditor.RichEditorClient;
import com.mathworks.mde.richeditor.RichEditorGroup;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.dialog.SpecifyNewFilenameDialog;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.publishparser.PublishParser;
import com.mathworks.services.mlx.MlxFile;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.util.AbsoluteFile;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Holder;
import com.mathworks.util.Log;
import com.mathworks.util.ThreadUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.apache.commons.io.FilenameUtils;
import org.netbeans.editor.BaseDocument;

public final class RichEditorApplication {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.resources.RES_RichEditor");
    private static final RichEditorApplication sInstance = new RichEditorApplication();
    private static final int MAX_FILENAME_LENGTH = 45;

    public static RichEditorApplication getInstance() {
        return sInstance;
    }

    public RichEditor newRichEditor() {
        return this.newRichEditorClient().getRichEditor();
    }

    public RichEditor openRichEditor(File file) {
        return this.openRichEditorClient(file).getRichEditor();
    }

    public RichEditorClient newRichEditorClient() {
        final Holder holder = new Holder();
        RichEditorApplication.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                holder.set((Object)RichEditorApplication.createRichEditorClient());
            }
        });
        return (RichEditorClient)((Object)holder.get());
    }

    public RichEditorClient openRichEditorClient(final File file) {
        final Holder holder = new Holder();
        RichEditorApplication.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                holder.set((Object)RichEditorApplication.this.doOpenRichEditor(file));
            }
        });
        return (RichEditorClient)((Object)holder.get());
    }

    private RichEditorClient doOpenRichEditor(File file) {
        assert (SwingUtilities.isEventDispatchThread()) : "RichEditorClient creation must be on EDT.";
        AbsoluteFile absoluteFile = new AbsoluteFile(file);
        FileStorageLocation fileStorageLocation = new FileStorageLocation(absoluteFile.toFile());
        RichEditorClient richEditorClient = RichEditorApplication.findRichEditorClient((StorageLocation)fileStorageLocation);
        if (richEditorClient != null) {
            MatlabDesktopServices.getDesktop().setClientSelected((Component)((Object)richEditorClient), true);
            return richEditorClient;
        }
        if (absoluteFile.exists()) {
            return RichEditorApplication.createRichEditorClientFromExistingFile(absoluteFile);
        }
        boolean bl = RichEditorApplication.userWantsToOpenNonExistentFile(absoluteFile);
        if (bl) {
            return RichEditorApplication.createRichEditorClientFromNonExistentFile(absoluteFile);
        }
        return null;
    }

    private static RichEditorClient createRichEditorClient() {
        assert (SwingUtilities.isEventDispatchThread()) : "RichEditorClient creation must be on EDT.";
        RichDocumentBackingStore richDocumentBackingStore = RichDocumentBackingStore.createWithNoBackingFile();
        RichEditorClient richEditorClient = RichEditorApplication.createRichEditorClient((BackingStore<RichDocument>)richDocumentBackingStore);
        return richEditorClient;
    }

    private static RichEditorClient createRichEditorClientFromExistingFile(AbsoluteFile absoluteFile) {
        assert (SwingUtilities.isEventDispatchThread()) : "RichEditorClient creation must be on EDT.";
        assert (absoluteFile.exists()) : "The given file does not exist.";
        MatlabDesktopServices.getDesktop().getRecentFiles().addFile(RichEditorGroup.getGroupName(), absoluteFile.getPath());
        RichDocumentBackingStore richDocumentBackingStore = RichDocumentBackingStore.createWithExistentBackingFile(absoluteFile.toFile());
        return RichEditorApplication.createRichEditorClient((BackingStore<RichDocument>)richDocumentBackingStore);
    }

    private static RichEditorClient createRichEditorClient(BackingStore<RichDocument> backingStore) {
        assert (SwingUtilities.isEventDispatchThread()) : "RichEditorClient creation must be on EDT.";
        if (!MlxFileUtils.isRichScriptEnabled()) {
            assert (false) : "Rich Script is turned off.";
            return null;
        }
        RichEditorClient richEditorClient = new RichEditorClient(backingStore);
        MatlabDesktopServices.getDesktop().addClient((Component)((Object)richEditorClient), richEditorClient.getClientTitle(), true, null, true);
        return richEditorClient;
    }

    private static RichEditorClient createRichEditorClientFromNonExistentFile(AbsoluteFile absoluteFile) {
        assert (SwingUtilities.isEventDispatchThread()) : "RichEditorClient creation must be on EDT.";
        assert (!absoluteFile.exists()) : "The given file should not exist.";
        try {
            if (SpecifyNewFilenameDialog.shouldShowDialog((File)absoluteFile.toFile())) {
                RichEditorClient richEditorClient = RichEditorApplication.findRichEditorClient((StorageLocation)new FileStorageLocation(absoluteFile.toFile()));
                File file = SpecifyNewFilenameDialog.getNewFilenameForBadFilename((File)absoluteFile.toFile(), (String)BUNDLE.getString("Dialog.Title"), (Frame)RichEditorApplication.getFrameToCenterDialogOn((Component)((Object)richEditorClient)));
                if (file == null) {
                    return null;
                }
                absoluteFile = new AbsoluteFile(file);
            }
            absoluteFile.createNewFile();
            return RichEditorApplication.createRichEditorClientFromExistingFile(absoluteFile);
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(BUNDLE.getString("ErrorCreatingFile.Label"), FileUtils.truncatePathname((String)absoluteFile.getPath(), (int)45), iOException.getLocalizedMessage());
            Component component = RichEditorApplication.getParentForDialogs();
            String string2 = BUNDLE.getString("Dialog.Title");
            int n = MJOptionPane.showConfirmDialog((Component)component, (Object)string, (String)string2, (int)0, (int)2);
            if (n == 0) {
                return RichEditorApplication.createRichEditorClient();
            }
            return null;
        }
    }

    private static RichEditorClient findRichEditorClient(StorageLocation storageLocation) {
        for (RichEditorClient richEditorClient : RichEditorGroup.getInstance().getOpenRichEditorClients()) {
            if (!storageLocation.isTheSameAs(richEditorClient.getStorageLocation())) continue;
            return richEditorClient;
        }
        return null;
    }

    static RichEditorClient findRichEditorClient(RichEditor richEditor) {
        for (RichEditorClient richEditorClient : RichEditorGroup.getInstance().getOpenRichEditorClients()) {
            if (!richEditorClient.getRichEditor().equals(richEditor)) continue;
            return richEditorClient;
        }
        return null;
    }

    public static RichEditorClient findRichEditorClient(String string) {
        RichEditorClient richEditorClient = null;
        for (RichEditorClient richEditorClient2 : RichEditorGroup.getInstance().getOpenRichEditorClients()) {
            RichEditor richEditor = richEditorClient2.getRichEditor();
            if (!richEditor.getRichDocument().getUniqueKey().equals(string)) continue;
            richEditorClient = richEditorClient2;
            break;
        }
        return richEditorClient;
    }

    public static RichEditorClient getLastActiveRichEditorClient() {
        Component component = MatlabDesktopServices.getDesktop().getLastDocumentSelectedInGroup(RichEditorGroup.getGroupTitle());
        return component != null && component instanceof RichEditorClient ? (RichEditorClient)((Object)component) : null;
    }

    private static boolean userWantsToOpenNonExistentFile(AbsoluteFile absoluteFile) {
        Object object = RichEditorApplication.getLastActiveRichEditorClient();
        object = object != null && MJFrame.getFrame((Component)object) != null ? MJFrame.getFrame((Component)object) : RichEditorApplication.getParentForDialogs();
        boolean bl = false;
        if (object == null) {
            object = new MJDialogParent();
            bl = true;
        }
        String string = FileUtils.truncatePathname((String)absoluteFile.getPath(), (int)45);
        String string2 = MessageFormat.format(BUNDLE.getString("UserOpenNonExistentFile.Label"), string);
        int n = MJOptionPane.showConfirmDialog((Component)object, (Object)string2, (String)BUNDLE.getString("Dialog.Title"), (int)0, (int)3);
        boolean bl2 = false;
        if (n == 0) {
            bl2 = true;
        } else if (n == 1) {
            bl2 = false;
        }
        if (bl) {
            ((Window)object).dispose();
        }
        return bl2;
    }

    private static void invokeAndWait(Runnable runnable) {
        try {
            AWTUtilities.invokeAndWait((Runnable)runnable);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static Component getParentForDialogs() {
        Container container = null;
        Desktop desktop = MatlabDesktopServices.getDesktop();
        if (desktop.isGroupShowing(RichEditorGroup.getGroupTitle())) {
            container = desktop.getGroupContainer(RichEditorGroup.getGroupTitle());
        } else if (desktop.hasMainFrame()) {
            container = desktop.getMainFrame();
        }
        return container;
    }

    private static Frame getFrameToCenterDialogOn(Component component) {
        MJFrame mJFrame;
        MJFrame mJFrame2 = MJFrame.getFrame((Component)(component == null ? null : component));
        MJFrame mJFrame3 = mJFrame = mJFrame2 == null ? MJFrame.getFrame((Component)RichEditorApplication.getParentForDialogs()) : mJFrame2;
        assert (mJFrame != null) : "The frame to return should not be null.";
        return mJFrame;
    }

    static void exportToM(final RichDocument richDocument, final File file) {
        ExecutorService executorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"richeditor");
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                String string = richDocument.getMContent();
                BaseDocument baseDocument = new BaseDocument(new MLanguage().createDefaultKit().getClass(), false);
                try {
                    baseDocument.insertString(0, string, null);
                    TextFileBackingStore textFileBackingStore = TextFileBackingStore.createWithNoBackingFile();
                    textFileBackingStore.doSaveAs((Document)baseDocument, file);
                    MLEditorServices.getEditorApplication().openEditorForExistingFile(file);
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        });
    }

    static void doImportMATLABCode(Component component) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = RichEditorApplication.createFileChooseDialog(Arrays.asList(MatlabProductFileExtensionFilter.getMFileFilter()));
        mJFileChooserPerPlatform.setMultiSelectionEnabled(false);
        mJFileChooserPerPlatform.showOpenDialog(component);
        if (mJFileChooserPerPlatform.getState() == 0) {
            File file = mJFileChooserPerPlatform.getSelectedFile();
            RichEditorApplication.openAsRichCode(component, file);
        }
    }

    public static void openAsRichCode(Component component, File file) {
        String string = file.getAbsolutePath();
        if (MLFileUtils.isMFile((String)string)) {
            String string2;
            try {
                string2 = PublishParser.convertMToRichScript((File)file);
            }
            catch (Exception exception) {
                MJOptionPane.showMessageDialog((Component)component, (Object)BUNDLE.getString("ImportMatlabCode.Failed"), (String)BUNDLE.getString("Dialog.Title"), (int)0);
                return;
            }
            final String string3 = string2;
            final RichEditor richEditor = RichEditorApplication.getInstance().newRichEditor();
            String string4 = FilenameUtils.getBaseName((String)string) + ".mlx";
            richEditor.setPendingName(string4);
            final RichDocument richDocument = richEditor.getRichDocument();
            richDocument.addDocumentListener(DocumentEvent.EventType.INITIALIZED, new DocumentListener(){

                @Override
                public void eventFired(DocumentEvent documentEvent) {
                    ThreadUtils.newSingleDaemonThreadExecutor((String)"richeditor").submit(new Runnable(){

                        @Override
                        public void run() {
                            MlxFile mlxFile = new MlxFile(string3, null);
                            richDocument.setContent(RichDocumentBackingStore.convertToMap(mlxFile));
                            richDocument.refreshOutputs();
                            RichEditorClient richEditorClient = RichEditorApplication.findRichEditorClient(richEditor);
                            richEditorClient.setDirty(true);
                        }
                    });
                    richDocument.removeDocumentListener(DocumentEvent.EventType.INITIALIZED, this);
                }
            });
        }
    }

    static void doOpen(Component component) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = RichEditorApplication.createFileChooseDialog(new RichCodeFileExtensionFilterContributor().getDialogFilters());
        mJFileChooserPerPlatform.showOpenDialog(component);
        if (mJFileChooserPerPlatform.getState() == 0) {
            File[] fileArray;
            for (File file : fileArray = mJFileChooserPerPlatform.getSelectedFiles()) {
                String string = file.getAbsolutePath();
                if (!MlxFileUtils.isMlxExtensionFile((String)string)) continue;
                RichEditorApplication.getInstance().openRichEditor(file);
            }
        }
    }

    private static MJFileChooserPerPlatform createFileChooseDialog(List<FileExtensionFilter> list) {
        File file = new File(MatlabPath.getCWD());
        String string = BUNDLE.getString("Dialog.Title");
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(file);
        mJFileChooserPerPlatform.setMultiSelectionEnabled(true);
        mJFileChooserPerPlatform.setFileMustExist(true);
        mJFileChooserPerPlatform.setAllowMacBundles(false);
        mJFileChooserPerPlatform.setDialogTitle(string);
        mJFileChooserPerPlatform.addChoosableFileFilters(list);
        mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
        return mJFileChooserPerPlatform;
    }
}

