/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor.widget.rtc;

import com.mathworks.mde.richeditor.widget.rtc.ConnectorFactory;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.util.Log;
import com.mathworks.util.ThreadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

final class DocumentEventSupport {
    private final String fChannel;
    private final Subscriber fEventsSubscriber;
    private final Map<DocumentEvent.EventType, List<DocumentListener>> fEventToDocumentListenerMap;
    private final List<DocumentListener> fDocumentListeners;
    private static final String EVENT_NAME_PROPERTY = "eventName";
    private static final String EVENT_DATA_PROPERTY = "eventData";
    private static final String EVENTS_CHANNEL_PREFIX = "/richeditor/events/";

    DocumentEventSupport(String string) {
        this.fChannel = EVENTS_CHANNEL_PREFIX + string;
        this.fEventsSubscriber = new Subscriber(){

            public void handle(Message message) {
                assert (message.getData() instanceof HashMap) : "The data in message should be a hashmap";
                Map map = (Map)message.getData();
                try {
                    String string = (String)map.get(DocumentEventSupport.EVENT_NAME_PROPERTY);
                    final Object v = map.get(DocumentEventSupport.EVENT_DATA_PROPERTY);
                    final DocumentEvent.EventType eventType = DocumentEvent.EventType.valueOf(string.toUpperCase());
                    ExecutorService executorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"richDocument");
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            DocumentEventSupport.this.fireDocumentEvent(new DocumentEvent(eventType, v));
                        }
                    });
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        };
        this.fEventToDocumentListenerMap = new HashMap<DocumentEvent.EventType, List<DocumentListener>>();
        this.fDocumentListeners = new ArrayList<DocumentListener>();
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                MessageServiceFactory.getMessageService().subscribe(DocumentEventSupport.this.fChannel, DocumentEventSupport.this.fEventsSubscriber);
            }
        });
    }

    void addDocumentListener(DocumentListener documentListener) {
        this.fDocumentListeners.add(documentListener);
    }

    void addDocumentListener(DocumentEvent.EventType eventType, DocumentListener documentListener) {
        if (this.fEventToDocumentListenerMap.get((Object)eventType) == null) {
            this.fEventToDocumentListenerMap.put(eventType, new ArrayList());
        }
        List<DocumentListener> list = this.fEventToDocumentListenerMap.get((Object)eventType);
        list.add(documentListener);
    }

    void removeDocumentListener(DocumentListener documentListener) {
        this.fDocumentListeners.remove(documentListener);
    }

    void removeDocumentListener(DocumentEvent.EventType eventType, DocumentListener documentListener) {
        if (this.fEventToDocumentListenerMap.get((Object)eventType) != null) {
            List<DocumentListener> list = this.fEventToDocumentListenerMap.get((Object)eventType);
            list.remove(documentListener);
        }
    }

    private void fireDocumentEvent(DocumentEvent documentEvent) {
        DocumentEventSupport.doFireDocumentEvent(documentEvent, this.fDocumentListeners);
        List<DocumentListener> list = this.fEventToDocumentListenerMap.get((Object)documentEvent.getType());
        if (list != null) {
            DocumentEventSupport.doFireDocumentEvent(documentEvent, list);
        }
    }

    private static void doFireDocumentEvent(DocumentEvent documentEvent, List<DocumentListener> list) {
        DocumentListener[] documentListenerArray;
        for (DocumentListener documentListener : documentListenerArray = list.toArray(new DocumentListener[0])) {
            documentListener.eventFired(documentEvent);
        }
    }

    void dispose() {
        MessageServiceFactory.getMessageService().unsubscribe(this.fChannel, this.fEventsSubscriber);
    }
}

