/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.openxml4j.opc.ContentTypes;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartCollection;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageProperties;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.RelationshipSource;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.opc.ZipPackage;
import org.openxml4j.opc.internal.ContentType;
import org.openxml4j.opc.internal.ContentTypeManager;
import org.openxml4j.opc.internal.PackagePropertiesPart;
import org.openxml4j.opc.internal.PartMarshaller;
import org.openxml4j.opc.internal.PartUnmarshaller;
import org.openxml4j.opc.internal.ZipContentTypeManager;
import org.openxml4j.opc.internal.marshallers.DefaultMarshaller;
import org.openxml4j.opc.internal.marshallers.ZipPackagePropertiesMarshaller;
import org.openxml4j.opc.internal.unmarshallers.PackagePropertiesUnmarshaller;
import org.openxml4j.opc.internal.unmarshallers.UnmarshallContext;
import org.openxml4j.util.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Package
implements RelationshipSource {
    protected static Logger logger = Logger.getLogger((String)"org.openxml4j.opc");
    protected static final PackageAccess defaultPackageAccess = PackageAccess.READ_WRITE;
    private PackageAccess packageAccess;
    protected PackagePartCollection partList;
    protected PackageRelationshipCollection relationships;
    protected Hashtable<ContentType, PartMarshaller> partMarshallers;
    protected PartMarshaller defaultPartMarshaller;
    protected Hashtable<ContentType, PartUnmarshaller> partUnmarshallers;
    protected PackagePropertiesPart packageProperties;
    protected ContentTypeManager contentTypeManager;
    protected boolean isDirty = false;
    protected String originalPackagePath;
    protected OutputStream output;

    protected Package(PackageAccess access) {
        this.init();
        this.packageAccess = access;
    }

    private void init() {
        this.partMarshallers = new Hashtable(5);
        this.partUnmarshallers = new Hashtable(2);
        try {
            this.partUnmarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new PackagePropertiesUnmarshaller());
            this.defaultPartMarshaller = new DefaultMarshaller();
            this.partMarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new ZipPackagePropertiesMarshaller());
        }
        catch (InvalidFormatException e) {
            throw new OpenXML4JRuntimeException("Package.init() : this exception should never happen, if you read this message please send a mail to the developers team.");
        }
    }

    public static Package open(String path) throws InvalidFormatException {
        return Package.open(path, defaultPackageAccess);
    }

    public static Package open(String path, PackageAccess access) throws InvalidFormatException {
        if (path == null || "".equals(path.trim()) || new File(path).exists() && new File(path).isDirectory()) {
            throw new IllegalArgumentException("path");
        }
        ZipPackage pack = new ZipPackage(path, access);
        if (pack.partList == null && access != PackageAccess.WRITE) {
            pack.getParts();
        }
        pack.originalPackagePath = new File(path).getAbsolutePath();
        return pack;
    }

    public static Package open(InputStream in) throws InvalidFormatException, IOException {
        ZipPackage pack = new ZipPackage(in, PackageAccess.READ);
        if (pack.partList == null) {
            pack.getParts();
        }
        return pack;
    }

    public static Package openOrCreate(File file) throws InvalidFormatException {
        Package retPackage = null;
        retPackage = file.exists() ? Package.open(file.getAbsolutePath()) : Package.create(file);
        return retPackage;
    }

    public static Package create(String path) {
        return Package.create(new File(path));
    }

    public static Package create(File file) {
        if (file == null || file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("file");
        }
        if (file.exists()) {
            throw new InvalidOperationException("This package (or file) already exists : use the open() method or delete the file.");
        }
        ZipPackage pkg = null;
        pkg = new ZipPackage();
        pkg.originalPackagePath = file.getAbsolutePath();
        Package.configurePackage(pkg);
        return pkg;
    }

    public static Package create(OutputStream output) {
        ZipPackage pkg = null;
        pkg = new ZipPackage();
        pkg.originalPackagePath = null;
        pkg.output = output;
        Package.configurePackage(pkg);
        return pkg;
    }

    private static void configurePackage(Package pkg) {
        try {
            pkg.contentTypeManager = new ZipContentTypeManager(null, pkg);
            pkg.contentTypeManager.addContentType(PackagingURIHelper.createPartName(PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_URI), "application/vnd.openxmlformats-package.relationships+xml");
            pkg.contentTypeManager.addContentType(PackagingURIHelper.createPartName("/default.xml"), "application/xml");
            pkg.packageProperties = new PackagePropertiesPart(pkg, PackagingURIHelper.CORE_PROPERTIES_PART_NAME);
            pkg.packageProperties.setCreatorProperty("Generated by OpenXML4J");
            pkg.packageProperties.setCreatedProperty(new Nullable<Date>(new Date()));
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    public void flush() {
        this.throwExceptionIfReadOnly();
        if (this.packageProperties != null) {
            this.packageProperties.flush();
        }
        this.flushImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.packageAccess == PackageAccess.READ) {
            logger.warn((Object)"The close() method is intended to SAVE a package. This package is open in READ ONLY mode, use the revert() method instead !");
            return;
        }
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        try {
            l.writeLock().lock();
            if (this.originalPackagePath != null && !"".equals(this.originalPackagePath.trim())) {
                File targetFile = new File(this.originalPackagePath);
                if (!targetFile.exists() || !this.originalPackagePath.equalsIgnoreCase(targetFile.getAbsolutePath())) {
                    this.save(targetFile);
                } else {
                    this.closeImpl();
                }
            } else if (this.output != null) {
                this.save(this.output);
            }
        }
        finally {
            l.writeLock().unlock();
        }
        this.contentTypeManager.clearAll();
        Runtime.getRuntime().gc();
    }

    public void revert() {
        this.revertImpl();
    }

    public void addThumbnail(String path) {
        String filename = path.substring(path.lastIndexOf(File.separatorChar) + 1);
        String contentType = ContentTypes.getContentTypeFromFileExtension(filename);
        PackagePartName thumbnailPartName = null;
        try {
            thumbnailPartName = PackagingURIHelper.createPartName("/docProps/" + filename);
        }
        catch (InvalidFormatException e) {
            throw new OpenXML4JRuntimeException("You already add a thumbnail named '" + filename + "'");
        }
        this.createPart(thumbnailPartName, contentType, false);
        this.addRelationship(thumbnailPartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail", "rId1");
    }

    void throwExceptionIfReadOnly() throws InvalidOperationException {
        if (this.packageAccess == PackageAccess.READ) {
            throw new InvalidOperationException("Operation not allowed, document open in read only mode!");
        }
    }

    void throwExceptionIfWriteOnly() throws InvalidOperationException {
        if (this.packageAccess == PackageAccess.WRITE) {
            throw new InvalidOperationException("Operation not allowed, document open in write only mode!");
        }
    }

    public PackageProperties getPackageProperties() throws InvalidFormatException {
        this.throwExceptionIfWriteOnly();
        if (this.packageProperties == null) {
            this.packageProperties = new PackagePropertiesPart(this, PackagingURIHelper.CORE_PROPERTIES_PART_NAME);
        }
        return this.packageProperties;
    }

    public PackagePart getPart(PackagePartName partName) {
        this.throwExceptionIfWriteOnly();
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList == null) {
            try {
                this.getParts();
            }
            catch (InvalidFormatException e) {
                return null;
            }
        }
        return this.getPartImpl(partName);
    }

    public ArrayList<PackagePart> getPartsByContentType(String contentType) {
        ArrayList<PackagePart> retArr = new ArrayList<PackagePart>();
        for (PackagePart part : this.partList.values()) {
            if (!part.getContentType().equals(contentType)) continue;
            retArr.add(part);
        }
        return retArr;
    }

    public ArrayList<PackagePart> getPartsByRelationshipType(String relationshipType) {
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        ArrayList<PackagePart> retArr = new ArrayList<PackagePart>();
        try {
            for (PackageRelationship rel : this.getRelationshipsByType(relationshipType)) {
                retArr.add(this.getPart(rel));
            }
        }
        catch (OpenXML4JException e) {
            logger.warn((Object)"Can't retrieve parts by relationship type: an exception has been thrown by getRelationshipsByType method");
            return null;
        }
        return retArr;
    }

    public PackagePart getPart(PackageRelationship partRel) {
        PackagePart retPart = null;
        this.ensureRelationships();
        for (PackageRelationship rel : this.relationships) {
            if (!rel.getRelationshipType().equals(partRel.getRelationshipType())) continue;
            try {
                retPart = this.getPart(PackagingURIHelper.createPartName(rel.getTargetURI()));
                break;
            }
            catch (InvalidFormatException e) {
            }
        }
        return retPart;
    }

    public ArrayList<PackagePart> getParts() throws InvalidFormatException {
        this.throwExceptionIfWriteOnly();
        if (this.partList == null) {
            boolean hasCorePropertiesPart = false;
            PackagePart[] parts = this.getPartsImpl();
            this.partList = new PackagePartCollection();
            for (PackagePart part : parts) {
                PartUnmarshaller partUnmarshaller;
                if (this.partList.containsKey(part.partName)) {
                    throw new InvalidFormatException("A part with the name '" + part.partName + "' already exist : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
                }
                if (part.getContentType().equals("application/vnd.openxmlformats-package.core-properties+xml")) {
                    if (!hasCorePropertiesPart) {
                        hasCorePropertiesPart = true;
                    } else {
                        throw new InvalidFormatException("OPC Compliance error [M4.1]: there is more than one core properties relationship in the package !");
                    }
                }
                if ((partUnmarshaller = this.partUnmarshallers.get(part.contentType)) != null) {
                    UnmarshallContext context = new UnmarshallContext(this, part.partName);
                    try {
                        PackagePart unmarshallPart = partUnmarshaller.unmarshall(context, part.getInputStream());
                        this.partList.put(unmarshallPart.partName, unmarshallPart);
                        if (!(unmarshallPart instanceof PackagePropertiesPart)) continue;
                        this.packageProperties = (PackagePropertiesPart)unmarshallPart;
                        continue;
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Unmarshall operation : IOException for " + part.partName));
                        continue;
                    }
                    catch (InvalidOperationException invoe) {
                        throw new InvalidFormatException(invoe.getMessage());
                    }
                }
                try {
                    this.partList.put(part.partName, part);
                }
                catch (InvalidOperationException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            }
        }
        return new ArrayList<PackagePart>(this.partList.values());
    }

    public PackagePart createPart(PackagePartName partName, String contentType) {
        return this.createPart(partName, contentType, true);
    }

    PackagePart createPart(PackagePartName partName, String contentType, boolean loadRelationships) {
        this.throwExceptionIfReadOnly();
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (contentType == null || contentType == "") {
            throw new IllegalArgumentException("contentType");
        }
        if (this.partList.containsKey(partName) && !((PackagePart)this.partList.get(partName)).isDeleted()) {
            throw new InvalidOperationException("A part with the name '" + partName.getName() + "' already exists : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
        }
        if (contentType == "application/vnd.openxmlformats-package.core-properties+xml" && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: you try to add more than one core properties relationship in the package !");
        }
        PackagePart part = this.createPartImpl(partName, contentType, loadRelationships);
        this.contentTypeManager.addContentType(partName, contentType);
        this.partList.put(partName, part);
        this.isDirty = true;
        return part;
    }

    public PackagePart createPart(PackagePartName partName, String contentType, ByteArrayOutputStream content) {
        PackagePart addedPart = this.createPart(partName, contentType);
        if (addedPart == null) {
            return null;
        }
        if (content != null) {
            try {
                OutputStream partOutput = addedPart.getOutputStream();
                if (partOutput == null) {
                    return null;
                }
                partOutput.write(content.toByteArray(), 0, content.size());
                partOutput.close();
            }
            catch (IOException ioe) {
                return null;
            }
        } else {
            return null;
        }
        return addedPart;
    }

    protected PackagePart addPackagePart(PackagePart part) {
        this.throwExceptionIfReadOnly();
        if (part == null) {
            throw new IllegalArgumentException("part");
        }
        if (this.partList.containsKey(part.partName)) {
            if (!((PackagePart)this.partList.get(part.partName)).isDeleted()) {
                throw new InvalidOperationException("A part with the name '" + part.partName.getName() + "' already exists : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
            }
            part.setDeleted(false);
            this.partList.remove(part.partName);
        }
        this.partList.put(part.partName, part);
        this.isDirty = true;
        return part;
    }

    public void removePart(PackagePart part) {
        if (part != null) {
            this.removePart(part.getPartName());
        }
    }

    public void removePart(PackagePartName partName) {
        this.throwExceptionIfReadOnly();
        if (partName == null || !this.containPart(partName)) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList.containsKey(partName)) {
            ((PackagePart)this.partList.get(partName)).setDeleted(true);
            this.removePartImpl(partName);
            this.partList.remove(partName);
        } else {
            this.removePartImpl(partName);
        }
        this.contentTypeManager.removeContentType(partName);
        if (partName.isRelationshipPartURI()) {
            PackagePart part;
            PackagePartName sourcePartName;
            URI sourceURI = PackagingURIHelper.getSourcePartUriFromRelationshipPartUri(partName.getURI());
            try {
                sourcePartName = PackagingURIHelper.createPartName(sourceURI);
            }
            catch (InvalidFormatException e) {
                logger.error((Object)("Part name URI '" + sourceURI + "' is not valid ! This message is not intended to be displayed !"));
                return;
            }
            if (sourcePartName.getURI().equals(PackagingURIHelper.PACKAGE_ROOT_URI)) {
                this.clearRelationships();
            } else if (this.containPart(sourcePartName) && (part = this.getPart(sourcePartName)) != null) {
                part.clearRelationships();
            }
        }
        this.isDirty = true;
    }

    public void removePartRecursive(PackagePartName partName) throws InvalidFormatException {
        PackagePart relPart = (PackagePart)this.partList.get(PackagingURIHelper.getRelationshipPartName(partName));
        PackagePart partToRemove = (PackagePart)this.partList.get(partName);
        if (relPart != null) {
            PackageRelationshipCollection partRels = new PackageRelationshipCollection(partToRemove);
            for (PackageRelationship rel : partRels) {
                PackagePartName partNameToRemove = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(rel.getSourceURI(), rel.getTargetURI()));
                this.removePart(partNameToRemove);
            }
            this.removePart(relPart.partName);
        }
        this.removePart(partToRemove.partName);
    }

    public void deletePart(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        this.removePart(partName);
        this.removePart(PackagingURIHelper.getRelationshipPartName(partName));
    }

    public void deletePartRecursive(PackagePartName partName) {
        if (partName == null || !this.containPart(partName)) {
            throw new IllegalArgumentException("partName");
        }
        PackagePart partToDelete = this.getPart(partName);
        this.removePart(partName);
        try {
            for (PackageRelationship relationship : partToDelete.getRelationships()) {
                PackagePartName targetPartName = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(partName.getURI(), relationship.getTargetURI()));
                this.deletePartRecursive(targetPartName);
            }
        }
        catch (InvalidFormatException e) {
            logger.warn((Object)("An exception occurs while deleting part '" + partName.getName() + "'. Some parts may remain in the package. - " + e.getMessage()));
            return;
        }
        PackagePartName relationshipPartName = PackagingURIHelper.getRelationshipPartName(partName);
        if (relationshipPartName != null && this.containPart(relationshipPartName)) {
            this.removePart(relationshipPartName);
        }
    }

    public boolean containPart(PackagePartName partName) {
        return this.getPart(partName) != null;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType, String relID) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties") && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: can't add another core properties part ! Use the built-in package method instead.");
        }
        if (targetPartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        this.ensureRelationships();
        PackageRelationship retRel = this.relationships.addRelationship(targetPartName.getURI(), targetMode, relationshipType, relID);
        this.isDirty = true;
        return retRel;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType) {
        return this.addRelationship(targetPartName, targetMode, relationshipType, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType) {
        return this.addExternalRelationship(target, relationshipType, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType, String id) {
        URI targetURI;
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        try {
            targetURI = new URI(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target - " + e);
        }
        this.ensureRelationships();
        PackageRelationship retRel = this.relationships.addRelationship(targetURI, TargetMode.EXTERNAL, relationshipType, id);
        this.isDirty = true;
        return retRel;
    }

    @Override
    public void removeRelationship(String id) {
        if (this.relationships != null) {
            this.relationships.removeRelationship(id);
            this.isDirty = true;
        }
    }

    @Override
    public PackageRelationshipCollection getRelationships() throws OpenXML4JException {
        return this.getRelationshipsHelper(null);
    }

    @Override
    public PackageRelationshipCollection getRelationshipsByType(String relationshipType) throws IllegalArgumentException, OpenXML4JException {
        this.throwExceptionIfWriteOnly();
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        return this.getRelationshipsHelper(relationshipType);
    }

    private PackageRelationshipCollection getRelationshipsHelper(String id) throws OpenXML4JException {
        this.throwExceptionIfWriteOnly();
        this.ensureRelationships();
        return this.relationships.getRelationships(id);
    }

    @Override
    public void clearRelationships() {
        if (this.relationships != null) {
            this.relationships.clear();
            this.isDirty = true;
        }
    }

    public void ensureRelationships() {
        if (this.relationships == null) {
            try {
                this.relationships = new PackageRelationshipCollection(this);
            }
            catch (InvalidFormatException e) {
                this.relationships = new PackageRelationshipCollection();
            }
        }
    }

    @Override
    public PackageRelationship getRelationship(String id) {
        return this.relationships.getRelationshipByID(id);
    }

    @Override
    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRelationshipExists(PackageRelationship rel) {
        try {
            for (PackageRelationship r : this.getRelationships()) {
                if (r != rel) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            return false;
        }
    }

    public void addMarshaller(String contentType, PartMarshaller marshaller) {
        try {
            this.partMarshallers.put(new ContentType(contentType), marshaller);
        }
        catch (InvalidFormatException e) {
            logger.warn((Object)("The specified content type is not valid: '" + e.getMessage() + "'. The marshaller will not be added !"));
        }
    }

    public void addUnmarshaller(String contentType, PartUnmarshaller unmarshaller) {
        try {
            this.partUnmarshallers.put(new ContentType(contentType), unmarshaller);
        }
        catch (InvalidFormatException e) {
            logger.warn((Object)("The specified content type is not valid: '" + e.getMessage() + "'. The unmarshaller will not be added !"));
        }
    }

    public void removeMarshaller(String contentType) {
        this.partMarshallers.remove(contentType);
    }

    public void removeUnmarshaller(String contentType) {
        this.partUnmarshallers.remove(contentType);
    }

    public PackageAccess getPackageAccess() {
        return this.packageAccess;
    }

    public boolean validatePackage(Package pkg) throws InvalidFormatException {
        throw new InvalidOperationException("Not implemented yet !!!");
    }

    public void save(File targetFile) throws IOException {
        if (targetFile == null) {
            throw new IllegalArgumentException("targetFile");
        }
        this.throwExceptionIfReadOnly();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        this.save(fos);
    }

    public void save(OutputStream outputStream) throws IOException {
        this.throwExceptionIfReadOnly();
        this.saveImpl(outputStream);
    }

    protected abstract PackagePart createPartImpl(PackagePartName var1, String var2, boolean var3);

    protected abstract void removePartImpl(PackagePartName var1);

    protected abstract void flushImpl();

    protected abstract void closeImpl() throws IOException;

    protected abstract void revertImpl();

    protected abstract void saveImpl(OutputStream var1) throws IOException;

    protected abstract PackagePart getPartImpl(PackagePartName var1);

    protected abstract PackagePart[] getPartsImpl() throws InvalidFormatException;
}

