/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.samples.opc;

import java.io.File;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.StreamHelper;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.samples.DemoCore;

public class CreateWordprocessingMLDocument {
    public static void main(String[] args) throws Exception {
        DemoCore demoCore = new DemoCore();
        File outputDocument = new File(demoCore.getTestRootPath() + "sample_output.docx");
        Package pkg = Package.create(outputDocument);
        PackagePartName corePartName = PackagingURIHelper.createPartName("/word/document.xml");
        pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument", "rId1");
        PackagePart corePart = pkg.createPart(corePartName, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml");
        Document doc = DocumentHelper.createDocument();
        Namespace nsWordprocessinML = new Namespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        Element elDocument = doc.addElement(new QName("document", nsWordprocessinML));
        Element elBody = elDocument.addElement(new QName("body", nsWordprocessinML));
        Element elParagraph = elBody.addElement(new QName("p", nsWordprocessinML));
        Element elRun = elParagraph.addElement(new QName("r", nsWordprocessinML));
        Element elText = elRun.addElement(new QName("t", nsWordprocessinML));
        elText.setText("Hello Open XML !");
        StreamHelper.saveXmlInStream(doc, corePart.getOutputStream());
        pkg.close();
    }
}

