/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.samples.opc;

import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.samples.DemoCore;

public class GetCorePart {
    public PackagePart getCorePartUri(String fileName) {
        try {
            Package p = Package.open(fileName, PackageAccess.READ);
            PackageRelationship coreDocRelationship = p.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
            PackagePart corePart = p.getPart(coreDocRelationship);
            return corePart;
        }
        catch (OpenXML4JException e) {
            DemoCore.getLogger().debug((Object)e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        DemoCore demoCore = new DemoCore();
        GetCorePart demo = new GetCorePart();
        String docPath = args.length == 1 ? demoCore.getTestRootPath() + args[0] : demoCore.getTestRootPath() + "sample.docx";
        PackagePart corePart = demo.getCorePartUri(docPath);
        if (corePart != null) {
            System.out.println(corePart.getPartName() + " -> " + corePart.getContentType());
        } else {
            System.out.println("The specified file is not valid !");
        }
    }
}

