/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.gridrulerguide;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.RulerGuideDrag;
import com.mathworks.toolbox.matlab.guide.scroll.ScrollRuler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class LayoutRuler
extends ScrollRuler
implements MouseListener,
MouseMotionListener {
    private LayoutArea fLayoutArea;
    private RulerGuideDrag fGuideTracker;
    static final String SHOWRULERS = "LayoutShowRulers";

    public LayoutRuler(LayoutArea layoutArea, int n, int n2) {
        super(n, 10, 50);
        this.setLabelStart(n2);
        this.setVisible(Prefs.getBooleanPref((String)SHOWRULERS, (boolean)false));
        this.fLayoutArea = layoutArea;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setLabelStart(int n) {
        int n2 = this.getLabelStart();
        if (n != n2) {
            super.setLabelStart(n);
            if (n == 0) {
                this.setLabelInterval(this.getMajorInterval());
            } else if (n2 == 0) {
                this.setLabelInterval(-this.getMajorInterval());
            }
        }
    }

    public int getGridWidth() {
        return this.getMajorInterval();
    }

    public void setGridWidth(int n) {
        this.setMajorInterval(n);
        if (this.getLabelStart() == 0) {
            this.setLabelInterval(n);
        } else {
            this.setLabelInterval(-n);
        }
        this.setLabelUnit(n);
    }

    public boolean getRulerState() {
        return this.isVisible();
    }

    public synchronized void setRulerState(boolean bl) {
        if (this.getRulerState() != bl) {
            this.setVisible(bl);
            Prefs.setBooleanPref((String)SHOWRULERS, (boolean)bl);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fGuideTracker = new RulerGuideDrag(this.fLayoutArea, this.getOrientation());
        this.fGuideTracker.mousePressed(mouseEvent);
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this.fGuideTracker != null) {
            this.fGuideTracker.mouseReleased(mouseEvent);
            this.fGuideTracker = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fGuideTracker != null) {
            this.fGuideTracker.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getOrientation() == 1) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.getOrientation() == 0) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public static Component buildMitre() {
        return new RulerMitre();
    }

    private static class RulerMitre
    extends Component {
        private RulerMitre() {
        }

        @Override
        public void paint(Graphics graphics) {
            ScrollRuler.drawMitre(graphics, this.getSize());
        }
    }
}

