/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.mathworks.toolbox.matlab.guide.icons.MenuEditorIcon;
import com.mathworks.toolbox.matlab.guide.icons.MoveIcon;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditor;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorAction;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorCommand;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorUtils;
import java.util.HashMap;
import javax.swing.Icon;

public class MenuEditorActionManager {
    private HashMap<MenuEditorCommand, MenuEditorAction> actionMap;
    private MenuEditor editor;

    public MenuEditorActionManager(MenuEditor menuEditor) {
        this.editor = menuEditor;
        this.actionMap = new HashMap(20);
        this.createMenuEditorActions();
    }

    public MenuEditorAction getAction(MenuEditorCommand menuEditorCommand) {
        return this.actionMap.get((Object)menuEditorCommand);
    }

    private void createMenuEditorActions() {
        this.addAction(MenuEditorCommand.NEW_MENU, MenuEditorIcon.NEW_MENU.getIcon(), "command.NewMenu");
        this.addAction(MenuEditorCommand.NEW_MENUITEM, MenuEditorIcon.NEW_MENUITEM.getIcon(), "command.NewMenuItem");
        this.addAction(MenuEditorCommand.NEW_CONTEXTMENU, MenuEditorIcon.NEW_CONTEXTMENU.getIcon(), "command.NewContextMenu");
        this.addAction(MenuEditorCommand.MOVE_BACKWARD, MoveIcon.MOVE_BACKWARD.getIcon(), "command.MoveBackward");
        this.addAction(MenuEditorCommand.MOVE_FORWARD, MoveIcon.MOVE_FORWARD.getIcon(), "command.MoveForward");
        this.addAction(MenuEditorCommand.MOVE_UP, MoveIcon.MOVE_UP.getIcon(), "command.MoveUp");
        this.addAction(MenuEditorCommand.MOVE_DOWN, MoveIcon.MOVE_DOWN.getIcon(), "command.MoveDown");
        this.addAction(MenuEditorCommand.DELETE, MenuEditorIcon.DELETE.getIcon(), "command.Delete");
    }

    private void addAction(MenuEditorCommand menuEditorCommand, Icon icon, String string) {
        String string2 = MenuEditorUtils.getResource(string);
        MenuEditorAction menuEditorAction = new MenuEditorAction(this.editor, menuEditorCommand, icon, string2);
        menuEditorAction.setName(string);
        menuEditorAction.setEnabled(menuEditorCommand.getDefaultEnabledState());
        this.actionMap.put(menuEditorCommand, menuEditorAction);
    }
}

