/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.udc.client;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.RequestContent;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.udc.client.EmptyResponseHandler;
import com.mathworks.webservices.udc.client.UDCClient;
import com.mathworks.webservices.udc.model.Events;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXB;

public class UDCClientImpl
extends MathWorksWebServiceClient
implements UDCClient {
    private final String clientVersion = "1.0";
    private String token;
    private String applicationName;
    private String locale;
    private String clientString;
    private String applicationVersion;

    public UDCClientImpl() {
        this(new ClientConfiguration());
    }

    public UDCClientImpl(ClientConfiguration clientConfiguration) {
        super(clientConfiguration, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.udc.model"));
    }

    protected UDCClientImpl(MathWorksHttpClient httpClient) {
        super(httpClient, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.udc.model"));
    }

    @Override
    public void logEvents(Events events) throws MathWorksServiceException, MathWorksClientException {
        this.validateRequiredHeaders();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)events, (OutputStream)outputStream);
        RequestContent requestContent = new RequestContent(outputStream.toByteArray(), "application/xml");
        EntityEnclosingRequest httpRequest = new EntityEnclosingRequest(HttpMethodName.POST, this.endpoint, "/events");
        httpRequest.setRequestContent(requestContent);
        httpRequest.setClientString(this.clientString);
        httpRequest.setLocale(this.locale);
        httpRequest.addHeader("x-mw-authentication", this.token);
        httpRequest.addHeader("x-mw-udc-application-name", this.applicationName);
        httpRequest.addHeader("x-mw-udc-client-version", "1.0");
        httpRequest.addHeader("x-mw-udc-application-version", this.applicationVersion);
        this.executeRequest((HttpRequest)httpRequest, new EmptyResponseHandler());
    }

    @Override
    public void ping() {
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, this.endpoint, "/ping");
        httpRequest.setClientString(this.clientString);
        this.executeRequest(httpRequest, new EmptyResponseHandler());
    }

    private void validateRequiredHeaders() throws MathWorksClientException {
        if (this.token == null || this.token.length() == 0) {
            throw new MathWorksClientException("A token is required to make this request");
        }
        if (this.applicationName == null || this.applicationName.length() == 0) {
            throw new MathWorksClientException("An application name is required to make this request");
        }
        if (this.applicationVersion == null || this.applicationVersion.length() == 0) {
            throw new MathWorksClientException("An application version is required to make this request");
        }
        if (this.locale == null || this.locale.length() == 0) {
            throw new MathWorksClientException("A locale is required to make this request");
        }
        if (this.clientString == null || this.clientString.length() == 0) {
            throw new MathWorksClientException("An client string is required to make this request");
        }
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void setClientString(String clientString) {
        this.clientString = clientString;
    }

    @Override
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    public void setEndPoint(String endPoint) {
        super.setEndpoint(endPoint);
    }
}

