/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute.stackmap;

import com.vladium.jcd.cls.attribute.stackmap.AppendFrame;
import com.vladium.jcd.cls.attribute.stackmap.ChopFrame;
import com.vladium.jcd.cls.attribute.stackmap.FullFrame;
import com.vladium.jcd.cls.attribute.stackmap.SameFrame;
import com.vladium.jcd.cls.attribute.stackmap.SameFrameExtended;
import com.vladium.jcd.cls.attribute.stackmap.SameLocalFrame;
import com.vladium.jcd.cls.attribute.stackmap.SameLocalFrameExtended;
import com.vladium.jcd.cls.attribute.stackmap.StackMapFrame_info;
import com.vladium.jcd.lib.UDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StackMapFrameFactory {
    public static StackMapFrame_info getStackMapFrame(int frameType, UDataInputStream bytes) throws IOException {
        if (frameType < 64) {
            return new SameFrame(frameType);
        }
        if (frameType < 128) {
            return new SameLocalFrame(frameType - 64, bytes);
        }
        if (frameType == 247) {
            return new SameLocalFrameExtended(bytes);
        }
        if (frameType < 251) {
            return new ChopFrame(frameType, bytes);
        }
        if (frameType == 251) {
            return new SameFrameExtended(bytes);
        }
        if (frameType < 255) {
            return new AppendFrame(frameType, bytes);
        }
        if (frameType == 255) {
            return new FullFrame(bytes);
        }
        throw new IllegalArgumentException("unknown stack map frame type: " + frameType);
    }

    public static StackMapFrame_info downcastStackMapFrame(StackMapFrame_info info) {
        int frameType = info.getFrameType();
        if (frameType < 64) {
            return (SameFrame)info;
        }
        if (frameType < 128) {
            return (SameLocalFrame)info;
        }
        if (frameType == 247) {
            return (SameLocalFrameExtended)info;
        }
        if (frameType < 251) {
            return (ChopFrame)info;
        }
        if (frameType == 251) {
            return (SameFrameExtended)info;
        }
        if (frameType < 255) {
            return (AppendFrame)info;
        }
        if (frameType == 255) {
            return (FullFrame)info;
        }
        throw new IllegalArgumentException("unknown stack map frame type: " + frameType);
    }

    public static StackMapFrame_info changeFrameToExtended(StackMapFrame_info frame) {
        int offsetDelta = frame.getOffsetDelta();
        if (frame instanceof SameFrame) {
            return new SameFrameExtended(offsetDelta);
        }
        if (frame instanceof SameLocalFrame) {
            return new SameLocalFrameExtended(offsetDelta, frame.getStack());
        }
        return frame;
    }

    public static StackMapFrame_info convertFirstVerificationType(StackMapFrame_info frame, List initialLocals) {
        int offsetDelta = frame.getOffsetDelta();
        ArrayList temp = new ArrayList();
        if (!(frame instanceof FullFrame)) {
            temp.addAll(initialLocals);
        }
        temp.addAll(frame.getLocal());
        return new FullFrame(offsetDelta, temp, frame.getStack());
    }
}

