/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.tooltip.BalloonTip;
import com.mathworks.help.helpui.DocPage;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.FilePathReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTipPanel;
import com.mathworks.mlwidgets.actionbrowser.HelpOnSelectionProvider;
import com.mathworks.mlwidgets.actionbrowser.TransparentDialog;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.StringEscapeUtils;

public final class ActionToolTip {
    private ActionToolTipPanel fTipPanel;
    private Point fArrowPointLocation;
    private BalloonToolTip fBalloonTip;
    private TransparentDialog fDialog;
    private ActionBrowserBalloonTip fActionBrowserBalloonTip;
    private boolean fDetached = false;
    private int fAlign = 2;
    private boolean fMouseWheelFocusState = false;
    private boolean fMouseWheelFocusManualState = false;
    private static final String resStr = "com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser";
    private static final String key = "ActionToolTip.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser");
    private static int DEFAULT_MARGIN = 10;

    private ActionToolTip(Dialog dialog, ActionToolTipPanel actionToolTipPanel) {
        Rectangle rectangle = WindowUtils.getVirtualScreenBounds();
        Dimension dimension = actionToolTipPanel.getPreferredSize();
        if (TransparentDialog.isTransparencySupported()) {
            this.fDialog = new TransparentDialog(dialog);
            this.fActionBrowserBalloonTip = new ActionBrowserBalloonTip((Component)((Object)actionToolTipPanel), dialog);
            this.fAlign = 4;
            Rectangle rectangle2 = dialog.getBounds();
            this.createBalloonTip(rectangle2, actionToolTipPanel, rectangle, dimension);
        } else {
            this.fAlign = dimension.width + dialog.getBounds().x + dialog.getBounds().width > rectangle.x + rectangle.width ? 2 : 4;
            this.fDialog = new TransparentDialog(dialog, true);
            this.fDialog.getContentPane().add((Component)((Object)actionToolTipPanel));
        }
        this.fTipPanel = actionToolTipPanel;
        actionToolTipPanel.setToolTipManager(this);
        this.fDialog.setTitle(resources.getString("ActionToolTip.LinuxTitle"));
    }

    private ActionToolTip(Frame frame, Rectangle rectangle, ActionToolTipPanel actionToolTipPanel) {
        Rectangle rectangle2 = WindowUtils.getVirtualScreenBounds();
        Dimension dimension = actionToolTipPanel.getPreferredSize();
        if (TransparentDialog.isTransparencySupported()) {
            this.fDialog = new TransparentDialog(frame);
            this.fActionBrowserBalloonTip = new ActionBrowserBalloonTip((Component)((Object)actionToolTipPanel), frame);
            this.fAlign = 4;
            this.createBalloonTip(rectangle, actionToolTipPanel, rectangle2, dimension);
        } else {
            this.fAlign = dimension.width + frame.getBounds().x + frame.getBounds().width > rectangle2.x + rectangle2.width ? 2 : 4;
            this.fDialog = new TransparentDialog(frame, true);
            this.fDialog.getContentPane().add((Component)((Object)actionToolTipPanel));
        }
        this.fTipPanel = actionToolTipPanel;
        actionToolTipPanel.setToolTipManager(this);
        this.fDialog.setTitle(resources.getString("ActionToolTip.LinuxTitle"));
    }

    private void createBalloonTip(Rectangle rectangle, ActionToolTipPanel actionToolTipPanel, Rectangle rectangle2, Dimension dimension) {
        rectangle.y = rectangle.y <= 1 + rectangle2.y ? 1 + rectangle2.y : rectangle.y;
        rectangle.y = rectangle.y + rectangle.height >= rectangle2.y + rectangle2.height ? rectangle2.y + rectangle2.height - rectangle.height : rectangle.y;
        this.fBalloonTip = BalloonToolTip.specialFactoryForJames((JDialog)((Object)this.fDialog), (Component)((Object)actionToolTipPanel), (List)BalloonToolTip.EAST_WEST, (Dimension)dimension, (Rectangle)rectangle, (BalloonTip)this.fActionBrowserBalloonTip);
        this.fBalloonTip.getBalloon().setForeground(Color.lightGray);
    }

    static ActionToolTip createActionToolTip(Dialog dialog, HelpOnSelectionProvider helpOnSelectionProvider) {
        return new ActionToolTip(dialog, new ActionToolTipPanel(helpOnSelectionProvider));
    }

    static ActionToolTip createActionToolTip(Dialog dialog, ActionToolTipPanel actionToolTipPanel, HelpOnSelectionProvider helpOnSelectionProvider) {
        if (actionToolTipPanel == null) {
            return ActionToolTip.createActionToolTip(dialog, helpOnSelectionProvider);
        }
        return new ActionToolTip(dialog, actionToolTipPanel);
    }

    public static ActionToolTip createActionToolTip(Frame frame, Rectangle rectangle, HelpOnSelectionProvider helpOnSelectionProvider) {
        return new ActionToolTip(frame, rectangle, new ActionToolTipPanel(helpOnSelectionProvider));
    }

    public static ActionToolTip createActionToolTip(Frame frame, ActionToolTipPanel actionToolTipPanel, Rectangle rectangle, HelpOnSelectionProvider helpOnSelectionProvider) {
        if (actionToolTipPanel == null) {
            return ActionToolTip.createActionToolTip(frame, rectangle, helpOnSelectionProvider);
        }
        return new ActionToolTip(frame, rectangle, actionToolTipPanel);
    }

    public TransparentDialog getDialog() {
        return this.fDialog;
    }

    public boolean isShowing() {
        return !this.fDetached && this.getDialog() != null && this.getDialog().isVisible();
    }

    private void setBorderColor(Color color) {
        if (this.fBalloonTip != null && this.fBalloonTip.getBalloon() != null) {
            this.fBalloonTip.getBalloon().setForeground(color);
            this.fBalloonTip.getBalloon().repaint();
        }
    }

    boolean isMouseWheelFocusState() {
        return this.fMouseWheelFocusState;
    }

    boolean isMouseWheelFocusManual() {
        return this.fMouseWheelFocusManualState;
    }

    void setMouseWheelFocus(boolean bl) {
        this.fMouseWheelFocusState = bl;
        if (this.fMouseWheelFocusState) {
            this.setBorderColor(Color.black);
        } else {
            this.setBorderColor(Color.lightGray);
        }
    }

    void setMouseWheelFocusManual(boolean bl) {
        this.fMouseWheelFocusManualState = bl;
    }

    int getAlignment() {
        return this.fAlign;
    }

    public BalloonTip getBalloon() {
        if (this.fBalloonTip != null) {
            return this.fBalloonTip.getBalloon();
        }
        return null;
    }

    void detach() {
        this.fDetached = true;
        this.getDialog().add((Component)((Object)this.fTipPanel), "Center");
        this.fTipPanel = null;
        this.getDialog().setTransparent(false);
        this.getDialog().setBackground(UIManager.getColor("ToolTip.background"));
        BalloonTip balloonTip = this.getBalloon();
        if (balloonTip != null) {
            balloonTip.hide();
        }
        this.getDialog().deParent();
        this.getDialog().setFocusableWindowState(true);
        this.getDialog().toFront();
    }

    ActionToolTipPanel getTipPanel() {
        return this.fTipPanel;
    }

    public void setArrowPointLocation(Point point) {
        this.fArrowPointLocation = point;
    }

    void openTooltip(String string, String string2, Url url, String string3, Url url2) {
        string = string.trim();
        this.showPopup(url, string, string2, string3, url2);
    }

    public void openTooltip(String string, String string2, Url url, String string3, String string4, Url url2) {
        string = string.trim();
        this.showPopup(url, string, string2, string3, string4, url2);
    }

    public void openTooltip(String string, String string2, boolean bl) {
        if (this.fBalloonTip != null) {
            this.fBalloonTip.setFocusableWindowState(false);
        }
        this.fTipPanel.setHtmlText("<html><i>" + string + "</i></html>");
        this.fTipPanel.setFunctionName(string2, null);
        this.fTipPanel.setHelpLinkVisible(bl);
        this.show();
    }

    void dispatchScrollEvent(AWTEvent aWTEvent) {
        if (!this.isShowing()) {
            return;
        }
        this.fTipPanel.dispatchScrollEvent(aWTEvent);
    }

    private void cleanup() {
        if (this.fActionBrowserBalloonTip != null) {
            this.fActionBrowserBalloonTip.removeListeners();
        }
        this.fTipPanel = null;
        this.fBalloonTip = null;
        this.fDialog = null;
        this.fActionBrowserBalloonTip = null;
    }

    private void showPopup(Url url, String string, String string2, String string3, Url url2) {
        this.showPopup(url, string, string2, string3, null, url2);
    }

    private void showPopup(Url url, String string, String string2, String string3, String string4, Url url2) {
        if (this.fBalloonTip != null) {
            this.fBalloonTip.setFocusableWindowState(false);
        }
        ActionToolTip.populateTipPanel(this.fTipPanel, url, string, null, string2, string3, string4, url2);
        this.fDialog.setName("ActionToolTip:" + string);
        this.show();
    }

    public static void populateTipPanel(final ActionToolTipPanel actionToolTipPanel, Url url, final String string, final String string2, String string3, final String string4, final String string5, Url url2) {
        Object object;
        if (url == null) {
            actionToolTipPanel.setHtmlText("<html><i>" + resources.getString("ActionToolTip.RetrievingMsg") + string + "...</i></html>");
            MatlabWorker matlabWorker = new MatlabWorker(){

                public Object runOnMatlabThread() {
                    try {
                        return Matlab.mtFeval((String)"help", (Object[])new Object[]{"-helpwin", string}, (int)2);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    if (object == null) {
                        return;
                    }
                    Object[] objectArray = (Object[])object;
                    String string3 = (String)objectArray[0];
                    if (string3 == null) {
                        actionToolTipPanel.setHtmlText(resources.getString("ActionToolTip.NoFile"));
                        return;
                    }
                    string3 = ActionToolTip.escapeHtml(string3);
                    string3 = string3.replaceAll("\n", "<br>");
                    string3 = ActionBrowserUtils.hiliteKeyword(string3, string4);
                    if (string5 != null) {
                        String string22 = ActionToolTip.escapeHtml(string5);
                        actionToolTipPanel.setHtmlText("<html><body>" + ActionToolTip.getSelectionMessageHtml(string22) + "<br><br>" + string3 + "</body></html>");
                    } else {
                        actionToolTipPanel.setHtmlText("<html><body>" + string3 + "</body></html>");
                    }
                    actionToolTipPanel.setFunctionName(string, null);
                    if (string2 != null) {
                        actionToolTipPanel.setShortDescription(string2);
                    }
                }
            };
            matlabWorker.start();
            return;
        }
        String string6 = null;
        try {
            object = ActionToolTip.getProductPathWrapperForUrl(url);
            string6 = ActionToolTip.getDescriptionFromDocAPI((ProductPathWrapper)object);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string6 == null) {
            actionToolTipPanel.setHtmlText(resources.getString("ActionToolTip.NoDesc"));
        } else {
            object = ActionToolTip.getLocalizedHtmlTag();
            String string7 = ActionToolTip.escapeHtml(string3);
            if (string5 != null) {
                String string8 = ActionToolTip.escapeHtml(string5);
                actionToolTipPanel.setHtmlText((String)object + "<b>" + string7 + "</b><br>" + ActionToolTip.getSelectionMessageHtml(string8) + string6 + "</html>");
            } else {
                actionToolTipPanel.setHtmlText((String)object + "<b>" + string7 + "</b><br>" + string6 + "</html>");
            }
        }
        try {
            object = ActionBrowserUtils.correctUrlForFileProtocol(url2.toString());
            actionToolTipPanel.setFunctionName(string, new URL((String)object));
        }
        catch (MalformedURLException malformedURLException) {
            actionToolTipPanel.setFunctionName(string, null);
        }
        if (string2 != null) {
            actionToolTipPanel.setShortDescription(string2);
        }
        actionToolTipPanel.setName("ActionToolTipPanel:" + string);
    }

    private static ProductPathWrapper getProductPathWrapperForUrl(Url url) throws MalformedURLException {
        DocSetItem docSetItem;
        DocCenterDocConfig<FileUrl> docCenterDocConfig = DocCenterDocConfig.getLocalConfig();
        DocPage docPage = docCenterDocConfig.getDocUrlParser().resolve(url);
        if (docPage != null && docPage.getDocSetItem() != null && (docSetItem = docPage.getDocSetItem()) instanceof DocProduct) {
            return new ProductPathWrapper((DocProduct)docSetItem, docPage.getRelativeUrl().getRelativePath());
        }
        return null;
    }

    private static String getDescriptionFromDocAPI(ProductPathWrapper productPathWrapper) {
        if (productPathWrapper == null) {
            return null;
        }
        String string = null;
        FilePathReferenceRequest filePathReferenceRequest = new FilePathReferenceRequest(productPathWrapper.getDocProduct(), HelpUtils.removeLocalizedPath(productPathWrapper.getRelativePath()));
        List<ReferenceData> list = ActionToolTip.getReferenceData((ReferenceRequest)filePathReferenceRequest);
        if (!list.isEmpty()) {
            string = ActionToolTip.escapeHtml(list.get(0).getDescription()) + "<br>";
            List list2 = list.get(0).getSyntaxLines();
            string = string + "<pre>";
            for (String string2 : list2) {
                string2 = ActionToolTip.escapeHtml(string2);
                string = string + string2 + "<br>";
            }
            string = string + "</pre>";
        }
        return string;
    }

    private static String escapeHtml(String string) {
        return StringEscapeUtils.escapeHtml((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        try {
            List list = referenceDataRetriever.getReferenceData(referenceRequest);
            return list;
        }
        finally {
            try {
                referenceDataRetriever.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getLocalizedHtmlTag() {
        LanguageLocale languageLocale = HelpUtils.getLanguageLocale();
        switch (languageLocale) {
            case JAPANESE: 
            case KOREAN: {
                return "<html lang='" + languageLocale.getLanguage() + "'>";
            }
            case SIMPLIFIED_CHINESE: {
                return "<html lang='" + languageLocale.getLanguage() + "-" + languageLocale.getTerritory() + "'>";
            }
        }
        return "<html>";
    }

    private static String getSelectionMessageHtml(String string) {
        String string2 = ActionToolTip.class.getResource("/com/mathworks/mlwidgets/graphics/resources/dialog_warning_16.png").toString();
        return "<table border='1'  width='100%' cellspacing='0' style=\"background-color:#ffffff\"><tr><td><table border='0' width='100%' cellspacing='0' cellpadding = '1' style=background-color:#FFFFFF> <COL width='20' align='left'> <tr><td width='20'> <img src='" + string2 + "'></td><td>" + resources.getString("ActionToolTip.SelectionMsg") + "</td></tr><tr><td td width='25'></td><td><b>" + string + "</b></td></tr></table></td></tr></table>";
    }

    private void show() {
        if (this.fDialog == null || this.fDialog.isVisible()) {
            return;
        }
        if (this.fBalloonTip != null) {
            Insets insets = this.fBalloonTip.getShape().getInsets(null);
            Point point = new Point(this.fDialog.getBounds().x, this.fTipPanel.getDialogY(this.fArrowPointLocation, insets));
            double d = ((double)this.fArrowPointLocation.y - (double)point.y - (double)insets.top) / (double)this.fTipPanel.getPreferredSize().height;
            this.fBalloonTip.setArrowSlide(d);
            this.fDialog.setLocation(point);
            this.fBalloonTip.show();
            this.fAlign = this.getBalloon() != null && this.getBalloon().getHotSpot() != null && this.getBalloon().getHotSpot().x > this.getBalloon().getBalloonSize().width / 2 ? 2 : 4;
        } else {
            this.fDialog.pack();
            Rectangle rectangle = WindowUtils.getVirtualScreenBounds();
            Point point = new Point(this.fArrowPointLocation.x, this.fArrowPointLocation.y - (int)this.fDialog.getSize().getHeight() / 2);
            if (this.fDialog.getOwner() != null && this.fArrowPointLocation.x + this.fDialog.getSize().width > rectangle.x + rectangle.width) {
                point.x = this.fDialog.getOwnerBounds().x - this.fDialog.getSize().width;
                this.fAlign = 2;
            } else {
                this.fAlign = 4;
            }
            this.fDialog.setLocation(point);
            this.fDialog.setFocusableWindowState(BalloonToolTip.isAlwaysFocusable());
            this.fDialog.show();
        }
    }

    public void hide() {
        if (this.fDetached) {
            return;
        }
        if (TransparentDialog.isTransparencySupported() && this.getBalloon() != null && this.getBalloon().isVisible()) {
            this.getBalloon().hide();
        }
        if (this.getDialog() != null) {
            this.getDialog().dispose();
        }
        this.cleanup();
    }

    private class ActionBrowserBalloonTip
    extends BalloonTip {
        private ComponentListener fComponentListener;
        private Dialog fDialogOwner;
        private Frame fFrameOwner;

        public ActionBrowserBalloonTip(Component component, Dialog dialog) {
            super(component);
            this.fDialogOwner = dialog;
            if (this.fComponentListener == null) {
                this.fComponentListener = this.createComponentListener();
                this.fDialogOwner.addComponentListener(this.fComponentListener);
            }
        }

        public ActionBrowserBalloonTip(Component component, Frame frame) {
            super(component);
            this.fFrameOwner = frame;
            if (this.fComponentListener == null) {
                this.fComponentListener = this.createComponentListener();
                this.fFrameOwner.addComponentListener(this.fComponentListener);
            }
        }

        private ComponentAdapter createComponentListener() {
            return new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    ActionToolTip.this.hide();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    ActionToolTip.this.hide();
                }
            };
        }

        protected void customizePopup(JidePopup jidePopup) {
            super.customizePopup(jidePopup);
            jidePopup.setTransient(false);
        }

        public void removeListeners() {
            if (this.fDialogOwner != null) {
                this.fDialogOwner.removeComponentListener(this.fComponentListener);
            }
            if (this.fFrameOwner != null) {
                this.fFrameOwner.removeComponentListener(this.fComponentListener);
            }
        }

        protected JidePopup createPopup() {
            return new JidePopup(){

                public boolean isClickOnPopup(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, ActionBrowserBalloonTip.this.getContent().getParent());
                    return ActionBrowserBalloonTip.this.getContent().getParent().contains(point2);
                }

                protected Rectangle getAdjustedRectangle(int n, int n2, Component component) {
                    return new Rectangle(n, n2, 1, 1);
                }
            };
        }
    }

    private static class ProductPathWrapper {
        private final DocProduct iDocProduct;
        private final String iRelativePath;

        private ProductPathWrapper(DocProduct docProduct, String string) {
            this.iDocProduct = docProduct;
            this.iRelativePath = string;
        }

        private DocProduct getDocProduct() {
            return this.iDocProduct;
        }

        private String getRelativePath() {
            return this.iRelativePath;
        }
    }
}

