/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractDatasetTable;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.TabularObjectEditorProvider;
import com.mathworks.mlwidgets.array.TabularObjectPanel;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.VariableFormatSpecifier;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;

public abstract class AbstractDatasetProvider
extends TabularObjectEditorProvider
implements ISpreadsheetSelectionController,
VariableFormatSpecifier {
    private RangeSelectionModel fColSelectionModel;

    protected AbstractDatasetProvider(TabularObjectTableModel tabularObjectTableModel, AbstractDatasetTable abstractDatasetTable, TabularObjectPanel tabularObjectPanel) {
        super(tabularObjectTableModel, abstractDatasetTable, tabularObjectPanel);
    }

    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        return this.getTable().getSpreadsheetRowSelectionModel();
    }

    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        if (this.fColSelectionModel == null) {
            RangeSelectionModel rangeSelectionModel = this.getTable().getSpreadsheetColumnSelectionModel();
            this.fColSelectionModel = new ColumnSelectionModelProxy(rangeSelectionModel);
        }
        return this.fColSelectionModel;
    }

    public void removeEmptyRowsAndColumns(ValueMetaInfo valueMetaInfo) {
        int n = valueMetaInfo.getRowCount();
        int n2 = valueMetaInfo.getColumnCount();
        if (n >= this.getModel().getLastDataRow() && n2 >= this.getModel().getLastDataColumn()) {
            return;
        }
        if (n < this.getModel().getLastDataRow()) {
            this.getTable().removeEmptyRows(n);
        }
        if (n2 < this.getModel().getLastDataColumn()) {
            this.getTable().removeEmptyColumns(n2);
        }
        this.getModel().setValueMetaInfo(valueMetaInfo);
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.DATASET_ARRAY);
        arrayList.add(INewVariableProvider.CreationParams.SEPARATE_VARS);
        arrayList.add(INewVariableProvider.CreationParams.NUMERIC_ARRAY);
        return arrayList;
    }

    @Override
    public List<FormatToolsetSupplierFactory.FormatSupported> getSupportedFormats() {
        ArrayList<FormatToolsetSupplierFactory.FormatSupported> arrayList = new ArrayList<FormatToolsetSupplierFactory.FormatSupported>();
        arrayList.add(FormatToolsetSupplierFactory.FormatSupported.NUMERIC);
        arrayList.add(FormatToolsetSupplierFactory.FormatSupported.DATETIME);
        return arrayList;
    }

    @Override
    public void setFormat(FormatToolsetSupplierFactory.FormatSupported formatSupported, String string) {
        this.fModel.setVariableFormat(string);
    }

    @Override
    public String getFormat(String string) {
        return this.fModel.getVariableFormat(string);
    }

    private class ColumnSelectionModelProxy
    implements RangeSelectionModel {
        private final RangeSelectionModel fColSelModelFromTable;

        ColumnSelectionModelProxy(RangeSelectionModel rangeSelectionModel) {
            this.fColSelModelFromTable = rangeSelectionModel;
        }

        public String getSelectionRangeString() {
            int[] nArray = ((AbstractDatasetTable)AbstractDatasetProvider.this.getTable()).getSelectedIndices();
            List list = SpreadsheetUtils.getSelectionIntervals((int[])nArray);
            return SpreadsheetUtils.getSelectionString((List)list, (int)-1);
        }

        public int getSelectionUpperLimit() {
            return this.fColSelModelFromTable.getSelectionUpperLimit();
        }

        public void addSelectionRangeListener(ChangeListener changeListener) {
            this.fColSelModelFromTable.addSelectionRangeListener(changeListener);
        }

        public void removeSelectionRangeListener(ChangeListener changeListener) {
            this.fColSelModelFromTable.removeSelectionRangeListener(changeListener);
        }

        public void setSelectionIntervals(List<int[]> list) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
            for (int[] nArray : list) {
                arrayList.add(((AbstractDatasetTable)AbstractDatasetProvider.this.getTable()).getSelectionIntervalToSet(nArray[0], nArray[1]));
            }
            this.fColSelModelFromTable.setSelectionIntervals(arrayList);
        }
    }
}

