/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLArrayEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CategoricalVariableEditor;
import com.mathworks.mlwidgets.array.DatasetHeaderPopup;
import com.mathworks.mlwidgets.array.DatasetPopupPanel;
import com.mathworks.mlwidgets.array.DatetimeCellEditor;
import com.mathworks.mlwidgets.array.GroupHeaderUI;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ObjectIdentifier;
import com.mathworks.mlwidgets.array.RefreshableObjectVariableLiteral;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.data.CategoricalScalar;
import com.mathworks.mlwidgets.array.data.DatetimeScalar;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.Log;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatasetTable
extends TabularObjectTable {
    private ExtractDatasetVariablesAction fExtractDatasetVariablesAction;
    private MJMenu fExtractMenu;
    private MJAbstractAction fExtractAction;
    private MJAbstractAction fExtractDatasetVariableArrayAction;
    private MJAbstractAction fUngroupVariableAction;
    private MJAbstractAction fGroupVariableAction;
    private MJAbstractAction fConvertToCategoricalAction;
    private static final int MAX_OPEN_VARS = 5;

    public AbstractDatasetTable(TabularObjectTableModel tabularObjectTableModel) {
        super(tabularObjectTableModel);
        assert (this.getVariable().getWorkspaceID() == 0);
        this.fBorderRenderer = new TabularObjectTable.BorderedCellRenderer(this, this);
        this.fExtractAction = new ExtractDatasetAction(ArrayUtils.getResource(this.getMatlabClassName() + ".newdataset"));
        this.fExtractAction.setComponentName("ExtractDataset");
        this.fExtractDatasetVariableArrayAction = new ExtractDatasetVariableArrayAction();
        this.fExtractDatasetVariableArrayAction.setComponentName("ExtractMatlabArrays");
        this.fExtractDatasetVariablesAction = new ExtractDatasetVariablesAction();
        this.fExtractDatasetVariablesAction.setComponentName("ExtractSeparateArrays");
        this.fUngroupVariableAction = new UngroupVariableAction(this);
        this.fUngroupVariableAction.setComponentName("UngroupVariable");
        this.fGroupVariableAction = new GroupVariableAction(this);
        this.fGroupVariableAction.setComponentName("GroupVariable");
        this.fConvertToCategoricalAction = new ConvertToCategoricalAction();
        this.fConvertToCategoricalAction.setComponentName("ConvertToNominal");
        GraphingActionFactory.addGraphingActionListener(this);
        this.setupDeleteActions(this.getMatlabClassName());
        this.updateForSelectionChange(null);
        this.setupTableHeader("DatasetTableHeader");
        this.createDataProxy();
        this.fTabularObjectColumnModel = new TabularObjectColumnModel(this.getColumnCount(), this.getVariableName(), this.fDataProxy);
        this.fTabularObjectColumnModel.getSelectionModel().addListSelectionListener(this.fLSL);
        if (Matlab.isMatlabAvailable()) {
            this.fTabularObjectColumnModel.updateData();
        }
        this.setColumnModel(this.fTabularObjectColumnModel);
        this.getTableHeader().setUI(new GroupHeaderUI());
        this.setupColumnModelListener();
        this.getInsertAction().setEnabled(false);
        this.setupCellEditorListener();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected abstract void createDataProxy();

    private Collection<Integer> getVisibleColumnsIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Rectangle rectangle = this.getVisibleRect();
        for (int i = rectangle.x; i <= (int)rectangle.getWidth(); i += TabularObjectHeaderRenderer.getIconWidths() / 2) {
            Integer n = this.getTabularObjectColumnModel().getColumnIndexAtX(i);
            if (arrayList.contains(n)) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    @Override
    public void adjustVisibleColumnWidths() {
        Collection<Integer> collection = this.getVisibleColumnsIndices();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n : collection) {
            int[] nArray = this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n2 = nArray[1] - nArray[0];
            if (n2 <= 1 || arrayList.contains(n)) continue;
            int n3 = this.getTabularObjectColumnModel().getGroupColumnWidth(n);
            int n4 = n3 / n2;
            int n5 = n4 + (n3 - n4 * n2);
            for (int i = nArray[0]; i < nArray[1] - 1; ++i) {
                this.getTabularObjectColumnModel().getColumn(i).setPreferredWidth(n4);
                this.getTabularObjectColumnModel().getColumn(i).setWidth(n4);
                arrayList.add(i);
            }
            this.getTabularObjectColumnModel().getColumn(nArray[1] - 1).setPreferredWidth(n5);
            this.getTabularObjectColumnModel().getColumn(nArray[1] - 1).setWidth(n5);
            arrayList.add(nArray[1] - 1);
        }
    }

    protected void doRegionCut(ActionEvent actionEvent) {
        String string;
        this.doRegionCopy(actionEvent);
        if (this.isAllTabularObjectRowsSelected()) {
            List<TabularObjectColumnModel.VariableInfo> list = this.getTabularObjectColumnModel().getSelectedVariableInfo();
            if (list == null || list.isEmpty()) {
                return;
            }
            string = this.getVariableName() + "(:,{'" + list.get(0).getVarName() + "'";
            for (int i = 1; i < list.size(); ++i) {
                string = string + ",'" + list.get(i).getVarName() + "'";
            }
            string = string + "}) = [];";
        } else if (this.isAllTabularObjectColumnsSelected()) {
            int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
            List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])nArray);
            String string2 = SpreadsheetUtils.getSelectionString((List)list, (int)-1);
            string = this.getVariableName() + "(" + string2 + ",:) = [];";
        } else {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string, false);
    }

    public String getCellSubsrefString(int n, int n2) {
        int n3 = this.getTabularObjectColumnModel().getGroupIndex(n2);
        int n4 = this.getTabularObjectColumnModel().getStartColumn(n3);
        String string = this.getTabularObjectColumnModel().getVariableName(n3);
        String string2 = this.getTabularObjectColumnModel().getVariableMatlabClass(n3);
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (!"cell".equals(string2) && Arrays.equals(nArray, new int[]{1, 1})) {
            return this.getVariableName() + "." + string;
        }
        if ("cell".equals(string2)) {
            return this.getVariableName() + "." + string + "{" + Integer.toString(n + 1) + "," + Integer.toString(n2 - n4 + 1) + "}";
        }
        return this.getVariableName() + "." + string + "(" + Integer.toString(n + 1) + "," + Integer.toString(n2 - n4 + 1) + ")";
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof ValueDataSection && ((IReadOnlyData)object).isReadOnly() && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2 && ((InputEvent)eventObject).getModifiers() == 16) {
            final String string = this.getCellSubsrefString(n, n2);
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        MLArrayEditorServices.openVariable((String)string);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    protected void showMetadataPopup(int n) {
        int n2 = this.getTabularObjectColumnModel().getGroupIndex(n);
        int[] nArray = this.getTabularObjectColumnModel().getGroupColumnInterval(n);
        final DatasetPopupPanel datasetPopupPanel = new DatasetPopupPanel(this, n2);
        Rectangle rectangle = this.getTableHeader().getHeaderRect(nArray[1] - 1);
        Point point = new Point(rectangle.x + rectangle.width - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth(), rectangle.y + rectangle.height);
        SwingUtilities.convertPointToScreen(point, this.getTableHeader());
        final Point point2 = point;
        datasetPopupPanel.setSortEnabled(this.getTabularObjectColumnModel().isSortEnabled(n));
        datasetPopupPanel.populateMetadataFields(new Runnable(){

            @Override
            public void run() {
                final MJDialog mJDialog = DatasetHeaderPopup.showDatasetHeaderPopup((JComponent)((Object)AbstractDatasetTable.this), (JComponent)((Object)datasetPopupPanel), point2);
                datasetPopupPanel.setDismissAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        mJDialog.dispose();
                    }
                });
            }
        });
    }

    @Override
    public void doColumnInsert(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    @Override
    void doRowInsert(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    String getEvalStringForPasteInsert(TabularObjectTableModel.PasteType pasteType, String string, int n, int n2, int n3, int n4) {
        int n5;
        String string2 = null;
        int n6 = pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT ? n3 + 1 : 1;
        int n7 = n5 = pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW ? n4 + 1 : 1;
        if (pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS || pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'columns'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        } else if (pasteType == TabularObjectTableModel.PasteType.INSERTROWS || pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'rows'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        }
        return string2;
    }

    protected void doPaste(int n) {
        this.doPaste(n, TabularObjectTableModel.PasteType.PASTE);
    }

    void doPaste(int n, TabularObjectTableModel.PasteType pasteType) {
        MJClipboard mJClipboard = MJClipboard.getMJClipboard();
        TabularObjectTableModel.PasteType pasteType2 = pasteType;
        try {
            List list;
            SimpleVariableDefinition simpleVariableDefinition;
            if (mJClipboard != null && mJClipboard.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) && (simpleVariableDefinition = (SimpleVariableDefinition)(list = (List)mJClipboard.getData(MLDataFlavor.simpleVariableListFlavor)).get(0)) instanceof RefreshableObjectVariableLiteral.ObjectVariableDefinition) {
                String string;
                ObjectIdentifier objectIdentifier = ((RefreshableObjectVariableLiteral.ObjectVariableDefinition)simpleVariableDefinition).getObjectIdentifier();
                int n2 = this.getColumnModel().getSelectionModel().getMinSelectionIndex();
                int n3 = this.getSelectionModel().getMinSelectionIndex();
                int n4 = this.getColumnModel().getSelectionModel().getMaxSelectionIndex() - n2 + 1;
                int n5 = this.getSelectionModel().getMaxSelectionIndex() - n3 + 1;
                int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
                if (n2 > nArray[1]) {
                    n2 = nArray[1] + 1;
                    pasteType = TabularObjectTableModel.PasteType.INSERTCOLUMNS;
                }
                if (pasteType.isInsert()) {
                    string = this.getEvalStringForPasteInsert(pasteType, objectIdentifier.getKey(), n2, n3, n4, n5);
                } else {
                    List list2 = AbstractDatasetTable.getSelectionIntervals((int[])this.getSelectedRows());
                    List list3 = AbstractDatasetTable.getSelectionIntervals((int[])this.getSelectedColumns());
                    String string2 = "arrayviewfunc('retrieveValue','" + objectIdentifier.getKey() + "')";
                    string = this.getVariableName() + "= variableEditorPaste(" + this.getVariableName() + "," + SpreadsheetUtils.getSelectionString((List)list2, (int)-1) + "," + SpreadsheetUtils.getSelectionString((List)list3, (int)-1) + "," + string2 + ");";
                    if (list2.size() == 1 && list3.size() == 1) {
                        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabPasteExpression(string, this.getPostPasteSelectionRunnable(string2, new Point(((int[])list2.get(0))[0], ((int[])list3.get(0))[0])));
                        return;
                    }
                }
                ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabPasteExpression(string);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((TabularObjectTableModel)((Object)this.getModel())).setInsertState(pasteType2);
        super.doPaste(n);
        ((TabularObjectTableModel)((Object)this.getModel())).setInsertState(TabularObjectTableModel.PasteType.PASTE);
    }

    protected void installEditorsAndRenderersForFormat() {
        super.installEditorsAndRenderersForFormat();
        this.setDefaultEditor(CategoricalScalar.class, new CategoricalVariableEditor());
        this.setDefaultEditor(DatetimeScalar.class, (TableCellEditor)((Object)new DatetimeCellEditor(this.getFormat())));
    }

    @Override
    protected void setupSelectionAsPerSpreadsheet() {
        super.setupSelectionAsPerSpreadsheet();
        this.setSelectionMode(2);
    }

    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.setFocusable(false);
        this.fSelectionPopupMenu.add(this.getCutAction());
        this.fSelectionPopupMenu.add(this.getCopyAction());
        this.fSelectionPopupMenu.add(this.getPasteAction());
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("dataset.createfromselect"));
        this.fExtractMenu.setName("ExtractParent");
        this.setupInsertActions(this.getMatlabClassName());
        this.fInsertColumnAction.setComponentName("InsertAsNewVariable");
        this.fInsertColumnRightAction.setComponentName("InsertAsNewVariableRight");
        this.fInsertRowAction.setComponentName("InsertAsNewObservation");
        this.fInsertRowBelowAction.setComponentName("InsertAsNewObservationBelow");
        this.addContextMenuMouseListener();
    }

    public abstract String getMatlabClassName();

    public static String getVariableUnits(String string, int n, String string2) {
        try {
            double[] dArray = (double[])Matlab.mtFeval((String)"eval", (Object[])new Object[]{"length(" + string + ".Properties." + string2 + ");"}, (int)1);
            if (dArray != null && dArray.length >= 1 && (int)dArray[0] >= n + 1) {
                return (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{string + ".Properties." + string2 + "{" + Integer.toString(n + 1) + "};"}, (int)1);
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected abstract String getVariableUnits(int var1);

    protected abstract String getVariableDescription(int var1);

    public static String getVariableDescription(String string, int n, String string2) {
        try {
            Object object = Matlab.mtFeval((String)"eval", (Object[])new Object[]{"length(" + string + ".Properties." + string2 + ");"}, (int)1);
            double[] dArray = (double[])object;
            if (dArray != null && dArray.length >= 1 && (int)dArray[0] >= n + 1) {
                return (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{string + ".Properties." + string2 + "{" + Integer.toString(n + 1) + "};"}, (int)1);
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected abstract String getNumericVariableCreationString();

    protected abstract String getTabularObjectCreationString();

    void setVariableUnits(String string, int n) {
        ((TabularObjectTableModel)((Object)this.getModel())).setVariableUnits(string, n);
    }

    void setVariableDescription(String string, int n) {
        ((TabularObjectTableModel)((Object)this.getModel())).setVariableDescription(string, n);
    }

    void toCategorical() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length != 1) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).toCategorical(stringArray[0]);
    }

    @Override
    public void updateForSelectionChange(@Nullable String[] stringArray) {
        int n;
        int n2;
        this.fExtractAction.setEnabled(stringArray != null && stringArray.length > 0);
        this.fExtractDatasetVariableArrayAction.setEnabled(stringArray != null && stringArray.length > 0);
        this.fExtractDatasetVariablesAction.setEnabled(stringArray != null && stringArray.length > 0);
        this.fExtractMenu.setEnabled(stringArray != null && stringArray.length > 0);
        if (this.fSelectionPopupMenu == null) {
            return;
        }
        for (n2 = 0; n2 < this.fSPItemsAddedCount; ++n2) {
            this.fSelectionPopupMenu.remove(this.fSelectionPopupMenu.getComponentCount() - 1);
        }
        this.fSPItemsAddedCount = 0;
        if (this.getSelectedColumnCount() > 0 && this.getSelectedRowCount() > 0) {
            n2 = this.isAllTabularObjectColumnsSelected() ? 1 : 0;
            n = this.isAllTabularObjectRowsSelected();
            if (!(n2 == 0 && n == 0 || n2 != 0 && n != 0)) {
                if (n != 0) {
                    this.fSelectionPopupMenu.add((Action)this.fInsertColumnAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertColumnRightAction);
                } else {
                    this.fSelectionPopupMenu.add((Action)this.fInsertRowAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertRowBelowAction);
                }
                this.fSPItemsAddedCount += 2;
                this.fSelectionPopupMenu.addSeparator();
                ++this.fSPItemsAddedCount;
                if (n != 0 && n2 == 0) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteColumnAction);
                    ++this.fSPItemsAddedCount;
                }
                if (n == 0 && n2 != 0) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteRowAction);
                    ++this.fSPItemsAddedCount;
                }
            }
            if (n != 0) {
                if (this.isSortEnabled()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fSortAscendingAction);
                    this.fSelectionPopupMenu.add((Action)this.fSortDescendingAction);
                    this.fSPItemsAddedCount += 3;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isUngroupedIntervalSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fGroupVariableAction);
                    this.fSPItemsAddedCount += 2;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isSingleSpanningColumnSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fUngroupVariableAction);
                    this.fSPItemsAddedCount += 2;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isCellStringSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fConvertToCategoricalAction);
                    this.fSPItemsAddedCount += 2;
                }
            }
        }
        if (this.getSelectedRowCount() > 0 && this.getSelectedColumnCount() > 0) {
            this.fSelectionPopupMenu.addSeparator();
            this.fSelectionPopupMenu.add((JMenuItem)this.fExtractMenu);
            this.fSPItemsAddedCount += 2;
            this.fExtractMenu.removeAll();
            this.fExtractMenu.add((Action)this.fExtractAction);
            this.fExtractMenu.add((Action)((Object)this.fExtractDatasetVariablesAction));
            TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
            n = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
            int n3 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
            if (n3 >= n) {
                if (this.getTabularObjectColumnModel().isNumericSelection()) {
                    this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newnumeric"));
                } else if (this.getTabularObjectColumnModel().isCharArraySelection()) {
                    this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newchararray"));
                } else {
                    this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newcell"));
                }
                this.fExtractMenu.add((Action)this.fExtractDatasetVariableArrayAction);
            }
        }
    }

    @Override
    public boolean isSortEnabled() {
        return this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isSortEnabled();
    }

    @Override
    public String[] getSelectionVariableStrings() {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        List<TabularObjectColumnModel.VariableInfo> list = this.getTabularObjectColumnModel().getSelectedVariableInfo();
        if (list == null || nArray == null || nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        int[] nArray2 = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        String string = AbstractDatasetTable.arrayToMatlabString(nArray, nArray2[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            TabularObjectColumnModel.VariableInfo variableInfo = list.get(i);
            int[] nArray3 = variableInfo.getColumnRange();
            int n = nArray3[1] - nArray3[0];
            stringArray[i] = string.isEmpty() ? this.getVariableName() + "." + list.get(i).getVarName() : (n > 1 ? this.getVariableName() + "." + list.get(i).getVarName() + "(" + string + ",:)" : this.getVariableName() + "." + list.get(i).getVarName() + "(" + string + ")");
        }
        return stringArray;
    }

    protected String getSelectionSubref(String string, String string2) {
        int n;
        if (!(this.getColumnModel() instanceof TabularObjectColumnModel)) {
            return null;
        }
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        if (this.getSelectedRowCount() == 0 || this.getSelectedColumnCount() == 0) {
            return null;
        }
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray2 == null || nArray2.length == 0 || nArray.length == 0) {
            return null;
        }
        List list = AbstractDatasetTable.getSelectionIntervals((int[])nArray);
        List list2 = AbstractDatasetTable.getSelectionIntervals((int[])nArray2);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (Object object2 : list2) {
            n = tabularObjectColumnModel.getGroupIndex(object2[0]);
            int n2 = tabularObjectColumnModel.getGroupIndex(object2[1]);
            arrayList.add(new int[]{n, n2});
        }
        Object object = "";
        if (nArray.length > 0 && nArray2.length > 0) {
            String string3;
            Object object2;
            object2 = this.getModel();
            n = -1;
            if (object2 instanceof IDataBoundsSupplier) {
                n = ((IDataBoundsSupplier)object2).getLastDataRow() + 1;
            }
            object = (string3 = ArrayUtils.getSelectionString(list, n, arrayList, -1)).isEmpty() ? this.getVariableName() : this.getVariableName() + string + string3 + string2;
        }
        return object;
    }

    @Override
    protected String getSelectionNameString() {
        return this.getSelectionSubref("(", ")");
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        String string = this.getSelectionNameString();
        if (string == null || string.isEmpty()) {
            return;
        }
        this.fLastCopyKey = this.getVariableName() + "_copy";
        this.populateClipboardFromIdentifier(new ObjectIdentifier(string, string, this.fLastCopyKey, this.getVariable().getWorkspaceID()));
    }

    static String getUniqueMatlabVariableName(String string) {
        return ArrayUtils.getUniqueMatlabVariableName(string);
    }

    private static void createAndOpenVariables(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = AbstractDatasetTable.getUniqueMatlabVariableName(stringArray[n]);
        }
        if (Matlab.isMatlabAvailable()) {
            for (n = 0; n < stringArray.length; ++n) {
                if (ArrayUtils.isCodeGenEnabled()) {
                    MLExecuteServices.executeCommand((String)(stringArray3[n] + " = " + stringArray2[n] + ";"));
                    continue;
                }
                MLExecuteServices.consoleEval((String)(stringArray3[n] + " = " + stringArray2[n] + ";"));
            }
        }
        AbstractDatasetTable.openVariablesInVariableEditor(stringArray3);
    }

    private static void openVariablesInVariableEditor(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (i == 5) break;
                AbstractDatasetTable.openVariableInMatlab(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                Log.log((String)exception.getMessage());
            }
        }
    }

    private static void openVariableInMatlab(String string) throws Exception {
        if (Matlab.isMatlabAvailable()) {
            Matlab.mtEval((String)("openvar('" + string + "');"));
        }
    }

    @Override
    public Map<INewVariableProvider.CreationParams, MJAbstractAction> getCreationActions() {
        EnumMap<INewVariableProvider.CreationParams, MJAbstractAction> enumMap = new EnumMap<INewVariableProvider.CreationParams, MJAbstractAction>(INewVariableProvider.CreationParams.class);
        enumMap.put(INewVariableProvider.CreationParams.DATASET_ARRAY, this.fExtractAction);
        enumMap.put(INewVariableProvider.CreationParams.SEPARATE_VARS, this.fExtractDatasetVariablesAction);
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        int n = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
        int n2 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
        if (n2 >= n) {
            if (this.getTabularObjectColumnModel().isNumericSelection()) {
                this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newnumeric"));
            } else if (this.getTabularObjectColumnModel().isCharArraySelection()) {
                this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newchararray"));
            } else {
                this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newcell"));
            }
            enumMap.put(INewVariableProvider.CreationParams.NUMERIC_ARRAY, this.fExtractDatasetVariableArrayAction);
        }
        return enumMap;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.fExtractAction = null;
    }

    Runnable getPostPasteSelectionRunnable(String string, Point point) {
        return new PostPasteSelectionRunnable(string, point);
    }

    public int[] getSelectedIndices() {
        return this.getTabularObjectColumnModel().getSelectedIndices();
    }

    public int[] getSelectionIntervalToSet(int n, int n2) {
        int[] nArray = this.getTabularObjectColumnModel().getVariableIndices();
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                nArray2[n4++] = nArray[i];
                continue;
            }
            if (nArray[i] != nArray[i - 1]) {
                nArray2[n4++] = nArray[i] + n3;
                continue;
            }
            ++n3;
        }
        int[] nArray3 = new int[]{n < nArray2.length ? nArray2[n] : 0, n2 < nArray2.length ? nArray2[n2] : 0};
        return nArray3;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEditing()) {
            if (!(keyEvent.getKeyCode() != 127 && keyEvent.getKeyCode() != 8 || this.getSelectedRowCount() <= 1 && this.getSelectedColumnCount() <= 1)) {
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
                return;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isCellEditable(int n, int n2) {
        TabularObjectColumnModel.ClassType classType = ((TabularObjectColumnModel)this.getColumnModel()).getColumnClassType(n2);
        return classType != TabularObjectColumnModel.ClassType.DURATION && classType != TabularObjectColumnModel.ClassType.CALENDAR_DURATION;
    }

    private class PostPasteSelectionRunnable
    implements Runnable {
        private final String iPastedDataExpression;
        private final Point iTopLeftCell;

        PostPasteSelectionRunnable(String string, Point point) {
            this.iPastedDataExpression = string;
            this.iTopLeftCell = point;
        }

        @Override
        public void run() {
            MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

                public double[] runOnMatlabThread() {
                    try {
                        return (double[])Matlab.mtEval((String)("variableEditorGridSize(" + PostPasteSelectionRunnable.this.iPastedDataExpression + ");"), (int)1);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(double[] dArray) {
                    if (dArray == null || dArray.length != 2) {
                        return;
                    }
                    AbstractDatasetTable.this.clearSelection();
                    AbstractDatasetTable.this.setRowSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x + (int)dArray[0] - 1);
                    AbstractDatasetTable.this.setColumnSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y + (int)dArray[1] - 1);
                }
            };
            matlabWorker.start();
        }
    }

    private class ConvertToCategoricalAction
    extends MJAbstractAction {
        ConvertToCategoricalAction() {
            super(ArrayUtils.getResource(AbstractDatasetTable.this.getMatlabClassName() + ".convertcategorical"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDatasetTable.this.toCategorical();
        }
    }

    public static class GroupVariableAction
    extends GroupingAction {
        public GroupVariableAction(AbstractDatasetTable abstractDatasetTable) {
            super(abstractDatasetTable, ArrayUtils.getResource(abstractDatasetTable.getMatlabClassName() + ".groupvars"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabularObjectColumnModel tabularObjectColumnModel = this.iAbstractDatasetTable.getTabularObjectColumnModel();
            String string = "variableEditorGroupCode(" + this.iAbstractDatasetTable.getVariableName() + ",'" + this.iAbstractDatasetTable.getVariableName() + "'," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex() + 1) + "," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex() + 1) + ")";
            ((TabularObjectTableModel)((Object)this.iAbstractDatasetTable.getModel())).evalMatlabString(string, true, true);
            this.postUpdateSelection(true);
        }
    }

    public static class UngroupVariableAction
    extends GroupingAction {
        public UngroupVariableAction(AbstractDatasetTable abstractDatasetTable) {
            super(abstractDatasetTable, ArrayUtils.getResource(abstractDatasetTable.getMatlabClassName() + ".ungroupvars"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabularObjectColumnModel tabularObjectColumnModel = this.iAbstractDatasetTable.getTabularObjectColumnModel();
            if (!tabularObjectColumnModel.isSingleSpanningColumnSelected()) {
                return;
            }
            String string = "variableEditorUngroupCode(" + this.iAbstractDatasetTable.getVariableName() + ",'" + this.iAbstractDatasetTable.getVariableName() + "'," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex() + 1) + ")";
            ((TabularObjectTableModel)((Object)this.iAbstractDatasetTable.getModel())).evalMatlabString(string, true, true);
            this.postUpdateSelection(false);
        }
    }

    public static abstract class GroupingAction
    extends MJAbstractAction {
        protected AbstractDatasetTable iAbstractDatasetTable;

        GroupingAction(AbstractDatasetTable abstractDatasetTable, String string) {
            super(string);
            this.iAbstractDatasetTable = abstractDatasetTable;
        }

        public boolean isEnabled() {
            return true;
        }

        public void postUpdateSelection(final boolean bl) {
            this.iAbstractDatasetTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n = GroupingAction.this.iAbstractDatasetTable.getTabularObjectColumnModel().getGroupIndex(GroupingAction.this.iAbstractDatasetTable.getTabularObjectColumnModel().getSelectionModel().getMinSelectionIndex());
                    int n2 = GroupingAction.this.iAbstractDatasetTable.getTabularObjectColumnModel().getGroupIndex(GroupingAction.this.iAbstractDatasetTable.getTabularObjectColumnModel().getSelectionModel().getMaxSelectionIndex());
                    if (bl && n == n2 || !bl && n != n2) {
                        GroupingAction.this.iAbstractDatasetTable.updateForSelectionChange(GroupingAction.this.iAbstractDatasetTable.getSelectionVariableStrings());
                        GroupingAction.this.iAbstractDatasetTable.getModel().removeTableModelListener(this);
                    }
                }
            });
        }
    }

    private class ExtractDatasetVariablesAction
    extends MJAbstractAction {
        ExtractDatasetVariablesAction() {
            super(ArrayUtils.getResource("dataset.separatevars"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String[] stringArray = AbstractDatasetTable.this.getSelectionVariableStrings();
            if (stringArray == null) {
                return;
            }
            final String[] stringArray2 = AbstractDatasetTable.this.getSelectedVariableNameArray();
            if (stringArray2 == null || stringArray2.length == 0) {
                return;
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractDatasetTable.createAndOpenVariables(stringArray2, stringArray);
                }
            });
        }
    }

    private class ExtractDatasetVariableArrayAction
    extends MJAbstractAction {
        private ExtractDatasetVariableArrayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AbstractDatasetTable.this.getSelectionNameString();
            if (string == null || string.isEmpty()) {
                return;
            }
            final String string2 = AbstractDatasetTable.this.getTabularObjectColumnModel().isNumericSelection() ? AbstractDatasetTable.this.getNumericVariableCreationString() : (AbstractDatasetTable.this.getTabularObjectColumnModel().isCharArraySelection() ? "char(cellstr(" + string + "))" : AbstractDatasetTable.this.getTabularObjectCreationString());
            int[] nArray = AbstractDatasetTable.this.getSelectedIndices();
            String string3 = "";
            if (nArray != null && nArray.length > 0) {
                string3 = AbstractDatasetTable.this.getTabularObjectColumnModel().getVariableName(nArray[0]);
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = AbstractDatasetTable.this.getSelectedVariableNameArray();
                    String string = stringArray != null && stringArray.length == 1 ? AbstractDatasetTable.getUniqueMatlabVariableName(stringArray[0]) : AbstractDatasetTable.this.getVariable().getVariableName();
                    String string22 = AbstractDatasetTable.getUniqueMatlabVariableName(string);
                    if (ArrayUtils.isCodeGenEnabled()) {
                        MLExecuteServices.executeCommand((String)(string22 + " = " + string2 + ";"));
                    } else {
                        MLExecuteServices.consoleEval((String)(string22 + " = " + string2 + ";"));
                    }
                    MLExecuteServices.consoleEval((String)("openvar('" + string22 + "');"));
                }
            });
        }
    }

    private class ExtractDatasetAction
    extends MJAbstractAction {
        ExtractDatasetAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String string = AbstractDatasetTable.this.getSelectionNameString();
            if (string == null || string.isEmpty()) {
                return;
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string2 = AbstractDatasetTable.getUniqueMatlabVariableName(AbstractDatasetTable.this.getVariable().getVariableName());
                    if (ArrayUtils.isCodeGenEnabled()) {
                        MLExecuteServices.executeCommand((String)(string2 + " = " + string + ";"));
                    } else {
                        MLExecuteServices.consoleEval((String)(string2 + " = " + string + ";"));
                    }
                    MLExecuteServices.consoleEval((String)("openvar('" + string2 + "');"));
                }
            });
        }
    }
}

