/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractMatlabTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetTableEvent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public abstract class AbstractTabularObjectTable
extends AbstractMatlabTable
implements VariableIdentifierProvider,
IGraphableInfoProvider,
IGraphingActionListener,
IPlotPickerDisplayTrigger {
    protected static final String[] STRINGS = new String[0];
    protected PlotCatalog fMorePlotsDlg = null;
    protected MJAbstractAction fCatalogAction;
    protected List<ListSelectionListener> fGraphicListener = new Vector<ListSelectionListener>();
    protected List<ListSelectionListener> fSimpleVariableListener = new Vector<ListSelectionListener>();
    protected int fSPItemsAddedCount = 0;
    protected ListSelectionListener fLSL;
    protected MJAbstractAction fPlotPickerAction = null;
    protected final Collection<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    protected MJAbstractAction fInsertColumnAction;
    protected MJAbstractAction fInsertColumnRightAction;
    protected MJAbstractAction fInsertRowAction;
    protected MJAbstractAction fInsertRowBelowAction;
    protected MJAbstractAction fDeleteRowAction;
    protected MJAbstractAction fDeleteColumnAction;
    protected MJAbstractAction fSortAscendingAction = new SortAscendingAction();
    protected MJAbstractAction fSortDescendingAction;

    public AbstractTabularObjectTable(TabularObjectTableModel tabularObjectTableModel) {
        super(tabularObjectTableModel);
        this.fSortAscendingAction.setComponentName("SortAscending");
        this.fSortDescendingAction = new SortDescendingAction();
        this.fSortDescendingAction.setComponentName("SortDescending");
        this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTabularObjectTable.this.firePlotPickerRequested();
            }
        };
        this.fLSL = new SelListener();
        this.addListSelectionListener(this.fLSL);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private void setListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fLSL = listSelectionListener;
    }

    protected void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    private void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().removeListSelectionListener(listSelectionListener);
        this.getColumnModel().getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof SpreadsheetTableEvent && ((SpreadsheetTableEvent)tableModelEvent).getScope() == SpreadsheetTableEvent.SCOPE.STRUCTURE) {
            super.tableChanged(tableModelEvent);
        } else {
            this.tableChangedWithoutSelectionUpdate(tableModelEvent);
        }
    }

    protected void tableChangedWithoutSelectionUpdate(TableModelEvent tableModelEvent) {
        if (this.fLSL != null) {
            this.removeListSelectionListener(this.fLSL);
        }
        super.tableChanged(tableModelEvent);
        if (this.fLSL != null) {
            this.addListSelectionListener(this.fLSL);
        }
    }

    public boolean isAllTabularObjectRowsSelected() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return false;
        }
        return this.isRowSelected(0) && this.isRowSelected(nArray[0] - 1) && this.getSelectedRowCount() >= nArray[0];
    }

    protected boolean isAllTabularObjectColumnsSelected() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return false;
        }
        return this.isColumnSelected(0) && this.isColumnSelected(nArray[1] - 1) && this.getSelectedColumnCount() >= nArray[1];
    }

    protected void reexamineEditingActions() {
        this.getInsertAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getUndoAction().setEnabled(true);
        this.getRedoAction().setEnabled(true);
        this.getClearContentsAction().setEnabled(false);
    }

    protected void reexamineInsertDeleteEnablement() {
    }

    static String arrayToMatlabString(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0 || nArray.length == n) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = nArray[0];
        stringBuilder.append(Integer.toString(n2 + 1));
        if (nArray.length == 1) {
            return stringBuilder.toString();
        }
        int n3 = 0;
        for (int i = 1; i <= nArray.length - 2; ++i) {
            if (nArray[i] - nArray[i - 1] <= 1) continue;
            if (nArray[i - 1] > n2) {
                stringBuilder.append(":");
                stringBuilder.append(Integer.toString(nArray[i - 1] + 1));
            }
            stringBuilder.append(",");
            ++n3;
            n2 = nArray[i];
            stringBuilder.append(Integer.toString(n2 + 1));
        }
        if (nArray[nArray.length - 1] - nArray[nArray.length - 2] > 1) {
            stringBuilder.append(":");
            stringBuilder.append(Integer.toString(nArray[nArray.length - 2] + 1));
            stringBuilder.append(",");
        } else {
            stringBuilder.append(":");
        }
        ++n3;
        if (nArray[nArray.length - 1] + 1 < n) {
            stringBuilder.append(Integer.toString(nArray[nArray.length - 1] + 1));
        } else {
            stringBuilder.append("end");
        }
        if (n3 >= 2) {
            return "[" + stringBuilder + "]";
        }
        return stringBuilder.toString();
    }

    public void cleanup() {
        this.getSelectionModel().removeListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fLSL);
        this.fLSL = null;
        GraphingActionFactory.removeGraphingActionListener(this);
        this.fGraphicListener = null;
        this.fSimpleVariableListener = null;
        this.fCatalogAction = null;
        super.cleanup();
    }

    protected void setupInsertActions(String string) {
        this.fInsertColumnAction = new MJAbstractAction(ArrayUtils.getResource(string + ".insertnewcol")){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTabularObjectTable.this.doColumnInsert(TabularObjectTableModel.PasteType.INSERTCOLUMNS);
            }
        };
        this.fInsertColumnRightAction = new MJAbstractAction(ArrayUtils.getResource(string + ".insertnewcolright")){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTabularObjectTable.this.doColumnInsert(TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT);
            }
        };
        this.fInsertRowAction = new MJAbstractAction(ArrayUtils.getResource(string + ".insertnewrow")){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTabularObjectTable.this.doRowInsert(TabularObjectTableModel.PasteType.INSERTROWS);
            }
        };
        this.fInsertRowBelowAction = new MJAbstractAction(ArrayUtils.getResource(string + ".insertnewrowbelow")){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTabularObjectTable.this.doRowInsert(TabularObjectTableModel.PasteType.INSERTROWS_BELOW);
            }
        };
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        MJAbstractAction mJAbstractAction = null;
        switch (scope) {
            case ROWS: {
                mJAbstractAction = this.fInsertRowAction;
                break;
            }
            case ROWS_BELOW: {
                mJAbstractAction = this.fInsertRowBelowAction;
                break;
            }
            case COLUMNS: {
                mJAbstractAction = this.fInsertColumnAction;
                break;
            }
            case COLUMNS_TO_THE_RIGHT: {
                mJAbstractAction = this.fInsertColumnRightAction;
                break;
            }
        }
        return mJAbstractAction;
    }

    protected void setupDeleteActions(String string) {
        this.fDeleteRowAction = new DeleteRowAction(string);
        this.fDeleteRowAction.setComponentName("DeleteObservations");
        this.fDeleteColumnAction = new DeleteColumnAction(string);
        this.fDeleteColumnAction.setComponentName("DeleteVariable");
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        MJAbstractAction mJAbstractAction = null;
        if (scope == IRegionOpProvider.Scope.ROWS) {
            mJAbstractAction = this.fDeleteRowAction;
        } else if (scope == IRegionOpProvider.Scope.COLUMNS) {
            mJAbstractAction = this.fDeleteColumnAction;
        }
        return mJAbstractAction;
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        boolean bl = this.isAllTabularObjectColumnsSelected();
        boolean bl2 = this.isAllTabularObjectRowsSelected();
        ArrayList<IRegionOpProvider.Scope> arrayList = new ArrayList<IRegionOpProvider.Scope>();
        if (!(!bl && !bl2 || bl && bl2)) {
            if (bl2 && !bl) {
                arrayList.add(IRegionOpProvider.Scope.COLUMNS);
            }
            if (!bl2 && bl) {
                arrayList.add(IRegionOpProvider.Scope.ROWS);
            }
        }
        return arrayList;
    }

    public VariableIdentifier getVariableIdentifier() {
        String string = this.getSelectionNameString();
        if (string == null) {
            string = this.getVariable().getVariableName();
        }
        return new VariableIdentifier(string, string, this.getVariable().getWorkspaceID());
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.add(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.remove(listSelectionListener);
    }

    @Override
    public String[] getGraphableNames() {
        if (this.useMinimalMenus()) {
            return STRINGS;
        }
        return this.getSelectionVariableStrings();
    }

    @Override
    public String[] getGraphableSizes() {
        return null;
    }

    @Override
    public String[] getGraphableClasses() {
        return null;
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fCatalogAction;
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    @Override
    public void graphingActionsChanged() {
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    abstract Map<INewVariableProvider.CreationParams, MJAbstractAction> getCreationActions();

    abstract boolean isSortEnabled();

    abstract void sortAscending();

    abstract void sortDescending();

    MJAbstractAction getSortAscendingAction() {
        return this.fSortAscendingAction;
    }

    MJAbstractAction getSortDecendingAction() {
        return this.fSortDescendingAction;
    }

    abstract void doColumnInsert(TabularObjectTableModel.PasteType var1);

    abstract void doRowInsert(TabularObjectTableModel.PasteType var1);

    abstract String getSelectionNameString();

    protected abstract void updateForSelectionChange(String[] var1);

    protected abstract String[] getSelectionVariableStrings();

    protected class SortDescendingAction
    extends MJAbstractAction {
        SortDescendingAction() {
            super(ArrayUtils.getResource("dataset.sortdescend"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTabularObjectTable.this.sortDescending();
        }
    }

    protected class SortAscendingAction
    extends MJAbstractAction {
        SortAscendingAction() {
            super(ArrayUtils.getResource("dataset.sortascend"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTabularObjectTable.this.sortAscending();
        }
    }

    protected class MorePlotsAction
    extends ArrayUtils.BaseAction {
        MorePlotsAction() {
            super("show-plot-catalog", "show-plot-catalog");
            AbstractTabularObjectTable.this.registerWithMapsUsingKeyBindingManager(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray;
            if (AbstractTabularObjectTable.this.fMorePlotsDlg == null) {
                AbstractTabularObjectTable.this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            if ((stringArray = AbstractTabularObjectTable.this.getSelectionVariableStrings()) != null) {
                AbstractTabularObjectTable.this.fMorePlotsDlg.setPlottedVars(stringArray);
                AbstractTabularObjectTable.this.fMorePlotsDlg.show();
            }
        }
    }

    protected class DeleteColumnAction
    extends MJAbstractAction {
        DeleteColumnAction(String string) {
            super(ArrayUtils.getResource(string + ".delcols"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])AbstractTabularObjectTable.this.restrictRowColumnSpecToValidRegion(AbstractTabularObjectTable.this.getSelectedColumns(), 1));
            if (list.isEmpty()) {
                return;
            }
            ((TabularObjectTableModel)((Object)AbstractTabularObjectTable.this.getModel())).deleteTableObjectColumns(list);
        }
    }

    protected class DeleteRowAction
    extends MJAbstractAction {
        DeleteRowAction(String string) {
            super(ArrayUtils.getResource(string + ".delrows"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])AbstractTabularObjectTable.this.restrictRowColumnSpecToValidRegion(AbstractTabularObjectTable.this.getSelectedRows(), 0));
            if (list.isEmpty()) {
                return;
            }
            ((TabularObjectTableModel)((Object)AbstractTabularObjectTable.this.getModel())).deleteTableObjectRows(list);
        }
    }

    protected class SelListener
    implements ListSelectionListener {
        protected SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (AbstractTabularObjectTable.this.fGraphicListener != null) {
                    for (ListSelectionListener listSelectionListener : AbstractTabularObjectTable.this.fGraphicListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (AbstractTabularObjectTable.this.fSimpleVariableListener != null) {
                    for (ListSelectionListener listSelectionListener : AbstractTabularObjectTable.this.fSimpleVariableListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                AbstractTabularObjectTable.this.updateForSelectionChange(AbstractTabularObjectTable.this.getSelectionVariableStrings());
                boolean bl = AbstractTabularObjectTable.this.isAllTabularObjectRowsSelected();
                boolean bl2 = AbstractTabularObjectTable.this.isAllTabularObjectColumnsSelected();
                AbstractTabularObjectTable.this.getCutAction().setEnabled(!(!bl && !bl2 || bl2 && bl));
            }
        }
    }
}

