/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractValueEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CellPanel;
import com.mathworks.mlwidgets.array.CellTable;
import com.mathworks.mlwidgets.array.ExtractVariableAction;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ISelectionOpenerProvider;
import com.mathworks.mlwidgets.array.ISortProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.ITransposeProvider;
import com.mathworks.mlwidgets.array.MatlabCellTableModel;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionListener;

public final class CellEditorProvider
extends AbstractValueEditorProvider
implements IGraphableInfoProvider,
VariableIdentifierProvider,
ISpreadsheetSelectionController,
IRegionOpProvider,
ISelectionOpenerProvider,
ISelectionOpProvider,
IPlotPickerDisplayTrigger,
ITransposeProvider,
ISortProvider,
INewVariableProvider {
    private CellPanel fPanel = null;
    private CellTable fTable = null;
    private MatlabCellTableModel fModel = null;

    public CellEditorProvider(MatlabCellTableModel matlabCellTableModel, CellTable cellTable, CellPanel cellPanel) {
        super((JComponent)((Object)cellPanel), cellTable, (IClipboardOpProvider)cellTable, (IUndoOpProvider)cellTable, (FormattableDisplay)cellTable, cellTable, cellTable);
        this.fModel = matlabCellTableModel;
        this.fTable = cellTable;
        this.fPanel = cellPanel;
    }

    public static CellEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        MatlabCellTableModel matlabCellTableModel = new MatlabCellTableModel(workspaceVariable);
        CellTable cellTable = new CellTable(matlabCellTableModel);
        CellPanel cellPanel = new CellPanel(cellTable);
        cellPanel.setName("CellPanel");
        CellEditorProvider cellEditorProvider = new CellEditorProvider(matlabCellTableModel, cellTable, cellPanel);
        cellTable.setProvider(cellEditorProvider);
        return cellEditorProvider;
    }

    @Override
    public void rename(String string) {
        this.fModel.rename(string);
    }

    @Override
    public void setUseMinimalMenus(boolean bl) {
        this.fTable.setUseMinimalMenus(bl);
    }

    @Override
    public void setOpenActionListener(ActionListener actionListener) {
        this.fModel.setOpenActionListener(actionListener);
    }

    @Override
    public void cleanup() {
        this.fPanel.cleanup();
        this.fTable.cleanup();
        this.fModel.cleanup();
        this.fPanel = null;
        this.fTable = null;
        this.fModel = null;
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.addPlotPickerOpener(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.removePlotPickerOpener(plotPickerOpener);
    }

    @Override
    public String[] getGraphableNames() {
        return this.fTable.getGraphableNames();
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fTable.getPlotPickerAction();
    }

    @Override
    public String[] getGraphableSizes() {
        return this.fTable.getGraphableSizes();
    }

    @Override
    public String[] getGraphableClasses() {
        return this.fTable.getGraphableClasses();
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fTable.getMorePlotsAction();
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.addGraphableSelectionListener(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeGraphableSelectionListener(listSelectionListener);
    }

    public VariableIdentifier getVariableIdentifier() {
        return this.fTable.getVariableIdentifier();
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.addVariableIdentifierListener(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeVariableIdentifierListener(listSelectionListener);
    }

    public Action getInsertAction() {
        return this.fTable.getInsertAction();
    }

    public Action getDeleteAction() {
        return this.fTable.getDeleteAction();
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getInsertAction(scope, n);
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getDeleteAction(scope, n);
    }

    public Action getClearContentsAction() {
        return this.fTable.getClearContentsAction();
    }

    @Override
    public Action getSelectionOpenerAction() {
        return this.fTable.getSelectionOpenerAction();
    }

    public Action getSelectAllAction() {
        return this.fTable.getSelectAllAction();
    }

    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        return this.fTable.getSpreadsheetRowSelectionModel();
    }

    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        return this.fTable.getSpreadsheetColumnSelectionModel();
    }

    MatlabCellTableModel getTableModel() {
        return this.fModel;
    }

    @Override
    public void transposeVariable() {
        this.fModel.transpose();
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        ArrayList<IRegionOpProvider.Scope> arrayList = new ArrayList<IRegionOpProvider.Scope>();
        if (this.fTable.areOnlyEntireColumnsSelected()) {
            arrayList.add(IRegionOpProvider.Scope.COLUMNS);
        } else if (this.fTable.areOnlyEntireRowsSelected()) {
            arrayList.add(IRegionOpProvider.Scope.ROWS);
        } else {
            arrayList.add(IRegionOpProvider.Scope.ROWS);
            arrayList.add(IRegionOpProvider.Scope.COLUMNS);
            arrayList.add(IRegionOpProvider.Scope.CELLS);
        }
        return arrayList;
    }

    @Override
    public void sortRows(ITableController.SortDirection sortDirection) {
        int[] nArray = this.fTable.getSelectedColumns();
        if (nArray.length > 0) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i] + 1;
            }
            this.fModel.sortRows(nArray2, sortDirection);
        }
    }

    @Override
    public boolean isSortEnabledForSelection() {
        return this.fTable.isSortEnabledForSelection();
    }

    @Override
    public String getCreationLabel() {
        return null;
    }

    @Override
    public Map<INewVariableProvider.CreationParams, MJAbstractAction> getCreationActions() {
        WorkspaceCommandsVarCreator workspaceCommandsVarCreator = new WorkspaceCommandsVarCreator();
        EnumMap<INewVariableProvider.CreationParams, MJAbstractAction> enumMap = new EnumMap<INewVariableProvider.CreationParams, MJAbstractAction>(INewVariableProvider.CreationParams.class);
        enumMap.put(INewVariableProvider.CreationParams.ALL, new ExtractVariableAction(this, ArrayUtils.getResource("dataset.newcell"), INewVariableProvider.CreationParams.ALL, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator));
        enumMap.put(INewVariableProvider.CreationParams.ROWS, new ExtractVariableAction(this, ArrayUtils.getResource("variable.separateRow.label"), INewVariableProvider.CreationParams.ROWS, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator));
        enumMap.put(INewVariableProvider.CreationParams.COLUMNS, new ExtractVariableAction(this, ArrayUtils.getResource("variable.separateColumn.label"), INewVariableProvider.CreationParams.COLUMNS, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator));
        return enumMap;
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.ALL);
        if (this.fTable.getSelectedRowCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.ROWS);
        }
        if (this.fTable.getSelectedColumnCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.COLUMNS);
        }
        return arrayList;
    }

    public void removeEmptyRowsAndColumns(ValueMetaInfo valueMetaInfo) {
        int n = valueMetaInfo.getRowCount();
        int n2 = valueMetaInfo.getColumnCount();
        if (n >= this.fModel.getLastDataRow() && n2 >= this.fModel.getLastDataColumn()) {
            return;
        }
        if (n < this.fModel.getLastDataRow()) {
            this.fTable.removeEmptyRows(n);
        }
        if (n2 < this.fModel.getLastDataColumn()) {
            this.fTable.removeEmptyColumns(n2);
        }
        this.fModel.setValueMetaInfo(valueMetaInfo);
    }

    private void setTableModel(MatlabCellTableModel matlabCellTableModel) {
        if (this.fModel != null) {
            this.fModel.cleanup();
        }
        this.fModel = matlabCellTableModel;
    }

    private void setTable(CellTable cellTable) {
        if (this.fTable != null) {
            this.fTable.cleanup();
        }
        this.fTable = cellTable;
    }

    private static class WorkspaceCommandsVarCreator
    implements ExtractVariableAction.VariableCreatorInterface {
        private WorkspaceCommandsVarCreator() {
        }

        @Override
        public void createVariable(String string) {
            try {
                MatlabMCR.mtEval((String)string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

