/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TabularObjectColumnModel
implements TableColumnModel,
PropertyChangeListener {
    private volatile Map<Integer, TableColumn> fColumnMap = Collections.synchronizedMap(new HashMap());
    protected ListSelectionModel fSelectionModel;
    private volatile String[] fVariableNames;
    private volatile String[] fVariableClasses;
    private volatile boolean[] fIsCellString;
    private volatile int[] fCharArrayWidths;
    private volatile int[] fColumnIndices;
    private volatile int[] fVariableIndices;
    private int fColumnCount = -1;
    protected EventListenerList fListenerList = new EventListenerList();
    protected ChangeEvent fChangeEvent = null;
    protected int fTotalColumnWidth;
    private MatlabWorker<Object> fColumnHeaderUpdater;
    private String fVarName;
    private VarEditorDataProxy fDataProxy = null;
    private static final int DEFAULT_WIDTH = 75;
    protected static final int DEFAULT_DATETIME_WIDTH = 125;
    private static final int MAX_COLUMN_WIDTH = 200;
    private static Font sDefaultFont = Matlab.isMatlabAvailable() ? UIManager.getFont("TextField.font") : new Font("Dialog", 0, 10);
    private boolean fTableIsAdjusting = false;
    private volatile Map<String, Integer> fColumnWidths = new HashMap<String, Integer>();

    TabularObjectColumnModel(int n, String string, VarEditorDataProxy varEditorDataProxy) {
        this.fColumnCount = n;
        this.fDataProxy = varEditorDataProxy;
        this.fSelectionModel = new TabularObjectColumnSelectionModel();
        this.fSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TabularObjectColumnModel.this.fireColumnSelectionChanged(listSelectionEvent);
            }
        });
        this.fVarName = string;
        this.fColumnHeaderUpdater = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                try {
                    Object object = TabularObjectColumnModel.this.fDataProxy.getColumnNamesAndMetaData(TabularObjectColumnModel.this.fVarName);
                    if (object == null || !(object instanceof Object[])) {
                        return null;
                    }
                    Object[] objectArray = (Object[])object;
                    if (!(objectArray.length >= 5 && objectArray[0] instanceof String[] && objectArray[2] instanceof String[] && objectArray[1] instanceof double[] && objectArray[3] instanceof boolean[])) {
                        return null;
                    }
                    String[] stringArray = (String[])objectArray[0];
                    String[] stringArray2 = (String[])objectArray[2];
                    double[] dArray = (double[])objectArray[1];
                    int[] nArray = new int[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        nArray[i] = (int)dArray[i] - 1;
                    }
                    boolean[] blArray = (boolean[])objectArray[3];
                    double[] dArray2 = (double[])objectArray[4];
                    int[] nArray2 = new int[dArray2.length];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = (int)dArray2[i];
                    }
                    TabularObjectColumnModel.this.setVariableProperties(stringArray, stringArray2, nArray, blArray, nArray2);
                }
                catch (Exception exception) {
                    return null;
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                ((TabularObjectColumnSelectionModel)TabularObjectColumnModel.this.fSelectionModel).fireValueChanged(0, 0, false);
            }
        };
    }

    private static ClassType getClassType(String string) {
        ClassType classType;
        switch (string) {
            case "cell": {
                classType = ClassType.CELL;
                break;
            }
            case "char": {
                classType = ClassType.CHAR;
                break;
            }
            case "nominal": 
            case "ordinal": 
            case "categorical": {
                classType = ClassType.CATEGORICAL;
                break;
            }
            case "datetime": {
                classType = ClassType.DATETIME;
                break;
            }
            case "duration": {
                classType = ClassType.DURATION;
                break;
            }
            case "calendarDuration": {
                classType = ClassType.CALENDAR_DURATION;
                break;
            }
            default: {
                classType = ClassType.NUMERIC;
            }
        }
        return classType;
    }

    public List<VariableInfo> getSelectedVariableInfo() {
        int[] nArray = this.fSelectionModel instanceof TabularObjectColumnSelectionModel ? ((TabularObjectColumnSelectionModel)this.fSelectionModel).getOrderedSelection() : this.getSelectedColumns();
        return this.getSelectedVariableInfo(nArray);
    }

    public int[] getOrderedSelection() {
        int[] nArray = this.fSelectionModel instanceof TabularObjectColumnSelectionModel ? ((TabularObjectColumnSelectionModel)this.fSelectionModel).getOrderedSelection() : this.getSelectedColumns();
        return nArray;
    }

    public void rename(String string) {
        this.fVarName = string;
    }

    protected synchronized List<VariableInfo> getSelectedVariableInfo(int[] nArray) {
        if (this.fVariableNames == null || this.fVariableNames.length == 0) {
            return null;
        }
        ArrayList<VariableInfo> arrayList = new ArrayList<VariableInfo>();
        for (int n : nArray) {
            ClassType classType;
            int n2;
            String string;
            VariableInfo variableInfo;
            if (n < 0 || n >= this.fVariableIndices.length || arrayList.contains(variableInfo = new VariableInfo(string = this.fVariableNames[this.fVariableIndices[n]], new int[]{this.fColumnIndices[n2 = this.fVariableIndices[n]], this.fColumnIndices[n2 + 1]}, classType = TabularObjectColumnModel.getClassType(this.fVariableClasses[this.fVariableIndices[n]])))) continue;
            arrayList.add(variableInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    int[] getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.fVariableIndices != null) {
            for (int n : this.getSelectedColumns()) {
                if (n >= this.fVariableIndices.length || arrayList.contains(this.fVariableIndices[n])) continue;
                arrayList.add(this.fVariableIndices[n]);
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    int getVariableColumnCount() {
        if (this.fColumnIndices == null) {
            return 0;
        }
        return this.fColumnIndices[this.fColumnIndices.length - 1];
    }

    public boolean isNumericSelection() {
        return this.isSelectionClassType(ClassType.NUMERIC);
    }

    public boolean isCharArraySelection() {
        return this.isSelectionClassType(ClassType.CHAR);
    }

    private boolean isSelectionClassType(ClassType classType) {
        if (this.fVariableClasses == null || this.fVariableClasses.length == 0) {
            return false;
        }
        for (int n : this.getSelectedColumns()) {
            int n2 = this.getGroupIndex(n);
            if (n2 < this.fVariableClasses.length && TabularObjectColumnModel.getClassType(this.fVariableClasses[n2]) == classType) continue;
            return false;
        }
        return true;
    }

    String getVariableSummary(int n, int n2) {
        if ("char".equals(this.fVariableClasses[n])) {
            return Integer.toString(n2) + "x" + Integer.toString(this.fCharArrayWidths[n]) + " char";
        }
        int n3 = this.fColumnIndices[n + 1] - this.fColumnIndices[n];
        return Integer.toString(n2) + "x" + Integer.toString(n3) + " " + this.fVariableClasses[n];
    }

    synchronized String getVariableName(int n) {
        if (this.fVariableNames == null || n >= this.fVariableNames.length || n < 0) {
            return null;
        }
        return this.fVariableNames[n];
    }

    synchronized void setNamedHeaderContentForColumn(int n, TabularObjectHeaderRenderer.NamedHeaderContent namedHeaderContent) {
        this.getColumn(n).setHeaderValue(namedHeaderContent);
        int n2 = this.getGroupIndex(n);
        this.fVariableNames[n2] = namedHeaderContent.getName();
    }

    public String getVariableMatlabClass(int n) {
        String string = null;
        if (this.fVariableClasses != null && n < this.fVariableClasses.length && n >= 0) {
            string = this.fVariableClasses[n];
        }
        return string;
    }

    boolean isVariableCellStr(int n) {
        return this.fIsCellString[n];
    }

    public boolean isSortEnabled() {
        int[] nArray = this.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        for (int n : nArray) {
            if ("cell".equals(this.fVariableClasses[n]) && !this.isVariableCellStr(n)) {
                return false;
            }
            if (!"calendarDuration".equals(this.fVariableClasses[n])) continue;
            return false;
        }
        return true;
    }

    boolean isSortEnabled(int n) {
        int n2 = this.getGroupIndex(n);
        if (n2 < 0) {
            return false;
        }
        if ("cell".equals(this.fVariableClasses[n2]) && !this.isVariableCellStr(n2)) {
            return false;
        }
        return !"calendarDuration".equals(this.fVariableClasses[n2]);
    }

    public boolean isCellStringSelected() {
        int[] nArray = this.getSelectedIndices();
        if (nArray == null || nArray.length != 1) {
            return false;
        }
        return this.isVariableCellStr(nArray[0]);
    }

    int getVariableCount() {
        return this.fColumnIndices != null ? this.fColumnIndices.length - 1 : 0;
    }

    public boolean isSingleSpanningColumnSelected() {
        int n;
        if (this.getSelectedColumnCount() <= 1) {
            return false;
        }
        int n2 = this.getGroupIndex(this.getSelectionModel().getMinSelectionIndex());
        return n2 == (n = this.getGroupIndex(this.getSelectionModel().getMaxSelectionIndex()));
    }

    public boolean isUngroupedIntervalSelected() {
        if (this.getSelectionModel().isSelectionEmpty()) {
            return false;
        }
        int n = this.getSelectionModel().getMinSelectionIndex();
        int n2 = this.getSelectionModel().getMaxSelectionIndex();
        if (this.getSelectedColumns().length < n2 - n + 1) {
            return false;
        }
        int n3 = this.getGroupIndex(n);
        int n4 = this.getGroupIndex(n2);
        if (n4 <= n3 || this.fVariableClasses == null || n4 > this.fVariableClasses.length - 1) {
            return false;
        }
        ClassType classType = TabularObjectColumnModel.getClassType(this.fVariableClasses[n3]);
        for (int i = n3 + 1; i <= n4; ++i) {
            if (this.fColumnIndices[i + 1] - this.fColumnIndices[i] <= 1 && TabularObjectColumnModel.getClassType(this.fVariableClasses[i]) == classType) continue;
            return false;
        }
        return true;
    }

    boolean isSpanningColumn(int n) {
        int[] nArray = this.getGroupColumnInterval(n);
        return nArray != null && nArray.length == 2 && nArray[1] - nArray[0] > 1;
    }

    int[] getGroupColumnInterval(int n) {
        if (this.fColumnIndices == null) {
            return new int[]{n, n};
        }
        int n2 = Arrays.binarySearch(this.fColumnIndices, n);
        if (n2 >= 0 && n2 <= this.fColumnIndices.length - 2) {
            return new int[]{this.fColumnIndices[n2], this.fColumnIndices[n2 + 1]};
        }
        if (n2 == this.fColumnIndices.length - 1) {
            return new int[]{this.fColumnIndices[n2], this.fColumnIndices[n2] + 1};
        }
        int n3 = -n2 - 1;
        if (n3 < this.fColumnIndices.length) {
            return new int[]{this.fColumnIndices[n3 - 1], this.fColumnIndices[n3]};
        }
        return new int[]{n, n + 1};
    }

    public int getGroupIndex(int n) {
        if (this.fColumnIndices == null) {
            return n;
        }
        int n2 = Arrays.binarySearch(this.fColumnIndices, n);
        if (n2 >= 0 && n2 <= this.fColumnIndices.length - 1) {
            return n2;
        }
        int n3 = -n2 - 1;
        if (n3 < this.fColumnIndices.length) {
            return n3 - 1;
        }
        return n - this.fColumnIndices[this.fColumnIndices.length - 1] + this.fColumnIndices.length - 1;
    }

    int getStartColumn(int n) {
        if (this.fColumnIndices != null && this.fColumnIndices.length - 1 > n) {
            return this.fColumnIndices[n];
        }
        if (this.fColumnIndices == null || this.fColumnIndices.length == 0) {
            return n;
        }
        return -1;
    }

    public int getGroupColumnWidth(int n) {
        if (n < 0) {
            return 0;
        }
        int[] nArray = this.getGroupColumnInterval(n);
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray[0];
        int n3 = nArray[0];
        if (nArray.length > 1) {
            n3 = nArray[1] - 1;
        }
        int n4 = 0;
        for (int i = n2; i <= n3; ++i) {
            n4 += this.getColumn(i).getWidth();
        }
        return n4;
    }

    void updateData() {
        this.fColumnHeaderUpdater.start();
    }

    private synchronized void setVariableProperties(String[] stringArray, String[] stringArray2, int[] nArray, boolean[] blArray, int[] nArray2) {
        if (stringArray == null || stringArray2 == null || nArray == null || blArray == null) {
            return;
        }
        if (Arrays.equals(stringArray, this.fVariableNames) && Arrays.equals(stringArray2, this.fVariableClasses) && Arrays.equals(this.fColumnIndices, nArray) && Arrays.equals(this.fIsCellString, blArray) && Arrays.equals(this.fCharArrayWidths, nArray2)) {
            return;
        }
        this.fColumnMap.clear();
        if (Matlab.isMatlabAvailable() && this.fVariableNames != null && this.fVariableNames.length > 0) {
            final TableColumnModelEvent tableColumnModelEvent = new TableColumnModelEvent(this, 0, this.fVariableNames.length - 1);
            MJUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TabularObjectColumnModel.this.fireColumnRemoved(tableColumnModelEvent);
                }
            });
        }
        this.fVariableNames = stringArray;
        this.fVariableClasses = stringArray2;
        this.fColumnIndices = nArray;
        this.fIsCellString = blArray;
        this.fCharArrayWidths = nArray2;
        this.fVariableIndices = new int[this.fColumnIndices[nArray.length - 1]];
        for (int i = 0; i < this.fColumnIndices.length - 1; ++i) {
            for (int j = this.fColumnIndices[i]; j < this.fColumnIndices[i + 1]; ++j) {
                this.fVariableIndices[j] = i;
            }
        }
        if (Matlab.isMatlabAvailable()) {
            final TableColumnModelEvent tableColumnModelEvent = new TableColumnModelEvent(this, 0, this.fVariableNames.length - 1);
            MJUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TabularObjectColumnModel.this.fireColumnAdded(tableColumnModelEvent);
                }
            });
        }
    }

    @Override
    public int getColumnCount() {
        return this.fColumnCount;
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        ++this.fColumnCount;
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        if (tableColumn.getModelIndex() < this.fColumnCount && this.fColumnCount > 0) {
            --this.fColumnCount;
        }
    }

    @Override
    public void moveColumn(int n, int n2) {
    }

    @Override
    public void setColumnMargin(int n) {
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new ColumnEnumeration();
    }

    @Override
    public synchronized int getColumnIndex(Object object) {
        int n = -1;
        for (int i = 0; i < this.fVariableNames.length; ++i) {
            if (!this.fVariableNames[i].equals(object)) continue;
            n = this.fColumnIndices[i];
            break;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Identifier not found");
        }
        return n;
    }

    @Override
    public synchronized TableColumn getColumn(int n) {
        if (n < 0) {
            return new TableColumn(n, 75);
        }
        TableColumn tableColumn = this.fColumnMap.get(n);
        if (tableColumn == null) {
            tableColumn = new TableColumn(n, this.getDefaultColumnWidth(n));
            if (this.fVariableIndices != null && n < this.fVariableIndices.length) {
                String string;
                tableColumn.setHeaderValue(new TabularObjectHeaderRenderer.NamedHeaderContent(this.fVariableIndices[n] + 1, this.fVariableNames[this.fVariableIndices[n]]));
                tableColumn.setIdentifier(this.fVariableNames[this.fVariableIndices[n]]);
                int n2 = FontUtils.getTextWidth((Font)sDefaultFont, (String)this.fVariableNames[this.fVariableIndices[n]]) + TabularObjectHeaderRenderer.getIconWidths() + 5;
                int n3 = TabularObjectHeaderRenderer.getIconWidths() + 5;
                n2 = n2 > this.getDefaultColumnWidth(n) ? n2 : this.getDefaultColumnWidth(n);
                n2 = n2 < 200 ? n2 : 200;
                Object object = tableColumn.getHeaderValue();
                int n4 = n2;
                if (object instanceof TabularObjectHeaderRenderer.NamedHeaderContent && this.fColumnWidths.containsKey(string = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName())) {
                    n4 = this.fColumnWidths.get(string);
                }
                tableColumn.setPreferredWidth(n4);
                tableColumn.setMinWidth(n3);
                this.fColumnMap.put(n, tableColumn);
            } else if (this.fColumnIndices != null && this.fColumnIndices.length > 0 && n >= this.fColumnIndices[this.fColumnIndices.length - 1]) {
                tableColumn = new TableColumn(n, 75);
                tableColumn.setHeaderValue(Integer.toString(this.fVariableNames.length + n - this.fColumnIndices[this.fColumnIndices.length - 1] + 1));
            } else {
                tableColumn = new TableColumn(n, 75);
                tableColumn.setHeaderValue(Integer.toString(n + 1));
            }
            tableColumn.addPropertyChangeListener(this);
        }
        return tableColumn;
    }

    @Override
    public int getColumnMargin() {
        return 1;
    }

    @Override
    public int getColumnIndexAtX(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = this.fColumnMap.get(i);
            n = tableColumn != null ? (n -= tableColumn.getWidth()) : (n -= this.getDefaultColumnWidth(i));
            if (n >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.fTotalColumnWidth == -1) {
            this.fTotalColumnWidth = 0;
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = this.fColumnMap.get(i);
                if (tableColumn != null) {
                    this.fTotalColumnWidth += tableColumn.getWidth();
                    continue;
                }
                this.fTotalColumnWidth += this.getDefaultColumnWidth(i);
            }
        }
        return this.fTotalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.fSelectionModel = listSelectionModel;
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.fSelectionModel;
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return true;
    }

    public String getVarName() {
        return this.fVarName;
    }

    @Override
    public int[] getSelectedColumns() {
        int n = this.fSelectionModel.getMinSelectionIndex();
        int n2 = this.fSelectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.fSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.fSelectionModel != null) {
            int n = this.fSelectionModel.getMinSelectionIndex();
            int n2 = this.fSelectionModel.getMaxSelectionIndex();
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.fSelectionModel.isSelectedIndex(i)) continue;
                ++n3;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.fListenerList.add(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.fListenerList.remove(TableColumnModelListener.class, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.fListenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.fListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.fListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.fListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnSelectionChanged(listSelectionEvent);
        }
    }

    public void setTableIsAdjusting(boolean bl) {
        this.fTableIsAdjusting = bl;
    }

    public boolean getTableIsAdjusting() {
        return this.fTableIsAdjusting;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("width".equals(string) || "preferredWidth".equals(string)) {
            this.fTotalColumnWidth = -1;
            this.fireColumnMarginChanged();
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.fListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnMarginChanged(new ChangeEvent(this));
        }
    }

    private static List<int[]> getNewList(int[] nArray, List<int[]> list) {
        if (nArray[0] > nArray[1]) {
            int n = nArray[1];
            nArray[1] = nArray[0];
            nArray[0] = n;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int[] nArray2 : list) {
            boolean bl = true;
            if (nArray2[0] == nArray[0] && nArray2[1] == nArray[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[0]) {
                nArray2[0] = nArray2[0] + 1;
            } else if (nArray[0] == nArray2[1]) {
                if (nArray2[1] > 0) {
                    nArray2[1] = nArray2[1] - 1;
                }
                if (nArray2[1] < nArray2[0]) {
                    bl = false;
                }
            } else if (nArray[0] < nArray2[0] && nArray[1] > nArray2[0] && nArray[1] < nArray2[1]) {
                arrayList.add(new int[]{nArray[1] + 1, nArray2[1]});
                bl = false;
            } else if (nArray[0] > nArray2[0] && nArray[1] < nArray2[1]) {
                arrayList.add(new int[]{nArray2[0], nArray[0] - 1});
                arrayList.add(new int[]{nArray[1] + 1, nArray2[1]});
                bl = false;
            } else if (nArray[0] > nArray2[0] && nArray[0] < nArray2[1] && nArray[1] >= nArray2[1]) {
                if (nArray[0] > 0) {
                    arrayList.add(new int[]{nArray2[0], nArray[0] - 1});
                }
                bl = false;
            } else if (nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1]) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(nArray2);
        }
        return arrayList;
    }

    public int[] getVariableIndices() {
        return this.fVariableIndices;
    }

    void restoreWidths(Map<String, Integer> map) {
        this.fColumnWidths.clear();
        this.fColumnWidths.putAll(map);
        int n = this.getVariableColumnCount();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object = this.getColumn(i).getHeaderValue();
            if (!(object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) || !this.fColumnWidths.containsKey(string = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName())) continue;
            int n2 = this.fColumnWidths.get(string);
            this.getColumn(i).setPreferredWidth(n2);
        }
    }

    protected int getDefaultColumnWidth(int n) {
        ClassType classType;
        if (this.fVariableIndices != null && this.fVariableClasses != null && n < this.fVariableIndices.length && ((classType = TabularObjectColumnModel.getClassType(this.fVariableClasses[this.fVariableIndices[n]])) == ClassType.DATETIME || classType == ClassType.DURATION || classType == ClassType.CALENDAR_DURATION)) {
            return 125;
        }
        return 75;
    }

    public ClassType getColumnClassType(int n) {
        if (this.fVariableIndices != null && this.fVariableClasses != null && n < this.fVariableIndices.length) {
            return TabularObjectColumnModel.getClassType(this.fVariableClasses[this.fVariableIndices[n]]);
        }
        return ClassType.NUMERIC;
    }

    public static class VariableInfo {
        private String iVarName;
        private int[] iColumnRange;
        private ClassType iClassType;

        public VariableInfo(String string, int[] nArray, ClassType classType) {
            this.iVarName = string;
            this.iColumnRange = nArray;
            this.iClassType = classType;
        }

        String getVarName() {
            return this.iVarName;
        }

        int[] getColumnRange() {
            return this.iColumnRange;
        }

        ClassType getClassType() {
            return this.iClassType;
        }

        boolean isCharArray() {
            return this.getClassType() == ClassType.CHAR;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof VariableInfo)) {
                return false;
            }
            VariableInfo variableInfo = (VariableInfo)object;
            return this.getClassType().equals((Object)variableInfo.getClassType()) && this.getVarName().equals(variableInfo.getVarName()) && Arrays.equals(this.getColumnRange(), variableInfo.getColumnRange());
        }

        public int hashCode() {
            return 10 * this.iClassType.hashCode() + 100 * this.getClassType().hashCode() + this.getColumnRange().hashCode();
        }
    }

    class TabularObjectColumnSelectionModel
    extends DefaultListSelectionModel {
        private List<int[]> iIntervalTemporalOrder = new ArrayList<int[]>();

        TabularObjectColumnSelectionModel() {
        }

        @Override
        public void fireValueChanged(int n, int n2, boolean bl) {
            super.fireValueChanged(n, n2, bl);
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            int[] nArray = this.getExpandedSelectionInterval(n, n2);
            this.iIntervalTemporalOrder.add(new int[]{nArray[0], nArray[1]});
            super.addSelectionInterval(nArray[0], nArray[1]);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            int[] nArray = this.getExpandedSelectionInterval(n, n2);
            this.iIntervalTemporalOrder.clear();
            this.iIntervalTemporalOrder.add(new int[]{nArray[0], nArray[1]});
            super.setSelectionInterval(nArray[0], nArray[1]);
        }

        void setRealSelectionInterval(int n, int n2) {
            this.iIntervalTemporalOrder.clear();
            this.iIntervalTemporalOrder.add(new int[]{n, n2});
            super.setSelectionInterval(n, n2);
        }

        @Override
        public void clearSelection() {
            this.iIntervalTemporalOrder.clear();
            super.clearSelection();
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            int[] nArray = this.getExpandedSelectionInterval(n, n2);
            this.iIntervalTemporalOrder = TabularObjectColumnModel.getNewList(nArray, this.iIntervalTemporalOrder);
            super.removeSelectionInterval(nArray[0], nArray[1]);
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            int[] nArray = this.getExpandedSelectionInterval(n, n2);
            this.iIntervalTemporalOrder.clear();
            super.removeIndexInterval(nArray[0], nArray[1]);
        }

        public int[] getOrderedSelection() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int[] nArray : this.iIntervalTemporalOrder) {
                int n;
                if (nArray[1] >= nArray[0]) {
                    for (n = nArray[0]; n <= nArray[1]; ++n) {
                        if (arrayList.contains(n)) continue;
                        arrayList.add(n);
                    }
                    continue;
                }
                for (n = nArray[0]; n >= nArray[1]; --n) {
                    if (arrayList.contains(n)) continue;
                    arrayList.add(n);
                }
            }
            Object object = new int[arrayList.size()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return object;
        }

        private int[] getExpandedSelectionInterval(int n, int n2) {
            int n3;
            int n4;
            boolean bl;
            if (TabularObjectColumnModel.this.fColumnIndices == null || TabularObjectColumnModel.this.fColumnIndices.length < 2) {
                return new int[]{n, n2};
            }
            boolean bl2 = bl = n2 < n;
            if (bl) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            n4 = n > TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 1] - 1 ? n : (n >= TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 2] ? TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 2] : ((n4 = Arrays.binarySearch(TabularObjectColumnModel.this.fColumnIndices, n)) < 0 ? (-n4 - 2 < TabularObjectColumnModel.this.fColumnIndices.length ? TabularObjectColumnModel.this.fColumnIndices[-n4 - 2] : TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 1]) : n));
            n3 = n2 > TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 1] - 1 ? n2 : (n2 >= TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 2] ? TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 1] - 1 : ((n3 = Arrays.binarySearch(TabularObjectColumnModel.this.fColumnIndices, n2 + 1)) < 0 ? (-n3 - 1 < TabularObjectColumnModel.this.fColumnIndices.length ? TabularObjectColumnModel.this.fColumnIndices[-n3 - 1] - 1 : TabularObjectColumnModel.this.fColumnIndices[TabularObjectColumnModel.this.fColumnIndices.length - 1] - 1) : n2));
            if (bl) {
                return new int[]{n3, n4};
            }
            return new int[]{n4, n3};
        }
    }

    private class ColumnEnumeration
    implements Enumeration<TableColumn> {
        private int iEnumCounter = 0;

        private ColumnEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.iEnumCounter < TabularObjectColumnModel.this.fColumnCount;
        }

        @Override
        public TableColumn nextElement() {
            if (this.iEnumCounter >= TabularObjectColumnModel.this.fColumnCount) {
                throw new NoSuchElementException();
            }
            TableColumn tableColumn = TabularObjectColumnModel.this.getColumn(this.iEnumCounter);
            ++this.iEnumCounter;
            return tableColumn;
        }
    }

    public static enum ClassType {
        NUMERIC,
        CATEGORICAL,
        CELL,
        CHAR,
        DATETIME,
        DURATION,
        CALENDAR_DURATION;

    }
}

