/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import ca.odell.glazedlists.swing.TreeTableSupport;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationNameUtils;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationExplorerButtonPanel;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupByFile;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupSelectionListener;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationUiUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SearchTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ConfigurationExplorer
extends MJPanel {
    private static final Color BAD_FILE_FOREGROUND;
    private AbstractFileConfiguration fUserSelectedConfiguration;
    private EventList<AbstractFileConfiguration> fConfigurations;
    private FilterList<AbstractFileConfiguration> fFilteredConfigurations;
    private SortedList<AbstractFileConfiguration> fNameSortedConfigurations;
    private SortedList<AbstractFileConfiguration> fImportanceSortedConfigurations;
    private TransformedList<AbstractFileConfiguration, AbstractFileConfiguration> fSwingProxy;
    private TreeList<AbstractFileConfiguration> fTreeList;
    private final SearchTextField fFilterText = new SearchTextField();
    private final TextComponentMatcherEditor<AbstractFileConfiguration> fMatcherEditor = this.fFilterText.createTextComponentMatcherEditor((TextFilterator)new ConfigurationTextFilterator());
    private EventTableModel<AbstractFileConfiguration> fModel;
    private final ShortCircuitedSelectionTable fTable = new ShortCircuitedSelectionTable();
    private TreeTableSupport fTreeTableSupport;
    private final MJScrollPane fScrollPane = new MJScrollPane((Component)((Object)this.fTable));
    private ConfigurationExplorerButtonPanel fButtonBarPanel;
    private List<ConfigurationSelectionListener> fConfigurationSelectionListeners = new Vector<ConfigurationSelectionListener>();
    private List<ConfigurationGroupSelectionListener> fConfigurationGroupSelectionListeners = new Vector<ConfigurationGroupSelectionListener>();
    private AbstractConfigurationGroup<ConfigurationGroupByFile.FileGroupingConfiguration> fConfigurationGrouping = new ConfigurationGroupByFile();
    private File fCurrentFile;
    private ActionListener fRemoveButtonActionListener;
    private ActionListener fUndoButtonActionListener;

    public ConfigurationExplorer(EventList<AbstractFileConfiguration> eventList) {
        this.fConfigurations = eventList;
        this.init();
    }

    private void init() {
        this.fButtonBarPanel = new ConfigurationExplorerButtonPanel(this.createAddActionListener());
        this.fScrollPane.setVerticalScrollBarPolicy(20);
        this.fScrollPane.setHorizontalScrollBarPolicy(30);
        this.fScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.fScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        FormLayout formLayout = new FormLayout("d:grow", "d, 3dlu, d:grow, 2dlu, " + ConfigurationEditor.getSubPanelHeight() + "px");
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        panelBuilder.add((Component)this.fFilterText.getComponent(), cellConstraints.xy(1, 1, "fill, center"));
        panelBuilder.add((Component)this.fScrollPane, cellConstraints.xy(1, 3, "fill, fill"));
        panelBuilder.add(this.fButtonBarPanel.getComponent(), cellConstraints.xy(1, 5, "fill, top"));
        this.initTreeList();
        this.initNames();
        this.initToolTips();
        this.initListeners();
    }

    private void initTreeList() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFilteredConfigurations = new FilterList((EventList)new FilterList(this.fConfigurations, (MatcherEditor)new ThreadedMatcherEditor(this.fMatcherEditor)), (Matcher)new Matcher<AbstractFileConfiguration>(){

            public boolean matches(AbstractFileConfiguration abstractFileConfiguration) {
                return PublishConfiguration.TYPE.equals(abstractFileConfiguration.getType());
            }
        });
        this.fNameSortedConfigurations = new SortedList(this.fFilteredConfigurations, ConfigurationNameUtils.getConfigurationNameSorter());
        this.fImportanceSortedConfigurations = new SortedList(this.fNameSortedConfigurations, ConfigurationPluginUtils.getConfigurationImportanceComparator());
        String[] stringArray = new String[]{"name"};
        String[] stringArray2 = new String[]{"Name"};
        TableFormat tableFormat = GlazedLists.tableFormat(AbstractFileConfiguration.class, (String[])stringArray, (String[])stringArray2);
        this.fSwingProxy = GlazedListsSwing.swingThreadProxyList(this.fImportanceSortedConfigurations);
        this.fTreeList = new TreeList(this.fSwingProxy, this.fConfigurationGrouping.getTreeFormat(), (TreeList.ExpansionModel)this.fConfigurationGrouping.getTreeExpansionModel(), (Comparator)new ConfigurationGroupByFile.FileNameComparator());
        this.fModel = new EventTableModel(this.fTreeList, tableFormat);
        this.fTable.setModel((TableModel)this.fModel);
        this.fTable.setTableHeader(null);
        this.fTable.getColumnModel().getColumn(0).setCellRenderer(new ConfigurationTreeTableCellRenderer(this.fTreeList));
        this.fTable.getSelectionModel().setSelectionMode(0);
        this.fTreeTableSupport = TreeTableSupport.install((JTable)((Object)this.fTable), this.fTreeList, (int)0);
        this.repaint();
    }

    private void initNames() {
        this.setName("ConfigurationExplorer");
        this.fFilterText.getComponent().setName("ConfigurationExplorer.FilterField");
        this.fTable.setName("ConfigurationExplorer.Table");
        this.fScrollPane.setName("ConfigurationExplorer.ScrollPane");
    }

    private void initToolTips() {
        this.fFilterText.getComponent().setToolTipText(ConfigurationUtils.lookup("filterator.tooltip"));
    }

    private void initListeners() {
        this.fRemoveButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractFileConfiguration abstractFileConfiguration = ConfigurationExplorer.this.getSelectedConfiguration();
                ConfigurationExplorer.this.ensureNodeIsExpanded(abstractFileConfiguration.getAssociatedFile());
                int n = ConfigurationExplorer.this.fTreeList.indexOf((Object)abstractFileConfiguration);
                if (ConfigurationExplorer.this.isSelectionConfigurationGroup()) {
                    ConfigurationManager.getInstance().removeAllConfigurationsForFile(abstractFileConfiguration.getAssociatedFile());
                } else {
                    ConfigurationManager.getInstance().removeConfiguration(abstractFileConfiguration);
                }
                if (ConfigurationExplorer.this.fTreeList.isEmpty()) {
                    ConfigurationExplorer.this.setSelectedConfiguration(null);
                } else {
                    int n2 = n >= ConfigurationExplorer.this.fTreeList.size() ? ConfigurationExplorer.this.fTreeList.size() - 1 : n;
                    AbstractFileConfiguration abstractFileConfiguration2 = (AbstractFileConfiguration)ConfigurationExplorer.this.fTreeList.get(n2);
                    ConfigurationExplorer.this.setSelectedConfiguration(abstractFileConfiguration2, true);
                }
                ConfigurationExplorer.this.fTable.requestFocus();
            }
        };
        this.fButtonBarPanel.getRemoveButton().addActionListener(this.fRemoveButtonActionListener);
        this.fUndoButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventList<AbstractFileConfiguration> eventList = ConfigurationManager.getInstance().undoLastDelete();
                ConfigurationExplorer.this.setSelectedConfiguration((AbstractFileConfiguration)eventList.get(0));
            }
        };
        this.fButtonBarPanel.getUndoButton().addActionListener(this.fUndoButtonActionListener);
        this.addConfigurationSelectionListener(this.fButtonBarPanel);
        this.addConfigurationGroupSelectionListener(this.fButtonBarPanel);
    }

    void cleanup() {
        this.fButtonBarPanel.getRemoveButton().removeActionListener(this.fRemoveButtonActionListener);
        this.fButtonBarPanel.getUndoButton().removeActionListener(this.fUndoButtonActionListener);
        this.fButtonBarPanel.cleanup();
        this.fTreeTableSupport.uninstall();
        this.fMatcherEditor.dispose();
        this.fModel.dispose();
        this.fConfigurations = null;
        this.fTreeList.dispose();
        this.fSwingProxy.dispose();
        this.fImportanceSortedConfigurations.dispose();
        this.fNameSortedConfigurations.dispose();
        this.fFilteredConfigurations.dispose();
        this.fConfigurationSelectionListeners.clear();
        this.fConfigurationGroupSelectionListeners.clear();
    }

    private ConfigurationExplorerButtonPanel.AddActionListener createAddActionListener() {
        return new ConfigurationExplorerButtonPanel.AddActionListener(){

            @Override
            public void addRequested(AbstractFileConfiguration.Type<?> type) {
                AbstractFileConfiguration abstractFileConfiguration = ConfigurationExplorer.this.getSelectedConfiguration();
                File file = abstractFileConfiguration == null ? ConfigurationExplorer.this.fCurrentFile : abstractFileConfiguration.getAssociatedFile();
                Object obj = ConfigurationManager.getInstance().createAndAddConfigurationForFile(file, type);
                ConfigurationExplorer.this.ensureNodeIsExpanded(file);
                ConfigurationExplorer.this.setSelectedConfiguration(obj, true);
                ConfigurationExplorer.this.fTable.requestFocus();
            }
        };
    }

    private AbstractFileConfiguration getSelectedConfigurationInTable() {
        int n = this.fTable.getSelectedRow();
        return n >= 0 ? (AbstractFileConfiguration)this.fTreeList.get(n) : null;
    }

    public AbstractFileConfiguration getSelectedConfiguration() {
        return this.fUserSelectedConfiguration;
    }

    private boolean isSelectionConfigurationGroup() {
        return this.getSelectedConfiguration() != null && this.getSelectedConfiguration() instanceof AbstractConfigurationGroup.GroupingConfiguration;
    }

    public void setSelectedConfiguration(AbstractFileConfiguration abstractFileConfiguration) {
        this.setSelectedConfiguration(abstractFileConfiguration, true);
    }

    private void setSelectedConfiguration(AbstractFileConfiguration abstractFileConfiguration, boolean bl) {
        this.fUserSelectedConfiguration = abstractFileConfiguration;
        int n = this.fTreeList.indexOf((Object)abstractFileConfiguration);
        this.fTable.getSelectionModel().setSelectionInterval(n, n);
        if (bl) {
            if (abstractFileConfiguration instanceof AbstractConfigurationGroup.GroupingConfiguration) {
                this.fireConfigurationGroupSelected((AbstractConfigurationGroup.GroupingConfiguration)abstractFileConfiguration);
            } else {
                this.fireConfigurationSelected(abstractFileConfiguration);
            }
        }
        this.repaint();
        this.scrollConfigurationToBeVisible(abstractFileConfiguration);
    }

    public void scrollConfigurationToBeVisible(AbstractFileConfiguration abstractFileConfiguration) {
        int n = this.fTreeList.indexOf((Object)abstractFileConfiguration);
        Rectangle rectangle = this.fTable.getCellRect(n, 0, true);
        this.fTable.scrollRectToVisible(rectangle);
    }

    public void showConfigurationsForFile(File file) {
        this.fCurrentFile = file;
        this.ensureNodeIsExpanded(file);
    }

    private void ensureNodeIsExpanded(File file) {
        for (TreeList.Node node : this.fTreeList.getRoots()) {
            if (!FileUtils.areFilesTheSame((File)file, (File)((AbstractFileConfiguration)node.getElement()).getAssociatedFile())) continue;
            int n = this.fTreeList.indexOf(node.getElement());
            this.fTreeList.setExpanded(n, true);
            break;
        }
    }

    public void setFilterText(String string) {
        this.fFilterText.setSearchText(string);
    }

    public ConfigurationExplorerButtonPanel getButtonBarPanel() {
        return this.fButtonBarPanel;
    }

    public void addConfigurationSelectionListener(ConfigurationSelectionListener configurationSelectionListener) {
        this.fConfigurationSelectionListeners.add(configurationSelectionListener);
    }

    public void removeConfigurationSelectionListener(ConfigurationSelectionListener configurationSelectionListener) {
        this.fConfigurationSelectionListeners.add(configurationSelectionListener);
    }

    private void fireConfigurationSelected(AbstractFileConfiguration abstractFileConfiguration) {
        for (ConfigurationSelectionListener configurationSelectionListener : this.fConfigurationSelectionListeners) {
            configurationSelectionListener.configurationSelected(abstractFileConfiguration);
        }
    }

    public void addConfigurationGroupSelectionListener(ConfigurationGroupSelectionListener configurationGroupSelectionListener) {
        this.fConfigurationGroupSelectionListeners.add(configurationGroupSelectionListener);
    }

    public void removeConfigurationGroupListSelectionListener(ConfigurationGroupSelectionListener configurationGroupSelectionListener) {
        this.fConfigurationGroupSelectionListeners.add(configurationGroupSelectionListener);
    }

    private void fireConfigurationGroupSelected(AbstractConfigurationGroup.GroupingConfiguration groupingConfiguration) {
        for (ConfigurationGroupSelectionListener configurationGroupSelectionListener : this.fConfigurationGroupSelectionListeners) {
            configurationGroupSelectionListener.configurationGroupSelected(groupingConfiguration);
        }
    }

    static {
        MJUtilities.initJIDE();
        BAD_FILE_FOREGROUND = Color.RED.darker();
    }

    private static class ConfigurationTextFilterator
    implements TextFilterator<AbstractFileConfiguration> {
        private ConfigurationTextFilterator() {
        }

        public void getFilterStrings(List<String> list, AbstractFileConfiguration abstractFileConfiguration) {
            list.add(abstractFileConfiguration.getName());
            list.add(abstractFileConfiguration.getAssociatedFileName());
        }
    }

    private static class ConfigurationTreeTableCellRenderer
    extends DefaultTableCellRenderer {
        private TreeList<AbstractFileConfiguration> fTreeList;

        private ConfigurationTreeTableCellRenderer(TreeList<AbstractFileConfiguration> treeList) {
            this.fTreeList = treeList;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            AbstractFileConfiguration abstractFileConfiguration = (AbstractFileConfiguration)this.fTreeList.get(n);
            boolean bl3 = this.fTreeList.hasChildren(n);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)bl2));
            this.setBackground(ListColorUtils.getListBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)bl2));
            if (PlatformInfo.isMacintosh()) {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            if (bl3 && !abstractFileConfiguration.isFileValid() && !bl) {
                this.setForeground(BAD_FILE_FOREGROUND);
            }
            this.setText(ConfigurationUiUtils.getDisplayName(abstractFileConfiguration));
            this.setToolTipText(ConfigurationUiUtils.getTooltip(abstractFileConfiguration));
            this.setIcon(ConfigurationUiUtils.getIcon(abstractFileConfiguration));
            this.setFont(ConfigurationUiUtils.getFont(this.getFont(), abstractFileConfiguration));
            return this;
        }
    }

    private class ShortCircuitedSelectionTable
    extends MJTable {
        private ShortCircuitedSelectionTable() {
            this.setShowGrid(false);
            this.setRowHeight(Math.max(19, this.getRowHeight()));
        }

        public boolean isRowSelected(int n) {
            return n == ConfigurationExplorer.this.fTreeList.indexOf((Object)ConfigurationExplorer.this.fUserSelectedConfiguration);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            super.changeSelection(n, n2, bl, bl2);
            ConfigurationExplorer.this.setSelectedConfiguration(ConfigurationExplorer.this.getSelectedConfigurationInTable(), true);
        }
    }
}

