/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.dialog.PathUpdateDialog;
import com.mathworks.mlwidgets.path.PathUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.FileUtils;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class PathChange {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.dialog.resources.RES_dialog");
    public static final String DIALOG_CANCELED = "DialogCancel";
    private static final String HELP_SUFFIX_NOT_ON_PATH = "_notonpath";
    private static final String HELP_SUFFIX_SHADOWED = "_shadowed";
    private static final Matlab sMatlab = new Matlab();
    private static final List<PathChange> sPendingCalls = Collections.synchronizedList(new ArrayList());
    private static boolean sPending;
    private final Frame fFrame;
    private final String fTitle;
    private final String fLabel;
    private final String fAbsoluteFilename;
    private final File fFile;
    private final CompletionObserver fObserver;
    private final String fHelpTopicPrefix;
    private final String fCustomCancel;
    private final boolean fResolveSymbolicLinks;

    public PathChange(Frame frame, String string, String string2, String string3, File file, CompletionObserver completionObserver, String string4) {
        this(frame, string, string2, string3, file, null, completionObserver, string4);
    }

    public PathChange(Frame frame, String string, String string2, String string3, File file, CompletionObserver completionObserver, String string4, boolean bl) {
        this(frame, string, string2, string3, file, null, completionObserver, string4, bl);
    }

    public PathChange(Frame frame, String string, String string2, String string3, File file, String string4, CompletionObserver completionObserver, String string5) {
        this(frame, string, string2, string3, file, string4, completionObserver, string5, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathChange(Frame frame, String string, String string2, String string3, File file, String string4, CompletionObserver completionObserver, String string5, boolean bl) {
        if (frame == null) {
            throw new IllegalArgumentException("'frame' cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("'title' cannot be null");
        }
        this.fFrame = frame;
        this.fTitle = string;
        this.fLabel = string2;
        this.fAbsoluteFilename = FileUtils.absolutePathname((String)string3);
        this.fFile = file;
        this.fCustomCancel = string4;
        this.fObserver = completionObserver;
        this.fHelpTopicPrefix = string5;
        this.fResolveSymbolicLinks = bl;
        List<PathChange> list = sPendingCalls;
        synchronized (list) {
            if (sPending) {
                sPendingCalls.add(this);
            } else {
                this.checkIfFileOnPath();
            }
        }
    }

    private void checkIfFileOnPath() {
        sPending = true;
        sMatlab.feval("mdbfileonpath", new Object[]{this.fAbsoluteFilename, this.fResolveSymbolicLinks}, 2, new CompletionObserver(){

            public void completed(final int n, final Object object) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PathChange.this.dispatchAction(n, object);
                    }
                });
            }
        });
    }

    private static void issuePending() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = sPendingCalls;
                synchronized (list) {
                    sPending = false;
                    if (!sPendingCalls.isEmpty()) {
                        ((PathChange)sPendingCalls.remove(0)).checkIfFileOnPath();
                    }
                }
            }
        });
    }

    private void dispatchAction(int n, Object object) {
        if (Matlab.getExecutionStatus((int)n) == 0 && object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            int n2 = (int)((double[])objectArray[1])[0];
            String string2 = FileUtils.truncatePathname((String)string, (int)45);
            switch (n2) {
                case 0: {
                    this.showChangePathDialog(string, n2);
                    break;
                }
                case 1: {
                    this.fObserver.completed(n, object);
                    PathChange.issuePending();
                    break;
                }
                case 2: {
                    this.showChangePathDialog(string, n2);
                    break;
                }
                case 3: {
                    this.showChangePathDialog(string, n2);
                    break;
                }
                case 4: {
                    String string3 = MessageFormat.format(BUNDLE.getString("msg.ShadowerPcode"), string2);
                    MJOptionPane.showMessageDialog((Component)this.fFrame, (Object)string3);
                    PathChange.issuePending();
                    break;
                }
                case 5: {
                    String string4 = MessageFormat.format(BUNDLE.getString("msg.ShadowerMex"), string2);
                    MJOptionPane.showMessageDialog((Component)this.fFrame, (Object)string4);
                    PathChange.issuePending();
                    break;
                }
                case 6: {
                    String string5 = MessageFormat.format(BUNDLE.getString("msg.ShadowerMlx"), string2);
                    MJOptionPane.showMessageDialog((Component)this.fFrame, (Object)string5);
                    PathChange.issuePending();
                    break;
                }
                default: {
                    assert (false) : "Unrecognized status: " + n2;
                    PathChange.issuePending();
                    break;
                }
            }
        } else {
            PathChange.issuePending();
        }
    }

    private void showChangePathDialog(String string, int n) {
        String string2;
        String string3;
        if (n == 0) {
            string3 = this.fAbsoluteFilename;
            string2 = HELP_SUFFIX_NOT_ON_PATH;
        } else {
            string3 = string;
            string2 = HELP_SUFFIX_SHADOWED;
        }
        PathUpdateDialog pathUpdateDialog = new PathUpdateDialog(this.fFrame, this.fTitle, string3, this.fLabel, this.fHelpTopicPrefix + string2, n);
        if (this.fCustomCancel != null) {
            this.handleReply(pathUpdateDialog.showDialogCustomCancel(this.fCustomCancel));
        } else {
            this.handleReply(pathUpdateDialog.showDialog());
        }
    }

    private void handleReply(int n) {
        if (n != 4) {
            String string = MatlabPath.getValidPathEntryParent((String)this.fFile.getParent());
            if (string != null) {
                if (n == 1) {
                    MatlabPath.setCWD((String)string, (CompletionObserver)new PathUpdateCallback(1));
                } else if (n == 2) {
                    MatlabPath.prepend((String)string, (CompletionObserver)new PathUpdateCallback(2));
                }
            }
        } else {
            if (this.fCustomCancel != null) {
                this.fObserver.completed(4, (Object)DIALOG_CANCELED);
            }
            PathChange.issuePending();
        }
    }

    private class PathUpdateCallback
    implements CompletionObserver {
        private final int fReason;

        PathUpdateCallback(int n) {
            this.fReason = n;
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) == 0) {
                if (PathUtils.changeNotificationWarningThrown(object)) {
                    PathUtils.showChangeNotificationDialog(PathChange.this.fFrame, this.fReason);
                }
                PathChange.this.fObserver.completed(n, object);
            }
            PathChange.issuePending();
        }
    }
}

