/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.examples;

import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.WebUrl;
import com.mathworks.mlwidgets.examples.ConfigDependencyProvider;
import com.mathworks.mlwidgets.examples.ExampleGalleryConfig;
import com.mathworks.mlwidgets.examples.WebappConfigDependencyProvider;
import java.net.MalformedURLException;

public class ExampleGalleryWebappConfig
implements ExampleGalleryConfig {
    private static final String MATLAB_VIEWER = "ml_desktop";
    private static final String ALL_PRODUCTS = "all";
    private static final String EXAMPLE_GALLERY_URI = "examples-gallery";
    private final String fExampleId;
    private final ConfigDependencyProvider fConfigDependencyProvider;

    public ExampleGalleryWebappConfig() {
        this(null);
    }

    public ExampleGalleryWebappConfig(String string) {
        this(string, new WebappConfigDependencyProvider());
    }

    public ExampleGalleryWebappConfig(String string, ConfigDependencyProvider configDependencyProvider) {
        this.fExampleId = string;
        this.fConfigDependencyProvider = configDependencyProvider;
    }

    @Override
    public Url getUrl() {
        UrlBuilder<WebUrl> urlBuilder = this.getUrlBuilder();
        if (this.fExampleId != null) {
            urlBuilder.append(new String[]{this.fExampleId});
        }
        return urlBuilder.toUrl();
    }

    private UrlBuilder<WebUrl> getUrlBuilder() {
        try {
            UrlBuilder urlBuilder = new WebUrl(this.fConfigDependencyProvider.getExampleGalleryDomain() + EXAMPLE_GALLERY_URI).toUrlBuilder();
            urlBuilder.addParameter("viewer", new String[]{this.getMatlabViewer()});
            urlBuilder.addParameter("products", new String[]{this.getProductList()});
            urlBuilder.addParameter("release", new String[]{this.getMatlabRelease()});
            urlBuilder.addParameter("language", new String[]{this.getLocale()});
            urlBuilder.addParameter("entitlementid", new String[]{this.getEntitlementId()});
            return urlBuilder;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String getEntitlementId() {
        return this.fConfigDependencyProvider.getEntitlementId();
    }

    private String getMatlabViewer() {
        return MATLAB_VIEWER;
    }

    private String getProductList() {
        return this.fConfigDependencyProvider.getProductList();
    }

    private String getLocale() {
        return this.fConfigDependencyProvider.getLocale();
    }

    private String getMatlabRelease() {
        return this.fConfigDependencyProvider.getMatlabRelease();
    }
}

