/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.RequestQueue;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileDecorationCache {
    private Map<FileLocation, FileDecorationModel> fDecorationModels;
    private ExtensionRegistry fExtensions;
    private final MulticastChangeListener fListeners = new MulticastChangeListener();
    private final RequestQueue fDecorationRequestQueue = new RequestQueue("FileDecorationCache request queue");

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListeners.removeChangeListener(changeListener);
    }

    public synchronized void markStale(FileLocation fileLocation, FileSystemEntry fileSystemEntry) {
        FileDecorationModel fileDecorationModel;
        if (this.fDecorationModels != null && (fileDecorationModel = this.fDecorationModels.get(fileLocation)) != null) {
            fileDecorationModel.markStale(fileSystemEntry);
        }
    }

    public synchronized void flush(FileLocation fileLocation) {
        if (this.fDecorationModels != null) {
            FileDecorationCache.disposeIfNotNull(this.fDecorationModels.remove(fileLocation));
        }
    }

    public synchronized void dispose() {
        if (this.fDecorationModels != null) {
            for (FileDecorationModel fileDecorationModel : this.fDecorationModels.values()) {
                fileDecorationModel.dispose();
            }
        }
        this.fDecorationModels = null;
        this.fExtensions = null;
    }

    public synchronized FileDecorations getDecorations(final FileSystemEntry fileSystemEntry, ExtensionRegistry extensionRegistry) {
        Object object;
        if (this.fExtensions != null && !extensionRegistry.equals(this.fExtensions)) {
            this.fExtensions = extensionRegistry;
            object = this.fDecorationModels.values().iterator();
            while (object.hasNext()) {
                FileDecorationModel fileDecorationModel = (FileDecorationModel)object.next();
                fileDecorationModel.dispose();
            }
            this.fDecorationModels = null;
        }
        this.fExtensions = extensionRegistry;
        if (this.fDecorationModels == null) {
            this.fDecorationModels = new HashMap<FileLocation, FileDecorationModel>();
        }
        if ((object = this.fDecorationModels.get(fileSystemEntry.getLocation())) == null) {
            object = new FileDecorationModel(this.fExtensions, this.fDecorationRequestQueue, fileSystemEntry);
            ((FileDecorationModel)object).addAsyncResponseListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    FileDecorationCache.this.fListeners.stateChanged(new ChangeEvent(fileSystemEntry.getLocation()));
                }
            });
            this.fDecorationModels.put(fileSystemEntry.getLocation(), (FileDecorationModel)object);
        }
        return ((FileDecorationModel)object).getDecorations();
    }

    private static void disposeIfNotNull(FileDecorationModel fileDecorationModel) {
        if (fileDecorationModel != null) {
            fileDecorationModel.dispose();
        }
    }
}

