/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.jidesoft.grid.Expandable;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public final class ActionInputImpl
implements ActionInput {
    private final List<FileSystemEntry> fSelection;
    private final int[] fSelectedRows;
    private final NavigationContext fContext;
    private final FileTable fTable;
    private final WorkMonitor fWorkMonitor;

    public ActionInputImpl(FileTable fileTable) {
        this.fWorkMonitor = fileTable == null ? new WorkMonitor() : fileTable.getWorkMonitor();
        this.fContext = fileTable == null ? null : fileTable.getContext();
        this.fTable = fileTable;
        this.fSelectedRows = this.fTable == null || this.fTable.getSelectedRows() == null ? new int[]{} : this.fTable.getSelectedRows();
        this.fSelection = this.fTable == null ? new ArrayList() : this.fTable.getSelectedItems();
    }

    ActionInputImpl(ActionInputImpl actionInputImpl) {
        this.fWorkMonitor = actionInputImpl.getWorkMonitor();
        this.fContext = actionInputImpl.getContext();
        this.fTable = actionInputImpl.getTable();
        this.fSelectedRows = actionInputImpl.getSelectedRows();
        this.fSelection = actionInputImpl.getSelection();
    }

    public ActionInputImpl(ActionInputImpl actionInputImpl, List<FileSystemEntry> list) {
        this.fWorkMonitor = actionInputImpl.fWorkMonitor;
        this.fContext = actionInputImpl.fContext;
        this.fTable = actionInputImpl.getTable();
        this.fSelectedRows = this.fTable == null || this.fTable.getSelectedRows() == null ? new int[]{} : this.fTable.getSelectedRows();
        this.fSelection = list;
    }

    ActionInputImpl without(List<FileSystemEntry> list) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>(this.fSelection);
        arrayList.removeAll(list);
        return new ActionInputImpl(this, arrayList);
    }

    public boolean canCut() {
        return this.fTable != null && this.fTable.canCut();
    }

    public boolean canCopy() {
        return this.fTable != null && this.fTable.canCopy();
    }

    public boolean canPaste() {
        return this.fTable != null && this.fTable.canPaste();
    }

    public boolean isSearching() {
        return this.fContext != null && this.fContext.isSearching();
    }

    public boolean hasAnythingExpanded() {
        return this.fContext != null && this.fTable.getConfiguration().hasAnythingExpanded();
    }

    public FileSystemEntry getLocation() {
        try {
            return this.fContext == null ? RealFileSystem.getInstance().getEntry(new FileLocation(MatlabPath.getCurrentDirectory())) : this.fContext.getLocationEntry();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public FileLocation getNextLocation() {
        return this.fContext == null ? null : this.fContext.getNextLocation();
    }

    public FileLocation getLastLocation() {
        return this.fContext == null ? null : this.fContext.getLastLocation();
    }

    public List<FileSystemEntry> getSelection() {
        return new ArrayList<FileSystemEntry>(this.fSelection);
    }

    public FileSystemEntry[] getSelectionArray() {
        FileSystemEntry[] fileSystemEntryArray = new FileSystemEntry[this.fSelection.size()];
        this.fSelection.toArray(fileSystemEntryArray);
        return fileSystemEntryArray;
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration) {
        return this.fTable.getDecoration(fileSystemEntry, fileDecoration);
    }

    public int[] getSelectedRows() {
        return (int[])this.fSelectedRows.clone();
    }

    public NavigationContext getContext() {
        return this.fContext;
    }

    public FileTable getTable() {
        return this.fTable;
    }

    public WorkMonitor getWorkMonitor() {
        return this.fWorkMonitor;
    }

    public int getParentRowIndex() {
        Expandable expandable;
        GroupingTableRow groupingTableRow;
        if (this.fTable == null) {
            return -1;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1 && (groupingTableRow = this.fTable.getRowAt(nArray[0])) instanceof Expandable && (expandable = groupingTableRow.getParent()) != null) {
            for (int i = nArray[0]; i >= 0; --i) {
                if (!this.fTable.getRowAt(i).equals((Object)expandable)) continue;
                return i;
            }
        }
        return -1;
    }

    public JComponent getComponent() {
        return this.fTable;
    }
}

