/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.overlayfs;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.overlayfs.OverlayFileList;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OverlayFileSystem
implements FileSystem {
    private final FileSystem fOverlay;
    private final FileSystem fBase;
    private final Predicate<FileLocation> fUseOverlayPredicate;

    public OverlayFileSystem(FileSystem fileSystem, FileSystem fileSystem2, Predicate<FileLocation> predicate) {
        this.fBase = fileSystem;
        this.fOverlay = fileSystem2;
        this.fUseOverlayPredicate = predicate;
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        FileSystemEntry fileSystemEntry = this.fOverlay.exists(fileLocation) ? this.fOverlay.getEntry(fileLocation) : this.fBase.getEntry(fileLocation);
        return this.toExternalEntry(fileSystemEntry, true);
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        if (this.fUseOverlayPredicate.accept((Object)fileLocation)) {
            return this.fOverlay.getInputStream(fileLocation);
        }
        return this.fBase.getInputStream(fileLocation);
    }

    public boolean exists(FileLocation fileLocation) {
        return this.fBase.exists(fileLocation);
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return this.fBase.followShortcutOrLink(fileSystemEntry);
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        return new OverlayFileList(this, this.fBase.getList(fileLocation), this.fOverlay.getList(fileLocation));
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new OverlayFileList(this, this.fBase.search(fileLocation, searchCriteria, predicate), this.fOverlay.search(fileLocation, searchCriteria, predicate));
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return this.fBase.isReadOnly(fileLocation);
    }

    public FileSystemTransaction createTransaction() throws IOException {
        return this.fBase.createTransaction();
    }

    public String encodeName(String string) {
        return this.fBase.encodeName(string);
    }

    public String decodeName(String string) {
        return this.fBase.decodeName(string);
    }

    public FileSystem getBase() {
        return this.fBase;
    }

    List<FileSystemEntry> toExternalEntryList(List<FileSystemEntry> list, boolean bl) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : list) {
            arrayList.add(this.toExternalEntry(fileSystemEntry, bl));
        }
        return arrayList;
    }

    FileSystemEntry toExternalEntry(FileSystemEntry fileSystemEntry, boolean bl) {
        FileLocation fileLocation = fileSystemEntry.getLocation();
        try {
            boolean bl2;
            boolean bl3 = bl2 = this.fOverlay.exists(fileLocation) && this.fUseOverlayPredicate.accept((Object)fileLocation);
            if (bl2) {
                FileSystemEntry fileSystemEntry2 = this.fOverlay.getEntry(fileLocation);
                return new FileSystemEntry(this.fOverlay, fileLocation, fileSystemEntry.isReal(), fileSystemEntry.isFolder(), fileSystemEntry2.getSize(), fileSystemEntry2.getDateModified().getTime(), fileSystemEntry.getMode());
            }
            return bl ? fileSystemEntry : this.fBase.getEntry(fileSystemEntry.getLocation());
        }
        catch (IOException iOException) {
            return new FileSystemEntry(fileSystemEntry, fileLocation, (FileSystem)this);
        }
    }

    public FileSystem getOverlay() {
        return this.fOverlay;
    }
}

