/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationHistory;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.table.RefreshDaemon;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarMode;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.BreadcrumbModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.EmptyPoller;
import com.mathworks.mlwidgets.explorer.widgets.address.GlobalShutdownEventListener;
import com.mathworks.mlwidgets.explorer.widgets.address.SearchButton;
import com.mathworks.mlwidgets.explorer.widgets.address.SearchModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.TitleChangeListener;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.util.ExecutorServiceFactory;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestQueue;
import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.WorkMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class AddressBar {
    private final NavigationContext fContext;
    private final MJPanel fComponent;
    private final MJPanel fMainComponent;
    private final SearchButton fSearchButton;
    private final WorkMonitor fWorkMonitor;
    private final NavigationHistory fHistory;
    private final PopupMenuCustomizer fContextMenuCustomizer;
    private final Map<AddressBarMode, AddressBarModeComponent> fModeComponents;
    private final MulticastChangeListener fListeners;
    private final RequestQueue fRequestQueue;
    private AddressBarMode fMode;
    private boolean fSortedAlphabetically = true;
    private boolean fRootVisible = true;
    private JPopupMenu fCurrentMenu;

    public AddressBar(NavigationContext navigationContext) {
        this(navigationContext, 10);
    }

    public AddressBar(NavigationContext navigationContext, int n) {
        this(navigationContext, new NavigationHistory(navigationContext, n), new WorkMonitor(), Arrays.asList(AddressBarMode.BREADCRUMB_MODE), null);
    }

    public AddressBar(NavigationContext navigationContext, NavigationHistory navigationHistory, WorkMonitor workMonitor, List<AddressBarMode> list, PopupMenuCustomizer popupMenuCustomizer) {
        Object object;
        this.fContext = navigationContext;
        this.fContextMenuCustomizer = popupMenuCustomizer;
        this.fListeners = new MulticastChangeListener();
        this.fRequestQueue = navigationContext.supportsAsyncFileSystemAccess() ? new RequestQueue("AddressBar request queue") : RequestQueue.EDT;
        this.fComponent = new MJPanel(){

            public void addNotify() {
                super.addNotify();
                AddressBar.this.setMode(AddressBar.this.getDefaultMode());
            }

            public Dimension getMaximumSize() {
                return new Dimension((int)super.getMaximumSize().getWidth(), (int)this.getPreferredSize().getHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.calculatePreferredWidth(), super.getPreferredSize().height);
            }

            private int calculatePreferredWidth() {
                String string = AddressBar.this.fContext.getLocation().toString();
                Dimension dimension = FontUtils.getTextSize((Font)AddressBar.this.fComponent.getFont(), (String)string);
                int n = AddressBar.this.getPath().length;
                if (n == 1) {
                    ++n;
                }
                int n2 = 0;
                if (AddressBar.this.fSearchButton != null) {
                    n2 = ((AddressBar)AddressBar.this).fSearchButton.getComponent().getPreferredSize().width;
                }
                return dimension.width + n2 + 50 * n;
            }
        };
        this.fMainComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        if (list.contains((Object)AddressBarMode.SEARCH_MODE)) {
            this.fSearchButton = new SearchButton(MiscellaneousIcon.MAGNIFYING_GLASS_BLUE.getIcon(), new Runnable(){

                @Override
                public void run() {
                    if (AddressBar.this.getMode().equals((Object)AddressBarMode.SEARCH_MODE)) {
                        AddressBar.this.setMode(AddressBar.this.getDefaultMode());
                    } else {
                        AddressBar.this.setMode(AddressBarMode.SEARCH_MODE);
                    }
                }
            });
            this.fComponent.setLayout((LayoutManager)new FormLayout("fill:d:grow, p", "fill:p:grow"));
            object = new CellConstraints();
            this.fComponent.add((Component)this.fMainComponent, (Object)object.xy(1, 1));
            this.fComponent.add((Component)this.fSearchButton.getComponent(), (Object)object.xy(2, 1));
        } else {
            this.fSearchButton = null;
            this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.fComponent.add((Component)this.fMainComponent, (Object)"Center");
        }
        this.fComponent.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AddressBar.this.setModeIfSupported(AddressBarMode.LOCATION_TYPING_MODE);
            }
        });
        if (list.size() == 1 && list.contains((Object)AddressBarMode.BREADCRUMB_MODE)) {
            this.fMainComponent.setBackground(AddressBar.getBrighterColor(UIManager.getColor("TextField.inactiveBackground"), UIManager.getColor("TextField.background"), AddressBar.getBackgroundFactor()));
            this.fMainComponent.setBorder((Border)new LineBorder(AddressBar.getBrighterColor(UIManager.getColor("windowBorder"), UIManager.getColor("TextField.background"), AddressBar.getBorderFactor())));
        } else {
            this.fMainComponent.setBackground(new MJTextField().getBackground());
            this.fMainComponent.setBorder((Border)new LineBorder(new Color(190, 190, 192)));
        }
        object = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 3, 0, 3);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("control"));
                for (int i = 0; i < 3; ++i) {
                    graphics.drawLine(n + i, n2, n + i, n4 - 1);
                    graphics.drawLine(n3 - i - 1, n2, n3 - i - 1, n4 - 1);
                }
                graphics.setColor(color);
            }
        };
        this.fComponent.setBorder((Border)object);
        this.fHistory = navigationHistory;
        this.fWorkMonitor = workMonitor == null ? new WorkMonitor() : workMonitor;
        this.fModeComponents = new LinkedHashMap<AddressBarMode, AddressBarModeComponent>();
        for (AddressBarMode addressBarMode : list) {
            this.fModeComponents.put(addressBarMode, addressBarMode.createComponent(this));
        }
        this.setMode(this.getDefaultMode());
        ScheduledExecutorService scheduledExecutorService = ExecutorServiceFactory.createScheduledExecutorService((String)"AddressBar directory emptiness poller", (Runnable)new EmptyPoller(this), (long)3L, (TimeUnit)TimeUnit.SECONDS);
        AddressBar.addShutdownEventListener(scheduledExecutorService);
        this.setupNotifications();
    }

    public static void addShutdownEventListener(ScheduledExecutorService scheduledExecutorService) {
        GlobalShutdownEventListener globalShutdownEventListener = new GlobalShutdownEventListener(scheduledExecutorService);
        GlobalEventManager.addListener((String)"shutdown", (GlobalEventListener)globalShutdownEventListener);
    }

    public RequestQueue getRequestQueue() {
        return this.fRequestQueue;
    }

    public RefreshDaemon getRefreshDaemon() {
        return this.fContext.getRefreshDaemon();
    }

    public boolean isModeSupported(AddressBarMode addressBarMode) {
        return this.fModeComponents.containsKey((Object)addressBarMode);
    }

    private static float getBackgroundFactor() {
        if (PlatformInfo.isWindowsXPAppearance() || PlatformInfo.isLinux()) {
            return 0.8f;
        }
        return 0.5f;
    }

    private static float getBorderFactor() {
        return 0.5f;
    }

    private static Color getBrighterColor(Color color, Color color2, float f) {
        if (color == null || color2 == null) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        fArray[2] = fArray[2] + (fArray2[2] - fArray[2]) * f;
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public Color getBackground() {
        return this.fMainComponent.getBackground();
    }

    void setCurrentMenu(JPopupMenu jPopupMenu) {
        this.fCurrentMenu = jPopupMenu;
    }

    public JPopupMenu getCurrentMenu() {
        return this.fCurrentMenu;
    }

    public void addStateChangeListener(ChangeListener changeListener) {
        this.fListeners.addChangeListener(changeListener);
    }

    public void removeStateChangeListener(ChangeListener changeListener) {
        this.fListeners.removeChangeListener(changeListener);
    }

    SearchButton getSearchButton() {
        return this.fSearchButton;
    }

    private void setupNotifications() {
        this.fComponent.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AddressBar.this.fireResizeNotification();
            }
        });
        this.fContext.addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                AddressBar.this.fireDataChangeNotification();
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
                AddressBar.this.fireDataChangeNotification();
            }

            @Override
            public void searchEnded() {
                AddressBar.this.fireDataChangeNotification();
            }
        });
        this.fWorkMonitor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AddressBar.this.fireDataChangeNotification();
            }
        });
    }

    public void setSearchEnabled(boolean bl) {
        if (this.fSearchButton != null) {
            this.fSearchButton.getComponent().setVisible(bl);
        }
    }

    public void addUpdateTitleListener(TitleChangeListener titleChangeListener) {
        this.getSearchComponent().addUpdateTitleListener(titleChangeListener);
    }

    public void addSearchTextListener(ChangeListener changeListener) {
        this.getSearchComponent().addSearchTextListener(changeListener);
    }

    public void removeSearchTextListener(ChangeListener changeListener) {
        this.getSearchComponent().removeSearchTextListener(changeListener);
    }

    public String getSearchText() {
        return this.getSearchComponent().getText();
    }

    public void setSearchText(String string) {
        this.getSearchComponent().setText(string);
    }

    private SearchModeComponent getSearchComponent() {
        if (!this.fModeComponents.containsKey((Object)AddressBarMode.SEARCH_MODE)) {
            throw new IllegalStateException("Search mode is not supported by this address bar instance.");
        }
        return (SearchModeComponent)this.fModeComponents.get((Object)AddressBarMode.SEARCH_MODE);
    }

    public PopupMenuCustomizer getContextMenuCustomizer() {
        return this.fContextMenuCustomizer;
    }

    public WorkMonitor getWorkMonitor() {
        return this.fWorkMonitor;
    }

    public BusyAffordance createBusyAffordance() {
        final BusyAffordance busyAffordance = new BusyAffordance();
        busyAffordance.getComponent().setName("BusyAffordance");
        this.fWorkMonitor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WorkMonitor.Task task = AddressBar.this.getWorkMonitor().getLatestTask();
                if (task != null) {
                    busyAffordance.getComponent().setToolTipText(task.getDisplayName());
                    busyAffordance.start();
                } else {
                    busyAffordance.stop();
                }
            }
        });
        return busyAffordance;
    }

    public NavigationHistory getHistory() {
        return this.fHistory;
    }

    public NavigationContext getContext() {
        return this.fContext;
    }

    public void setSortedAlphabetically(boolean bl) {
        this.fSortedAlphabetically = bl;
    }

    public void setRootVisible(boolean bl) {
        this.fRootVisible = bl;
    }

    public boolean isRootVisible() {
        return this.fRootVisible;
    }

    public boolean isSortedAlphabetically() {
        return this.fSortedAlphabetically;
    }

    public FileLocation[] getPath() {
        FileLocation fileLocation;
        Stack<FileLocation> stack = new Stack<FileLocation>();
        for (fileLocation = this.fContext.getLocation(); fileLocation != null; fileLocation = fileLocation.getParent()) {
            stack.push(fileLocation);
        }
        fileLocation = new FileLocation[stack.size()];
        for (int i = 0; i < ((FileLocation)fileLocation).length; ++i) {
            fileLocation[i] = (FileLocation)stack.pop();
        }
        return fileLocation;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public AddressBarMode getDefaultMode() {
        return this.fModeComponents.containsKey((Object)AddressBarMode.BREADCRUMB_MODE) ? AddressBarMode.BREADCRUMB_MODE : this.fModeComponents.keySet().iterator().next();
    }

    public AddressBarMode getMode() {
        return this.fMode;
    }

    public void setModeIfSupported(AddressBarMode addressBarMode) {
        if (this.fModeComponents.keySet().contains((Object)addressBarMode)) {
            this.setMode(addressBarMode, null);
        }
    }

    public void setModeIfSupported(AddressBarMode addressBarMode, MouseEvent mouseEvent) {
        if (this.fModeComponents.keySet().contains((Object)addressBarMode)) {
            this.setMode(addressBarMode, mouseEvent);
        }
    }

    public void setMode(AddressBarMode addressBarMode) {
        this.setMode(addressBarMode, null);
    }

    public void setMode(AddressBarMode addressBarMode, MouseEvent mouseEvent) {
        this.setMode(addressBarMode, mouseEvent, false);
    }

    public void setMode(AddressBarMode addressBarMode, boolean bl) {
        this.setMode(addressBarMode, null, bl);
    }

    public void setToolTipText(String string) {
        ((BreadcrumbModeComponent)this.fModeComponents.get((Object)AddressBarMode.BREADCRUMB_MODE)).setToolTipText(string);
    }

    private void setMode(final AddressBarMode addressBarMode, final MouseEvent mouseEvent, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AddressBar.this.fMode != null && AddressBar.this.fMode.equals((Object)addressBarMode)) {
                    return;
                }
                if (!AddressBar.this.fModeComponents.keySet().contains((Object)addressBarMode)) {
                    throw new IllegalArgumentException("Mode not supported by this AddressBar instance: " + (Object)((Object)addressBarMode));
                }
                AddressBar.this.fMode = addressBarMode;
                if (AddressBar.this.fMode.equals((Object)AddressBarMode.SEARCH_MODE)) {
                    AddressBar.this.fSearchButton.setIcon(MiscellaneousIcon.CANCEL_15x15.getIcon());
                    AddressBar.this.fSearchButton.setToolTipText(MessageFormat.format(ExplorerResources.getString("tooltip.stopSearching"), AddressBar.this.fContext.getLocation().toString()));
                } else if (AddressBar.this.fSearchButton != null) {
                    AddressBar.this.fSearchButton.setIcon(MiscellaneousIcon.MAGNIFYING_GLASS_BLUE.getIcon());
                    AddressBar.this.fSearchButton.setToolTipText(ExplorerResources.getString("tooltip.search"));
                }
                AddressBarModeComponent addressBarModeComponent = (AddressBarModeComponent)AddressBar.this.fModeComponents.get((Object)AddressBar.this.fMode);
                addressBarModeComponent.notifyActivating(mouseEvent);
                AddressBar.this.fMainComponent.removeAll();
                AddressBar.this.fMainComponent.add(addressBarModeComponent.getComponent(), (Object)"Center");
                AddressBar.this.fComponent.revalidate();
                AddressBar.this.fComponent.repaint();
                addressBarModeComponent.notifyActivated(bl);
                AddressBar.this.fListeners.stateChanged(new ChangeEvent(AddressBar.this));
            }
        });
    }

    void fireDataChangeNotification() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (AddressBarModeComponent addressBarModeComponent : AddressBar.this.fModeComponents.values()) {
                    addressBarModeComponent.notifyDataChanged();
                }
            }
        };
        if (this.fContext.supportsAsyncFileSystemAccess()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            MJUtilities.runOnEventDispatchThread((Runnable)runnable);
        }
    }

    private void fireResizeNotification() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (AddressBarModeComponent addressBarModeComponent : AddressBar.this.fModeComponents.values()) {
                    addressBarModeComponent.notifyResized();
                }
            }
        });
    }
}

