/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.table;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.DefaultTableCellViewerCustomizer;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.TableCell;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.IconAndText;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public final class FileCellViewerCustomizer
extends DefaultTableCellViewerCustomizer {
    private final GroupingTable<FileSystemEntry> fTable;
    private final GroupingTableColumn<FileSystemEntry> fIconColumn;

    public FileCellViewerCustomizer(GroupingTable<FileSystemEntry> groupingTable) {
        super(groupingTable);
        this.fTable = groupingTable;
        this.fIconColumn = this.fTable.getConfiguration().getColumnByKey("icon");
    }

    private int getNameOffset(int n) {
        return this.fTable.getIndent() * this.fTable.getRowAt(n).getLevel() + this.fTable.getConfiguration().getColumnSize(this.fIconColumn).getSize();
    }

    public boolean shouldShowCellViewer(TableCell tableCell) {
        boolean bl;
        Rectangle rectangle = this.fTable.getVisibleRect();
        Rectangle rectangle2 = this.fTable.getCellRect(tableCell.getRow(), tableCell.getColumn(), false);
        Component component = this.getCellPainter(tableCell);
        Dimension dimension = component.getPreferredSize();
        boolean bl2 = bl = component instanceof Painter && ((Painter)((Object)component)).isAttribute();
        if (bl) {
            rectangle2.width = this.fTable.getWidth();
            rectangle2.x = 0;
        }
        if (tableCell.getColumn() == 0 || bl) {
            int n = this.getNameOffset(tableCell.getRow());
            rectangle2.x += n;
            rectangle2.width -= n;
        }
        return CellViewer.shouldShow((Rectangle)rectangle, (Rectangle)rectangle2, (Dimension)dimension, (int)2);
    }

    public boolean constrainViewerToCellHeight() {
        return false;
    }

    public Dimension getCellViewerOffset(TableCell tableCell) {
        int n;
        Dimension dimension = new Dimension(0, 2);
        if (tableCell.getColumn() == 0) {
            dimension.setSize((double)(this.getNameOffset(tableCell.getRow()) - 1), dimension.getHeight());
        }
        if (this.fTable.getConfiguration().getVisibleVerticalAttributeCount() > 0 && (n = this.getAttributeIndexForCurrentMouseLocation(tableCell)) > -1) {
            Rectangle rectangle = this.fTable.getCellRect(tableCell.getRow(), tableCell.getColumn(), true);
            int n2 = this.fTable.getConfiguration().getColumnSize(this.fIconColumn).getSize();
            int n3 = this.fTable.getIndent() * this.fTable.getRowAt(tableCell.getRow()).getLevel();
            dimension.setSize(-rectangle.getX() + (double)n3 + (double)n2 - 1.0, (double)((n + 1) * (this.fTable.getLineHeight() + 1)));
        }
        return dimension;
    }

    public Component getCellPainter(TableCell tableCell) {
        int n;
        if (tableCell.getColumn() == 0) {
            tableCell = new TableCell(tableCell.getRow(), 1);
        }
        int n2 = this.fTable.getColumnModel().getColumn(tableCell.getColumn()).getModelIndex();
        GroupingTableColumn groupingTableColumn = this.fTable.getConfiguration().getVisibleColumn(n2);
        TableCellRenderer tableCellRenderer = groupingTableColumn.getCellRenderer(false, false);
        boolean bl = this.fTable.isCellSelected(tableCell.getRow(), tableCell.getColumn());
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)this.fTable, this.fTable.getModel().getValueAt(tableCell.getRow(), n2), bl, false, tableCell.getRow(), tableCell.getColumn());
        if (this.fTable.getConfiguration().getVisibleVerticalAttributeCount() > 0 && (n = this.getAttributeIndexForCurrentMouseLocation(tableCell)) > -1) {
            GroupingTableRow groupingTableRow = this.fTable.getRowAt(tableCell.getRow());
            ArrayList arrayList = new ArrayList(groupingTableRow.getLoadedVerticalAttributes().keySet());
            ArrayList arrayList2 = new ArrayList(groupingTableRow.getLoadedVerticalAttributes().values());
            return new Painter((String)arrayList2.get(n), bl, component, (VerticalAttribute<FileSystemEntry>)((VerticalAttribute)arrayList.get(n)));
        }
        Object object = this.fTable.getValueAt(tableCell.getRow(), tableCell.getColumn());
        return FileCellViewerCustomizer.getPainter(bl, component, object);
    }

    public static Component getPainter(boolean bl, Component component, Object object) {
        if (object instanceof IconAndText && IconAndText.class.isAssignableFrom(object.getClass())) {
            IconAndText iconAndText = (IconAndText)object;
            MJLabel mJLabel = new MJLabel(iconAndText.getText(), iconAndText.getIcon(), 10);
            mJLabel.setBackground(component.getBackground());
            mJLabel.setForeground(component.getForeground());
            return mJLabel;
        }
        return new Painter(object == null ? "" : object.toString(), bl, component);
    }

    private int getAttributeIndexForCurrentMouseLocation(TableCell tableCell) {
        Point point = new Point(MouseInfo.getPointerInfo().getLocation());
        SwingUtilities.convertPointFromScreen(point, this.fTable);
        Rectangle rectangle = this.fTable.getCellRect(tableCell.getRow(), tableCell.getColumn(), true);
        if (point.getY() < rectangle.getY() + (double)this.fTable.getLineHeight()) {
            return -1;
        }
        int n = (int)(point.getY() - rectangle.getY() - (double)this.fTable.getLineHeight()) / this.fTable.getLineHeight();
        return n >= this.fTable.getRowAt(tableCell.getRow()).getLoadedVerticalAttributeCount() ? -1 : n;
    }

    private static class Painter
    extends MJLabel {
        private final VerticalAttribute<FileSystemEntry> iAttribute;

        Painter(String string, boolean bl, Component component) {
            this(string, bl, component, null);
        }

        Painter(String string, boolean bl, Component component, VerticalAttribute<FileSystemEntry> verticalAttribute) {
            super(string);
            this.iAttribute = verticalAttribute;
            this.setBackground(component.getBackground());
            this.setForeground(component.getForeground());
            if (!bl && this.iAttribute != null && this.iAttribute.getForegroundColor() != null) {
                this.setForeground(this.iAttribute.getForegroundColor());
            }
        }

        public boolean isAttribute() {
            return this.iAttribute != null;
        }
    }
}

