/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.html.Url;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTip;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTipPanel;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.actionbrowser.HelpOnSelectionProvider;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotActionEvaluator;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.components.gallery.model.FilteredGalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class PlotToolSet
extends TSToolSet {
    public static final String TOOL_SET_NAME = "plot_toolset";
    public static final String PLOT_GALLERY_NAME = "plots";
    private String[] fVariableNames;
    private boolean fReuseFigure = true;
    private int fApplicablePlotCount;
    private VariableUpdateEvent fVariableUpdateEvent;
    private ModelStateFactory.InterruptibleMatlabWorker fWorker;
    private boolean fIsUpdatePending;
    private PlotUpdateListener fPendingListener;
    private AtomicReference<String[]> fNamesToEvaluate = new AtomicReference<Object>(null);
    private GalleryView fGalleryView;
    private Predicate<Item> fFilter;
    private MJAbstractAction fShowPlotsForAction = new ShowPlotsForAction();
    private MJAbstractAction fShowAllAction = new ShowAllAction();
    private PlotCatalog fMorePlotsDialog;

    PlotToolSet(TSToolSetContents tSToolSetContents) {
        super(tSToolSetContents);
        this.addDecorator(PLOT_GALLERY_NAME, new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                PlotToolSet.this.fGalleryView = (GalleryView)jComponent;
                PlotToolSet.this.addFilterActions(PlotToolSet.this.fGalleryView);
                PlotToolSet.this.fGalleryView.addPopupListener(new GalleryView.PopupListener(){

                    public void galleryPopupShown(GalleryView galleryView) {
                    }

                    public void galleryPopupHidden(GalleryView galleryView) {
                        if (PlotToolSet.this.fApplicablePlotCount > 0) {
                            PlotToolSet.this.showPlotsForSelection();
                        }
                        PlotToolSet.this.updateShowActions();
                    }
                });
            }
        });
    }

    void addPlotAction(String string, PlotAction plotAction) {
        this.configureAndAdd(string, (Action)((Object)new BoundPlotAction(plotAction)));
    }

    public void setVariablesToPlot(String[] stringArray) {
        this.setVariablesToPlot(stringArray, null);
    }

    public void setVariablesToPlot(String[] stringArray, PlotUpdateListener plotUpdateListener) {
        if (this.fVariableUpdateEvent == null) {
            this.fVariableUpdateEvent = new VariableUpdateEvent(stringArray, plotUpdateListener);
            EventQueue.invokeLater(this.fVariableUpdateEvent);
        } else {
            VariableUpdateEvent.access$602(this.fVariableUpdateEvent, stringArray);
            this.fVariableUpdateEvent.iListener = plotUpdateListener;
        }
    }

    public boolean hasPlotsForVariables() {
        return this.fApplicablePlotCount > 0;
    }

    public void setReuseFigure(boolean bl) {
        this.fReuseFigure = bl;
    }

    public boolean willReuseFigure() {
        return this.fReuseFigure;
    }

    public static String createArgumentString(String[] stringArray) {
        return PlotAction.createArgumentString(stringArray);
    }

    private void setVariableNames(String[] stringArray) {
        this.fVariableNames = stringArray;
    }

    private void addFilterActions(GalleryView galleryView) {
        Box box = Box.createHorizontalBox();
        MJRadioButton mJRadioButton = new MJRadioButton((Action)this.fShowPlotsForAction);
        int n = mJRadioButton.getMinimumSize().width * 2;
        mJRadioButton.setMaximumSize(new Dimension(n, mJRadioButton.getMinimumSize().height));
        mJRadioButton.setName("ShowPlotsForSelectionRadioButton");
        mJRadioButton.setFocusable(false);
        box.add((Component)mJRadioButton);
        mJRadioButton = new MJRadioButton((Action)this.fShowAllAction);
        mJRadioButton.setName("ShowAllPlotsRadioButton");
        mJRadioButton.setFocusable(false);
        box.add((Component)mJRadioButton);
        box.add(Box.createHorizontalGlue());
        MJButton mJButton = new MJButton((Action)((Object)new CatalogAction()));
        mJButton.setName("ShowCatalogButton");
        mJButton.setFocusable(false);
        mJButton.setFocusTraversable(false);
        box.add((Component)mJButton);
        galleryView.setPopupExtension((JComponent)box);
    }

    private static boolean isSelectionEmpty(String[] stringArray) {
        return stringArray == null || stringArray.length == 0;
    }

    private static boolean areTwoSelected(String[] stringArray) {
        return stringArray != null && stringArray.length == 2;
    }

    private void updatePlotActions(PlotUpdateListener plotUpdateListener) {
        boolean bl = false;
        if (this.fWorker == null) {
            this.fWorker = new ModelStateFactory.InterruptibleMatlabWorker(){

                public void runOnAWTEventDispatchThread(Object object) {
                    if (PlotToolSet.this.fIsUpdatePending) {
                        PlotToolSet.this.fIsUpdatePending = false;
                        this.start();
                    } else {
                        if (((Boolean)object).booleanValue() && !this.isInterrupted()) {
                            PlotToolSet.this.updateActions(PlotToolSet.this.fPendingListener);
                        }
                        this.reset();
                    }
                }

                public Object runOnMatlabThread() {
                    try {
                        return PlotToolSet.this.evaluatePlotApplicability((String[])PlotToolSet.this.fNamesToEvaluate.get());
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                        return false;
                    }
                }
            };
        } else if (this.fWorker.isRunning()) {
            this.fNamesToEvaluate.set(this.fVariableNames);
            this.fWorker.interrupt();
            this.fPendingListener = plotUpdateListener;
            this.fIsUpdatePending = true;
            bl = true;
        }
        if (PlotToolSet.isSelectionEmpty(this.fVariableNames)) {
            this.disallowAllPlots(plotUpdateListener);
            this.updateActions(this.fPendingListener);
            this.fIsUpdatePending = false;
        } else if (!bl) {
            this.fNamesToEvaluate.set(this.fVariableNames);
            this.fPendingListener = plotUpdateListener;
            this.fWorker.start();
        }
    }

    private boolean evaluatePlotApplicability(String[] stringArray) {
        if (this.fWorker.isInterrupted()) {
            return false;
        }
        PlotActionEvaluator plotActionEvaluator = new PlotActionEvaluator();
        PlotActionIterator plotActionIterator = new PlotActionIterator();
        while (plotActionIterator.hasNext()) {
            final BoundPlotAction boundPlotAction = plotActionIterator.next();
            PlotAction plotAction = boundPlotAction.getPlotAction();
            plotActionEvaluator.addEvalItem(new CompletionObserver(){

                public void completed(int n, Object object) {
                    boundPlotAction.setApplicableToSelection(n == 0 && (Boolean)object != false);
                }
            }, plotAction.getMatlabEvalFunction(stringArray));
            if (plotAction.allowSwap() && stringArray != null && stringArray.length == 2 && (plotAction.getShortDescription() == null || plotAction.getShortDescription().length() == 0)) {
                plotActionEvaluator.addEvalItem(new CompletionObserver(){

                    public void completed(int n, Object object) {
                        boundPlotAction.setApplicableToSelectionIfSwapped(n == 0 && (Boolean)object != false);
                    }
                }, plotAction.getMatlabSwappedEvalFunction(stringArray));
                continue;
            }
            boundPlotAction.setApplicableToSelectionIfSwapped(false);
        }
        if (this.fWorker.isInterrupted()) {
            return false;
        }
        plotActionEvaluator.eval();
        return !this.fWorker.isInterrupted();
    }

    private void disallowAllPlots(PlotUpdateListener plotUpdateListener) {
        PlotActionIterator plotActionIterator = new PlotActionIterator();
        while (plotActionIterator.hasNext()) {
            BoundPlotAction boundPlotAction = plotActionIterator.next();
            boundPlotAction.setApplicableToSelection(false);
            boundPlotAction.setApplicableToSelectionIfSwapped(false);
        }
        this.fApplicablePlotCount = 0;
        if (plotUpdateListener != null) {
            plotUpdateListener.plotsUpdated(0);
        }
    }

    private void updateActions(PlotUpdateListener plotUpdateListener) {
        assert (EventQueue.isDispatchThread());
        this.fApplicablePlotCount = 0;
        PlotActionIterator plotActionIterator = new PlotActionIterator();
        while (plotActionIterator.hasNext()) {
            BoundPlotAction boundPlotAction = plotActionIterator.next();
            boundPlotAction.setSwapVariables(false);
            boundPlotAction.update();
            if (!boundPlotAction.isEnabled()) continue;
            ++this.fApplicablePlotCount;
        }
        this.fGalleryView.setBusy(false);
        if (PlotToolSet.isSelectionEmpty(this.fVariableNames) || this.fApplicablePlotCount == 0) {
            this.showAllPlots();
        } else if (this.fFilter != null && this.fGalleryView.getModel() instanceof FilteredGalleryModel) {
            ((FilteredGalleryModel)this.fGalleryView.getModel()).updateFilter();
        } else {
            this.showPlotsForSelection();
        }
        this.updateShowActions();
        if (plotUpdateListener != null) {
            plotUpdateListener.plotsUpdated(this.fApplicablePlotCount);
        }
    }

    private void showPlotsForSelection() {
        if (this.fFilter == null && this.fGalleryView.getModel() instanceof FilteredGalleryModel) {
            this.fFilter = new ApplicablePlotFilter();
            ((FilteredGalleryModel)this.fGalleryView.getModel()).setFilter(this.fFilter);
        }
    }

    private void showAllPlots() {
        if (this.fFilter != null && this.fGalleryView.getModel() instanceof FilteredGalleryModel) {
            ((FilteredGalleryModel)this.fGalleryView.getModel()).setFilter(null);
            this.fFilter = null;
        }
    }

    private void updateShowActions() {
        this.fShowPlotsForAction.setSelected(this.fFilter != null);
        this.fShowAllAction.setSelected(this.fFilter == null);
        this.fShowPlotsForAction.setEnabled(this.fApplicablePlotCount > 0);
        this.fShowPlotsForAction.putValue("Name", (Object)PlotToolSet.getShowLabelFor(this.fVariableNames));
    }

    static String getShowLabelFor(String[] stringArray) {
        if (PlotToolSet.isSelectionEmpty(stringArray)) {
            return ModelStateFactory.getResourceString("PlotToolSet", "PlotsForSelection");
        }
        return "<html>" + ModelStateFactory.getResourceString("PlotPickerPanel", "PlotsFor") + " " + PlotToolSet.createVarArgs(stringArray, true) + "</html>";
    }

    private static String createVarArgs(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = bl ? " <font color=#4187D3>" + stringArray[0] : stringArray[0];
        if (stringArray.length == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        if (bl) {
            stringBuilder.append("</font>");
        }
        return stringBuilder.toString();
    }

    static Url getURLForAction(PlotAction plotAction, boolean bl) {
        String string = plotAction.getProductHelp();
        String string2 = plotAction.getRefPagePath();
        if (string != null && string2 != null) {
            Url url = FunctionReferenceUtils.getFullUrlForProduct(string, string2, bl);
            return url == null ? null : url;
        }
        String string3 = plotAction.getFunctionName();
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        List<Url> list = FunctionReferenceUtils.getAllReferencePageUrls(string3, false, bl);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static class HelpProvider
    implements HelpOnSelectionProvider {
        private HelpProvider() {
        }

        @Override
        public void showHelpOnSelection(URL uRL, Rectangle rectangle) {
            ActionBrowserUtils.showHelpOnSelection(uRL, rectangle, null, null);
        }

        @Override
        public void showHelpOnSelection(String string, Rectangle rectangle) {
            ActionBrowserUtils.showHelpOnSelection(string, rectangle, null, null);
        }
    }

    private class CatalogAction
    extends MJAbstractAction {
        private CatalogAction() {
            super(ModelStateFactory.getResourceString("CatalogPanel", "Catalog"));
            this.setTip(ModelStateFactory.getResourceString("CatalogPanel", "OpenCatalog"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PlotToolSet.this.fMorePlotsDialog == null) {
                PlotToolSet.this.fMorePlotsDialog = PlotCatalog.getInstance();
            }
            PlotToolSet.this.fMorePlotsDialog.setPlottedVars(PlotToolSet.this.fVariableNames);
            PlotToolSet.this.fMorePlotsDialog.setVisible(true);
        }
    }

    private class ShowAllAction
    extends MJAbstractAction {
        ShowAllAction() {
            super(ModelStateFactory.getResourceString("PlotPickerPanel", "AllPlots"));
            this.setTip(ModelStateFactory.getResourceString("PlotToolSet", "AllPlotsTip"));
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotToolSet.this.showAllPlots();
            PlotToolSet.this.updateShowActions();
        }
    }

    private class ShowPlotsForAction
    extends MJAbstractAction {
        ShowPlotsForAction() {
            super(PlotToolSet.getShowLabelFor(PlotToolSet.this.fVariableNames));
            this.setTip(ModelStateFactory.getResourceString("PlotToolSet", "PlotsForTip"));
            this.setEnabled(false);
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotToolSet.this.showPlotsForSelection();
            PlotToolSet.this.updateShowActions();
        }
    }

    private static class ApplicablePlotFilter
    implements Predicate<Item> {
        private ApplicablePlotFilter() {
        }

        public boolean accept(Item item) {
            return item.isEnabled();
        }
    }

    private class PlotActionIterator
    implements Iterator<BoundPlotAction> {
        private Iterator<Map.Entry<String, Action>> iIterator;
        private BoundPlotAction iNextAction;

        private PlotActionIterator() {
            this.iIterator = PlotToolSet.this.getActions().iterator();
        }

        @Override
        public BoundPlotAction next() throws NoSuchElementException {
            if (this.iNextAction != null) {
                BoundPlotAction boundPlotAction = this.iNextAction;
                this.iNextAction = null;
                return boundPlotAction;
            }
            return this.findNextBoundAction();
        }

        @Override
        public boolean hasNext() {
            if (this.iNextAction != null) {
                return true;
            }
            if (!this.iIterator.hasNext()) {
                return false;
            }
            this.iNextAction = this.findNextBoundAction();
            return this.iNextAction != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private BoundPlotAction findNextBoundAction() throws NoSuchElementException {
            while (this.iIterator.hasNext()) {
                Map.Entry<String, Action> entry = this.iIterator.next();
                if (!(entry.getValue() instanceof BoundPlotAction)) continue;
                return (BoundPlotAction)((Object)entry.getValue());
            }
            return null;
        }
    }

    private class VariableUpdateEvent
    implements Runnable {
        private String[] iVariableNames;
        private PlotUpdateListener iListener;

        VariableUpdateEvent(String[] stringArray, PlotUpdateListener plotUpdateListener) {
            this.iVariableNames = stringArray;
            this.iListener = plotUpdateListener;
        }

        @Override
        public void run() {
            PlotToolSet.this.fPendingListener = null;
            if (!PlotToolSet.isSelectionEmpty(this.iVariableNames)) {
                PlotToolSet.this.fGalleryView.setBusy(true);
            }
            PlotToolSet.this.setVariableNames(this.iVariableNames);
            PlotToolSet.this.updatePlotActions(this.iListener);
            PlotToolSet.this.fVariableUpdateEvent = null;
        }

        static /* synthetic */ String[] access$602(VariableUpdateEvent variableUpdateEvent, String[] stringArray) {
            variableUpdateEvent.iVariableNames = stringArray;
            return stringArray;
        }
    }

    private class SwapVariablesAction
    extends MJAbstractAction {
        private final BoundPlotAction iBoundAction;

        SwapVariablesAction(BoundPlotAction boundPlotAction) {
            super("", (Icon)new ImageIcon(PlotToolSet.class.getResource("resources/swap_xy.png")));
            this.iBoundAction = boundPlotAction;
            this.setSelected(boundPlotAction.iSwapVariables);
            this.setComponentName("SwapXYFor" + this.iBoundAction.getPlotAction().getID());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iBoundAction.toggleSwap();
            this.iBoundAction.update();
        }
    }

    private class InsertAction
    extends MJAbstractAction {
        private final PlotAction iPlotAction;
        private final boolean iSwapVariables;

        private InsertAction(PlotAction plotAction, boolean bl) {
            super(ModelStateFactory.getResourceString("PlotPickerTreeTable", "Insert"));
            this.iPlotAction = plotAction;
            this.iSwapVariables = bl;
            this.setComponentName("Insert");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iPlotAction.insert(PlotToolSet.this.fVariableNames, this.iSwapVariables);
        }
    }

    private class BoundPlotAction
    extends MJAbstractAction
    implements ToolTipContentProvider,
    TSContextMenuContributor {
        private PlotAction iPlotAction;
        private boolean iApplicableToSelection;
        private boolean iApplicableIfSwapped;
        private boolean iSwapVariables;
        private MJAbstractAction iSwapAction;

        private BoundPlotAction(PlotAction plotAction) {
            this.iPlotAction = plotAction;
            this.setEnabled(false);
            this.putValue("tool-tip-content-provider", (Object)this);
            this.putValue("toolstrip-context-menu-contributor", (Object)this);
            this.iSwapAction = new SwapVariablesAction(this);
            this.iSwapAction.setEnabled(false);
            this.putValue("auxiliary-action", this.iSwapAction);
        }

        private void setApplicableToSelection(boolean bl) {
            this.iApplicableToSelection = bl;
        }

        private void setApplicableToSelectionIfSwapped(boolean bl) {
            this.iApplicableIfSwapped = bl;
        }

        private void setSwapVariables(boolean bl) {
            this.iSwapVariables = bl;
        }

        PlotAction getPlotAction() {
            return this.iPlotAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PlotToolSet.this.fVariableNames != null) {
                boolean bl;
                boolean bl2 = bl = PlotToolSet.this.fVariableNames.length == 2 && (this.iSwapVariables || this.iApplicableIfSwapped && !this.iApplicableToSelection);
                if (PlotToolSet.this.fReuseFigure || this.iPlotAction.isGUI()) {
                    this.iPlotAction.execute(PlotToolSet.this.fVariableNames, bl, actionEvent.getSource());
                } else {
                    this.iPlotAction.executeInNewFigure(PlotToolSet.this.fVariableNames, bl, actionEvent.getSource());
                }
            }
        }

        private void toggleSwap() {
            this.iSwapVariables = !this.iSwapVariables;
            this.iSwapAction.setSelected(this.iSwapVariables);
        }

        private void update() {
            this.setEnabled(this.iApplicableToSelection || this.iApplicableIfSwapped);
            this.iSwapAction.setEnabled(this.iPlotAction.allowSwap() && (this.iPlotAction.getShortDescription() == null || this.iPlotAction.getShortDescription().length() == 0) && PlotToolSet.areTwoSelected(PlotToolSet.this.fVariableNames));
            this.putValue("extended-label", this.iSwapVariables ? this.iPlotAction.getSwappedPlotLabel(PlotToolSet.this.fVariableNames) : this.iPlotAction.getPlotLabel(PlotToolSet.this.fVariableNames));
        }

        public JComponent getToolTipContent() {
            ActionToolTipPanel actionToolTipPanel = new ActionToolTipPanel(new HelpProvider(), false);
            ActionToolTip.populateTipPanel(actionToolTipPanel, PlotToolSet.getURLForAction(this.iPlotAction, true), this.iPlotAction.getFunctionName(), this.iPlotAction.getShortDescription(), this.iPlotAction.getDescription(), "", this.isEnabled() ? null : this.iPlotAction.getRuleDescription(), PlotToolSet.getURLForAction(this.iPlotAction, false));
            return actionToolTipPanel;
        }

        public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
            Object object;
            jPopupMenu.insert(new JPopupMenu.Separator(), 0);
            if (this.iPlotAction.allowSwap() && PlotToolSet.areTwoSelected(PlotToolSet.this.fVariableNames)) {
                object = new ChildAction((Action)this.iSwapAction);
                object.putValue("Name", (Object)ModelStateFactory.getResourceString("PlotToolSet", "ReverseVariables"));
                object.putValue("SmallIcon", ChildAction.NULL_VALUE);
                jPopupMenu.insert((Component)new MJCheckBoxMenuItem((Action)object), 0);
            }
            object = new InsertAction(this.iPlotAction, this.iSwapVariables);
            object.setEnabled(this.isEnabled());
            jPopupMenu.insert((Action)object, 0);
        }
    }

    public static interface PlotUpdateListener {
        public void plotsUpdated(int var1);
    }
}

