/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.ProductFilterModel;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.Prefs;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public class DocCenterProductPrefs {
    private static ProductFilterModel sCurrentModel = null;
    private static boolean sShowTestProducts;
    public static final String DOC_CENTER_FILTER_ENABLED = "DocCenterFilterEnabled";
    public static final String SELECTED_UNINSTALLED_PRODUCTS = "SelectedUninstalledProducts";
    public static final String SELECTED_INSTALLED_PRODUCTS = "SelectedInstalledProducts";
    public static final String SHOW_UNINSTALLED_PRODUCTS = "ShowUninstalledProducts";
    private static final String ALL_SELECTED = "ALL";

    private DocCenterProductPrefs() {
    }

    static synchronized ProductFilterModel getProductFilterModel() {
        if (sCurrentModel == null) {
            Set<ProductIdentifier> set = DocCenterProductPrefs.getSelectedProductsFromPref();
            boolean bl = DocCenterProductPrefs.isShowUninstalledProducts();
            sCurrentModel = new ProductFilterModel(set, bl);
        }
        return sCurrentModel;
    }

    private static Set<ProductIdentifier> getSelectedProductsFromPref() {
        EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
        String string = Prefs.getStringPref((String)"HelpSelectedInstalledProducts", (String)"");
        String string2 = Prefs.getStringPref((String)"HelpSelectedUninstalledProducts", (String)"");
        if (string.isEmpty() && string2.isEmpty() || !DocCenterProductPrefs.getProductFilterEnabledPref()) {
            enumSet.addAll(ProductFilterModel.InstalledState.INSTALLED.getProducts());
        } else {
            enumSet.addAll(DocCenterProductPrefs.getSelectedProductsFromPrefString(ProductFilterModel.InstalledState.INSTALLED, string));
            enumSet.addAll(DocCenterProductPrefs.getSelectedProductsFromPrefString(ProductFilterModel.InstalledState.UNINSTALLED, string2));
        }
        return enumSet;
    }

    private static Set<ProductIdentifier> getSelectedProductsFromPrefString(ProductFilterModel.InstalledState installedState, String string) {
        if (string.equals(ALL_SELECTED)) {
            return installedState.getProducts();
        }
        return DocCenterProductPrefs.getProductsFromPrefString(string);
    }

    private static boolean getProductFilterEnabledPref() {
        return Prefs.getBooleanPref((String)"HelpDocCenterFilterEnabled", (boolean)true);
    }

    public static synchronized void setSelectedProductPreferences(ProductFilterModel productFilterModel) {
        DocCenterProductPrefs.setProductFilterModel(productFilterModel);
        DocCenterProductPrefs.saveSelectedProductsPref(productFilterModel, ProductFilterModel.InstalledState.INSTALLED);
        boolean bl = productFilterModel.getInstalledState() == ProductFilterModel.InstalledState.ALL;
        DocCenterProductPrefs.setShowUninstalledProducts(bl);
        if (bl) {
            DocCenterProductPrefs.saveSelectedProductsPref(productFilterModel, ProductFilterModel.InstalledState.UNINSTALLED);
        }
        DocCenterProductPrefs.removeProductFilterEnabledPref();
    }

    private static synchronized void setProductFilterModel(ProductFilterModel productFilterModel) {
        sCurrentModel = productFilterModel;
    }

    private static void saveSelectedProductsPref(ProductFilterModel productFilterModel, ProductFilterModel.InstalledState installedState) {
        String string = DocCenterProductPrefs.getPrefNameForInstalledState(installedState);
        if (productFilterModel.areAllProductsSelected(installedState)) {
            Prefs.setStringPref((String)string, (String)ALL_SELECTED);
        } else {
            Set<ProductIdentifier> set = productFilterModel.getSelectedProducts(installedState);
            String string2 = DocCenterProductPrefs.toPreferenceString(set);
            Prefs.setStringPref((String)string, (String)string2);
        }
    }

    private static String getPrefNameForInstalledState(ProductFilterModel.InstalledState installedState) {
        switch (installedState) {
            case INSTALLED: {
                return "HelpSelectedInstalledProducts";
            }
            case UNINSTALLED: {
                return "HelpSelectedUninstalledProducts";
            }
            case ALL: {
                return null;
            }
        }
        return null;
    }

    private static void removeProductFilterEnabledPref() {
        if (Prefs.exists((String)"HelpDocCenterFilterEnabled")) {
            Prefs.remove((String)"HelpDocCenterFilterEnabled");
        }
    }

    private static boolean isShowUninstalledProducts() {
        return Prefs.getBooleanPref((String)"HelpShowUninstalledProducts", (boolean)false);
    }

    public static void setShowUninstalledProducts(boolean bl) {
        Prefs.setBooleanPref((String)"HelpShowUninstalledProducts", (boolean)bl);
    }

    private static String toPreferenceString(Collection<ProductIdentifier> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductIdentifier productIdentifier : collection) {
            stringBuilder.append(';').append(productIdentifier.getBitNum());
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(1);
        }
        return "";
    }

    private static Set<ProductIdentifier> getProductsFromPrefString(String string) {
        String[] stringArray;
        EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
        for (String string2 : stringArray = string.split(";")) {
            if (string2.isEmpty()) continue;
            try {
                int n = Integer.parseInt(string2);
                ProductIdentifier productIdentifier = ProductIdentifier.get((int)n);
                if (productIdentifier == null) continue;
                enumSet.add(productIdentifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return enumSet;
    }

    public static void setShowTestProducts(boolean bl) {
        if (bl != sShowTestProducts) {
            sShowTestProducts = bl;
            sCurrentModel = null;
        }
    }

    static boolean getShowTestProducts() {
        return sShowTestProducts;
    }
}

