/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlNavigationRuleHandler;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentWrapper;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.SystemBrowserLauncher;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocSearchRequestHandler;
import com.mathworks.mlwidgets.help.F1QueryStringDocUrlRule;
import com.mathworks.mlwidgets.help.HelpDisplayType;
import com.mathworks.mlwidgets.help.HelpPanelLinkClickedHandler;
import com.mathworks.mlwidgets.help.IceBrowserCssHandler;
import com.mathworks.mlwidgets.help.ProductFilterRequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabContextMenuBuilder;
import com.mathworks.mlwidgets.html.MatlabContextMenuCustomAction;
import com.mathworks.mlwidgets.html.OpenBrowserStrategies;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HelpPanel
extends MJPanel {
    private final HtmlComponentHolder fHtmlComponentHolder;
    private final DocConfig<? extends Url> fDocConfig;
    private final Collection<DocUrlNavigationRule> fCustomRules = new ArrayList<DocUrlNavigationRule>();
    private final LinkClickedHandlerHolder fHelpPanelLinkClickedHandler;
    private boolean fSuppressLoadForCurrentLocation = false;

    public HelpPanel() {
        this((DocConfig<? extends Url>)((DocConfig)null));
    }

    public HelpPanel(DocConfig<? extends Url> docConfig) {
        this(docConfig, null);
    }

    public HelpPanel(DocConfig<? extends Url> docConfig, OpenBrowserStrategies openBrowserStrategies) {
        this(docConfig, openBrowserStrategies, null);
    }

    public HelpPanel(DocConfig<? extends Url> docConfig, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
        this(docConfig, openBrowserStrategies, matlabContextMenuCustomAction, HelpDisplayType.HELP);
    }

    public HelpPanel(DocConfig<? extends Url> docConfig, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction, HelpDisplayType helpDisplayType) {
        this(docConfig, openBrowserStrategies, matlabContextMenuCustomAction, helpDisplayType, new HtmlComponentFactory.HtmlComponentType[0]);
    }

    public HelpPanel(DocConfig<? extends Url> docConfig, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction, HelpDisplayType helpDisplayType, HtmlComponentFactory.HtmlComponentType ... htmlComponentTypeArray) {
        this.setLayout(new BorderLayout());
        if (htmlComponentTypeArray.length == 0) {
            htmlComponentTypeArray = new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.CHROMIUM, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER};
        }
        HtmlComponent htmlComponent = HtmlComponentFactory.buildHtmlComponent(htmlComponentTypeArray);
        this.addDocUrlNavigationRules(new F1QueryStringDocUrlRule(helpDisplayType));
        this.fDocConfig = docConfig != null ? docConfig : DocCenterDocConfig.getInstance();
        this.fHelpPanelLinkClickedHandler = new LinkClickedHandlerHolder();
        HelpPanelVisitor helpPanelVisitor = new HelpPanelVisitor(this.fDocConfig, this.fHelpPanelLinkClickedHandler, openBrowserStrategies, matlabContextMenuCustomAction);
        HtmlConversionUtils.visitBrowser(htmlComponent, helpPanelVisitor);
        HtmlComponentHolder htmlComponentHolder = helpPanelVisitor.getHtmlComponent();
        this.fHtmlComponentHolder = htmlComponentHolder == null ? new DummyRendererHolder(htmlComponent) : htmlComponentHolder;
        this.add(this.fHtmlComponentHolder.getHtmlComponentWrapper().getComponent(), "Center");
    }

    public HelpPanel(HtmlComponentFactory.HtmlComponentType ... htmlComponentTypeArray) {
        this(null, null, null, HelpDisplayType.HELP, htmlComponentTypeArray);
    }

    public HtmlComponent getHTMLRenderer() {
        return this.getHtmlComponent();
    }

    public HtmlComponent getHtmlComponent() {
        return this.fHtmlComponentHolder.getHtmlComponentWrapper();
    }

    public void addDocUrlNavigationRules(DocUrlNavigationRule ... docUrlNavigationRuleArray) {
        this.addDocUrlNavigationRules(Arrays.asList(docUrlNavigationRuleArray));
    }

    public void addDocUrlNavigationRules(Collection<DocUrlNavigationRule> collection) {
        this.fCustomRules.addAll(collection);
    }

    DocConfig<? extends Url> getDocConfig() {
        return this.fDocConfig;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fHtmlComponentHolder.getHtmlComponentWrapper().getComponent().setVisible(bl);
    }

    public void dispose() {
        this.fHtmlComponentHolder.dispose();
    }

    public void setSuppressLoadForCurrentLocation(boolean bl) {
        this.fSuppressLoadForCurrentLocation = bl;
    }

    public void setCurrentLocation(String string) {
        try {
            Url url = Url.parse((String)string);
            this.setCurrentLocation(url);
        }
        catch (MalformedURLException malformedURLException) {
            this.fHtmlComponentHolder.getHtmlComponentWrapper().setCurrentLocation(string);
        }
    }

    public void setCurrentLocation(Url url) {
        this.fHtmlComponentHolder.getHtmlComponentWrapper().setCurrentLocation(url);
    }

    private void loadNavigationUrl(Url url) {
        this.fHtmlComponentHolder.getHtmlComponentWrapper().loadNavigationUrl(url);
    }

    public boolean showHelpPage(String string, String string2) {
        DocProduct docProduct = this.fDocConfig.getDocumentationSet().getProductByShortName(string);
        if (docProduct != null) {
            DocPage docPage = new DocPage((DocSetItem)docProduct, string2);
            Url url = this.fDocConfig.getDocRoot().buildDocPageUrl(docPage);
            this.setCurrentLocation(url);
            return true;
        }
        return false;
    }

    public String getCurrentLocation() {
        return this.fHtmlComponentHolder.getHtmlComponentWrapper().getCurrentLocation();
    }

    private String getUserVisibleUrl(String string) {
        try {
            Url url = Url.parse((String)string);
            Url url2 = this.getUserVisibleUrl(url);
            return url2.toUrlBuilder().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    public void setHtmlText(String string) {
        this.fHtmlComponentHolder.getHtmlComponentWrapper().setHtmlText(string);
    }

    public String getHtmlText() {
        return this.fHtmlComponentHolder.getHtmlComponentWrapper().getHtmlText();
    }

    public void displayTopic(String string, String string2) {
        if (string != null) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            if (cSHelpTopicMap.exists()) {
                String string3 = cSHelpTopicMap.mapID(string2);
                if (string3 != null) {
                    this.setCurrentLocation(string3);
                } else {
                    this.fHtmlComponentHolder.getHtmlComponentWrapper().setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
                }
            } else {
                this.fHtmlComponentHolder.getHtmlComponentWrapper().setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
            }
        }
    }

    public void addLinkClickedHandler(HelpPanelLinkClickedHandler helpPanelLinkClickedHandler) {
        this.fHelpPanelLinkClickedHandler.addLinkClickedHandler(helpPanelLinkClickedHandler);
    }

    private Url getNavigationUrl(Url url) {
        DocUrlNavigationRuleHandler docUrlNavigationRuleHandler = this.getRuleHandlerForUrlType(url.getType());
        return docUrlNavigationRuleHandler != null ? docUrlNavigationRuleHandler.applyRules(url.toUrlBuilder(), this.getDocUrlTypeForUrl(url)) : url;
    }

    private Url getUserVisibleUrl(Url url) {
        DocUrlNavigationRuleHandler docUrlNavigationRuleHandler = this.getRuleHandlerForUrlType(url.getType());
        return docUrlNavigationRuleHandler != null ? docUrlNavigationRuleHandler.removeRules(url.toUrlBuilder(), this.getDocUrlTypeForUrl(url)) : url;
    }

    private DocUrlNavigationRuleHandler getRuleHandlerForUrlType(Url.UrlType urlType) {
        DocConfig<? extends Url> docConfig;
        DocConfig<? extends Url> docConfig2 = docConfig = urlType == this.fDocConfig.getUrlType() ? this.fDocConfig : HelpPanel.getDocConfigForUrlType(urlType);
        if (docConfig != null) {
            DocUrlNavigationRuleHandler docUrlNavigationRuleHandler = new DocUrlNavigationRuleHandler(docConfig.getDocUrlNavigationRules());
            return docUrlNavigationRuleHandler.copyOf(this.fCustomRules);
        }
        return null;
    }

    private static DocConfig<? extends Url> getDocConfigForUrlType(Url.UrlType urlType) {
        switch (urlType) {
            case FILE: {
                return DocCenterDocConfig.getLocalConfig();
            }
            case WEB: {
                try {
                    return DocCenterDocConfig.getWebConfig();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private DocUrlType getDocUrlTypeForUrl(Url url) {
        if (url.getType() == this.fDocConfig.getUrlType()) {
            return this.fDocConfig.getDocRoot().getDocUrlType(url);
        }
        switch (url.getType()) {
            case FILE: {
                return DocCenterDocConfig.getLocalConfig().getDocRoot().getDocUrlType(url);
            }
            case WEB: {
                try {
                    return DocCenterDocConfig.getWebConfig().getDocRoot().getDocUrlType(url);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return DocUrlType.CONTENT;
    }

    private class LinkClickedHandlerHolder
    extends HelpPanelLinkClickedHandler {
        private final List<HelpPanelLinkClickedHandler> iLinkClickedHandlers = new LinkedList<HelpPanelLinkClickedHandler>();
        private final HelpPanelLinkClickedHandler iDefaultLinkClickedHandler;

        private LinkClickedHandlerHolder() {
            this.iDefaultLinkClickedHandler = HelpPanel.this.fDocConfig.getUrlType() == Url.UrlType.FILE ? new DefaultInstalledLinkClickedHandler() : null;
        }

        private void addLinkClickedHandler(HelpPanelLinkClickedHandler helpPanelLinkClickedHandler) {
            this.iLinkClickedHandlers.add(helpPanelLinkClickedHandler);
        }

        @Override
        public void linkClicked(Url url) {
            if (!this.iLinkClickedHandlers.isEmpty()) {
                HelpPanelLinkClickedHandler helpPanelLinkClickedHandler = this.iLinkClickedHandlers.get(0);
                helpPanelLinkClickedHandler.linkClicked(url);
            } else if (this.iDefaultLinkClickedHandler != null) {
                this.iDefaultLinkClickedHandler.linkClicked(url);
            }
        }

        protected boolean handleLinkClickRequest(BrowserRequest browserRequest) {
            for (HelpPanelLinkClickedHandler helpPanelLinkClickedHandler : this.iLinkClickedHandlers) {
                if (!helpPanelLinkClickedHandler.handleRequest(browserRequest)) continue;
                return true;
            }
            return this.iDefaultLinkClickedHandler != null && this.iDefaultLinkClickedHandler.handleRequest(browserRequest);
        }
    }

    private class DefaultInstalledLinkClickedHandler
    extends HelpPanelLinkClickedHandler {
        private DefaultInstalledLinkClickedHandler() {
        }

        @Override
        public void linkClicked(Url url) {
            this.handleLinkClicked(url);
        }

        protected boolean handleLinkClickRequest(BrowserRequest browserRequest) {
            return this.handleLinkClicked(browserRequest.getUrl());
        }

        private boolean handleLinkClicked(Url url) {
            if (url.getType() == Url.UrlType.WEB) {
                SystemBrowserLauncher.openSystemBrowser((Url)url);
                return true;
            }
            Url url2 = HelpPanel.this.getNavigationUrl(url);
            if (!url2.equals((Object)url)) {
                HelpPanel.this.loadNavigationUrl(url2);
                return true;
            }
            return false;
        }
    }

    private class DummyRendererHolder
    implements HtmlComponentHolder {
        private final UrlHandlingHtmlComponentWrapper iComponent;

        private DummyRendererHolder(HtmlComponent htmlComponent) {
            this.iComponent = new UrlHandlingHtmlComponentWrapper(htmlComponent);
        }

        @Override
        public UrlHandlingHtmlComponentWrapper getHtmlComponentWrapper() {
            return this.iComponent;
        }

        @Override
        public void dispose() {
            this.iComponent.dispose();
        }
    }

    private class HtmlRendererHolder
    implements HtmlComponentHolder {
        private final HtmlComponentAdapter iHtmlComponentAdapter;
        private final UrlHandlingHtmlComponentWrapper iRenderer;
        private final HelpPanelLinkClickedHandler iLinkClickedHandler;

        private HtmlRendererHolder(HtmlComponentAdapter htmlComponentAdapter, DocConfig<? extends Url> docConfig, HelpPanelLinkClickedHandler helpPanelLinkClickedHandler) {
            this.iHtmlComponentAdapter = htmlComponentAdapter;
            this.iRenderer = new UrlHandlingHtmlComponentWrapper(htmlComponentAdapter);
            HTMLRenderer hTMLRenderer = htmlComponentAdapter.getHTMLRenderer();
            assert (docConfig.getUrlType() == Url.UrlType.FILE);
            this.iLinkClickedHandler = helpPanelLinkClickedHandler;
            hTMLRenderer.addRequestHandler((RequestHandler)new DocSearchRequestHandler(hTMLRenderer, docConfig));
            hTMLRenderer.addRequestHandler((RequestHandler)new IceBrowserCssHandler(hTMLRenderer));
            if (this.iLinkClickedHandler != null) {
                hTMLRenderer.setLinkClickedHandler(this.iLinkClickedHandler);
            }
        }

        @Override
        public UrlHandlingHtmlComponentWrapper getHtmlComponentWrapper() {
            return this.iRenderer;
        }

        @Override
        public void dispose() {
            this.iHtmlComponentAdapter.getHTMLRenderer().removeLinkClickedHandler(this.iLinkClickedHandler);
            this.iRenderer.dispose();
        }
    }

    private class MJHtmlPanelHolder
    implements HtmlComponentHolder {
        private final UrlHandlingHtmlComponentWrapper iPanel;
        private final Collection<PageChangedListener> iListeners = new LinkedList<PageChangedListener>();

        protected MJHtmlPanelHolder(MJHtmlPanel mJHtmlPanel, DocConfig<? extends Url> docConfig, RequestHandler requestHandler, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
            this.iPanel = new UrlHandlingHtmlComponentWrapper((HtmlComponent)mJHtmlPanel);
            switch (docConfig.getUrlType()) {
                case FILE: {
                    this.addHandlersForInstalledDoc(mJHtmlPanel, docConfig, requestHandler, openBrowserStrategies, matlabContextMenuCustomAction);
                    return;
                }
                case WEB: {
                    this.addHandlersForWebDoc(mJHtmlPanel, requestHandler, openBrowserStrategies, matlabContextMenuCustomAction);
                    return;
                }
            }
            assert (docConfig.getUrlType() != Url.UrlType.CUSTOM_PROTOCOL);
        }

        private void addHandlersForInstalledDoc(MJHtmlPanel mJHtmlPanel, DocConfig<FileUrl> docConfig, RequestHandler requestHandler, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
            this.iListeners.add((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent)mJHtmlPanel, docConfig));
            for (PageChangedListener pageChangedListener : this.iListeners) {
                mJHtmlPanel.addPageChangedListener(pageChangedListener);
            }
            mJHtmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)mJHtmlPanel, docConfig));
            mJHtmlPanel.addRequestHandler((RequestHandler)new ProductFilterRequestHandler((HtmlComponent)mJHtmlPanel, docConfig));
            if (requestHandler != null) {
                mJHtmlPanel.addRequestHandler(requestHandler);
            }
            if (openBrowserStrategies != null) {
                mJHtmlPanel.setHtmlContextMenuBuilder((HtmlContextMenuBuilder)new MatlabContextMenuBuilder((HtmlComponent)mJHtmlPanel, openBrowserStrategies, matlabContextMenuCustomAction));
            }
        }

        private void addHandlersForWebDoc(MJHtmlPanel mJHtmlPanel, RequestHandler requestHandler, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
            for (PageChangedListener pageChangedListener : this.iListeners) {
                mJHtmlPanel.addPageChangedListener(pageChangedListener);
            }
            if (requestHandler != null) {
                mJHtmlPanel.addRequestHandler(requestHandler);
            }
            if (openBrowserStrategies != null) {
                mJHtmlPanel.setHtmlContextMenuBuilder((HtmlContextMenuBuilder)new MatlabContextMenuBuilder((HtmlComponent)mJHtmlPanel, openBrowserStrategies, matlabContextMenuCustomAction));
            }
        }

        @Override
        public UrlHandlingHtmlComponentWrapper getHtmlComponentWrapper() {
            return this.iPanel;
        }

        @Override
        public void dispose() {
            for (PageChangedListener pageChangedListener : this.iListeners) {
                this.iPanel.removePageChangedListener(pageChangedListener);
            }
            this.iPanel.dispose();
        }
    }

    private static interface HtmlComponentHolder {
        public UrlHandlingHtmlComponentWrapper getHtmlComponentWrapper();

        public void dispose();
    }

    private class PageChangedListenerWrapper
    implements PageChangedListener {
        private final PageChangedListener fWrappedListener;

        protected PageChangedListenerWrapper(PageChangedListener pageChangedListener) {
            this.fWrappedListener = pageChangedListener;
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            if (pageChangedEvent != null) {
                Url url = HelpPanel.this.getUserVisibleUrl(pageChangedEvent.getNewUrl());
                this.fWrappedListener.pageChanged(new PageChangedEvent(pageChangedEvent.getTitle(), url, pageChangedEvent.getOldUrl()));
            }
        }
    }

    private class UrlHandlingHtmlComponentWrapper
    extends HtmlComponentWrapper<HtmlComponent> {
        private Map<PageChangedListener, PageChangedListenerWrapper> iWrappedListeners;

        private UrlHandlingHtmlComponentWrapper(HtmlComponent htmlComponent) {
            super(htmlComponent);
            this.iWrappedListeners = new HashMap<PageChangedListener, PageChangedListenerWrapper>();
        }

        public void setCurrentLocation(Url url) {
            Url url2 = HelpPanel.this.getNavigationUrl(url);
            Url url3 = Url.parseSilently((String)HelpPanel.this.fHtmlComponentHolder.getHtmlComponentWrapper().getWrappedComponent().getCurrentLocation());
            if (HelpPanel.this.fSuppressLoadForCurrentLocation && url2.equals((Object)url3)) {
                return;
            }
            this.loadNavigationUrl(url2);
        }

        private void loadNavigationUrl(Url url) {
            super.setCurrentLocation(url);
        }

        public String getCurrentLocation() {
            return HelpPanel.this.getUserVisibleUrl(super.getCurrentLocation());
        }

        public void addPageChangedListener(PageChangedListener pageChangedListener) {
            PageChangedListenerWrapper pageChangedListenerWrapper = new PageChangedListenerWrapper(pageChangedListener);
            this.iWrappedListeners.put(pageChangedListener, pageChangedListenerWrapper);
            super.addPageChangedListener((PageChangedListener)pageChangedListenerWrapper);
        }

        public void removePageChangedListener(PageChangedListener pageChangedListener) {
            PageChangedListenerWrapper pageChangedListenerWrapper = this.iWrappedListeners.get(pageChangedListener);
            if (pageChangedListenerWrapper != null) {
                super.removePageChangedListener((PageChangedListener)pageChangedListenerWrapper);
            }
        }
    }

    private class HelpPanelVisitor
    implements HtmlConversionUtils.BrowserVisitor {
        private HtmlComponentHolder iComponent;
        private final DocConfig<? extends Url> iDocConfig;
        private final HelpPanelLinkClickedHandler iLinkClickedHandler;
        private final OpenBrowserStrategies fIOpenBrowserStrategies;
        private final MatlabContextMenuCustomAction iCustomEmptyAreaAction;

        private HelpPanelVisitor(DocConfig<? extends Url> docConfig, HelpPanelLinkClickedHandler helpPanelLinkClickedHandler, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
            this.iDocConfig = docConfig;
            this.iLinkClickedHandler = helpPanelLinkClickedHandler;
            this.fIOpenBrowserStrategies = openBrowserStrategies;
            this.iCustomEmptyAreaAction = matlabContextMenuCustomAction;
        }

        @Override
        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            this.iComponent = new MJHtmlPanelHolder(mJHtmlPanel, this.iDocConfig, (RequestHandler)this.iLinkClickedHandler, this.fIOpenBrowserStrategies, this.iCustomEmptyAreaAction);
        }

        @Override
        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            this.iComponent = new HtmlRendererHolder(new HtmlComponentAdapter(hTMLRenderer), this.iDocConfig, this.iLinkClickedHandler);
        }

        private HtmlComponentHolder getHtmlComponent() {
            return this.iComponent;
        }
    }
}

