/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.TestProduct;
import com.mathworks.mlwidgets.help.DocCenterProductPrefs;
import com.mathworks.mlwidgets.help.InstalledProductUtils;
import com.mathworks.product.util.ProductIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProductFilterModel {
    private final Set<ProductIdentifier> fSelectedProducts;
    private final boolean fShowTestProducts;
    private final InstalledState fInstalledState;

    public ProductFilterModel(Set<ProductIdentifier> set, boolean bl) {
        this(set, bl ? InstalledState.ALL : InstalledState.INSTALLED);
    }

    private ProductFilterModel(Set<ProductIdentifier> set, InstalledState installedState) {
        this.fSelectedProducts = EnumSet.copyOf(set);
        this.fShowTestProducts = DocCenterProductPrefs.getShowTestProducts();
        this.fInstalledState = installedState;
    }

    Set<ProductIdentifier> getSelectedProducts() {
        return this.getSelectedProducts(this.fInstalledState);
    }

    Set<ProductIdentifier> getSelectedProducts(InstalledState installedState) {
        return ProductFilterModel.getProducts(this.fSelectedProducts, installedState);
    }

    Set<String> getSelectedBaseCodes() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Set<ProductIdentifier> set = this.getSelectedProducts();
        for (ProductIdentifier productIdentifier : set) {
            linkedHashSet.add(productIdentifier.getBaseCode());
        }
        if (this.fShowTestProducts) {
            for (TestProduct testProduct : TestProduct.values()) {
                linkedHashSet.add(testProduct.getBaseCode());
            }
        }
        return linkedHashSet;
    }

    boolean areAllProductsSelected(InstalledState installedState) {
        Set<ProductIdentifier> set = this.getSelectedProducts(installedState);
        Set<ProductIdentifier> set2 = installedState.getProducts();
        return set.equals(set2);
    }

    private static Set<ProductIdentifier> getProducts(Collection<ProductIdentifier> collection, InstalledState installedState) {
        EnumSet<ProductIdentifier> enumSet = EnumSet.copyOf(installedState.getProducts());
        enumSet.retainAll(collection);
        return enumSet;
    }

    InstalledState getInstalledState() {
        return this.fInstalledState;
    }

    public int hashCode() {
        return 29 + 13 * this.fSelectedProducts.hashCode() + 13 * this.fInstalledState.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ProductFilterModel) {
            ProductFilterModel productFilterModel = (ProductFilterModel)object;
            return this.fInstalledState == productFilterModel.getInstalledState() && this.fSelectedProducts.equals(productFilterModel.getSelectedProducts(InstalledState.ALL)) && this.fShowTestProducts == productFilterModel.fShowTestProducts;
        }
        return false;
    }

    public static enum InstalledState {
        INSTALLED(InstalledProductUtils.getInstalledProducts()),
        UNINSTALLED(InstalledProductUtils.getUninstalledProducts()),
        ALL(EnumSet.allOf(ProductIdentifier.class));

        private final Set<ProductIdentifier> iProducts;

        private InstalledState(Collection<ProductIdentifier> collection) {
            this.iProducts = EnumSet.copyOf(collection);
        }

        public Set<ProductIdentifier> getProducts() {
            return Collections.unmodifiableSet(this.iProducts);
        }
    }
}

