/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.ContextMenuTargetData;
import com.mathworks.html.DefaultContextMenuBuilder;
import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.html.MatlabContextMenuCustomAction;
import com.mathworks.mlwidgets.html.OpenBrowserStrategies;
import com.mathworks.mlwidgets.html.OpenBrowserStrategy;
import com.mathworks.mlwidgets.html.OpenBrowserStrategyId;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MatlabContextMenuBuilder
extends DefaultContextMenuBuilder {
    public static final String TAB_ACTIONS = "TabActions";
    public static final String OPEN_CURRENT_TAB_ID = "open-current-tab";
    public static final String OPEN_NEW_TAB_ID = "open-new-tab";
    public static final String OPEN_SYSTEM_BROWSER_ID = "open-system-browser";
    public static final String CUSTOM_EMPTY_AREA_ACTION_ID = "CustomEmptyArea";
    private final MatlabActionLabels fMatlabActionLabels;
    private final HtmlComponent fHtmlPanel;
    private final OpenBrowserStrategies fOpenBrowserStrategies;
    private MatlabContextMenuCustomAction fCustomEmptyAreaAction;

    public MatlabContextMenuBuilder(HtmlComponent htmlComponent, OpenBrowserStrategies openBrowserStrategies) {
        this(htmlComponent, openBrowserStrategies, null);
    }

    public MatlabContextMenuBuilder(HtmlComponent htmlComponent, OpenBrowserStrategies openBrowserStrategies, MatlabContextMenuCustomAction matlabContextMenuCustomAction) {
        this.fHtmlPanel = htmlComponent;
        this.fOpenBrowserStrategies = openBrowserStrategies;
        this.fCustomEmptyAreaAction = matlabContextMenuCustomAction;
        this.fMatlabActionLabels = new MatlabActionLabels();
    }

    public HtmlActionGroups getActionGroups(HtmlActions htmlActions, ContextMenuTargetData contextMenuTargetData) {
        HtmlActionGroups htmlActionGroups;
        String string = contextMenuTargetData.getSelectedText();
        Url url = contextMenuTargetData.getLinkClickUrl();
        HtmlActionGroups htmlActionGroups2 = new HtmlActionGroups();
        if (url != null) {
            htmlActionGroups = this.createLinkClickedActions(url);
            htmlActionGroups2.addAllCustomActionGroups(htmlActionGroups);
        }
        if (string != null && !string.isEmpty()) {
            htmlActionGroups = MatlabContextMenuBuilder.createSelectedTextActions(htmlActions);
            htmlActionGroups2.addAllCustomActionGroups(htmlActionGroups);
        }
        if (htmlActionGroups2.getAllGroups().isEmpty()) {
            htmlActionGroups = this.createEmptyAreaActionGroups(htmlActions);
            htmlActionGroups2.addAllCustomActionGroups(htmlActionGroups);
        }
        return htmlActionGroups2;
    }

    private static HtmlActionGroups createSelectedTextActions(HtmlActions htmlActions) {
        HtmlActionGroup htmlActionGroup;
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        HtmlActionGroups htmlActionGroups2 = htmlActions.getCustomActionGroups();
        if (htmlActionGroups2 != null) {
            htmlActionGroup = htmlActionGroups2.getCustomActionGroup("MatlabActions");
            htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        }
        htmlActionGroup = MatlabContextMenuBuilder.createCopyActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        return htmlActionGroups;
    }

    private HtmlActionGroups createLinkClickedActions(Url url) {
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        HtmlActionGroup htmlActionGroup = this.createTabActionGroup(url);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        return htmlActionGroups;
    }

    private HtmlActionGroups createEmptyAreaActionGroups(HtmlActions htmlActions) {
        HtmlActionGroup htmlActionGroup;
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        HtmlActionGroup htmlActionGroup2 = this.createNavActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup2);
        HtmlActionGroup htmlActionGroup3 = this.createFindActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup3);
        HtmlActionGroups htmlActionGroups2 = htmlActions.getCustomActionGroups();
        if (htmlActionGroups2 != null) {
            htmlActionGroup = htmlActionGroups2.getCustomActionGroup("ZoomActions");
            htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        }
        htmlActionGroup = MatlabContextMenuBuilder.createFileActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        HtmlActionGroup htmlActionGroup4 = this.createPageActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup4);
        return htmlActionGroups;
    }

    protected HtmlActionGroup createNavActionGroup(HtmlActions htmlActions) {
        Map map = MatlabContextMenuBuilder.createActionGroup((HtmlActions)htmlActions, (StandardHtmlActionId[])new StandardHtmlActionId[]{StandardHtmlActionId.GO_BACK, StandardHtmlActionId.GO_FORWARD});
        return map == null ? null : new HtmlActionGroup("NavActions", map);
    }

    private static HtmlActionGroup createFileActionGroup(HtmlActions htmlActions) {
        Map map = MatlabContextMenuBuilder.createActionGroup((HtmlActions)htmlActions, (StandardHtmlActionId[])new StandardHtmlActionId[]{StandardHtmlActionId.PRINT, StandardHtmlActionId.SAVE_AS});
        return map == null ? null : new HtmlActionGroup("FileActions", map);
    }

    protected HtmlActionGroup createPageActionGroup(HtmlActions htmlActions) {
        LinkedHashMap<String, 1> linkedHashMap;
        Map map = MatlabContextMenuBuilder.createActionGroup((HtmlActions)htmlActions, (StandardHtmlActionId[])new StandardHtmlActionId[]{StandardHtmlActionId.VIEW_SOURCE});
        LinkedHashMap<String, 1> linkedHashMap2 = linkedHashMap = map == null ? new LinkedHashMap<String, 1>() : new LinkedHashMap(map);
        if (this.fCustomEmptyAreaAction != null) {
            final String string = this.fHtmlPanel.getCurrentLocation();
            MJAbstractAction mJAbstractAction = new MJAbstractAction(this.fCustomEmptyAreaAction.getLabel()){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatlabContextMenuBuilder.this.fCustomEmptyAreaAction.doAction(string);
                }
            };
            boolean bl = this.fCustomEmptyAreaAction.enableAction(string);
            mJAbstractAction.setEnabled(bl);
            linkedHashMap.put(CUSTOM_EMPTY_AREA_ACTION_ID, mJAbstractAction);
        }
        return linkedHashMap.isEmpty() ? null : new HtmlActionGroup("PageActions", linkedHashMap);
    }

    protected static HtmlActionGroup createCopyActionGroup(HtmlActions htmlActions) {
        Map map = MatlabContextMenuBuilder.createActionGroup((HtmlActions)htmlActions, (StandardHtmlActionId[])new StandardHtmlActionId[]{StandardHtmlActionId.COPY});
        return map == null ? null : new HtmlActionGroup("CopyActions", map);
    }

    private HtmlActionGroup createTabActionGroup(Url url) {
        OpenBrowserStrategy openBrowserStrategy;
        OpenBrowserStrategy openBrowserStrategy2;
        LinkedHashMap<String, LinkClickedAction> linkedHashMap = new LinkedHashMap<String, LinkClickedAction>();
        OpenBrowserStrategy openBrowserStrategy3 = this.fOpenBrowserStrategies.getOpenBrowserStrategy(OpenBrowserStrategyId.CURRENT_BROWSER);
        if (openBrowserStrategy3 != null) {
            linkedHashMap.put(OPEN_CURRENT_TAB_ID, new LinkClickedAction(OPEN_CURRENT_TAB_ID, url, openBrowserStrategy3));
        }
        if ((openBrowserStrategy2 = this.fOpenBrowserStrategies.getOpenBrowserStrategy(OpenBrowserStrategyId.NEW_TAB)) != null) {
            linkedHashMap.put(OPEN_NEW_TAB_ID, new LinkClickedAction(OPEN_NEW_TAB_ID, url, openBrowserStrategy2));
        }
        if ((openBrowserStrategy = this.fOpenBrowserStrategies.getOpenBrowserStrategy(OpenBrowserStrategyId.SYSTEM_BROWSER)) != null) {
            linkedHashMap.put(OPEN_SYSTEM_BROWSER_ID, new LinkClickedAction(OPEN_SYSTEM_BROWSER_ID, url, openBrowserStrategy));
        }
        return new HtmlActionGroup(TAB_ACTIONS, linkedHashMap);
    }

    private class LinkClickedAction
    extends MJAbstractAction {
        private final Url iUrl;
        private final OpenBrowserStrategy iOpenBrowserStrategy;

        private LinkClickedAction(String string, Url url, OpenBrowserStrategy openBrowserStrategy) {
            super(MatlabContextMenuBuilder.this.fMatlabActionLabels.getActionLabel(string));
            this.iUrl = url;
            this.iOpenBrowserStrategy = openBrowserStrategy;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iOpenBrowserStrategy.openUrl(this.iUrl);
        }
    }

    private static class MatlabActionLabels {
        private final ResourceBundle LABEL_BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.html.resources.RES_HTMLRenderer");

        private MatlabActionLabels() {
        }

        public String getActionLabel(String string) {
            return this.LABEL_BUNDLE.getString("Action." + string);
        }
    }
}

