/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.ProxyAuthenticationFailureHandler;
import com.mathworks.html.ProxyCredentials;
import com.mathworks.html.ProxySettings;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class ProxyCredentialsDialog
implements ProxyAuthenticationFailureHandler {
    ProxyCredentialsDialog() {
    }

    public void onFailure(Component component, ProxySettings proxySettings, HtmlDataListener<ProxyCredentials> htmlDataListener) {
        ProxyCredentialsRunnable proxyCredentialsRunnable = new ProxyCredentialsRunnable(component, proxySettings, htmlDataListener);
        SwingUtilities.invokeLater(proxyCredentialsRunnable);
    }

    private static class InitialFocusListener
    implements AncestorListener {
        private InitialFocusListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            ancestorEvent.getComponent().requestFocus();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private static class CredentialsPanel
    extends MJPanel {
        private final MJTextField iUsernameField = new MJTextField();
        private final JPasswordField iPasswordField;

        private CredentialsPanel(String string, int n) {
            this.iUsernameField.addAncestorListener((AncestorListener)new InitialFocusListener());
            this.iPasswordField = new JPasswordField();
            this.setLayout((LayoutManager)new FormLayout("p,3dlu,p:grow", "p,3dlu,p,7dlu,p,3dlu,p"));
            CellConstraints cellConstraints = new CellConstraints();
            MessageFormat messageFormat = new MessageFormat(HTMLUtils.sRes.getString("proxy.auth.text1"));
            String string2 = messageFormat.format(new Object[]{string + ":" + n});
            this.add(new JLabel(string2), cellConstraints.xyw(1, 1, 3));
            this.add(new JLabel(HTMLUtils.sRes.getString("proxy.auth.text2")), cellConstraints.xyw(1, 3, 3));
            this.add(new JLabel(HTMLUtils.sRes.getString("proxy.username.label")), cellConstraints.xy(1, 5));
            this.add((Component)this.iUsernameField, cellConstraints.xy(3, 5));
            this.add(new JLabel(HTMLUtils.sRes.getString("proxy.password.label")), cellConstraints.xy(1, 7));
            this.add(this.iPasswordField, cellConstraints.xy(3, 7));
        }

        private ProxyCredentials getCredentials() {
            return new ProxyCredentials(this.iUsernameField.getText(), new String(this.iPasswordField.getPassword()));
        }
    }

    private static class ProxyCredentialsRunnable
    implements Runnable {
        private final Component iBrowserComp;
        private final ProxySettings iSettings;
        private final HtmlDataListener<ProxyCredentials> iListener;

        private ProxyCredentialsRunnable(Component component, ProxySettings proxySettings, HtmlDataListener<ProxyCredentials> htmlDataListener) {
            this.iBrowserComp = component;
            this.iSettings = proxySettings;
            this.iListener = htmlDataListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.iBrowserComp.setFocusable(false);
            try {
                CredentialsPanel credentialsPanel = new CredentialsPanel(this.iSettings.getHost(), this.iSettings.getPort());
                String string = HTMLUtils.sRes.getString("proxy.auth.title");
                int n = MJOptionPane.showConfirmDialog((Component)this.iBrowserComp, (Object)((Object)credentialsPanel), (String)string, (int)2, (int)-1);
                if (n == 0) {
                    ProxyCredentials proxyCredentials = credentialsPanel.getCredentials();
                    ProxyCredentialsRunnable.updateProxyPrefs(proxyCredentials);
                    this.iListener.dataRetrieved((Object)proxyCredentials);
                } else {
                    this.iListener.dataRetrieved(null);
                }
            }
            finally {
                this.iBrowserComp.setFocusable(true);
            }
        }

        private static void updateProxyPrefs(ProxyCredentials proxyCredentials) {
            if (proxyCredentials == null) {
                HTMLPrefs.setUseProxyAuthentication(false);
            } else {
                HTMLPrefs.setUseProxyAuthentication(true);
                HTMLPrefs.setProxyUsername(proxyCredentials.getUsername());
                HTMLPrefs.setProxyPassword(proxyCredentials.getPassword());
            }
            HTMLPrefs.setProxySettings();
        }
    }
}

