/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.BlankColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.BlankReplacementRule;
import com.mathworks.mlwidgets.importtool.BlankRowExcludeRule;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ImportToolstripTab;
import com.mathworks.mlwidgets.importtool.NonNumericColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.NonNumericRowExcludeRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.SpreadsheetTabbedPane;
import com.mathworks.mlwidgets.importtool.StringReplacementRule;
import com.mathworks.mlwidgets.importtool.TextFilePane;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ImportClient
extends DTClientBase {
    protected ImportToolstripTab fImportToolstripTab;
    protected File fFileLocation;
    protected String fFileHash = "";
    protected JComponent fImportComponent;
    private boolean fShowCodeGeneration = false;
    private Object fDstWorkspace = null;
    protected static String DEFAULT_DESTINATION_WORKSPACE = "caller";
    private TargetType[] fTargetTypes = null;
    private SpinnerMouseListener fSpinnerMouseListener = new SpinnerMouseListener();
    private long MAXFILECOMPARESIZE = 10000000L;

    public static TargetType[] getSupportedTargetTypes() {
        return new TargetType[]{TargetType.COLUMNVECTORS, TargetType.MATRIX, TargetType.CELLARRAY, TargetType.DATASET, TargetType.TABLE, TargetType.TIMESERIES};
    }

    public static TargetType[] getTargetTypesForTesting() {
        return new TargetType[]{TargetType.COLUMNVECTORS, TargetType.MATRIX, TargetType.CELLARRAY, TargetType.DATASET, TargetType.TABLE};
    }

    public static TargetType[] getDefaultTargetTypes() {
        return new TargetType[]{TargetType.COLUMNVECTORS, TargetType.MATRIX, TargetType.CELLARRAY, TargetType.TABLE};
    }

    protected void setTargetTypes(TargetType[] targetTypeArray) {
        this.fTargetTypes = targetTypeArray;
    }

    protected TargetType[] getTargetTypes() {
        return this.fTargetTypes;
    }

    protected void setShowCodeGeneration(boolean bl) {
        this.fShowCodeGeneration = bl;
    }

    protected boolean getShowCodeGeneration() {
        return this.fShowCodeGeneration;
    }

    protected void setDestinationWorkspace(Object object) {
        this.fDstWorkspace = object;
    }

    protected Object getDestinationWorkspace() {
        return this.fDstWorkspace;
    }

    static List<WorksheetRule> getRulePrototypes() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericColumnExcludeRule());
        arrayList.add(new NonNumericReplacementRule());
        arrayList.add(new NonNumericRowExcludeRule());
        arrayList.add(new BlankRowExcludeRule());
        arrayList.add(new BlankColumnExcludeRule());
        arrayList.add(new BlankReplacementRule());
        arrayList.add(new StringReplacementRule());
        return arrayList;
    }

    void setFile(File file) {
        this.fFileLocation = file;
    }

    File getFile() {
        return this.fFileLocation;
    }

    protected synchronized String getFileHash() {
        return this.fFileHash;
    }

    protected synchronized void setFileHash() {
        try {
            if (this.getFile() != null) {
                this.fFileHash = FileUtils.generateFileHash((File)this.getFile());
            }
        }
        catch (IOException iOException) {
            this.fFileHash = "";
        }
    }

    protected abstract void cleanup(boolean var1);

    protected void cleanupToolstrip() {
        if (this.fImportToolstripTab != null) {
            this.fImportToolstripTab.cleanup();
            TSFactory.disposeTab((ToolstripTab)this.fImportToolstripTab);
            this.fImportToolstripTab = null;
        }
    }

    protected ImportClient(File file) {
        this.createClient(file, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
    }

    protected ImportClient(File file, String string) {
        this.createClient(file, string);
    }

    protected abstract void unregisterFind();

    protected abstract void registerFind();

    private void createClient(File file, String string) {
        Desktop desktop;
        this.setLayout(new BorderLayout());
        this.fFileLocation = file;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (Thread.interrupted()) {
                        return;
                    }
                    ImportClient.this.setFileHash();
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        Thread thread = new Thread(runnable, "Text Import Client");
        thread.setDaemon(true);
        thread.start();
        this.setName("ImportClient");
        this.setMultipleInstances(true);
        this.setPermitUserUndock(false);
        this.setGroup((DTGroupPropertyProvider)SpreadsheetImportToolGroup.getInstance(string));
        this.setDontReopen(true);
        if (Matlab.isMatlabAvailable() && (desktop = MatlabDesktopServices.getDesktop()) != null) {
            desktop.addClientListener((Component)((Object)this), this.createDTClientListeners(desktop, string));
        }
    }

    private DTClientListener createDTClientListeners(final Desktop desktop, final String string) {
        return new DTClientAdapter(){

            public void clientClosed(DTClientEvent dTClientEvent) {
                ImportClient.this.unregisterFind();
                desktop.removeClientListener((DTClientListener)this);
                ImportClient.this.cleanup(true);
            }

            public void clientActivated(DTClientEvent dTClientEvent) {
                if (ImportClient.this.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                    ImportClient.this.reOpen(ImportClient.this.getFile().getPath(), string);
                }
                if (ImportClient.this.fImportComponent != null) {
                    ImportClient.this.registerFind();
                }
            }

            public void clientOpened(DTClientEvent dTClientEvent) {
                if (ImportClient.this.fImportComponent != null) {
                    ImportClient.this.registerFind();
                }
            }
        };
    }

    protected abstract void reOpen(String var1, String var2);

    protected boolean isLastLoadedFileContentDifferentThanOnDiskFileContent() {
        if (this.getFileHash() == null || this.getFileHash().isEmpty() || this.getFile().length() > this.MAXFILECOMPARESIZE) {
            return false;
        }
        try {
            String string = FileUtils.generateFileHash((File)this.getFile());
            return !string.equals(this.getFileHash());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void addClient(Desktop desktop, String string) {
        this.addClient(desktop, string, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
    }

    protected void addClient(Desktop desktop, String string, String string2) {
        if (!desktop.hasGroup(string2)) {
            desktop.addGroup((DTGroupPropertyProvider)SpreadsheetImportToolGroup.getInstance(string2));
        }
        if (!desktop.hasClient(string, string2)) {
            desktop.addClient((Component)((Object)this), string, true, null, true);
        }
        desktop.setClientDocked((Component)((Object)this), true);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        if (desktop.useToolstrip() && this.fImportToolstripTab != null) {
            this.fImportToolstripTab.getComponent().setCursor(cursor);
        }
    }

    ImportToolstripTab getImportToolstripTab() {
        return this.fImportToolstripTab;
    }

    public JComponent getImportComponent() {
        return this.fImportComponent;
    }

    private void setVariableNamesHighlightRow(int n) {
        if (this.fImportComponent instanceof TextFilePane) {
            ((TextFilePane)this.fImportComponent).setVariableNamesHighlightRow(n);
        } else if (this.fImportComponent instanceof SpreadsheetTabbedPane) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).setVariableNamesHighlightRow(n);
        }
    }

    protected void addHeaderRowListener(JSpinner jSpinner, HeaderRowListenerInterface headerRowListenerInterface) {
        jSpinner.addChangeListener(new SpinnerChangeListener(headerRowListenerInterface));
        Component[] componentArray = jSpinner.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(this.fSpinnerMouseListener);
        }
        ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().addMouseListener(this.fSpinnerMouseListener);
    }

    protected void setHeaderRowSpinnerDefaultValue(JSpinner jSpinner, int n, int n2) {
        List<ChangeListener> list = Arrays.asList(jSpinner.getChangeListeners());
        for (ChangeListener object : list) {
            if (!(object instanceof SpinnerChangeListener)) continue;
            jSpinner.removeChangeListener(object);
        }
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
        spinnerNumberModel.setMaximum(Integer.valueOf(n2));
        jSpinner.setValue(n <= 0 ? 1 : n + 1);
        for (ChangeListener changeListener : list) {
            if (!(changeListener instanceof SpinnerChangeListener)) continue;
            jSpinner.addChangeListener(changeListener);
        }
    }

    static class Target {
        TargetType iTargetType;
        private List<WorksheetRule> iWorksheetRules = new ArrayList<WorksheetRule>();

        Target(TargetType targetType) {
            this.iTargetType = targetType;
        }

        TargetType getTargetType() {
            return this.iTargetType;
        }

        public String toString() {
            if (this.iTargetType != null) {
                return this.iTargetType.toString();
            }
            return null;
        }

        public Icon getIcon() {
            if (this.iTargetType != null) {
                return this.iTargetType.getIcon();
            }
            return null;
        }

        List<WorksheetRule> getWorksheetRules() {
            return this.iWorksheetRules;
        }

        void setWorksheetRules(List<WorksheetRule> list) {
            this.iWorksheetRules = list;
        }

        void addWorksheetRule(WorksheetRule worksheetRule) {
            this.iWorksheetRules.add(worksheetRule);
        }
    }

    private class SpinnerMouseListener
    extends MouseAdapter {
        private boolean fMouseInComponent = false;

        private SpinnerMouseListener() {
        }

        public boolean isMouseInComponent() {
            return this.fMouseInComponent;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MJSpinner mJSpinner = ImportClient.this.fImportToolstripTab.getHeaderSpinner();
            if (mJSpinner.isEnabled()) {
                int n = (Integer)mJSpinner.getValue();
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
                this.fMouseInComponent = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MJSpinner mJSpinner = ImportClient.this.fImportToolstripTab.getHeaderSpinner();
            if (mJSpinner.isEnabled()) {
                int n = (Integer)mJSpinner.getValue();
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
                this.fMouseInComponent = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ImportClient.this.setVariableNamesHighlightRow(-1);
            this.fMouseInComponent = false;
        }
    }

    private class SpinnerChangeListener
    implements ChangeListener {
        private HeaderRowListenerInterface iHeaderRowListener = null;

        SpinnerChangeListener(HeaderRowListenerInterface headerRowListenerInterface) {
            this.iHeaderRowListener = headerRowListenerInterface;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            int n = (Integer)jSpinner.getValue();
            this.iHeaderRowListener.setHeaderRow(n - 1);
            if (((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().hasFocus() && ImportClient.this.fSpinnerMouseListener.isMouseInComponent()) {
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
            }
        }
    }

    static class ImportToolMenuBar
    extends MJMenuBar {
        ImportToolMenuBar(WorksheetTable worksheetTable) {
            Action action;
            MJMenu mJMenu = new MJMenu();
            this.add((JMenu)mJMenu);
            DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu);
            Action action2 = worksheetTable.getSelectAllAction();
            if (action2 != null) {
                action = new MJMenuItem(action2);
                mJMenu.add((JMenuItem)((Object)action));
                DTMenuMergeTag.SELECT_ALL.setTag((JMenuItem)((Object)action));
            }
            if ((action = worksheetTable.getCopyAction()) != null) {
                MJMenuItem mJMenuItem = new MJMenuItem(action);
                mJMenu.add((JMenuItem)mJMenuItem);
                DTMenuMergeTag.COPY.setTag((JMenuItem)mJMenuItem);
            }
        }
    }

    static class TargetRenderer
    extends DefaultListCellRenderer {
        TargetRenderer() {
            this.setHorizontalTextPosition(11);
            this.setIconTextGap(4);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setText(object.toString());
            if (object instanceof Target) {
                jLabel.setIcon(((Target)object).getIcon());
            }
            return jLabel;
        }
    }

    public static enum TargetType {
        MATRIX("targettype.numeric", ImportToolUtils.getResourceIcon("matrix.png"), "internal.matlab.importtool.AbstractSpreadsheet.matrixAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.ALLOW_SHADOW),
        COLUMNVECTORS("targettype.vectors", ImportToolUtils.getResourceIcon("columnvectors.png"), "internal.matlab.importtool.AbstractSpreadsheet.columnVectorAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.AVOID_ALL_SHADOWS),
        CELLARRAY("targettype.cell", ImportToolUtils.getResourceIcon("cellarray.png"), "internal.matlab.importtool.AbstractSpreadsheet.cellArrayAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.ALLOW_SHADOW),
        TABLE("targettype.table", ImportToolUtils.getResourceIcon("variable_dataset.png"), "internal.matlab.importtool.AbstractSpreadsheet.tableAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.AVOID_SOME_SHADOWS),
        DATASET("targettype.dataset", ImportToolUtils.getResourceIcon("variable_dataset.png"), "internal.matlab.importtool.AbstractSpreadsheet.datasetAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.AVOID_SOME_SHADOWS),
        TIMESERIES("targettype.timeseries", ImportToolUtils.getResourceIcon("timeseries.png"), "internal.matlab.importtool.AbstractSpreadsheet.timeseriesAllocationFcn", AbstractFileTableModel.AvoidShadowLevel.ALLOW_SHADOW);

        private String iIdentifier = "";
        private String iDisplayString = "";
        private String iAllocationFcn = "";
        private Icon iIcon;
        private AbstractFileTableModel.AvoidShadowLevel iAvoidShadowLevel = AbstractFileTableModel.AvoidShadowLevel.ALLOW_SHADOW;

        private TargetType(String string2, Icon icon, String string3, AbstractFileTableModel.AvoidShadowLevel avoidShadowLevel) {
            this.iIdentifier = string2;
            this.iDisplayString = ImportToolUtils.getResourceString(this.iIdentifier);
            this.iIcon = icon;
            this.iAllocationFcn = string3;
            this.iAvoidShadowLevel = avoidShadowLevel;
        }

        public String toString() {
            return this.iDisplayString;
        }

        public Icon getIcon() {
            return this.iIcon;
        }

        public String getResourceID() {
            return this.iIdentifier;
        }

        public String getAllocationFcn() {
            return this.iAllocationFcn;
        }

        public AbstractFileTableModel.AvoidShadowLevel getAvoidShadowLevel() {
            return this.iAvoidShadowLevel;
        }

        public boolean isCellArray() {
            return this == CELLARRAY;
        }

        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isColumnVectors() {
            return this == COLUMNVECTORS;
        }

        public boolean isDataSet() {
            return this == DATASET;
        }

        public boolean isTable() {
            return this == TABLE;
        }

        public boolean isTimeseries() {
            return this == TIMESERIES;
        }

        public boolean usesColumnNames() {
            return this == COLUMNVECTORS || this == DATASET || this == TIMESERIES || this == TABLE;
        }

        public boolean usesColumnTypes() {
            return this == COLUMNVECTORS || this == DATASET || this == TIMESERIES || this == TABLE;
        }

        public boolean usesGroupName() {
            return this != COLUMNVECTORS;
        }
    }
}

