/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.jidesoft.swing.JideTabbedPane;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.FloatingComponentLayout;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportDataSource;
import com.mathworks.mlwidgets.importtool.ImportScrollPane;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.Importer;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.VariableNamePanel;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.importtool.WorksheetTableModel;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientBase;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpreadsheetTabbedPane
extends JideTabbedPane
implements WorksheetRuleListener,
ListSelectionListener,
WorksheetSelectionListener,
Importer,
AbstractFileTableModel.WorksheetCachedDataListener,
HeaderRowListenerInterface {
    private List<WorksheetSelectionListener> fRangeSelectionListeners = new ArrayList<WorksheetSelectionListener>();
    private List<WorksheetRule> fRules;
    private ImportClient.TargetType fTargetType;
    private ChangeListener fWorksheetChangeListener;
    private Object fSpreadsheet;
    private String fWorkbookName;
    private Vector<ChangeListener> fSpreadsheetTabSelectionListeners = new Vector();

    void addSpreadsheetTabSelectionListener(ChangeListener changeListener) {
        this.fSpreadsheetTabSelectionListeners.remove(changeListener);
        this.fSpreadsheetTabSelectionListeners.add(changeListener);
    }

    void removeSpreadsheetTabSelectionListener(ChangeListener changeListener) {
        this.fSpreadsheetTabSelectionListeners.remove(changeListener);
    }

    void addWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
        this.fRangeSelectionListeners.add(worksheetSelectionListener);
    }

    void removeWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
    }

    @Override
    public void importData(ImportDataSource importDataSource) {
        this.getCurrentTabContentPanel().getWorksheetTable().importData(importDataSource);
    }

    @Override
    public void generateMatlabFunction(String string) {
        this.getCurrentTabContentPanel().getWorksheetTable().generateMatlabFunction(string);
    }

    @Override
    public void generateMatlabScript() {
        this.getCurrentTabContentPanel().getWorksheetTable().generateMatlabScript();
    }

    public ImportClient.TargetType getTargetType() {
        return this.fTargetType;
    }

    void rebuild(String[] stringArray) {
        Object object;
        boolean bl = true;
        if (this.getTabCount() != stringArray.length) {
            bl = false;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                object = this.getComponentAt(i);
                if (!(object instanceof TabContentPanel) || stringArray[i].equals(((TabContentPanel)object).getSheetName())) continue;
                bl = false;
                break;
            }
        }
        TabContentPanel tabContentPanel = this.getCurrentTabContentPanel();
        object = null;
        if (Arrays.asList(stringArray).contains(tabContentPanel.getSheetName())) {
            tabContentPanel.rebuild();
            tabContentPanel.setTargetType(this.fTargetType);
            object = tabContentPanel.getSheetName();
        } else {
            this.removeChangeListener(this.fWorksheetChangeListener);
            this.remove((Component)((Object)tabContentPanel));
            tabContentPanel.cleanup();
        }
        if (bl) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof TabContentPanel) || component.equals(tabContentPanel)) continue;
                ((TabContentPanel)((Object)component)).deinitialize();
            }
            tabContentPanel.getWorksheetTable().addInitialSelectionListener();
        } else {
            Object object2;
            int n;
            Component[] componentArray;
            this.removeChangeListener(this.fWorksheetChangeListener);
            Component[] componentArray2 = componentArray = this.getComponents();
            int n2 = componentArray2.length;
            for (n = 0; n < n2; ++n) {
                object2 = componentArray2[n];
                if (!(object2 instanceof TabContentPanel)) continue;
                this.remove((Component)object2);
                if (object2.equals(tabContentPanel)) continue;
                ((TabContentPanel)object2).cleanup();
            }
            int n3 = 0;
            WorksheetTable worksheetTable = null;
            for (n = 0; n < stringArray.length; ++n) {
                if (n == 0 && object == null) {
                    object2 = new TabContentPanel(this.fSpreadsheet, this.fWorkbookName, stringArray[n], this, true);
                    this.addTab(stringArray[n], (Component)object2);
                    worksheetTable = ((TabContentPanel)object2).getWorksheetTable();
                    ((TabContentPanel)object2).setTargetType(this.fTargetType);
                    continue;
                }
                if (!stringArray[n].equals(object)) {
                    object2 = new TabContentPanel(this.fSpreadsheet, this.fWorkbookName, stringArray[n], this, false);
                    ((TabContentPanel)object2).setTargetType(this.fTargetType);
                    this.addTab(stringArray[n], (Component)object2);
                    continue;
                }
                this.addTab(stringArray[n], (Component)((Object)tabContentPanel));
                n3 = n;
            }
            this.addChangeListener(this.fWorksheetChangeListener);
            this.setSelectedIndex(n3);
            if (worksheetTable != null) {
                worksheetTable.addInitialSelectionListener();
            }
        }
    }

    SpreadsheetTabbedPane(Object object, String string, String[] stringArray, List<WorksheetRule> list, ImportClient.TargetType targetType) {
        int n;
        this.setName("importool:SpreadsheetTabbedPane");
        this.fTargetType = targetType;
        this.fRules = list;
        this.fSpreadsheet = object;
        this.fWorkbookName = string;
        if (!PlatformInfo.isMacintosh()) {
            this.setTabShape(4);
        }
        this.setBoldActiveTab(true);
        this.setTabPlacement(3);
        TabContentPanel tabContentPanel = new TabContentPanel(object, string, stringArray[0], this, true);
        tabContentPanel.setTargetType(targetType);
        this.addTab(stringArray[0], (Component)((Object)tabContentPanel));
        for (n = 1; n < stringArray.length; ++n) {
            TabContentPanel tabContentPanel2 = new TabContentPanel(object, string, stringArray[n], this, false);
            tabContentPanel2.setTargetType(targetType);
            this.addTab(stringArray[n], (Component)((Object)tabContentPanel2));
        }
        for (n = 1; n < this.getTabCount(); ++n) {
            this.setEnabledAt(n, false);
        }
        this.fWorksheetChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent changeEvent) {
                if (SpreadsheetTabbedPane.this.getSelectedIndex() < 0) {
                    return;
                }
                Component component = SpreadsheetTabbedPane.this.getComponentAt(SpreadsheetTabbedPane.this.getSelectedIndex());
                if (!(component instanceof TabContentPanel)) {
                    return;
                }
                final TabContentPanel tabContentPanel = (TabContentPanel)((Object)component);
                for (int i = 0; i < SpreadsheetTabbedPane.this.getTabCount(); ++i) {
                    if (i == SpreadsheetTabbedPane.this.getSelectedIndex()) continue;
                    SpreadsheetTabbedPane.this.setEnabledAt(i, false);
                }
                DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, (Component)((Object)SpreadsheetTabbedPane.this));
                dTClientBase.setCursor(new Cursor(3));
                if (!tabContentPanel.isInitialized()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            this.stateChangeComplete(tabContentPanel, changeEvent);
                        }
                    };
                    tabContentPanel.initialize(runnable);
                    tabContentPanel.getWorksheetTable().addInitialSelectionListener();
                    return;
                }
                String string = tabContentPanel.getWorksheetTable().getSelectedRange();
                for (WorksheetSelectionListener worksheetSelectionListener : SpreadsheetTabbedPane.this.fRangeSelectionListeners) {
                    worksheetSelectionListener.selectedDataChanged(string);
                }
                SpreadsheetTabbedPane.this.ruleChanged(SpreadsheetTabbedPane.this.fRules);
                this.stateChangeComplete(tabContentPanel, changeEvent);
            }

            private void stateChangeComplete(TabContentPanel tabContentPanel, ChangeEvent changeEvent) {
                tabContentPanel.getWorksheetTable().setTargetType(SpreadsheetTabbedPane.this.fTargetType);
                tabContentPanel.setTargetType(SpreadsheetTabbedPane.this.fTargetType);
                for (ChangeListener changeListener : SpreadsheetTabbedPane.this.fSpreadsheetTabSelectionListeners) {
                    changeListener.stateChanged(changeEvent);
                }
            }
        };
        this.addChangeListener(this.fWorksheetChangeListener);
    }

    @Override
    public void setHeaderRow(int n) {
        this.getCurrentTabContentPanel().getWorksheetTable().setHeaderRow(n);
    }

    public void setVariableNamesHighlightRow(int n) {
        this.getCurrentTabContentPanel().getWorksheetTable().setVariableNamesHighlightRow(n);
        this.getCurrentTabContentPanel().getWorksheetTable().repaint();
        this.getCurrentTabContentPanel().getWorksheetTable().getTableHeader().repaint();
    }

    List<WorksheetRule> getRules() {
        return this.fRules;
    }

    void setRules(List<WorksheetRule> list) {
        this.fRules = list;
    }

    public void cleanup() {
        this.fRules = null;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getComponentAt(i);
            if (!(component instanceof TabContentPanel)) continue;
            ((TabContentPanel)((Object)component)).cleanup();
        }
        this.removeChangeListener(this.fWorksheetChangeListener);
        this.fRangeSelectionListeners = null;
        this.fTargetType = null;
    }

    public WorksheetTable getWorksheetTableAtIndex(int n) {
        Component component = this.getComponentAt(n);
        if (component instanceof TabContentPanel) {
            return ((TabContentPanel)((Object)component)).getWorksheetTable();
        }
        return null;
    }

    TabContentPanel getCurrentTabContentPanel() {
        Component component = this.getSelectedComponent();
        if (component instanceof TabContentPanel) {
            return (TabContentPanel)((Object)component);
        }
        return null;
    }

    @Override
    public void ruleChanged(List<WorksheetRule> list) {
        this.getCurrentTabContentPanel().ruleChanged(list);
    }

    boolean isImportableData() {
        WorksheetTable worksheetTable = this.getCurrentTabContentPanel().getWorksheetTable();
        if (worksheetTable == null) {
            return false;
        }
        int[] nArray = worksheetTable.getSelectionSizeAfterExclusion();
        return nArray != null && nArray.length >= 2 && nArray[0] > 0 && nArray[1] > 0 && !worksheetTable.isUntreatedDataInSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        WorksheetTable worksheetTable = this.getCurrentTabContentPanel().getWorksheetTable();
        if (worksheetTable == null) {
            return;
        }
        String string = worksheetTable.getSelectedRange();
        for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
            worksheetSelectionListener.selectedDataChanged(string, listSelectionEvent.getValueIsAdjusting());
        }
    }

    @Override
    public void worksheetCachedDataChanged(EventObject eventObject) {
        DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, (Component)((Object)this));
        if (dTClientBase != null) {
            dTClientBase.setCursor(null);
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            WorksheetTable worksheetTable;
            this.setEnabledAt(i, true);
            Component component = this.getComponentAt(i);
            if (!(component instanceof TabContentPanel) || !((TabContentPanel)((Object)component)).isInitialized() || (worksheetTable = ((TabContentPanel)((Object)component)).getWorksheetTable()) == null || !worksheetTable.getModel().equals(eventObject.getSource())) continue;
            String string = worksheetTable.getSelectedRange();
            for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
                worksheetSelectionListener.selectedDataChanged(string);
            }
        }
    }

    @Override
    public void selectedDataChanged(String string) {
        TabContentPanel tabContentPanel = this.getCurrentTabContentPanel();
        if (tabContentPanel == null) {
            return;
        }
        WorksheetTable worksheetTable = tabContentPanel.getWorksheetTable();
        if (worksheetTable != null) {
            worksheetTable.setSelectedRanges(string);
        }
    }

    @Override
    public void temporarySelectionDataChanged(String string) {
        TabContentPanel tabContentPanel = this.getCurrentTabContentPanel();
        if (tabContentPanel == null) {
            return;
        }
        WorksheetTable worksheetTable = tabContentPanel.getWorksheetTable();
        if (worksheetTable != null) {
            worksheetTable.setTemporarySelectedRanges(string);
            worksheetTable.repaint();
        }
    }

    @Override
    public void selectedDataChanged(String string, boolean bl) {
        this.selectedDataChanged(string);
    }

    public void setTargetType(ImportClient.TargetType targetType) {
        this.fTargetType = targetType;
        if (this.getCurrentTabContentPanel() != null && this.getCurrentTabContentPanel().getWorksheetTable() != null) {
            this.getCurrentTabContentPanel().getWorksheetTable().setTargetType(this.fTargetType);
            this.getCurrentTabContentPanel().setTargetType(this.fTargetType);
        }
    }

    static class TabContentPanel
    extends MJPanel
    implements WorksheetRuleListener {
        private boolean iIsInitialized = false;
        private MJPanel iBuildingPanel;
        private Object iSpreadsheet;
        private String iWorkbookName;
        private String iSheetName;
        private WorksheetTable iWorksheetTable;
        private SpreadsheetTabbedPane iSpreadsheetTabbedPane;
        private ImportScrollPane iImportScrollPane;
        private VariableNamePanel iVariableNamePanel;
        private MJLayeredPane iLayeredPane;

        TabContentPanel(Object object, String string, String string2, SpreadsheetTabbedPane spreadsheetTabbedPane, boolean bl) {
            super((LayoutManager)new FloatingComponentLayout());
            this.iSpreadsheet = object;
            this.iSheetName = string2;
            this.iWorkbookName = string;
            this.iSpreadsheetTabbedPane = spreadsheetTabbedPane;
            if (bl) {
                this.initialize();
            } else {
                MJLabel mJLabel = new MJLabel("Please wait...");
                this.iBuildingPanel = new MJPanel();
                this.iBuildingPanel.add((Component)mJLabel);
                this.add((Component)this.iBuildingPanel);
            }
        }

        String getSheetName() {
            return this.iSheetName;
        }

        boolean isInitialized() {
            return this.iIsInitialized;
        }

        WorksheetTable getWorksheetTable() {
            return this.iWorksheetTable;
        }

        void cleanup() {
            if (this.iImportScrollPane != null) {
                this.iImportScrollPane.cleanup();
            }
            this.iImportScrollPane = null;
            this.iSpreadsheet = null;
            this.iSpreadsheetTabbedPane = null;
            if (this.iWorksheetTable != null) {
                this.iWorksheetTable.cleanup();
            }
            this.iWorksheetTable = null;
        }

        void rebuild() {
            if (this.iWorksheetTable != null) {
                this.iWorksheetTable.rebuild();
            }
        }

        void setTargetType(ImportClient.TargetType targetType) {
            if (this.iVariableNamePanel == null) {
                return;
            }
            this.iVariableNamePanel.setVisible(targetType.usesGroupName());
            if (this.iWorksheetTable.getTableHeader().getDefaultRenderer() instanceof VariableHeaderRenderer) {
                VariableHeaderRenderer variableHeaderRenderer = (VariableHeaderRenderer)((Object)this.iWorksheetTable.getTableHeader().getDefaultRenderer());
                variableHeaderRenderer.setVariableNamesVisible(targetType.usesColumnNames());
                variableHeaderRenderer.setGroupNamesVisible(targetType.usesGroupName());
            }
            this.iWorksheetTable.getTableHeader().repaint();
            this.iWorksheetTable.getTableHeader().revalidate();
            this.revalidate();
            this.repaint();
        }

        void deinitialize() {
            if (this.iIsInitialized) {
                this.remove((Component)((Object)this.iImportScrollPane));
                this.iWorksheetTable.getSelectionModel().removeListSelectionListener(this.iSpreadsheetTabbedPane);
                this.iWorksheetTable.getColumnModel().getSelectionModel().removeListSelectionListener(this.iSpreadsheetTabbedPane);
                this.iWorksheetTable.removeWorksheetCachedDataListener(this.iSpreadsheetTabbedPane);
                this.iWorksheetTable = null;
                this.iImportScrollPane = null;
                this.iIsInitialized = false;
            }
        }

        void initialize() {
            this.initialize(null);
        }

        void initialize(final Runnable runnable) {
            if (!this.iIsInitialized) {
                WorksheetTableModel worksheetTableModel = new WorksheetTableModel(this.iSpreadsheet, this.iWorkbookName, this.iSheetName, this.iSpreadsheetTabbedPane.getRules());
                this.iWorksheetTable = new WorksheetTable(worksheetTableModel);
                this.iWorksheetTable.addWorksheetCachedDataListener(this.iSpreadsheetTabbedPane);
                this.iWorksheetTable.getColumnModel().getSelectionModel().addListSelectionListener(this.iSpreadsheetTabbedPane);
                this.iWorksheetTable.addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                    @Override
                    public void worksheetCachedDataChanged(EventObject eventObject) {
                        if (TabContentPanel.this.iWorksheetTable == null) {
                            return;
                        }
                        TabContentPanel.this.iWorksheetTable.removeWorksheetCachedDataListener(this);
                        TabContentPanel.this.build();
                        if (runnable != null) {
                            runnable.run();
                        }
                        TabContentPanel.this.iIsInitialized = true;
                    }
                });
            }
        }

        private void build() {
            this.iWorksheetTable.setHorizontalAutoScrollEnabled(false);
            this.iWorksheetTable.setTargetType(this.iSpreadsheetTabbedPane.getTargetType());
            this.iImportScrollPane = new ImportScrollPane((JTable)((Object)this.iWorksheetTable));
            int n = this.iSpreadsheetTabbedPane.indexOfTab(this.iSheetName);
            File file = new File(this.iWorkbookName);
            String string = file.getName();
            int n2 = string.indexOf(".");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            if ((string = string.replaceAll("^[^a-zA-Z]*|[^a-zA-Z0-9]", "") + (n > 0 ? "S" + n : "")).isEmpty()) {
                string = "Untitled";
            }
            this.iWorksheetTable.validateVariableName(string, true, new ImportTable.VariableNameValidationCallback(){

                @Override
                public void nameValidated(String string, boolean bl) {
                    if (bl && TabContentPanel.this.iVariableNamePanel != null) {
                        TabContentPanel.this.iVariableNamePanel.setVariableName(string);
                    }
                    if (TabContentPanel.this.iWorksheetTable != null) {
                        TabContentPanel.this.iWorksheetTable.setDefaultMatrixVariableName(string);
                    }
                }
            });
            this.iVariableNamePanel = this.iWorksheetTable.createVariableNamePanel(this.iImportScrollPane, string);
            this.setTargetType(this.iSpreadsheetTabbedPane.getTargetType());
            this.iLayeredPane = new MJLayeredPane();
            VariableNamePanel.VariableNamePanelLayout variableNamePanelLayout = new VariableNamePanel.VariableNamePanelLayout(this.iVariableNamePanel, (JTable)((Object)this.iWorksheetTable));
            this.iLayeredPane.setLayout((LayoutManager)variableNamePanelLayout);
            this.iLayeredPane.add((Component)((Object)this.iImportScrollPane), (Object)MJLayeredPane.DEFAULT_LAYER);
            this.iLayeredPane.add((Component)((Object)this.iVariableNamePanel), (Object)MJLayeredPane.PALETTE_LAYER);
            if (this.iBuildingPanel != null) {
                this.remove((Component)this.iBuildingPanel);
            }
            this.add((Component)this.iLayeredPane);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void ruleChanged(List<WorksheetRule> list) {
            DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, (Component)((Object)this));
            if (dTClientBase != null) {
                dTClientBase.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (this.iSpreadsheetTabbedPane != null && this.iWorksheetTable != null) {
                this.iSpreadsheetTabbedPane.setRules(list);
                this.iWorksheetTable.setWorksheetRules(list);
            }
        }
    }
}

