/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.HeaderMouseAdapter;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

class TextHeaderMouseAdapter
extends HeaderMouseAdapter {
    private TextTableHeaderRenderer fHeaderRenderer;
    private JTableHeader fTableHeader;
    private int fLastColumnHeaderClick = -1;
    private static int RESIZE_REGION_SIZE = 2;
    private static final Cursor fResizeCursor = new Cursor(10);
    private static final Cursor fDefaultCursor = new Cursor(0);
    private static final Cursor fTextCursor = new Cursor(2);
    private int fMouseDownColumn = -1;

    TextHeaderMouseAdapter(JTableHeader jTableHeader, TextTableHeaderRenderer textTableHeaderRenderer) {
        super(jTableHeader, textTableHeaderRenderer);
        this.fHeaderRenderer = textTableHeaderRenderer;
        this.fTableHeader = jTableHeader;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fHeaderRenderer.isHeaderEditing()) {
            this.fHeaderRenderer.fireEditingStopped();
        }
        if (this.fTableHeader.getTable().isEditing() && this.fTableHeader.getTable().getCellEditor() != null) {
            this.fTableHeader.getTable().getCellEditor().cancelCellEditing();
        }
        super.mouseReleased(mouseEvent);
        Point point = mouseEvent.getPoint();
        int n = this.fTableHeader.columnAtPoint(point);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        TextTable textTable = null;
        if (this.fTableHeader.getTable() instanceof TextTable) {
            textTable = (TextTable)((Object)this.fTableHeader.getTable());
        }
        if (n == this.fMouseDownColumn) {
            Rectangle rectangle2 = this.fHeaderRenderer.getDataTypeDropDownBounds(n, this.fTableHeader.getTable().getColumnModel().getColumn(n).getHeaderValue());
            if (textTable != null) {
                Point point2 = textTable.getColumnPoint(n);
                rectangle2.x += point2.x;
                rectangle2.y += point2.y;
            }
            if (rectangle2.contains(point)) {
                if (textTable != null && textTable.getCurrentlyExpandedColumn() != n) {
                    textTable.expandAndCollapseFixedWidthColumns(n);
                }
                if (this.fTableHeader.getDefaultRenderer() instanceof TextTableHeaderRenderer) {
                    if (((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).getLastItemListColumn() == n) {
                        ((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).hideListItemPopup();
                        textTable.collapseAllFixedWidthColumns();
                    } else {
                        ((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).showListItemPopup(n, textTable.getTargetType());
                    }
                }
            } else {
                if (this.fTableHeader.getDefaultRenderer() instanceof TextTableHeaderRenderer) {
                    ((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).hideListItemPopup();
                }
                if (textTable != null && textTable.getCurrentlyExpandedColumn() != n) {
                    textTable.expandAndCollapseFixedWidthColumns(n);
                } else if (textTable != null && !this.fHeaderRenderer.isEditableAtPoint(point, n, this.fTableHeader.getTable().getColumnModel().getColumn(n).getHeaderValue())) {
                    textTable.collapseAllFixedWidthColumns();
                    this.fLastColumnHeaderClick = -1;
                }
            }
        }
        this.fMouseDownColumn = -1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fHeaderRenderer.fireEditingStopped();
        if (this.fTableHeader.getTable().isEditing() && this.fTableHeader.getTable().getCellEditor() != null) {
            this.fTableHeader.getTable().getCellEditor().stopCellEditing();
        }
        super.mousePressed(mouseEvent);
        Point point = mouseEvent.getPoint();
        if (!this.isRulerRegion(point) && mouseEvent.getButton() == 1) {
            this.fMouseDownColumn = this.fTableHeader.columnAtPoint(point);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        int n = this.fHeaderRenderer.getHoverColumn();
        Point point = mouseEvent.getPoint();
        int n2 = this.fTableHeader.columnAtPoint(point);
        if (n2 >= 0) {
            object2 = this.fTableHeader.getTable().getColumnModel().getColumn(n2).getHeaderValue();
            if (object2 instanceof TextTableHeaderRenderer.TextImportDataHeader) {
                Object object3;
                object = null;
                if (((TextTable)((Object)this.fTableHeader.getTable())).showColumnHeaderVariableWarning(n2) && point.x - this.fTableHeader.getHeaderRect((int)n2).x >= (object3 = (Object)this.fHeaderRenderer.calculateWarningIconHorizontalPosition(this.fTableHeader.getColumnModel().getColumn(n2).getWidth(), ((VariableHeaderRenderer.ImportDataHeader)object2).getName()))[0] && point.x - this.fTableHeader.getHeaderRect((int)n2).x <= object3[1]) {
                    object = ImportToolUtils.getResourceString("variablewarn.tooltip");
                }
                if (object == null) {
                    object3 = (TextTableHeaderRenderer.TextImportDataHeader)object2;
                    String string = ImportToolUtils.getResourceString("datatypes.text");
                    String string2 = ImportToolUtils.getResourceString("datatypes.datatype");
                    if (((TextTableHeaderRenderer.TextImportDataHeader)object3).getParseRule() != null) {
                        string = ((TextTableHeaderRenderer.TextImportDataHeader)object3).getParseRule().getParseTargetType();
                    }
                    object = ((VariableHeaderRenderer.ImportDataHeader)object3).getName() + " [" + string2 + ":" + string + "]";
                }
                this.fTableHeader.setToolTipText((String)object);
            }
            this.fHeaderRenderer.setDataTypeHoverColumn(-1);
            object = this.fHeaderRenderer.getDataTypeDropDownBounds(n2, object2);
            ((Rectangle)object).x += ((TextTable)((Object)this.fTableHeader.getTable())).getColumnPoint((int)n2).x;
            if (((Rectangle)object).contains(point)) {
                this.fHeaderRenderer.setDataTypeHoverColumn(n2);
                this.fTableHeader.setToolTipText(ImportToolUtils.getResourceString("datatypes.tooltip"));
            }
        } else {
            this.fHeaderRenderer.setDataTypeHoverColumn(-1);
        }
        if (n2 >= 0) {
            object2 = this.fTableHeader.getHeaderRect(n2);
            object = this.fHeaderRenderer.getVarNameEditorBounds(n2, this.fTableHeader.getTable().getColumnModel().getColumn(n2).getHeaderValue());
            if (((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x + 5, point.y - ((Rectangle)object2).y)) && ((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x - 5, point.y - ((Rectangle)object2).y))) {
                this.fTableHeader.setCursor(fTextCursor);
                this.fTableHeader.setToolTipText(ImportToolUtils.getResourceString("variablename.editcolumn.tooltip"));
            } else if (point.x - ((Rectangle)object2).x <= RESIZE_REGION_SIZE && n2 > 0 || point.x - ((Rectangle)object2).x >= ((Rectangle)object2).width - RESIZE_REGION_SIZE) {
                this.fTableHeader.setCursor(fResizeCursor);
            } else {
                this.fTableHeader.setCursor(fDefaultCursor);
            }
            if (!((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x, point.y - ((Rectangle)object2).y))) {
                n2 = -1;
            }
        } else {
            this.fTableHeader.setCursor(fDefaultCursor);
        }
        if (n2 == n) {
            return;
        }
        this.fHeaderRenderer.setHoverColumn(n2);
        object2 = this.fTableHeader.getHeaderRect(n2);
        this.fTableHeader.repaint((Rectangle)object2);
        object = this.fTableHeader.getHeaderRect(n);
        this.fTableHeader.repaint((Rectangle)object);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fTableHeader.setCursor(new Cursor(0));
        this.fHeaderRenderer.setDataTypeHoverColumn(-1);
        this.fTableHeader.setCursor(null);
        this.fHeaderRenderer.setHoverColumn(-1);
        this.fHeaderRenderer.setDataTypeHoverColumn(-1);
        int n = this.fHeaderRenderer.getHoverColumn();
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        this.fTableHeader.repaint(rectangle);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.fTableHeader.columnAtPoint(point);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        TextTable textTable = null;
        if (this.fTableHeader.getTable() instanceof TextTable) {
            textTable = (TextTable)((Object)this.fTableHeader.getTable());
        }
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        if (!this.isRulerRegion(point) && n == this.fLastColumnHeaderClick && this.fHeaderRenderer.isEditableAtPoint(point, n, this.fTableHeader.getTable().getColumnModel().getColumn(n).getHeaderValue())) {
            if (this.fTableHeader.getDefaultRenderer() instanceof TextTableHeaderRenderer) {
                ((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).hideListItemPopup();
            }
            this.fHeaderRenderer.editColumnHeaderCellAt(this.fTableHeader.getTable(), n);
        }
        this.fLastColumnHeaderClick = n;
    }

    boolean isRulerRegion(Point point) {
        int n = ((TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).getRulerLabelHeight();
        return point.y > this.fTableHeader.getHeight() - n;
    }
}

