/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.mlservices.scc;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.mlservices.scc.CheckInDlg;
import com.mathworks.mlwidgets.mlservices.scc.CheckOutDlg;
import com.mathworks.mlwidgets.mlservices.scc.MWSccManager;
import com.mathworks.mlwidgets.mlservices.scc.SccFileListener;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.FileEvent;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.FileSystemAdapter;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class MWSccFileListenerImpl
implements SccFileListener,
PrefListener {
    public static final int SCC_UNIX_CMD_CHECKIN = 450;
    public static final int SCC_UNIX_CMD_CHECKOUT = 451;
    public static final int SCC_UNIX_CMD_UNCHECKOUT = 452;
    public static final int SCC_PC_CMD_GET = 400;
    public static final int SCC_PC_CMD_CHECKOUT = 401;
    public static final int SCC_PC_CMD_CHECKIN = 402;
    public static final int SCC_PC_CMD_UNCHECKOUT = 403;
    public static final int SCC_PC_CMD_ADD = 404;
    public static final int SCC_PC_CMD_REMOVE = 405;
    public static final int SCC_PC_CMD_DIFF = 406;
    public static final int SCC_PC_CMD_HISTORY = 407;
    public static final int SCC_PC_CMD_PROPERTIES = 409;
    public static final int SCC_PC_CMD_OPTION = 410;
    public static final int SCC_PC_CMD_START_SCC = 411;
    public static final int SCC_PC_CMD_REG_PROJ = 412;
    public static final long SCC_CAP_REMOVE = 1L;
    public static final long SCC_CAP_RENAME = 2L;
    public static final long SCC_CAP_DIFF = 4L;
    public static final long SCC_CAP_HISTORY = 8L;
    public static final long SCC_CAP_PROPERTIES = 16L;
    public static final long SCC_CAP_RUNSCC = 32L;
    public static final long SCC_CAP_GETCOMMANDOPTIONS = 64L;
    public static final long SCC_CAP_QUERYINFO = 128L;
    public static final long SCC_CAP_GETEVENTS = 256L;
    public static final long SCC_CAP_GETPROJPATH = 512L;
    public static final long SCC_CAP_ADDFROMSCC = 1024L;
    public static final long SCC_CAP_COMMENTCHECKOUT = 2048L;
    public static final long SCC_CAP_COMMENTCHECKIN = 4096L;
    public static final long SCC_CAP_COMMENTADD = 8192L;
    public static final long SCC_CAP_COMMENTREMOVE = 16384L;
    public static final long SCC_CAP_TEXTOUT = 32768L;
    public static final long SCC_CAP_ADD_STORELATEST = 0x200000L;
    public static final long SCC_CAP_HISTORY_MULTFILE = 0x400000L;
    public static final long SCC_CAP_IGNORECASE = 0x800000L;
    public static final long SCC_CAP_IGNORESPACE = 0x1000000L;
    public static final long SCC_CAP_POPULATELIST = 0x2000000L;
    public static final long SCC_CAP_COMMENTPROJECT = 0x4000000L;
    public static final long SCC_CAP_DIFFALWAYS = 0x10000000L;
    public static final long SCC_CAP_GET_NOUI = 0x20000000L;
    public static final long SCC_CAP_REENTRANT = 0x40000000L;
    private static int sSccCapability = 0;
    private static Matlab sMatlab;
    private static String sSccKey;
    private static boolean sIsSccTurnedOn;
    private static ResourceBundle sResources;
    private Hashtable fMenusHash = new Hashtable();
    private SccFileProvider fFileProvider;
    private FileSystemListener fFileSystemListener = this.createFileSystemListener();
    private boolean fProviderForMultipleFiles = false;

    MWSccFileListenerImpl(SccFileProvider sccFileProvider) {
        if (sMatlab == null) {
            sMatlab = new Matlab();
            MWSccFileListenerImpl.initSccCapability();
        }
        this.fFileProvider = sccFileProvider;
    }

    private static void initSccCapability() {
        if (Matlab.isMatlabAvailable() && MWSccFileListenerImpl.isSccAvailable() && PlatformInfo.isWindows()) {
            sMatlab.feval("verctrl", (Object[])new String[]{"CAPABILITY"}, 1, (MatlabListener)new SccCapabilityObserver());
        } else {
            sSccCapability = 0;
        }
    }

    MJMenu getSccMenu(String string) {
        MJMenu mJMenu;
        if (string.equals("DEFAULT_FILE")) {
            this.fProviderForMultipleFiles = true;
        }
        if ((mJMenu = this.getMenu(string)) != null) {
            return mJMenu;
        }
        MJMenu mJMenu2 = new MJMenu((Action)((Object)new SccAction(100)));
        if (PlatformInfo.isWindows()) {
            mJMenu2.add((Action)((Object)new SccAction(400)));
            mJMenu2.add((Action)((Object)new SccAction(401)));
            mJMenu2.add((Action)((Object)new SccAction(402)));
            mJMenu2.add((Action)((Object)new SccAction(403)));
            mJMenu2.addSeparator();
            mJMenu2.add((Action)((Object)new SccAction(404)));
            mJMenu2.add((Action)((Object)new SccAction(405)));
            mJMenu2.add((Action)((Object)new SccAction(412)));
            mJMenu2.addSeparator();
            mJMenu2.add((Action)((Object)new SccAction(407)));
            mJMenu2.add((Action)((Object)new SccAction(406)));
            mJMenu2.add((Action)((Object)new SccAction(409)));
            mJMenu2.add((Action)((Object)new SccAction(411)));
            this.addMenuItemToMap(string, mJMenu2);
        } else {
            mJMenu2.add((Action)((Object)new SccAction(450)));
            mJMenu2.add((Action)((Object)new SccAction(451)));
            mJMenu2.add((Action)((Object)new SccAction(452)));
        }
        this.setFactoryMenuStates(mJMenu2);
        return mJMenu2;
    }

    private void addMenuItemToMap(String string, MJMenu mJMenu) {
        this.fMenusHash.put(string, mJMenu);
    }

    private void removeMenuItemFromMap(String string) {
        this.fMenusHash.remove(string);
    }

    private boolean doesMapContainMenuItem(String string) {
        return this.fMenusHash.contains(string);
    }

    public int getCachedMenuItemCount() {
        return this.fMenusHash.size();
    }

    @Override
    public void untitledBufferClosed(FileEvent fileEvent) {
        if (this.fMenusHash.containsKey(fileEvent.getFilename())) {
            this.removeMenuItemFromMap(fileEvent.getFilename());
        }
    }

    @Override
    public void editorClosed(Editor editor) {
        if (editor.getStorageLocation() instanceof FileStorageLocation) {
            String string = ((FileStorageLocation)editor.getStorageLocation()).getFile().getPath();
            this.removeMenuItemFromMap(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileSelectionChanged(FileEvent fileEvent) {
        String[] stringArray = this.fFileProvider.getSelectedFiles();
        if (stringArray != null && stringArray.length == 1 && stringArray[0] != null && !this.fProviderForMultipleFiles && this.fMenusHash.containsKey(stringArray[0])) {
            MJMenu mJMenu = this.getMenu(stringArray[0]);
            if (mJMenu != null) {
                this.setCurrentMenuStates(mJMenu);
            }
        } else if (stringArray != null && stringArray.length == 1 && this.fProviderForMultipleFiles) {
            String string = null;
            Hashtable hashtable = this.fMenusHash;
            synchronized (hashtable) {
                Enumeration enumeration = this.fMenusHash.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                }
            }
            if (string != null) {
                hashtable = this.getMenu(string);
                if (hashtable == null) {
                    hashtable = this.getMenu("DEFAULT_FILE");
                }
                if (hashtable != null) {
                    if (!string.equals(stringArray[0])) {
                        this.removeMenuItemFromMap(string);
                        this.addMenuItemToMap(stringArray[0], (MJMenu)hashtable);
                    }
                    this.setCurrentMenuStates((MJMenu)hashtable);
                }
            }
        } else {
            this.setStateOfSCCMenus();
        }
    }

    private static boolean isSccAvailable() {
        return sIsSccTurnedOn;
    }

    private static void setSccAvailable(boolean bl) {
        sIsSccTurnedOn = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateOfSCCMenus() {
        if (MWSccFileListenerImpl.isSccAvailable() && PlatformInfo.isWindows()) {
            Hashtable hashtable = this.fMenusHash;
            synchronized (hashtable) {
                HashSet hashSet = new HashSet(this.fMenusHash.keySet());
                for (String string : hashSet) {
                    MJMenu mJMenu = this.getMenu(string);
                    if (mJMenu == null) continue;
                    this.setCurrentMenuStates(mJMenu);
                }
            }
        }
        Hashtable hashtable = this.fMenusHash;
        synchronized (hashtable) {
            HashSet hashSet = new HashSet(this.fMenusHash.keySet());
            for (String string : hashSet) {
                MJMenu mJMenu = this.getMenu(string);
                if (mJMenu == null) continue;
                this.setFactoryMenuStates(mJMenu);
            }
        }
    }

    private void setCurrentMenuStates(MJMenu mJMenu) {
        assert (mJMenu != null);
        assert (mJMenu.getAction() != null);
        if (!MWSccFileListenerImpl.isSccAvailable()) {
            mJMenu.getAction().setEnabled(false);
            return;
        }
        String[] stringArray = this.fFileProvider.getSelectedFiles();
        if (stringArray == null || stringArray.length == 0) {
            this.setFactoryMenuStates(mJMenu);
        } else {
            boolean bl = false;
            for (String string : stringArray) {
                if (string == null || FileUtils.fileExists((String)string)) continue;
                bl = true;
                this.setFactoryMenuStates(mJMenu);
                break;
            }
            if (!bl) {
                Long l;
                Frame frame = this.fFileProvider.getFrame(stringArray.length > 0 ? stringArray[0] : null);
                try {
                    long illegalStateException = frame == null ? 0L : NativeJava.hWndFromComponent((Component)frame);
                    l = new Long(illegalStateException);
                }
                catch (IllegalStateException illegalStateException) {
                    l = 0L;
                }
                if (mJMenu != null) {
                    sMatlab.feval("verctrl", new Object[]{"status", stringArray, l}, 1, (MatlabListener)new MenuStatusCmpObsr(mJMenu));
                }
            }
        }
    }

    private MJMenu getMenu(String string) {
        MJMenu mJMenu = (MJMenu)this.fMenusHash.get(string);
        if (mJMenu != null && mJMenu.getAction() == null) {
            this.removeMenuItemFromMap(string);
            mJMenu = null;
        }
        return mJMenu;
    }

    private boolean isCommandEnabled(Object object, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (!MWSccFileListenerImpl.isSccAvailable()) {
            return bl2;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            n2 = nArray[0];
            if (nArray.length > 1) {
                bl = true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                n2 &= nArray[i];
                n3 |= nArray[i];
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            n2 = (int)dArray[0];
            if (dArray.length > 1) {
                bl = true;
            }
            for (int i = 0; i < dArray.length; ++i) {
                n2 &= (int)dArray[i];
                n3 |= (int)dArray[i];
            }
        }
        switch (n) {
            case 404: {
                if ((n2 & 1) == 1 && (n2 & 0x40) == 64) {
                    bl2 = true;
                    break;
                }
                if (n3 & true || (n2 & 0x9000) == 36864) break;
                bl2 = true;
                break;
            }
            case 402: {
                if ((n2 & 1) != 1 || (n2 & 2) != 2) break;
                bl2 = true;
                break;
            }
            case 400: {
                if ((n2 & 1) != 1 || (n3 & 2) == 2 || (n3 & 0x40) == 64) break;
                bl2 = true;
                break;
            }
            case 401: {
                if ((n2 & 1) != 1 || (n3 & 2) == 2 || (n3 & 4) == 4 || (n3 & 0x80) == 128 || (n3 & 0x40) == 64) break;
                bl2 = true;
                break;
            }
            case 403: {
                if ((n2 & 1) != 1 || (n2 & 2) != 2) break;
                bl2 = true;
                break;
            }
            case 405: {
                if (((long)sSccCapability & 1L) != 1L || (n2 & 1) != 1 || (n3 & 0x40) == 64) break;
                bl2 = true;
                break;
            }
            case 412: {
                if ((n2 & 0x9000) != 36864) break;
                bl2 = true;
                break;
            }
            case 411: {
                bl2 = ((long)sSccCapability & 0x20L) == 32L;
                break;
            }
            case 406: {
                if (((long)sSccCapability & 4L) != 4L || bl || (n2 & 1) != 1 || (n2 & 0x40) == 64) break;
                bl2 = true;
                break;
            }
            case 407: {
                if (((long)sSccCapability & 8L) != 8L || bl || (n2 & 1) != 1 || (n2 & 0x40) == 64) break;
                bl2 = true;
                break;
            }
            case 409: {
                if (((long)sSccCapability & 0x10L) != 16L || bl || (n2 & 1) != 1 || (n2 & 0x40) == 64) break;
                bl2 = true;
            }
        }
        return bl2;
    }

    private void setFactoryMenuStates(MJMenu mJMenu) {
        assert (mJMenu != null) : "null menu not allowed";
        assert (mJMenu.getAction() != null) : "menu has been disposed; caller should check";
        mJMenu.getAction().setEnabled(MWSccFileListenerImpl.isSccAvailable());
        if (MWSccFileListenerImpl.isSccAvailable()) {
            block3: for (int i = 0; i < mJMenu.getMenuComponentCount(); ++i) {
                Component component = mJMenu.getMenuComponent(i);
                if (!(component instanceof MJMenuItem)) continue;
                SccAction sccAction = (SccAction)((Object)((JMenuItem)component).getAction());
                switch ((Integer)sccAction.getValue("COMMAND")) {
                    case 411: 
                    case 450: 
                    case 451: 
                    case 452: {
                        sccAction.setEnabled(MWSccFileListenerImpl.isSccAvailable());
                        continue block3;
                    }
                    default: {
                        sccAction.setEnabled(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prefChanged(PrefEvent prefEvent) {
        Object[] objectArray;
        String string = "";
        if (!prefEvent.getPrefKey().equals("SourceControlSystem")) return;
        String string2 = Prefs.getStringPref((String)"SourceControlSystem", (String)sSccKey);
        boolean bl = sIsSccTurnedOn = string2 != null && string2.length() != 0 && !string2.equalsIgnoreCase(sSccKey);
        if (PlatformInfo.isWindows()) {
            string = sResources.getString("action.scc.register");
            objectArray = new Object[]{string2};
            string = MessageFormat.format(string, objectArray);
        }
        objectArray = this.fMenusHash;
        synchronized (this.fMenusHash) {
            for (Object k : this.fMenusHash.keySet()) {
                MJMenu mJMenu = this.getMenu((String)k);
                if (mJMenu == null) continue;
                if (sIsSccTurnedOn) {
                    mJMenu.getAction().setEnabled(true);
                    if (!PlatformInfo.isWindows()) {
                        this.setFactoryMenuStates(mJMenu);
                        continue;
                    }
                    for (int i = 0; i < mJMenu.getMenuComponentCount(); ++i) {
                        SccAction sccAction;
                        Component component = mJMenu.getMenuComponent(i);
                        if (!(component instanceof MJMenuItem) || (Integer)(sccAction = (SccAction)((Object)((AbstractButton)component).getAction())).getValue("COMMAND") != 412) continue;
                        sccAction.putValue("Name", string);
                    }
                    continue;
                }
                mJMenu.getAction().setEnabled(false);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!PlatformInfo.isWindows()) return;
            sMatlab.feval("clear", new Object[]{"verctrl"}, 0, new MatlabListener(){

                public void matlabEvent(MatlabEvent matlabEvent) {
                    if (matlabEvent.getEventType() == 3) {
                        MWSccFileListenerImpl.initSccCapability();
                    }
                }
            });
            return;
        }
    }

    private void fireFileStatusChangeEvent() {
        if (PlatformInfo.isWindows()) {
            MWSccManager.fireSccStatusChange();
        }
    }

    private boolean confirmGet(Frame frame, String[] stringArray) {
        boolean bl = MWSccFileListenerImpl.isFileDirty(stringArray);
        int n = 0;
        if (bl) {
            n = this.confirmDialogHelper(frame, sResources.getString("question.get.msg"));
        }
        return n == 0;
    }

    private boolean confirmCheckout(Frame frame, String[] stringArray) {
        boolean bl = MWSccFileListenerImpl.isFileDirty(stringArray);
        int n = 0;
        if (bl) {
            n = this.confirmDialogHelper(frame, sResources.getString("question.co.dirty.msg"));
        }
        return n == 0;
    }

    private boolean confirmCheckin(Frame frame, String[] stringArray) {
        if (MWSccFileListenerImpl.isFutureFile(stringArray) || !PlatformInfo.isWindows() && MWSccFileListenerImpl.isFileDirty(stringArray)) {
            MJOptionPane.showConfirmDialog((Component)frame, (Object)sResources.getString("question.checkinnosave.msg"), (String)sResources.getString("question.dialog.title"), (int)-1, (int)2);
            return false;
        }
        boolean bl = MWSccFileListenerImpl.isFileDirty(stringArray);
        int n = 0;
        if (bl) {
            n = this.confirmDialogHelper(frame, sResources.getString("question.checkinsave.msg"));
        }
        return n == 0;
    }

    private boolean confirmUncheckout(Frame frame, String[] stringArray) {
        boolean bl = MWSccFileListenerImpl.isFileDirty(stringArray);
        int n = 0;
        if (bl) {
            n = this.confirmDialogHelper(frame, sResources.getString("question.uncheckout.msg"));
        }
        return n == 0;
    }

    private static boolean isFileOpenAndDirty(String string) {
        assert (new File(string).isAbsolute());
        Editor editor = MLEditorServices.getEditorApplication().findEditor((StorageLocation)new FileStorageLocation(string));
        return editor != null && editor.isDirty();
    }

    public static boolean isFileDirty(String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (!MWSccFileListenerImpl.isFileOpenAndDirty(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isFutureFile(String[] stringArray) {
        for (String string : stringArray) {
            if (new File(string).isAbsolute()) continue;
            assert (stringArray.length == 1);
            return true;
        }
        return false;
    }

    private int confirmDialogHelper(Frame frame, String string) {
        Object[] objectArray = new Object[]{MJUtilities.intlString((String)"dialog.MJOptionPane.Yes"), MJUtilities.intlString((String)"dialog.MJOptionPane.No")};
        return MJOptionPane.showOptionDialog((Component)frame, (Object)string, (String)sResources.getString("question.dialog.title"), (int)0, (int)2, null, (Object[])objectArray, (Object)objectArray[1]);
    }

    public FileSystemListener getFileSystemListener() {
        return this.fFileSystemListener;
    }

    private FileSystemListener createFileSystemListener() {
        return new FileSystemAdapter(){

            public void fileMoved(File file, File file2) {
                if (file.getAbsolutePath() != null && file2.getAbsolutePath() != null && MWSccFileListenerImpl.this.doesMapContainMenuItem(file.getAbsolutePath())) {
                    MJMenu mJMenu = MWSccFileListenerImpl.this.getMenu(file.getAbsolutePath());
                    if (mJMenu != null) {
                        MWSccFileListenerImpl.this.removeMenuItemFromMap(file.getAbsolutePath());
                        MWSccFileListenerImpl.this.addMenuItemToMap(file2.getAbsolutePath(), mJMenu);
                    }
                    MWSccFileListenerImpl.this.setStateOfSCCMenus();
                }
            }

            public void fileDeleted(File file) {
                if (MWSccFileListenerImpl.this.fMenusHash.containsKey(file.getAbsolutePath())) {
                    MJMenu mJMenu;
                    if (MWSccFileListenerImpl.this.fProviderForMultipleFiles && (mJMenu = MWSccFileListenerImpl.this.getMenu(file.getAbsolutePath())) != null) {
                        MWSccFileListenerImpl.this.addMenuItemToMap("DEFAULT_FILE", mJMenu);
                    }
                    MWSccFileListenerImpl.this.removeMenuItemFromMap(file.getAbsolutePath());
                }
                MWSccFileListenerImpl.this.fireFileStatusChangeEvent();
            }
        };
    }

    static {
        sIsSccTurnedOn = false;
        sResources = ResourceBundle.getBundle("com.mathworks.mlwidgets.mlservices.scc.resources.RES_MWSCC");
        sSccKey = "None";
        String string = Prefs.getStringPref((String)"SourceControlSystem", (String)sSccKey);
        sIsSccTurnedOn = string != null && !string.equals("") && !string.equalsIgnoreCase(sSccKey);
    }

    class ReloadCommandObsr
    implements MatlabListener {
        protected Frame frame;
        protected String[] fileNames;

        public ReloadCommandObsr(Frame frame, String[] stringArray) {
            this.frame = frame;
            this.fileNames = stringArray;
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getEventType() == 3) {
                this.completed(matlabEvent.getStatus(), matlabEvent.getResult());
            }
        }

        private void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) == 0) {
                if (object != null) {
                    MJMenu mJMenu;
                    boolean[] blArray = (boolean[])object;
                    if (blArray[0]) {
                        this.reloadFiles();
                    }
                    if ((mJMenu = MWSccFileListenerImpl.this.getMenu(this.fileNames[0])) != null) {
                        MWSccFileListenerImpl.this.setCurrentMenuStates(mJMenu);
                    }
                    MWSccFileListenerImpl.this.fireFileStatusChangeEvent();
                }
            } else {
                this.showLasterr();
            }
        }

        protected void showLasterr() {
            sMatlab.feval("lasterr", null, 1, new MatlabListener(){

                public void matlabEvent(MatlabEvent matlabEvent) {
                    if (matlabEvent.getEventType() == 3) {
                        this.completed(matlabEvent.getStatus(), matlabEvent.getResult());
                    }
                }

                private void completed(int n, Object object) {
                    if (Matlab.getExecutionStatus((int)n) == 0) {
                        MJOptionPane.showMessageDialog((Component)ReloadCommandObsr.this.frame, (Object)object, (String)sResources.getString("error.dialog.title"), (int)2);
                    } else {
                        MJOptionPane.showMessageDialog((Component)ReloadCommandObsr.this.frame, (Object)sResources.getString("error.genericmsg"), (String)sResources.getString("error.dialog.title"), (int)2);
                    }
                }
            });
        }

        protected void reloadFiles() {
            if (PlatformInfo.isWindows()) {
                for (String string : this.fileNames) {
                    Editor editor = MLEditorServices.getEditorApplication().findEditor((StorageLocation)new FileStorageLocation(string));
                    if (editor == null) continue;
                    editor.reload();
                }
            }
        }
    }

    class SccAction
    extends MJAbstractAction {
        SccAction(int n) {
            this.putValue("COMMAND", n);
            switch (n) {
                case 400: {
                    this.putValue("Name", sResources.getString("action.scc.get"));
                    break;
                }
                case 401: 
                case 451: {
                    this.putValue("Name", sResources.getString("action.scc.co"));
                    break;
                }
                case 402: 
                case 450: {
                    this.putValue("Name", sResources.getString("action.scc.ci"));
                    break;
                }
                case 403: 
                case 452: {
                    this.putValue("Name", sResources.getString("action.scc.unco"));
                    break;
                }
                case 404: {
                    this.putValue("Name", sResources.getString("action.scc.add"));
                    break;
                }
                case 405: {
                    this.putValue("Name", sResources.getString("action.scc.remove"));
                    break;
                }
                case 412: {
                    String string = sResources.getString("action.scc.register");
                    Object[] objectArray = new Object[]{Prefs.getStringPref((String)"SourceControlSystem", (String)"None")};
                    string = MessageFormat.format(string, objectArray);
                    this.putValue("Name", string);
                    break;
                }
                case 407: {
                    this.putValue("Name", sResources.getString("action.scc.history"));
                    break;
                }
                case 406: {
                    this.putValue("Name", sResources.getString("action.scc.diff"));
                    break;
                }
                case 409: {
                    this.putValue("Name", sResources.getString("action.scc.prop"));
                    break;
                }
                case 411: {
                    this.putValue("Name", sResources.getString("action.scc.scc"));
                    break;
                }
                default: {
                    this.setName(sResources.getString("action.scc"));
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = MWSccFileListenerImpl.this.fFileProvider.getSelectedFiles();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            Frame frame = MWSccFileListenerImpl.this.fFileProvider.getFrame(stringArray[0]);
            MJMenuItem mJMenuItem = (MJMenuItem)actionEvent.getSource();
            int n = (Integer)mJMenuItem.getAction().getValue("COMMAND");
            if (PlatformInfo.isWindows()) {
                long l = NativeJava.hWndFromComponent((Component)frame);
                Long l2 = l;
                switch (n) {
                    case 400: {
                        if (!MWSccFileListenerImpl.this.confirmGet(frame, stringArray)) break;
                        sMatlab.feval("verctrl", new Object[]{"GET", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 401: {
                        if (!MWSccFileListenerImpl.this.confirmCheckout(frame, stringArray)) break;
                        sMatlab.feval("verctrl", new Object[]{"CHECKOUT", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 402: {
                        if (!MWSccFileListenerImpl.this.confirmCheckin(frame, stringArray)) break;
                        String string = "";
                        boolean bl = true;
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!MLEditorServices.getEditorApplication().isEditorOpenAndDirty((StorageLocation)new FileStorageLocation(stringArray[i]))) continue;
                            boolean bl2 = MWSccFileListenerImpl.this.fFileProvider.save(stringArray[i]);
                            boolean bl3 = bl = bl2 && bl;
                            if (bl2) continue;
                            string = string + stringArray[i] + "\n";
                        }
                        if (bl) {
                            sMatlab.feval("verctrl", new Object[]{"CHECKIN", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                            break;
                        }
                        MJOptionPane.showMessageDialog((Component)frame, (Object)(sResources.getString("error.checkin_save.msg") + string), (String)sResources.getString("error.dialog.title"), (int)2);
                        break;
                    }
                    case 403: {
                        if (!MWSccFileListenerImpl.this.confirmUncheckout(frame, stringArray)) break;
                        sMatlab.feval("verctrl", new Object[]{"uncheckout", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 404: {
                        String string = "";
                        boolean bl = true;
                        for (String string2 : stringArray) {
                            if (!MLEditorServices.getEditorApplication().isEditorOpenAndDirty((StorageLocation)new FileStorageLocation(string2))) continue;
                            boolean bl4 = MWSccFileListenerImpl.this.fFileProvider.save(string2);
                            boolean bl5 = bl = bl4 && bl;
                            if (bl4) continue;
                            string = string + string2 + "\n";
                        }
                        if (bl) {
                            sMatlab.feval("verctrl", new Object[]{"add", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                            break;
                        }
                        MJOptionPane.showMessageDialog((Component)frame, (Object)(sResources.getString("error.add_save.msg") + string), (String)sResources.getString("error.dialog.title"), (int)2);
                        break;
                    }
                    case 412: {
                        sMatlab.feval("verctrl", new Object[]{"register", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 405: {
                        sMatlab.feval("verctrl", new Object[]{"remove", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 407: {
                        sMatlab.feval("verctrl", new Object[]{"history", stringArray, l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 406: {
                        if (MWSccFileListenerImpl.isFileOpenAndDirty(stringArray[0])) {
                            if (MWSccFileListenerImpl.this.fFileProvider.save(stringArray[0])) {
                                sMatlab.feval("verctrl", new Object[]{"showdiff", stringArray[0], l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                                break;
                            }
                            MJOptionPane.showMessageDialog((Component)frame, (Object)sResources.getString("error.diff_save.msg"), (String)sResources.getString("error.dialog.title"), (int)2);
                            break;
                        }
                        sMatlab.feval("verctrl", new Object[]{"showdiff", stringArray[0], l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 409: {
                        sMatlab.feval("verctrl", new Object[]{"properties", stringArray[0], l2, "FRAME", frame}, 1, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                        break;
                    }
                    case 411: {
                        sMatlab.feval("verctrl", new Object[]{"runscc", l2}, 0, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                    }
                }
            } else {
                switch (n) {
                    case 450: {
                        if (!MWSccFileListenerImpl.this.confirmCheckin(frame, stringArray)) break;
                        CheckInDlg checkInDlg = new CheckInDlg(stringArray, false);
                        break;
                    }
                    case 451: {
                        if (!MWSccFileListenerImpl.this.confirmCheckout(frame, stringArray)) break;
                        CheckOutDlg checkOutDlg = new CheckOutDlg(stringArray, false);
                        break;
                    }
                    case 452: {
                        if (!MWSccFileListenerImpl.this.confirmUncheckout(frame, stringArray)) break;
                        sMatlab.fevalConsoleOutput("undocheckout", new Object[]{stringArray}, 0, (MatlabListener)new ReloadCommandObsr(frame, stringArray));
                    }
                }
            }
        }
    }

    class MenuStatusCmpObsr
    implements MatlabListener {
        private MJMenu fMenu;

        public MenuStatusCmpObsr(MJMenu mJMenu) {
            assert (mJMenu != null);
            assert (mJMenu.getAction() != null);
            this.fMenu = mJMenu;
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getEventType() == 3) {
                this.completed(matlabEvent.getStatus(), matlabEvent.getResult());
            }
        }

        private void completed(int n, Object object) {
            if (this.fMenu.getAction() == null) {
                return;
            }
            if (Matlab.getExecutionStatus((int)n) == 0) {
                for (int i = 0; i < this.fMenu.getMenuComponentCount(); ++i) {
                    Component component = this.fMenu.getMenuComponent(i);
                    if (!(component instanceof MJMenuItem)) continue;
                    SccAction sccAction = (SccAction)((Object)((JMenuItem)component).getAction());
                    sccAction.setEnabled(MWSccFileListenerImpl.this.isCommandEnabled(object, (Integer)sccAction.getValue("COMMAND")));
                }
            } else {
                MWSccFileListenerImpl.this.setFactoryMenuStates(this.fMenu);
            }
        }
    }

    private static class SccCapabilityObserver
    implements MatlabListener {
        private SccCapabilityObserver() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getEventType() == 3) {
                double[] dArray;
                sSccCapability = 0;
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0 && matlabEvent.getResult() != null && (dArray = (double[])matlabEvent.getResult()) != null && dArray.length > 0) {
                    sSccCapability = (int)dArray[0];
                }
            }
        }
    }
}

