/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLArrayEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.StatisticalFunction;
import com.mathworks.mlwidgets.workspace.WorkspaceCommandEvent;
import com.mathworks.mlwidgets.workspace.WorkspaceCommandListener;
import com.mathworks.mlwidgets.workspace.WorkspaceDialogs;
import com.mathworks.mlwidgets.workspace.WorkspaceLog;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.WorkspacePrefs;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.datatransfer.MATFileVariableReference;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;

public class WorkspaceCommands {
    private static final String RETRIEVE_AND_CLEAR_VALUE = "'retrieveAndClearValue'";
    private static final String STORE_VALUE = "'storeValue'";
    private static final String ARRAYVIEWFUNC_START = "arrayviewfunc(";
    private static final String ARRAYVIEWFUNC_END = "); ";
    private static final Object sNonExistentVariableProxy = new Object();
    private static final List<WorkspaceCommandListener> sWorkspaceCommandListeners = new ArrayList<WorkspaceCommandListener>();
    private static final int sMatlabRuntimeErrorCode = 131072;
    private static final String UNLIKELY_VARIABLE_NAME = "qfkomq2o034u62yjqweriogeferhewt";

    private WorkspaceCommands() {
    }

    public static boolean clearAllVariables(boolean bl, Frame frame) {
        return WorkspaceCommands.clear(bl, frame, "variables");
    }

    public static boolean clearAll(boolean bl, Frame frame) {
        return WorkspaceCommands.clear(bl, frame, "all");
    }

    private static boolean clear(boolean bl, Frame frame, String string) {
        boolean bl2;
        if (!bl) {
            bl2 = true;
        } else {
            int n = WorkspaceDialogs.showDefaultDeletionDialog(frame, WorkspaceResources.getResource("alert.clear.title"), -20);
            boolean bl3 = bl2 = n == 0;
        }
        if (bl2) {
            if (!Matlab.isMatlabAvailable()) {
                return bl2;
            }
            String string2 = "builtin('clear', '" + string + "');";
            WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(string2 + " " + string2);
        }
        return bl2;
    }

    public static boolean clearVariables(String[] stringArray, boolean bl, Frame frame) {
        boolean bl2 = false;
        if (stringArray != null && stringArray.length > 0) {
            if (!bl) {
                bl2 = true;
            } else {
                int n = WorkspaceDialogs.showDefaultDeletionDialog(frame, WorkspaceResources.getResource("alert.clear.title"), -20);
                boolean bl3 = bl2 = n == 0;
            }
            if (bl2) {
                StringBuilder stringBuilder = new StringBuilder("");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append('\'').append(stringArray[i]).append('\'');
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
                if (!Matlab.isMatlabAvailable()) {
                    return bl2;
                }
                WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("builtin('clear', " + stringBuilder + ");");
            }
        }
        return bl2;
    }

    public static void duplicateVariables(String[] stringArray) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(new StringBuffer("eval([workspacefunc('getcopyname', '").append(string).append("', who) ' = ").append(string).append(";']);").toString());
            }
        }
    }

    public static void createVariable() {
        WorkspaceCommands.createVariableUsingValue("0");
    }

    public static void createVariableUsingValue(String string) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("eval([workspacefunc('getnewname', who) ' = " + string + ";']);");
    }

    public static void createAndOpenVariable() {
        WorkspaceCommands.createAndOpenVariable("0");
    }

    public static void createAndOpenVariable(String string) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("qfkomq2o034u62yjqweriogeferhewt=workspacefunc('getnewname', who); eval([qfkomq2o034u62yjqweriogeferhewt ' = " + string + ";']); openvar(" + UNLIKELY_VARIABLE_NAME + "); clear('" + UNLIKELY_VARIABLE_NAME + "')");
    }

    public static void getVariableAbstractSummaries(WorkspaceVariable workspaceVariable, MatlabListener matlabListener) {
        if (workspaceVariable.getWorkspaceID() == 0) {
            WorkspaceCommands.getVariableAbstractSummaries(new String[]{workspaceVariable.getVariableName()}, matlabListener);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string = "getabstractvaluesummaries";
        Object[] objectArray = new Object[]{string, workspaceVariable};
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", objectArray, 1, (MatlabListener)new ActionLogProcessor(matlabListener, "getVariableAbstractSummaries", (Object)objectArray));
    }

    public static void getVariableAbstractSummaries(String[] stringArray, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i]).append(" ,");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]).append('}');
            Object[] objectArray = new String[]{"workspacefunc('getabstractvaluesummariesj', " + stringBuffer + ");"};
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (CompletionObserver)new ActionLogProcessor(completionObserver, "getVariableAbstractSummaries", (Object)stringBuffer));
        }
    }

    public static void getVariableAbstractSummaries(String[] stringArray, MatlabListener matlabListener) {
        if (stringArray != null && stringArray.length > 0) {
            WorkspaceCommands.checkForExistenceOfVariables(stringArray, new ExistenceCheckerML(stringArray, matlabListener));
        }
    }

    public static void addWorkspaceCommandListener(WorkspaceCommandListener workspaceCommandListener) {
        sWorkspaceCommandListeners.remove(workspaceCommandListener);
        sWorkspaceCommandListeners.add(workspaceCommandListener);
    }

    public static void removeWorkspaceCommandListener(WorkspaceCommandListener workspaceCommandListener) {
        sWorkspaceCommandListeners.remove(workspaceCommandListener);
    }

    private static void checkForExistenceOfVariables(String[] stringArray, MatlabListener matlabListener) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string = WorkspaceCommands.getExistenceCheckCommand(stringArray);
        Object[] objectArray = new String[]{string};
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (MatlabListener)new ActionLogProcessor(matlabListener, "getVariableAbstractSummaries", (Object)string));
    }

    private static String getExistenceCheckCommand(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray2[i];
            do {
                stringBuilder.append("builtin('exist','").append(string2).append("','var')&&");
            } while ((string2 = WorkspaceCommands.getImmediateParentIdentifier(string2)) != null);
        }
        stringBuilder.append("true, ");
        return stringBuilder.toString();
    }

    private static void getVariableAbstractSummariesBody(String[] stringArray, MatlabListener matlabListener) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("{");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                String string = stringArray[i];
                stringBuilder.append(string).append(" ,");
            }
            stringBuilder.append(stringArray[stringArray.length - 1]).append('}');
            Object[] objectArray = new String[]{"workspacefunc('getabstractvaluesummariesj', " + stringBuilder + ");"};
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (MatlabListener)new ActionLogProcessor(matlabListener, "getVariableAbstractSummaries", (Object)stringBuilder));
        }
    }

    public static void getVariableShortObjects(String[] stringArray, CompletionObserver completionObserver) {
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append("'").append(stringArray[i]).append("' ,");
            }
            stringBuffer.append("'").append(stringArray[stringArray.length - 1]).append("'}");
            Object[] objectArray = new String[]{"workspacefunc('getshortvalueobjectswithevalj', " + stringBuffer + ");"};
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (CompletionObserver)new ActionLogProcessor(completionObserver, "getVariableShortObjects", (Object)stringBuffer));
        }
    }

    public static void getVariableShortObjects(String[] stringArray, int n, CompletionObserver completionObserver) {
        if (n == 0) {
            WorkspaceCommands.getVariableShortObjects(stringArray, completionObserver);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        Object[] objectArray = new Object[]{"getshortvalueobjects", n};
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = stringArray;
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", objectArray2, 1, (CompletionObserver)new ActionLogProcessor(completionObserver, "getVariableShortObjects", (Object)stringArray[0]));
    }

    public static void getVariableStatObjects(String[] stringArray, int n, StatisticalFunction statisticalFunction, boolean bl, int n2, CompletionObserver completionObserver) {
        if (n == 0) {
            WorkspaceCommands.getVariableStatObjects(stringArray, statisticalFunction, bl, n2, completionObserver);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        Object[] objectArray = new Object[]{"getvariablestatobjects", n};
        Object[] objectArray2 = new Object[]{statisticalFunction.getMatlabFunction(), bl, n2};
        Object[] objectArray3 = new Object[objectArray.length + 1 + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = stringArray;
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length + 1, objectArray2.length);
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", objectArray3, 1, (CompletionObserver)new ActionLogProcessor(completionObserver, "getVariableStatObjects", (Object)stringArray[0]));
    }

    public static void getVariableStatObjects(String[] stringArray, int n, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        if (n == 0) {
            WorkspaceCommands.getVariableStatObjects(stringArray, statisticalFunction, completionObserver);
            return;
        }
        WorkspaceCommands.getVariableStatObjects(stringArray, n, statisticalFunction, WorkspacePrefs.getUseNaNsForStatCalculations(), WorkspacePrefs.getStatCalculationsNumelLimit(), completionObserver);
    }

    public static void getVariableStatObjects(String[] stringArray, StatisticalFunction statisticalFunction, boolean bl, int n, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i]).append(" ,");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]).append('}');
            Object[] objectArray = new String[]{"workspacefunc('getstatobjectsj', " + stringBuffer + ", '" + statisticalFunction.getMatlabFunction() + "', " + bl + ',' + n + ");"};
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (CompletionObserver)new ActionLogProcessor(completionObserver, "getVariableStatObjects", (Object)stringBuffer));
        }
    }

    public static void getVariableStatObjects(String[] stringArray, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        WorkspaceCommands.getVariableStatObjects(stringArray, statisticalFunction, WorkspacePrefs.getUseNaNsForStatCalculations(), WorkspacePrefs.getStatCalculationsNumelLimit(), completionObserver);
    }

    public static void saveAllVariables(Frame frame) {
        WorkspaceCommands.saveAllVariables(null, frame);
    }

    public static void saveAllVariables(File file, Frame frame) {
        WorkspaceCommands.saveVariables(null, file, frame);
    }

    public static void saveVariables(String[] stringArray, Frame frame) {
        WorkspaceCommands.saveVariables(stringArray, null, frame);
    }

    public static void saveVariables(String[] stringArray, File file, Frame frame) {
        WorkspaceCommands.saveVariables(stringArray, file, frame, false, null);
    }

    public static void saveVariables(String[] stringArray, File file, Frame frame, boolean bl, MatlabListener matlabListener) {
        String[] stringArray2 = stringArray;
        boolean bl2 = WorkspaceCommands.areVariableNamesOK(stringArray);
        if (!bl2) {
            boolean bl3 = WorkspaceCommands.varNameNormalizationAllowed(frame, stringArray);
            if (!bl3) {
                if (matlabListener != null) {
                    matlabListener.matlabEvent(new MatlabEvent(3, 131072, (Object)""));
                }
                return;
            }
            stringArray2 = WorkspaceCommands.normalizeNames(stringArray);
        }
        if (file != null) {
            WorkspaceCommands.saveVariablesWithValidFile(stringArray2, file, 1, null, false, frame, bl, null, matlabListener);
        } else {
            WorkspaceCommands.showSaveDialog(frame, stringArray2, matlabListener);
        }
    }

    private static void showSaveDialog(Frame frame, String[] stringArray, MatlabListener matlabListener) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPath.getCWD());
        mJFileChooserPerPlatform.setDialogTitle(WorkspaceResources.getResource("dialog.save.title"));
        mJFileChooserPerPlatform.setSelectedFile(new File("matlab.mat"));
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)FileExtensionFilter.getMatFileFilter());
        String string = WorkspaceResources.getResource("dialog.save.mfileDescription");
        FileExtensionFilter fileExtensionFilter = new FileExtensionFilter(string, "m", true);
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)fileExtensionFilter);
        mJFileChooserPerPlatform.setIncludeFilterExtension(true);
        mJFileChooserPerPlatform.showSaveDialog((Component)frame);
        if (mJFileChooserPerPlatform.getState() == 0 && mJFileChooserPerPlatform.getSelectedFile() != null) {
            OverwriteOptionHandler overwriteOptionHandler = new OverwriteOptionHandler();
            boolean bl = overwriteOptionHandler.run(mJFileChooserPerPlatform);
            if (bl) {
                WorkspaceCommands.saveVariablesWithValidFile(stringArray, mJFileChooserPerPlatform.getSelectedFile(), mJFileChooserPerPlatform.getFileFilterIndex(), overwriteOptionHandler.getSelectedFileAction(), overwriteOptionHandler.isIgnoreMATFileDeletionWarning(), frame, false, null, matlabListener);
            }
        } else if (matlabListener != null) {
            matlabListener.matlabEvent(new MatlabEvent(3, 131072, (Object)""));
        }
    }

    private static void saveVariablesWithValidFile(String[] stringArray, File file, int n, String string, boolean bl, Frame frame, boolean bl2, SaveWorker saveWorker, MatlabListener matlabListener) {
        boolean bl3 = true;
        boolean bl4 = true;
        if (WorkspaceCommands.isFileReadOnly(file)) {
            int n2 = WorkspaceCommands.handleSaveReadOnly(file, frame);
            if (n2 == 2) {
                bl3 = false;
            }
            if (n2 == 3) {
                bl3 = false;
                bl4 = false;
            }
        } else {
            bl3 = false;
            bl4 = true;
        }
        if (!bl4) {
            return;
        }
        if (!bl3) {
            if (saveWorker == null) {
                WorkspaceCommands.startWaitOperation(frame, file);
                if (!Matlab.isMatlabAvailable()) {
                    return;
                }
                saveWorker = new SaveWorker(file, n, string, bl, stringArray, frame, bl2, matlabListener);
            }
            saveWorker.start();
        } else {
            WorkspaceCommands.saveVariables(stringArray, null, frame, false, matlabListener);
        }
    }

    private static String[] normalizeNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2;
            String string = stringArray[i];
            int n3 = string.indexOf(46);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if ((n2 = string.indexOf(123)) != -1) {
                string = string.substring(0, n2);
            }
            if ((n = string.indexOf(40)) != -1) {
                string = string.substring(0, n);
            }
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    private static boolean varNameNormalizationAllowed(Frame frame, String[] stringArray) {
        String string = stringArray == null || stringArray.length > 1 ? WorkspaceResources.getResource("error.save.field.question.plural") : WorkspaceResources.getResource("error.save.field.question.singular");
        return MJOptionPane.showConfirmDialog((Component)frame, (Object)(WorkspaceResources.getResource("error.save.field.description") + "\n\n" + string), (String)WorkspaceResources.getResource("error.save.field.title"), (int)0) == 0;
    }

    private static boolean areVariableNamesOK(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (String string : stringArray) {
            if (string.indexOf(46) == -1 && string.indexOf(123) == -1 && string.indexOf(40) == -1) continue;
            return false;
        }
        return true;
    }

    public static void loadData() {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("uiload;");
    }

    public static void importDataFromClipboard() {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("uiimport('-pastespecial');");
    }

    public static void pasteDataFromClipboard() {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String[] stringArray = WorkspaceCommands.getCommaSeparatedListFromSimpleVariableListOnMJClipboard().split(", ");
        Object[] objectArray = new Object[]{WhichCall.pasteworkspacevariables, stringArray, stringArray};
        int[] nArray = new int[]{2};
        SerializingMatlabWorker.callSerializedWorker(objectArray, nArray);
    }

    public static String getCommaSeparatedListFromSimpleVariableListOnMJClipboard() {
        if (!Matlab.isMatlabAvailable()) {
            return "";
        }
        if (MJClipboard.getMJClipboard().isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) || MJClipboard.getMJClipboard().isDataFlavorAvailable(MLDataFlavor.serializedVariableListFlavor)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = ", ";
            try {
                SimpleVariableDefinition[] simpleVariableDefinitionArray = MJClipboard.getMJClipboard().isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) ? MLDataFlavor.decodeSimpleVariableListFlavor((Transferable)MJClipboard.getMJClipboard().getContents(null)) : MLDataFlavor.decodeSerializedVariableListFlavor((Transferable)MJClipboard.getMJClipboard().getContents(null));
                for (SimpleVariableDefinition simpleVariableDefinition : simpleVariableDefinitionArray) {
                    stringBuilder.append(simpleVariableDefinition.getVariable());
                    stringBuilder.append(string);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Log.log((String)unsupportedFlavorException.toString());
            }
            catch (IOException iOException) {
                Log.log((String)iOException.toString());
            }
            int n = stringBuilder.lastIndexOf(string);
            if (n > 0) {
                return stringBuilder.toString().substring(0, n);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static void importData() {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("uiimport;");
    }

    public static void importData(File file) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string = file.getAbsolutePath();
        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("uiimport('" + StringUtils.quoteSingleQuotes((String)string) + "');");
    }

    private static Map<File, List<MATFileVariableReference>> mapByFile(MATFileVariableReference[] mATFileVariableReferenceArray) {
        HashMap<File, List<MATFileVariableReference>> hashMap = new HashMap<File, List<MATFileVariableReference>>();
        for (MATFileVariableReference mATFileVariableReference : mATFileVariableReferenceArray) {
            Vector<MATFileVariableReference> vector = (Vector<MATFileVariableReference>)hashMap.get(mATFileVariableReference.getFile());
            if (vector == null) {
                vector = new Vector<MATFileVariableReference>();
                hashMap.put(mATFileVariableReference.getFile(), vector);
            }
            vector.add(mATFileVariableReference);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importDataMat(MATFileVariableReference[] mATFileVariableReferenceArray) {
        Map<File, List<MATFileVariableReference>> map = WorkspaceCommands.mapByFile(mATFileVariableReferenceArray);
        for (Map.Entry<File, List<MATFileVariableReference>> entry : map.entrySet()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                printWriter.printf("load('%s'", WorkspaceCommands.getFileToLoad(entry.getKey()));
                for (MATFileVariableReference mATFileVariableReference : entry.getValue()) {
                    printWriter.printf(", '%s'", StringUtils.quoteSingleQuotes((String)mATFileVariableReference.getVariableName()));
                }
                printWriter.printf(")", new Object[0]);
            }
            catch (IllegalFormatException illegalFormatException) {
                System.out.println(illegalFormatException);
            }
            finally {
                printWriter.close();
                MLExecuteServices.executeCommand((String)stringWriter.toString());
            }
        }
    }

    public static void importDataMat(File file) {
        if (MLFileUtils.isMatFile((String)file.getAbsolutePath())) {
            MLExecuteServices.executeCommand((String)("load('" + WorkspaceCommands.getFileToLoad(file) + "')"));
        } else {
            WorkspaceCommands.importData(file);
        }
    }

    public static void importDataMat(File file, String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(", '");
            stringBuilder.append(StringUtils.quoteSingleQuotes((String)string));
            stringBuilder.append('\'');
        }
        MLExecuteServices.executeCommand((String)("load('" + WorkspaceCommands.getFileToLoad(file) + "'" + stringBuilder + ")"));
    }

    private static String getFileToLoad(File file) {
        String string = MatlabPath.getCurrentDirectory().equals(file.getParentFile()) ? file.getName() : file.getAbsolutePath();
        return StringUtils.quoteSingleQuotes((String)string);
    }

    public static boolean importVariablesFromDropEvent(Component component, DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (dropTargetDropEvent.isDataFlavorSupported(MLDataFlavor.matReferenceListFlavor)) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                MATFileVariableReference[] mATFileVariableReferenceArray = MLDataFlavor.decodeMatReferenceListFlavor((Transferable)transferable);
                dropTargetDropEvent.acceptDrop(1);
                if (MATFileUtils.confirmOverwriteWorkspaceIfNecessary(component, mATFileVariableReferenceArray)) {
                    WorkspaceCommands.importDataMat(mATFileVariableReferenceArray);
                }
                dropTargetDropEvent.dropComplete(true);
                return true;
            }
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.logException((Exception)unsupportedFlavorException);
        }
        return false;
    }

    public static void importDataWithDialog(final Action action) {
        action.setEnabled(false);
        MatlabWorker<Boolean> matlabWorker = new MatlabWorker<Boolean>(){

            public Boolean runOnMatlabThread() {
                try {
                    Matlab.mtFeval((String)"uiimport", (Object[])new Object[]{"-file"}, (int)0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }

            public void runOnAWTEventDispatchThread(Boolean bl) {
                action.setEnabled(true);
            }
        };
        if (Matlab.isMatlabAvailable()) {
            matlabWorker.start();
        } else {
            try {
                matlabWorker.runOnAWTEventDispatchThread(matlabWorker.runOnMatlabThread());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void openVariable(String string) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().evalNoOutput("openvar('" + string + "', " + string + ");");
    }

    public static void openVariables(String[] stringArray) {
        for (String string : stringArray) {
            WorkspaceCommands.openVariable(string);
        }
    }

    public static void openVariable(WorkspaceVariable workspaceVariable) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        MLArrayEditorServices.openVariableLater((WorkspaceVariable)workspaceVariable);
    }

    public static void openVariables(WorkspaceVariable[] workspaceVariableArray) {
        for (WorkspaceVariable workspaceVariable : workspaceVariableArray) {
            WorkspaceCommands.openVariable(workspaceVariable);
        }
    }

    public static void renameVariable(String string, String string2, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string3 = ";";
        if (!string.equals(string2)) {
            string3 = string2 + " = " + string + "; builtin('clear', '" + string + "');";
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(string3, (CompletionObserver)new RenameCompletionObserver(completionObserver, string, string2));
    }

    public static void renameField(WorkspaceVariable workspaceVariable, String string, String string2, CompletionObserver completionObserver) {
        if (workspaceVariable.getWorkspaceID() == 0) {
            WorkspaceCommands.renameField(workspaceVariable.getVariableName(), string, string2, completionObserver);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (!string.equals(string2)) {
            WorkspaceMCRProvider.getMCRForUserActions().feval("workspacefunc", new Object[]{"renamefield", workspaceVariable, string, string2}, completionObserver);
        } else {
            WorkspaceMCRProvider.getMCRForUserActions().eval(";", completionObserver);
        }
    }

    public static void renameField(String string, String string2, String string3, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string4 = ";";
        if (!string2.equals(string3)) {
            string4 = string + " = " + ARRAYVIEWFUNC_START + "'renamefield', " + string + ", '" + string2 + "', '" + string3 + '\'' + ARRAYVIEWFUNC_END;
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(string4, completionObserver);
    }

    public static void duplicateField(String string, String string2, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(string + ".(workspacefunc('getcopyname', '" + string2 + "', fields(" + string + "))) = " + string + '.' + string2 + ';', completionObserver);
    }

    public static void duplicateField(WorkspaceVariable workspaceVariable, String string, CompletionObserver completionObserver) {
        if (workspaceVariable.getWorkspaceID() == 0) {
            WorkspaceCommands.duplicateField(workspaceVariable.getVariableName(), string, completionObserver);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().feval("workspacefunc", new Object[]{"duplicateField", workspaceVariable, string}, completionObserver);
    }

    public static void duplicateFieldNamesIntoKeys(String string, String[] stringArray, WorkspaceUndoManager.UndoKey[] undoKeyArray, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(WorkspaceCommands.getStoreValueIntoKeyCommand(string, stringArray[i], undoKeyArray[i]));
        }
        stringBuilder.append(WorkspaceCommands.getDuplicateFieldsCommand(string, stringArray));
        WorkspaceMCRProvider.getMCRForUserActions().eval(stringBuilder.toString(), completionObserver);
    }

    private static String getStoreValueIntoKeyCommand(String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
        return "arrayviewfunc('storeValue', " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ", " + "workspacefunc('getcopyname', '" + string2 + "', fields(" + string + "))); ";
    }

    private static String getDuplicateFieldsCommand(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string).append(" = arrayviewfunc('doMultiFieldAutoCopy', ").append(string).append(", {");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append('\'').append(stringArray[i]).append('\'').append(',');
        }
        stringBuilder.append('\'').append(stringArray[stringArray.length - 1]).append('\'').append("});");
        return stringBuilder.toString();
    }

    public static void createUniqueField(WorkspaceVariable workspaceVariable, String string) {
        if (!Matlab.isMatlabAvailable() || workspaceVariable == null) {
            return;
        }
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", new Object[]{"createUniqueField", workspaceVariable, string == null ? "" : string}, null);
    }

    public static void createUniqueFieldNameIntoKey(String string, String string2, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval("arrayviewfunc('storeValue', " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ", workspacefunc('getnewname', fields(" + string + "))" + ARRAYVIEWFUNC_END + string + ".(workspacefunc('getnewname', fields(" + string + "))) = " + string2 + ';', completionObserver);
    }

    public static void rmField(WorkspaceVariable workspaceVariable, String string) {
        if (workspaceVariable.getWorkspaceID() == 0) {
            WorkspaceCommands.rmField(workspaceVariable.getVariableName(), string, null);
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", new Object[]{"rmfield", workspaceVariable, string}, null);
    }

    public static void rmField(String string, String string2, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(WorkspaceCommands.getRmFieldsCommand(string, new String[]{string2}), completionObserver);
    }

    public static void rmFieldValuesIntoKeys(String string, String[] stringArray, WorkspaceUndoManager.UndoKey[] undoKeyArray, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray.length != undoKeyArray.length) {
            throw new IllegalArgumentException("Number of fields (" + stringArray.length + ") does not equal number of keys(" + undoKeyArray.length + ").");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(WorkspaceCommands.getStoreCommand(string, stringArray[i], undoKeyArray[i]));
        }
        stringBuilder.append(WorkspaceCommands.getRmFieldsCommand(string, stringArray));
        WorkspaceMCRProvider.getMCRForUserActions().eval(stringBuilder.toString(), completionObserver);
    }

    private static String getStoreCommand(String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
        return "arrayviewfunc('storeValue', " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ", " + string + '.' + string2 + ARRAYVIEWFUNC_END;
    }

    private static String getRmFieldsCommand(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string).append(" = rmfield(").append(string).append(", {");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append('\'').append(stringArray[i]).append('\'').append(',');
        }
        stringBuilder.append('\'').append(stringArray[stringArray.length - 1]).append('\'').append("});");
        return stringBuilder.toString();
    }

    public static void rmFieldNamesFromKeys(String string, WorkspaceUndoManager.UndoKey[] undoKeyArray, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" = rmfield(").append(string).append(", {");
        for (int i = 0; i < undoKeyArray.length - 1; ++i) {
            stringBuilder.append(ARRAYVIEWFUNC_START).append(RETRIEVE_AND_CLEAR_VALUE).append(", ").append(WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKeyArray[i])).append(ARRAYVIEWFUNC_END).append(',');
        }
        stringBuilder.append(ARRAYVIEWFUNC_START).append(RETRIEVE_AND_CLEAR_VALUE).append(", ").append(WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKeyArray[undoKeyArray.length - 1])).append(ARRAYVIEWFUNC_END).append("});");
        WorkspaceMCRProvider.getMCRForUserActions().eval(stringBuilder.toString(), completionObserver);
    }

    public static void assignVariable(WorkspaceVariable workspaceVariable, String string, CompletionObserver completionObserver) {
        if (workspaceVariable.getWorkspaceID() == 0) {
            WorkspaceCommands.assignVariable(workspaceVariable.getVariableName(), string, completionObserver);
            return;
        }
        if (string != null && !string.isEmpty()) {
            WorkspaceMCRProvider.getMCRForUserActions().feval("workspacefunc", new Object[]{"assignVariable", workspaceVariable, string}, ArrayDialog.getErrorDialogCompletionObserver(completionObserver, true));
        } else {
            WorkspaceMCRProvider.getMCRForUserActions().eval(";", completionObserver);
        }
    }

    public static void assignVariable(String string, String string2, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string3 = ";";
        if (string2 != null && !string2.isEmpty()) {
            string3 = string + " = " + string2 + ';';
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(string3, completionObserver);
    }

    public static void reassignVariableValueIntoKey(String string, String string2, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string3 = ";";
        if (string2 != null && !string2.isEmpty()) {
            string3 = "arrayviewfunc('storeValue', " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ", " + string + ARRAYVIEWFUNC_END + string + " = " + string2 + ';';
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(string3, completionObserver);
    }

    public static void reassignVariableValueIntoKeyFromKey(String string, WorkspaceUndoManager.UndoKey undoKey, WorkspaceUndoManager.UndoKey undoKey2, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string2 = "arrayviewfunc('storeValue', " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey2) + ", " + string + ARRAYVIEWFUNC_END + string + " = " + ARRAYVIEWFUNC_START + RETRIEVE_AND_CLEAR_VALUE + ", " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ARRAYVIEWFUNC_END;
        WorkspaceMCRProvider.getMCRForUserActions().eval(string2, completionObserver);
    }

    public static void createNewValueFromKey(String string, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String string2 = string + " = " + ARRAYVIEWFUNC_START + RETRIEVE_AND_CLEAR_VALUE + ", " + WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKey) + ARRAYVIEWFUNC_END;
        WorkspaceMCRProvider.getMCRForUserActions().eval(string2, completionObserver);
    }

    public static void createNewFieldsFromKeys(String string, String[] stringArray, WorkspaceUndoManager.UndoKey[] undoKeyArray, CompletionObserver completionObserver) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (stringArray.length != undoKeyArray.length) {
            throw new IllegalArgumentException("Number of fields (" + stringArray.length + ") does not equal number of keys(" + undoKeyArray.length + ").");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(string).append('.').append(stringArray[i]).append(" = ").append(ARRAYVIEWFUNC_START).append(RETRIEVE_AND_CLEAR_VALUE).append(", ").append(WorkspaceUndoManager.UndoKey.translateKeyForMatlab(undoKeyArray[i])).append(ARRAYVIEWFUNC_END);
        }
        WorkspaceMCRProvider.getMCRForUserActions().eval(stringBuilder.toString(), completionObserver);
    }

    public static boolean isValidVariableName(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    private static boolean isFileReadOnly(File file) {
        return file.exists() && !file.canWrite();
    }

    private static int handleSaveReadOnly(File file, Frame frame) {
        boolean bl = file.exists();
        Object[] objectArray = new Object[]{file.getAbsolutePath()};
        String string = bl ? WorkspaceResources.getResource("dialog.readonly.message") : WorkspaceResources.getResource("dialog.readonlydir.message");
        String string2 = MessageFormat.format(string, objectArray);
        String string3 = WorkspaceResources.getResource("dialog.save.title");
        int n = bl ? WorkspaceCommands.showReadOnlyOverwrite(frame, string2, string3) : MJOptionPane.showConfirmDialog((Component)frame, (Object)string2, (String)string3, (int)0);
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            if (bl) {
                NativeJava.changeFileAttribute((String)file.getAbsolutePath(), (String)"w");
                return 2;
            }
            return 3;
        }
        return 3;
    }

    private static int showReadOnlyOverwrite(Component component, String string, String string2) {
        return MJOptionPane.showOptionDialog((Component)component, (Object)string, (String)string2, (int)1, (int)2, null, (Object[])new Object[]{"Save", "Overwrite", "Cancel"}, (Object)"Save");
    }

    private static void startWaitOperation(Frame frame, File file) {
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            WorkspaceCommands.startWaitOperationImpl(frame, file);
        } else {
            SwingUtilities.invokeLater(new StartWaitOperator(frame, file));
        }
    }

    private static void startWaitOperationImpl(Frame frame, File file) {
        if (frame != null) {
            GlobalCursor.setWait((Window)frame);
            if (frame instanceof DTFrame) {
                ((DTFrame)frame).setStatusText(WorkspaceResources.getResource("status.saving", file.getAbsolutePath()));
            }
        }
    }

    private static void endWaitOperationImpl(Frame frame) {
        if (frame != null) {
            GlobalCursor.clear((Window)frame);
            if (frame instanceof DTFrame) {
                ((DTFrame)frame).setStatusText(null);
            }
        }
    }

    public static boolean isBuiltinNumericType(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"double", "uint8", "uint16", "uint32", "uint64", "int8", "int16", "int32", "int64", "single"}) {
            if (!string.equals(string2) && !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuiltinType(String string) {
        return WorkspaceCommands.isBuiltinNumericType(string) || WorkspaceCommands.isBuiltinCharType(string) || WorkspaceCommands.isTimeseriesType(string);
    }

    public static boolean isBuiltinCharType(String string) {
        return string.equals("char") || string.startsWith("char ");
    }

    public static boolean isTimeseriesType(String string) {
        return string.equals("timeseries") || string.startsWith("timeseries ");
    }

    public static boolean isDatasetType(String string) {
        return string.equals("dataset") || string.startsWith("dataset ");
    }

    public static boolean isTableType(String string) {
        return string.equals("table");
    }

    public static boolean isCategoricalType(String string) {
        return string.equals("nominal") || string.equals("ordinal") || string.equals("categorical");
    }

    static String getEventNameFromCode(int n) {
        switch (n) {
            case -2147483648: {
                return "WS_SCOPE";
            }
            case 0x40000000: {
                return "WS_ADD";
            }
            case 0x20000000: {
                return "WS_CLEAR";
            }
            case 0x10000000: {
                return "WS_DELETE";
            }
            case 1: {
                return "WS_ARRAY_ALL";
            }
            case 0x8000000: {
                return "WS_ARRAY_CHANGE";
            }
        }
        return "UNKNOWN";
    }

    public static String getContainingVariable(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.indexOf(46);
            int n2 = string.indexOf(123);
            int n3 = string.indexOf(40);
            int n4 = string.length();
            n = n != -1 ? n : n4;
            n2 = n2 != -1 ? n2 : n4;
            n3 = n3 != -1 ? n3 : n4;
            int n5 = Math.min(n2, n);
            n5 = Math.min(n5, n3);
            string2 = string.substring(0, n5);
        }
        return string2;
    }

    public static String getImmediateParentIdentifier(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.lastIndexOf(46);
            int n2 = string.lastIndexOf(123);
            int n3 = Math.max(n2, n);
            if (n3 != -1 && (string2 = string.substring(0, n3)).endsWith(")")) {
                string2 = string2.substring(0, string2.lastIndexOf(40));
            }
        }
        return string2;
    }

    public static List<String> getParentIdentifierHierarchy(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        while (string2 != null) {
            arrayList.add(string2);
            string2 = WorkspaceCommands.getImmediateParentIdentifier(string2);
        }
        return arrayList;
    }

    public static void isParentIdentifierHierarchyReadOnly(List<String> list, MatlabListener matlabListener) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("workspacefunc('areAnyVariablesReadOnly', ");
        StringBuilder stringBuilder2 = new StringBuilder("{");
        StringBuilder stringBuilder3 = new StringBuilder("{");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder2.append(list.get(i));
            stringBuilder3.append('\'').append(list.get(i)).append('\'');
            if (i >= list.size() - 1) continue;
            stringBuilder2.append(',');
            stringBuilder3.append(',');
        }
        stringBuilder2.append('}');
        stringBuilder3.append('}');
        stringBuilder.append((CharSequence)stringBuilder2).append(", ").append((CharSequence)stringBuilder3).append(");");
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", (Object[])new String[]{"exist('" + list.get(list.size() - 1) + "', 'var') && " + stringBuilder}, 1, matlabListener);
    }

    public static void isParentIdentifierHierarchyReadOnly(WorkspaceVariable workspaceVariable, List<String> list, MatlabListener matlabListener) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("workspacefunc", new Object[]{"readonly", workspaceVariable.getWorkspaceID(), workspaceVariable.getVariableName(), stringArray}, 1, matlabListener);
    }

    private static final class ActionLogProcessor
    implements CompletionObserver,
    MatlabListener {
        private CompletionObserver iCO;
        private MatlabListener iListener;
        private String iLocation;
        private Object iSpecifics;

        ActionLogProcessor(CompletionObserver completionObserver, String string, Object object) {
            this.iCO = completionObserver;
            this.iLocation = string;
            this.iSpecifics = object;
        }

        ActionLogProcessor(MatlabListener matlabListener, String string, Object object) {
            this.iListener = matlabListener;
            this.iLocation = string;
            this.iSpecifics = object;
        }

        public void completed(int n, Object object) {
            if (WorkspaceLog.isEnabled() && Matlab.getExecutionStatus((int)n) != 0) {
                String string = object == null ? "Unknown" : object.toString();
                WorkspaceLog.println("WorkspaceCommands failed: " + this.iLocation + " :args: " + this.iSpecifics.toString() + " :error:" + string);
            }
            if (this.iCO != null) {
                this.iCO.completed(n, object);
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            int n = matlabEvent.getStatus();
            Object object = matlabEvent.getResult();
            if (WorkspaceLog.isEnabled() && Matlab.getExecutionStatus((int)n) != 0) {
                String string = object == null ? "Unknown" : object.toString();
                WorkspaceLog.println("WorkspaceCommands failed: " + this.iLocation + " :args: " + this.iSpecifics.toString() + " :error:" + string);
            }
            if (this.iListener != null) {
                this.iListener.matlabEvent(matlabEvent);
            }
        }
    }

    private static class EndWaitOperator
    implements Runnable {
        private Frame iCO;

        private EndWaitOperator(Frame frame) {
            this.iCO = frame;
        }

        @Override
        public void run() {
            WorkspaceCommands.endWaitOperationImpl(this.iCO);
        }
    }

    private static class StartWaitOperator
    implements Runnable {
        private Frame iCO;
        private File iFile;

        StartWaitOperator(Frame frame, File file) {
            this.iCO = frame;
            this.iFile = file;
        }

        @Override
        public void run() {
            WorkspaceCommands.startWaitOperationImpl(this.iCO, this.iFile);
        }
    }

    public static class SaveWorker
    extends MatlabWorker<Object> {
        private File fFile;
        private int fFileFilterIndex;
        private String fFileAction;
        private String fFileExtension;
        private boolean fIgnoreMATFileDeletionWarning;
        private String[] fVarsToSave;
        private Frame fParentFrame;
        private boolean fAppend;
        private MatlabListener fMatlabListener;

        public SaveWorker() {
        }

        SaveWorker(File file, int n, String string, boolean bl, String[] stringArray, Frame frame, boolean bl2, MatlabListener matlabListener) {
            this.fFile = file;
            this.fFileFilterIndex = n;
            this.fFileAction = string;
            this.fFileExtension = null;
            this.fIgnoreMATFileDeletionWarning = bl;
            this.fVarsToSave = stringArray != null ? (String[])stringArray.clone() : null;
            this.fParentFrame = frame;
            this.fAppend = bl2;
            this.fMatlabListener = matlabListener;
        }

        public Object runOnMatlabThread() throws Exception {
            String string = this.fFile.getName();
            String string2 = this.fFile.getAbsolutePath();
            int n = string.lastIndexOf(46);
            int n2 = string.length();
            if (n > 0 && n < n2) {
                this.fFileExtension = string.substring(n + 1, n2);
            } else {
                if (this.fFileFilterIndex == 1) {
                    this.fFileExtension = "mat";
                } else {
                    assert (this.fFileFilterIndex == 2);
                    this.fFileExtension = "m";
                }
                string = string + "." + this.fFileExtension;
                string2 = string2 + "." + this.fFileExtension;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.fVarsToSave != null) {
                if (this.fFileExtension.equalsIgnoreCase("mat")) {
                    for (String string3 : this.fVarsToSave) {
                        stringBuffer.append(", '").append(string3).append('\'');
                    }
                } else if (this.fFileExtension.equalsIgnoreCase("m")) {
                    stringBuffer.append(", {");
                    for (String string4 : this.fVarsToSave) {
                        stringBuffer.append('\'').append(string4).append('\'').append(' ');
                    }
                    stringBuffer.append("}");
                }
            }
            try {
                Object[] objectArray = (Object[])Matlab.mtFeval((String)"lastwarn", null, (int)2);
                Matlab.mtFeval((String)"lastwarn", (Object[])new Object[]{""}, (int)0);
                if (this.fFileExtension.equalsIgnoreCase("mat")) {
                    String string5 = "save(" + (this.fAppend && this.fFile.exists() ? "'-append', " : "") + "'" + StringUtils.quoteSingleQuotes((String)this.fFile.getAbsolutePath()) + '\'' + stringBuffer + ");";
                    Matlab.mtEval((String)string5);
                } else if (this.fFileExtension.equalsIgnoreCase("m")) {
                    StringBuffer stringBuffer2 = new StringBuffer(" ");
                    if (this.fFileAction != null) {
                        stringBuffer2.append(", ").append('\'').append("SaveMode").append('\'').append(", ").append('\'').append(this.fFileAction).append('\'');
                    }
                    String string6 = "matlab.io.saveVariablesToScript('" + StringUtils.quoteSingleQuotes((String)string2) + "'" + stringBuffer + stringBuffer2 + ");";
                    Matlab.mtEval((String)string6);
                }
                Object[] objectArray2 = (Object[])Matlab.mtFeval((String)"lastwarn", null, (int)2);
                Matlab.mtFeval((String)"lastwarn", (Object[])objectArray, (int)2);
                return objectArray2;
            }
            catch (Exception exception) {
                return exception;
            }
        }

        public void runOnAWTEventDispatchThread(Object object) {
            SaveWorker.endWaitOperation(this.fParentFrame);
            if (object instanceof Exception) {
                if (this.fFileExtension != null && this.fFileExtension.equalsIgnoreCase("m")) {
                    Exception exception = (Exception)object;
                    String string = exception.getLocalizedMessage();
                    this.showErrorDialog(string);
                } else {
                    WorkspaceCommands.saveVariablesWithValidFile(this.fVarsToSave, this.fFile, 1, null, false, this.fParentFrame, this.fAppend, this, null);
                }
            } else {
                Object[] objectArray = (Object[])object;
                if (objectArray[0] instanceof String && ((CharSequence)objectArray[0]).length() > 0) {
                    if (this.fVarsToSave != null && this.fVarsToSave.length >= 2 && objectArray.length >= 2 && "MATLAB:save:sizeTooBigForMATFile".equals(objectArray[1])) {
                        this.showWarningDialog(WorkspaceResources.getResource("warn.multvarmsg"));
                    } else if (!this.fIgnoreMATFileDeletionWarning || !objectArray[1].equals("MATLAB:savevars:SaveVarsMATFileCleanup")) {
                        this.showWarningDialog((String)objectArray[0]);
                    }
                }
                if (Matlab.isMatlabAvailable() && this.fFile != null) {
                    MLFileUtils.resetFileType((File)this.fFile);
                }
                if (this.fMatlabListener != null) {
                    this.fMatlabListener.matlabEvent(new MatlabEvent(3, 0, (Object)""));
                }
            }
        }

        private static void endWaitOperation(Frame frame) {
            if (SwingUtilities.isEventDispatchThread()) {
                WorkspaceCommands.endWaitOperationImpl(frame);
            } else {
                SwingUtilities.invokeLater(new EndWaitOperator(frame));
            }
        }

        public void showWarningDialog(String string) {
            MJOptionPane.showMessageDialog((Component)this.fParentFrame, (Object)string, (String)WorkspaceResources.getResource("warn.Title"), (int)2);
        }

        public void showErrorDialog(String string) {
            MJOptionPane.showMessageDialog((Component)this.fParentFrame, (Object)string, (String)WorkspaceResources.getResource("error.Title"), (int)0);
        }
    }

    private static class RenameCompletionObserver
    implements CompletionObserver {
        private CompletionObserver iCompletionObserver;
        private String iOldName;
        private String iNewName;

        private RenameCompletionObserver(CompletionObserver completionObserver, String string, String string2) {
            this.iCompletionObserver = completionObserver;
            this.iOldName = string;
            this.iNewName = string2;
        }

        public void completed(int n, Object object) {
            this.iCompletionObserver.completed(n, object);
            if (Matlab.getExecutionStatus((int)n) != 0) {
                return;
            }
            for (WorkspaceCommandListener workspaceCommandListener : sWorkspaceCommandListeners) {
                workspaceCommandListener.workspaceCommandOccured(new WorkspaceCommandEvent("renameVariable", new Object[]{this.iOldName, this.iNewName}));
            }
            MatlabWorkspaceListener.reportWSChange();
        }
    }

    private static class WaitCursorML
    implements MatlabListener {
        private Cursor iOrigCursor;
        private Component iComponent;

        WaitCursorML(Component component, Cursor cursor) {
            this.iComponent = component;
            this.iOrigCursor = cursor;
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (this.iComponent != null && this.iOrigCursor != null) {
                this.iComponent.setCursor(this.iOrigCursor);
            }
        }
    }

    public static class SerializingMatlabWorker
    extends MatlabWorker<Object> {
        private Object[] fInputsToWorkspacefunc;
        private int[] fInputIndicesWhichRequireUniqueMatlabVariableNames;

        public static void callSerializedWorker(Object[] objectArray) {
            if (!Matlab.isMatlabAvailable()) {
                return;
            }
            SerializingMatlabWorker serializingMatlabWorker = new SerializingMatlabWorker(objectArray);
            serializingMatlabWorker.start();
        }

        public static void callSerializedWorker(Object[] objectArray, int[] nArray) {
            if (!Matlab.isMatlabAvailable()) {
                return;
            }
            SerializingMatlabWorker serializingMatlabWorker = new SerializingMatlabWorker(objectArray, nArray);
            serializingMatlabWorker.start();
        }

        public SerializingMatlabWorker(Object[] objectArray) {
            this.setFields(objectArray, null);
        }

        public SerializingMatlabWorker(Object[] objectArray, int[] nArray) {
            this.setFields(objectArray, nArray);
        }

        private void setFields(Object[] objectArray, int[] nArray) {
            this.fInputsToWorkspacefunc = objectArray;
            this.fInputIndicesWhichRequireUniqueMatlabVariableNames = nArray;
        }

        public Object runOnMatlabThread() {
            try {
                Object object = this.fInputsToWorkspacefunc[0];
                if (object instanceof WhichCall) {
                    this.fInputsToWorkspacefunc[0] = object.toString();
                }
                if (this.fInputIndicesWhichRequireUniqueMatlabVariableNames != null) {
                    for (int n : this.fInputIndicesWhichRequireUniqueMatlabVariableNames) {
                        if (n <= 0 || !((object = this.fInputsToWorkspacefunc[n]) instanceof String[])) continue;
                        String[] stringArray = (String[])object;
                        int n2 = stringArray.length;
                        String[] stringArray2 = new String[n2];
                        for (int i = 0; i < n2; ++i) {
                            stringArray2[i] = ArrayUtils.getUniqueMatlabVariableName(stringArray[i], "Copy");
                        }
                        this.fInputsToWorkspacefunc[n] = stringArray2;
                    }
                }
                Matlab.mtFeval((String)"workspacefunc", (Object[])this.fInputsToWorkspacefunc, (int)0);
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }

    public static enum WhichCall {
        copyworkspacevariables,
        pasteworkspacevariables,
        clearstoredworkspacevariables;

    }

    private static class OverwriteOptionHandler {
        private String fSelectedFileAction = null;
        private boolean fIgnoreMATFileDeletionWarning = false;

        OverwriteOptionHandler() {
        }

        private String getSelectedFileAction() {
            return this.fSelectedFileAction;
        }

        private boolean isIgnoreMATFileDeletionWarning() {
            return this.fIgnoreMATFileDeletionWarning;
        }

        private String getSelectedFileNameExtension(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
            String string = mJFileChooserPerPlatform.getSelectedFile().getAbsolutePath();
            int n = string.indexOf(46);
            String string2 = "";
            if (n != -1) {
                string2 = string.substring(n + 1, string.length());
            } else {
                int n2 = mJFileChooserPerPlatform.getFileFilterIndex();
                if (n2 == 1) {
                    string2 = "mat";
                }
                if (n2 == 2) {
                    string2 = "m";
                }
            }
            return string2;
        }

        private String getSelectedFullFileNameWithExtension(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
            String string = mJFileChooserPerPlatform.getSelectedFile().getAbsolutePath();
            int n = string.lastIndexOf(46);
            int n2 = string.length();
            String string2 = "";
            if (n == -1) {
                int n3 = mJFileChooserPerPlatform.getFileFilterIndex();
                if (n3 == 1) {
                    string2 = ".mat";
                } else if (n3 == 2) {
                    string2 = ".m";
                }
                string = string + string2;
            }
            return string;
        }

        private boolean run(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
            String string = this.getSelectedFileNameExtension(mJFileChooserPerPlatform);
            String string2 = this.getSelectedFullFileNameWithExtension(mJFileChooserPerPlatform);
            File file = new File(string2);
            boolean bl = true;
            if (string.equals("m")) {
                if (file.exists()) {
                    MJPanel mJPanel = this.createSaveModeOptionsPanel();
                    int n = MJOptionPane.showConfirmDialog(null, (Object)mJPanel, (String)WorkspaceResources.getResource("dialog.save.OverwriteMFileTitle"), (int)2);
                    if (n == 0) {
                        boolean bl2;
                        this.SetSelectedFileAction(mJPanel);
                        int n2 = string2.indexOf(".");
                        String string3 = string2.substring(0, n2 + 1);
                        string3 = string3 + "mat";
                        File file2 = new File(string3);
                        if (file2.exists() && !(bl2 = this.checkIfCompanionMATFilePresent(file, file2))) {
                            String string4 = file2.getName();
                            bl = this.isExistingMATFileDelete(string2, string4);
                        }
                    }
                } else {
                    int n = string2.indexOf(".");
                    String string5 = string2.substring(0, n + 1);
                    File file3 = new File(string5 = string5 + "mat");
                    if (file3.exists()) {
                        String string6 = file3.getName();
                        bl = this.isExistingMATFileDelete(string2, string6);
                    }
                }
            } else if (string.equals("mat") && file.exists()) {
                int n = string2.indexOf(".");
                String string7 = string2.substring(0, n + 1);
                File file4 = new File(string7 = string7 + "m");
                if (file4.exists() && this.checkIfCompanionMATFilePresent(file4, file)) {
                    String string8 = file.getName();
                    String string9 = file4.getName();
                    MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(1, 1, 4, 6, 196608, (Object)0, null));
                    Object[] objectArray = new Object[]{string8, string9};
                    String string10 = MessageFormat.format(WorkspaceResources.getResource("dialog.save.warnMFileLoadFail"), objectArray);
                    int n3 = MJOptionPane.showConfirmDialog(null, (Object)string10, (String)WorkspaceResources.getResource("dialog.save.overwriteMATFileTitle"), (int)0);
                    bl = n3 == 0;
                }
            }
            return bl;
        }

        private MJPanel createSaveModeOptionsPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(3, 1, 4, 6, 196608, (Object)0, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            MJRadioButton mJRadioButton = this.createOverWriteButton(5, 6, buttonGroup);
            MJRadioButton mJRadioButton2 = this.createAppendButton(5, 6, buttonGroup);
            MJRadioButton mJRadioButton3 = this.createUpdateButton(5, 6, buttonGroup);
            mJPanel.add((Component)mJRadioButton);
            mJPanel.add((Component)mJRadioButton2);
            mJPanel.add((Component)mJRadioButton3);
            return mJPanel;
        }

        private MJRadioButton createOverWriteButton(int n, int n2, ButtonGroup buttonGroup) {
            MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceResources.getResource("dialog.save.overwrite"));
            mJRadioButton.setName("OverWriteFile");
            mJRadioButton.setSelected(true);
            buttonGroup.add((AbstractButton)mJRadioButton);
            return mJRadioButton;
        }

        private MJRadioButton createAppendButton(int n, int n2, ButtonGroup buttonGroup) {
            MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceResources.getResource("dialog.save.append"));
            mJRadioButton.setName("AppendFile");
            buttonGroup.add((AbstractButton)mJRadioButton);
            return mJRadioButton;
        }

        private MJRadioButton createUpdateButton(int n, int n2, ButtonGroup buttonGroup) {
            MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceResources.getResource("dialog.save.update"));
            mJRadioButton.setName("UpdateFile");
            buttonGroup.add((AbstractButton)mJRadioButton);
            return mJRadioButton;
        }

        private void SetSelectedFileAction(MJPanel mJPanel) {
            Component[] componentArray = mJPanel.getComponents();
            block5: for (int i = 0; i < componentArray.length && null == this.fSelectedFileAction; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof MJRadioButton) || !((MJRadioButton)component).isSelected()) continue;
                switch (i) {
                    case 0: {
                        this.fSelectedFileAction = "Create";
                        continue block5;
                    }
                    case 1: {
                        this.fSelectedFileAction = "Append";
                        continue block5;
                    }
                    case 2: {
                        this.fSelectedFileAction = "Update";
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkIfCompanionMATFilePresent(File file, File file2) {
            boolean bl = false;
            String string = file2.getName();
            String string2 = "saveVarsMat = load('" + string + "'" + ");";
            BufferedReader bufferedReader = null;
            try {
                String string3;
                String string4 = file.getAbsolutePath();
                FileInputStream fileInputStream = new FileInputStream(string4);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                int n = 10;
                for (int i = 0; (string3 = bufferedReader.readLine()) != null && i < n; ++i) {
                    if (!string3.equals(string2)) continue;
                    bl = true;
                    break;
                }
                boolean bl2 = bl;
                return bl2;
            }
            catch (Exception exception) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return bl;
        }

        private boolean isExistingMATFileDelete(String string, String string2) {
            MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(1, 1, 4, 6, 196608, (Object)0, null));
            Object[] objectArray = new Object[]{string, string2};
            String string3 = MessageFormat.format(WorkspaceResources.getResource("dialog.save.warnOverwriteMATFile"), objectArray);
            int n = MJOptionPane.showConfirmDialog(null, (Object)string3, (String)WorkspaceResources.getResource("dialog.save.overwriteMATFileTitle"), (int)0);
            if (n == 0) {
                this.fSelectedFileAction = "Create";
                this.fIgnoreMATFileDeletionWarning = true;
                return true;
            }
            return false;
        }
    }

    private static class ExistenceCheckerML
    implements MatlabListener {
        private String[] iVars;
        private MatlabListener iBaseListener;

        ExistenceCheckerML(String[] stringArray, MatlabListener matlabListener) {
            this.iVars = stringArray != null ? (String[])stringArray.clone() : null;
            this.iBaseListener = matlabListener;
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0) {
                boolean[] blArray = (boolean[])matlabEvent.getResult();
                if (blArray[0]) {
                    WorkspaceCommands.getVariableAbstractSummariesBody(this.iVars, this.iBaseListener);
                } else {
                    this.iBaseListener.matlabEvent(new MatlabEvent(matlabEvent.getEventType(), matlabEvent.getStatus(), sNonExistentVariableProxy));
                }
            }
        }
    }
}

