/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmImpl;
import com.mathworks.mvm.MvmTerminatedException;
import com.mathworks.mvm.MvmWrapper;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MatlabIIP;
import com.mathworks.mvm.exec.MatlabRequest;
import com.mathworks.mvm.exec.NativeFutureResult;
import com.mathworks.util.ShutdownRuntimeException;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MatlabExecutor
extends AbstractExecutorService {
    private final MVM fMvm;

    public MatlabExecutor(MvmWrapper mvmWrapper) {
        this.fMvm = mvmWrapper.get();
    }

    public <V> FutureResult<V> submit(MatlabRequest<V> matlabRequest) throws RejectedExecutionException, ShutdownRuntimeException {
        NativeFutureResult<V> nativeFutureResult = this.nativeSubmitIIP(this.fMvm.getHandle(), matlabRequest.createIIP());
        if (nativeFutureResult == null) {
            if (this.fMvm.isTerminated()) {
                MvmTerminatedException mvmTerminatedException = new MvmTerminatedException();
                throw new RejectedExecutionException(mvmTerminatedException.getMessage(), mvmTerminatedException);
            }
            throw new RejectedExecutionException();
        }
        return matlabRequest.createFutureResult(nativeFutureResult);
    }

    public <V> FutureFevalResult<V> submit(MatlabFevalRequest<V> matlabFevalRequest) throws RejectedExecutionException {
        return (FutureFevalResult)this.submit((MatlabRequest<V>)matlabFevalRequest);
    }

    public FutureEvalResult submit(MatlabEvalRequest matlabEvalRequest) throws RejectedExecutionException {
        return (FutureEvalResult)this.submit((MatlabRequest)matlabEvalRequest);
    }

    private native <V> NativeFutureResult<V> nativeSubmitIIP(long var1, MatlabIIP var3);

    @Override
    public void execute(@NotNull Runnable runnable) {
        throw new RejectedExecutionException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean awaitTermination(long l, @NotNull TimeUnit timeUnit) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        throw new RejectedExecutionException();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        throw new RejectedExecutionException();
    }

    static {
        MvmImpl.loadLibrary();
    }
}

