/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jini.activation.ActivatableInvocationHandler;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;

public final class ActivationExporter
implements Exporter {
    private final ActivationID id;
    private final Exporter underlyingExporter;
    private final ClassLoader loader;
    private boolean used = false;
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    static /* synthetic */ Class class$net$jini$security$proxytrust$ProxyTrust;

    public ActivationExporter(ActivationID activationID, Exporter exporter) {
        this(activationID, exporter, null);
    }

    public ActivationExporter(ActivationID activationID, Exporter exporter, ClassLoader classLoader) {
        if (activationID == null || exporter == null) {
            throw new NullPointerException();
        }
        this.id = activationID;
        this.underlyingExporter = exporter;
        this.loader = classLoader;
    }

    public synchronized Remote export(Remote remote) throws ExportException {
        Remote remote2;
        block9: {
            if (this.used) {
                throw new IllegalStateException("object already exported via this exporter");
            }
            if (remote == null) {
                throw new NullPointerException("impl is null");
            }
            Remote remote3 = this.underlyingExporter.export(remote);
            this.used = true;
            boolean bl = false;
            try {
                Object object;
                ClassLoader classLoader;
                Class<?> clazz = remote3.getClass();
                if (this.loader != null) {
                    classLoader = this.loader;
                } else {
                    object = System.getSecurityManager();
                    if (object != null) {
                        ((SecurityManager)object).checkPermission(getClassLoaderPermission);
                    }
                    classLoader = clazz.getClassLoader();
                }
                object = new LinkedHashSet();
                boolean bl2 = remote3 instanceof RemoteMethodControl;
                boolean bl3 = !Modifier.isPublic(clazz.getModifiers());
                ActivationExporter.getSuperinterfaces((Set)object, clazz, bl2, bl3);
                Class[] classArray = object.toArray(new Class[object.size()]);
                ActivatableInvocationHandler activatableInvocationHandler = new ActivatableInvocationHandler(this.id, remote3);
                Remote remote4 = (Remote)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)activatableInvocationHandler);
                bl = true;
                remote2 = remote4;
                Object var14_14 = null;
                if (bl) break block9;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    throw new ExportException("proxy creation failed", illegalArgumentException);
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var14_15 = null;
                        if (bl) break block10;
                        this.unexport(true);
                    }
                    throw throwable;
                }
            }
            this.unexport(true);
        }
        return remote2;
    }

    public synchronized boolean unexport(boolean bl) {
        if (!this.used) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        return this.underlyingExporter.unexport(bl);
    }

    private static void getSuperinterfaces(Set set, Class clazz, boolean bl, boolean bl2) throws ExportException {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ActivationExporter.getSuperinterfaces(set, clazz2, bl, bl2);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz3 = classArray[i];
            if (bl2 && !Modifier.isPublic(clazz3.getModifiers())) {
                throw new ExportException("proxy implements non-public interface");
            }
            if (bl && clazz3 == (class$net$jini$security$proxytrust$ProxyTrust == null ? ActivationExporter.class$("net.jini.security.proxytrust.ProxyTrust") : class$net$jini$security$proxytrust$ProxyTrust)) continue;
            set.add(clazz3);
        }
    }
}

