/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.io.Serializable;
import java.net.Socket;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.AuthenticationPermission;

class ClientAuthManager
extends AuthManager {
    private static final Logger logger = clientLogger;
    private X509Certificate serverCredential;
    private X500Principal serverPrincipal;
    private X500PrivateCredential clientCredential;
    private X500Principal clientPrincipal;
    private Exception clientCredentialException;
    private long credentialsValidUntil = 0L;
    private AuthenticationPermission authenticationPermission;

    ClientAuthManager(Subject subject, Set set, Set set2) throws NoSuchAlgorithmException {
        super(subject, set, set2);
    }

    synchronized boolean getClientAuthenticated() {
        return this.clientCredential != null;
    }

    synchronized Exception getClientCredentialException() {
        return this.clientCredentialException;
    }

    synchronized void checkAuthentication() throws UnsupportedConstraintException {
        if (this.clientCredential == null) {
            throw new UnsupportedConstraintException("Client is not authenticated");
        }
        if (this.clientCredential.isDestroyed()) {
            throw new UnsupportedConstraintException("Private credentials are destroyed");
        }
        if (System.currentTimeMillis() > this.credentialsValidUntil) {
            throw new UnsupportedConstraintException("Certificates are no longer valid");
        }
        if (this.subjectIsReadOnly) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(this.authenticationPermission);
            }
        } else {
            X509Certificate x509Certificate;
            Subject subject = this.getSubject();
            if (SubjectCredentials.getPrincipal(subject, x509Certificate = this.clientCredential.getCertificate()) == null) {
                throw new UnsupportedConstraintException("Missing principal");
            }
            CertPath certPath = SubjectCredentials.getCertificateChain(subject, x509Certificate);
            if (certPath == null) {
                throw new UnsupportedConstraintException("Missing public credentials");
            }
            X500PrivateCredential x500PrivateCredential = this.getPrivateCredential(x509Certificate, this.authenticationPermission);
            if (x500PrivateCredential == null) {
                throw new UnsupportedConstraintException("Missing private credentials");
            }
            if (!this.equalPrivateCredentials(this.clientCredential, x500PrivateCredential)) {
                throw new UnsupportedConstraintException("Wrong private credentials");
            }
        }
    }

    synchronized X500PrivateCredential getPrivateCredential(X509Certificate x509Certificate) {
        return this.getPrivateCredential(x509Certificate, this.getAuthenticationPermission(x509Certificate));
    }

    private X500PrivateCredential getPrivateCredential(X509Certificate x509Certificate, AuthenticationPermission authenticationPermission) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(authenticationPermission);
        }
        return (X500PrivateCredential)AccessController.doPrivileged(new SubjectCredentials.GetPrivateCredentialAction(subject, x509Certificate));
    }

    Logger getLogger() {
        return logger;
    }

    private AuthenticationPermission getAuthenticationPermission(X509Certificate x509Certificate) {
        Set<X500Principal> set = Collections.singleton(x509Certificate.getSubjectX500Principal());
        Set<X500Principal> set2 = this.serverPrincipal == null ? null : Collections.singleton(this.serverPrincipal);
        return new AuthenticationPermission(set, set2, "connect");
    }

    synchronized X500Principal getServerPrincipal() {
        return this.serverPrincipal;
    }

    synchronized X500Principal getClientPrincipal() {
        return this.clientPrincipal;
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        super.checkServerTrusted(x509CertificateArray, string);
        if (this.serverPrincipal == null) {
            this.serverCredential = x509CertificateArray[0];
            this.serverPrincipal = this.serverCredential.getSubjectX500Principal();
            this.setPermittedRemotePrincipals(Collections.singleton(this.serverPrincipal));
            this.credentialsValidUntil = ClientAuthManager.certificatesValidUntil(x509CertificateArray);
        } else if (!this.serverCredential.equals(x509CertificateArray[0])) {
            throw new CertificateException("Server credentials changed");
        }
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        Object[] objectArray = this.getAliases(string, principalArray);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "get client aliases for key type {0}\nand issuers {1}\nreturns {2}", new Object[]{string, ClientAuthManager.toString(principalArray), ClientAuthManager.toString(objectArray)});
        }
        return objectArray;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return null;
    }

    public synchronized String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        Serializable serializable;
        if (this.clientCredentialException != null) {
            return null;
        }
        if (this.clientCredential == null) {
            Exception exception;
            int n;
            serializable = null;
            for (n = 0; n < stringArray.length; ++n) {
                try {
                    this.clientCredential = this.chooseCredential(stringArray[n], principalArray);
                    if (this.clientCredential == null) continue;
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    exception = generalSecurityException;
                }
                catch (SecurityException securityException) {
                    exception = securityException;
                }
                if (serializable == null) {
                    serializable = new ArrayList();
                }
                serializable.add(exception);
            }
            if (this.clientCredential == null) {
                if (serializable == null) {
                    this.clientCredentialException = new GeneralSecurityException("Credentials not found");
                } else if (serializable.size() == 1) {
                    this.clientCredentialException = (Exception)serializable.get(0);
                } else {
                    n = serializable.size();
                    while (--n >= 0) {
                        exception = (Exception)serializable.get(n);
                        if (exception instanceof SecurityException) continue;
                        this.clientCredentialException = new GeneralSecurityException(serializable.toString());
                        break;
                    }
                    if (this.clientCredentialException == null) {
                        this.clientCredentialException = new SecurityException(serializable.toString());
                    }
                }
                return null;
            }
        }
        serializable = this.clientCredential.getCertificate();
        this.clientPrincipal = ((X509Certificate)serializable).getSubjectX500Principal();
        this.credentialsValidUntil = Math.min(this.credentialsValidUntil, ClientAuthManager.certificatesValidUntil(SubjectCredentials.getCertificateChain(this.getSubject(), (X509Certificate)serializable)));
        this.authenticationPermission = this.getAuthenticationPermission((X509Certificate)serializable);
        String string = SubjectCredentials.getCertificateName(this.clientCredential.getCertificate());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose client alias for key types {0}\nand issuers {1}\nreturns {2}", new Object[]{ClientAuthManager.toString(stringArray), ClientAuthManager.toString(principalArray), string});
        }
        return string;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return null;
    }
}

