/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ClientAuthManager;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

class SslConnection
extends Utilities
implements Connection {
    private static long maxClientSessionDuration;
    private static final Logger logger;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    final CallContext callContext;
    private final SSLContext sslContext;
    final SSLSocketFactory sslSocketFactory;
    private final ClientAuthManager authManager;
    SSLSocket sslSocket;
    private String activeCipherSuite;
    private SSLSession session;
    boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    SslConnection(CallContext callContext, String string, int n, SocketFactory socketFactory) {
        this.serverHost = string;
        this.port = n;
        this.socketFactory = socketFactory;
        if (callContext == null) {
            throw new NullPointerException("Call context cannot be null");
        }
        this.callContext = callContext;
        Utilities.SSLContextInfo sSLContextInfo = SslConnection.getClientSSLContextInfo(callContext);
        this.sslContext = sSLContextInfo.sslContext;
        this.sslSocketFactory = this.sslContext.getSocketFactory();
        this.authManager = (ClientAuthManager)sSLContextInfo.authManager;
    }

    final void establishCallContext() throws IOException {
        Exception exception;
        block12: {
            try {
                this.establishNewSocket();
                if (this.callContext.clientAuthRequired && !this.authManager.getClientAuthenticated()) {
                    Exception exception2 = this.authManager.getClientCredentialException();
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(getSubjectPermission);
                        }
                        catch (SecurityException securityException) {
                            exception2 = null;
                        }
                    }
                    exception = exception2 instanceof SecurityException ? (SecurityException)exception2 : new UnsupportedConstraintException("Client not authenticated", exception2);
                    break block12;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "new connection for {0}\ncreates {1}", new Object[]{this.callContext, this});
                }
                return;
            }
            catch (SSLProtocolException sSLProtocolException) {
                exception = sSLProtocolException;
            }
            catch (SSLException sSLException) {
                exception = new UnsupportedConstraintException(sSLException.getMessage(), sSLException);
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
        }
        if (logger.isLoggable(Levels.FAILED)) {
            SslConnection.logThrow(logger, Levels.FAILED, SslConnection.class, "establishCallContext", "new connection for {0}\nthrows", new Object[]{this.callContext}, exception);
        }
        this.closeSocket();
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (SecurityException)exception;
    }

    private void closeSocket() {
        if (this.sslSocket != null) {
            try {
                this.sslSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sslSocket = null;
            this.session = null;
            this.activeCipherSuite = null;
        }
    }

    void establishNewSocket() throws IOException {
        Socket socket = this.createPlainSocket(this.serverHost, this.port);
        this.sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, this.serverHost, this.port, true);
        this.establishSuites();
    }

    final void establishSuites() throws IOException {
        this.sslSocket.setEnabledCipherSuites(this.callContext.cipherSuites);
        this.sslSocket.startHandshake();
        this.session = this.sslSocket.getSession();
        this.activeCipherSuite = this.session.getCipherSuite();
        this.sslSocket.setEnableSessionCreation(false);
        SslConnection.releaseClientSSLContextInfo(this.callContext, this.sslContext, this.authManager);
    }

    final Socket createPlainSocket(String string, int n) throws IOException {
        int n2;
        Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        long l = this.callContext.connectionTime;
        long l2 = System.currentTimeMillis();
        if (l == -1L) {
            n2 = 0;
        } else {
            if (l < l2) {
                throw new IOException("Connection not made within specified time");
            }
            n2 = l - l2 > Integer.MAX_VALUE ? 0 : (int)(l - l2);
        }
        if (!this.callContext.endpointImpl.disableSocketConnect) {
            socket.connect(new InetSocketAddress(string, n), n2);
        }
        return socket;
    }

    public String toString() {
        String string = this.session == null ? "" : this.session + ", ";
        return SslConnection.getClassName(this) + "[" + string + (this.sslSocket == null ? "???" : Integer.toString(this.sslSocket.getLocalPort())) + "=>" + this.serverHost + ":" + this.port + "]";
    }

    public InputStream getInputStream() throws IOException {
        if (this.sslSocket != null) {
            return this.sslSocket.getInputStream();
        }
        throw new IOException("No socket established");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.sslSocket != null) {
            return this.sslSocket.getOutputStream();
        }
        throw new IOException("No socket established");
    }

    public SocketChannel getChannel() {
        return null;
    }

    public void populateContext(OutboundRequestHandle outboundRequestHandle, Collection collection) {
        CallContext.coerce(outboundRequestHandle, this.callContext.endpoint);
        if (collection == null) {
            throw new NullPointerException("Context cannot be null");
        }
    }

    public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle outboundRequestHandle) {
        CallContext callContext = CallContext.coerce(outboundRequestHandle, this.callContext.endpoint);
        return callContext.getUnfulfilledConstraints();
    }

    public void writeRequestData(OutboundRequestHandle outboundRequestHandle, OutputStream outputStream) {
        CallContext.coerce(outboundRequestHandle, this.callContext.endpoint);
        if (outputStream == null) {
            throw new NullPointerException("Stream cannot be null");
        }
    }

    public IOException readResponseData(OutboundRequestHandle outboundRequestHandle, InputStream inputStream) {
        CallContext.coerce(outboundRequestHandle, this.callContext.endpoint);
        if (inputStream == null) {
            throw new NullPointerException("Stream cannot be null");
        }
        return null;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            logger.log(Level.FINE, "closing {0}", this);
            this.closed = true;
            this.closeSocket();
        }
    }

    final boolean useFor(CallContext callContext) {
        X500Principal x500Principal;
        if (!$assertionsDisabled && !this.callContext.endpoint.equals(callContext.endpoint)) {
            throw new AssertionError();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "try {0}\nwith {1}\nfor {2}", new Object[]{this, this.callContext, callContext});
        }
        if (this.session == null) {
            logger.log(Level.FINEST, "connection {0} is not established", this);
            return false;
        }
        if (this.checkSessionExpired()) {
            logger.log(Level.FINE, "connection {0} session is expired", this);
            return false;
        }
        if (this.callContext.clientSubject != callContext.clientSubject) {
            logger.log(Level.FINEST, "connection has wrong subject");
            return false;
        }
        X500Principal x500Principal2 = this.authManager.getClientPrincipal();
        if (x500Principal2 == null) {
            if (callContext.clientAuthRequired) {
                logger.log(Level.FINEST, "connection has no client authentication");
                return false;
            }
        } else if (callContext.clientPrincipals != null && !callContext.clientPrincipals.contains(x500Principal2)) {
            logger.log(Level.FINEST, "connection has wrong client principal");
            return false;
        }
        if ((x500Principal = this.authManager.getServerPrincipal()) != null && callContext.serverPrincipals != null && !callContext.serverPrincipals.contains(x500Principal)) {
            logger.log(Level.FINEST, "connection has wrong server principal");
            return false;
        }
        String[] stringArray = callContext.cipherSuites;
        int n = SslConnection.position(this.activeCipherSuite, stringArray);
        if (n < 0) {
            logger.log(Level.FINEST, "connection has wrong suite");
            return false;
        }
        String[] stringArray2 = this.callContext.cipherSuites;
        int n2 = SslConnection.position(this.activeCipherSuite, stringArray2);
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError((Object)"Couldn't find connection suite");
        }
        int n3 = n;
        while (--n3 >= 0) {
            String string = stringArray[n3];
            int n4 = SslConnection.position(string, stringArray2);
            if (n4 >= 0 && n4 < n2) continue;
            logger.log(Level.FINEST, "connection did not try all better suites");
            return false;
        }
        if (x500Principal2 != null) {
            Exception exception;
            try {
                this.authManager.checkAuthentication();
                exception = null;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (UnsupportedConstraintException unsupportedConstraintException) {
                exception = unsupportedConstraintException;
            }
            if (exception != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    SslConnection.logThrow(logger, Level.FINEST, SslConnection.class, "useFor", "connection {0} has missing subject credentials", new Object[]{this}, exception);
                }
                return false;
            }
        }
        logger.log(Level.FINEST, "connection OK");
        return true;
    }

    private boolean checkSessionExpired() {
        long l = this.session.getCreationTime();
        long l2 = l + maxClientSessionDuration;
        if (l2 < l) {
            l2 = Long.MAX_VALUE;
        }
        if (l2 <= System.currentTimeMillis()) {
            this.session.invalidate();
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !SslConnection.class.desiredAssertionStatus();
        maxClientSessionDuration = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.ssl.maxClientSessionDuration", 84600000L));
        logger = clientLogger;
    }
}

