/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jrmp;

import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;

public final class JrmpExporter
implements Exporter {
    private static final Logger logger = Logger.getLogger("net.jini.jrmp.JrmpExporter");
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final ActivationID id;
    private WeakReference ref;

    public JrmpExporter() {
        this(0);
    }

    public JrmpExporter(int n) {
        this(n, null, null);
    }

    public JrmpExporter(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
        this.id = null;
    }

    public JrmpExporter(ActivationID activationID, int n) {
        this(activationID, n, null, null);
    }

    public JrmpExporter(ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        if (activationID == null) {
            throw new NullPointerException();
        }
        this.id = activationID;
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public ActivationID getActivationID() {
        return this.id;
    }

    public synchronized Remote export(Remote remote) throws ExportException {
        if (remote == null) {
            throw new NullPointerException();
        }
        if (this.ref != null) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        this.ref = new WeakReference<Remote>(remote);
        try {
            Remote remote2;
            Remote remote3 = remote2 = this.id != null ? Activatable.exportObject((Remote)remote, (ActivationID)this.id, (int)this.port, (RMIClientSocketFactory)this.csf, (RMIServerSocketFactory)this.ssf) : UnicastRemoteObject.exportObject(remote, this.port, this.csf, this.ssf);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{remote, this, remote2});
            }
            return remote2;
        }
        catch (ExportException exportException) {
            throw exportException;
        }
        catch (RemoteException remoteException) {
            throw new ExportException("export failed", remoteException);
        }
    }

    public synchronized boolean unexport(boolean bl) {
        if (this.ref == null) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        Remote remote = (Remote)this.ref.get();
        if (remote == null) {
            return true;
        }
        try {
            boolean bl2;
            boolean bl3 = bl2 = this.id != null ? Activatable.unexportObject((Remote)remote, (boolean)bl) : UnicastRemoteObject.unexportObject(remote, bl);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, bl2});
            }
            return bl2;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return true;
        }
    }

    public String toString() {
        return this.id != null ? "JrmpExporter[" + this.id + "," + this.port + "," + this.csf + "," + this.ssf + "]" : "JrmpExporter[" + this.port + "," + this.csf + "," + this.ssf + "]";
    }
}

