/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.Permission;

public class AccessPermission
extends Permission {
    private static final long serialVersionUID = 7269818741475881138L;
    private transient String iface;
    private transient String method;

    public AccessPermission(String string) {
        super(string);
        this.init(string);
    }

    private void init(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            this.iface = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (!string.equals("*")) {
            this.method = string;
        }
        if (this.iface != null && !AccessPermission.validClass(this.iface)) {
            throw new IllegalArgumentException("invalid interface name");
        }
        if (this.method != null && !AccessPermission.validMethod(this.method)) {
            throw new IllegalArgumentException("invalid method name");
        }
    }

    private static boolean validClass(String string) {
        int n = string.length();
        block0: for (int i = 0; i < n && Character.isJavaIdentifierStart(string.charAt(i)); ++i) {
            while (++i < n) {
                char c = string.charAt(i);
                if (c == '.') continue block0;
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean validMethod(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!(Character.isJavaIdentifierStart(c) || c == '*' && n > 1)) {
            return false;
        }
        if (c != '*' && string.charAt(n - 1) == '*') {
            --n;
        }
        while (--n >= 1) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        AccessPermission accessPermission = (AccessPermission)permission;
        if (this.iface != null && !this.iface.equals(accessPermission.iface)) {
            return false;
        }
        if (this.method == null) {
            return true;
        }
        if (accessPermission.method == null) {
            return false;
        }
        int n = this.method.length() - 1;
        if (this.method.charAt(0) == '*') {
            return accessPermission.method.regionMatches(accessPermission.method.length() - n, this.method, 1, n);
        }
        if (this.method.charAt(n) == '*') {
            return accessPermission.method.regionMatches(0, this.method, 0, n);
        }
        return this.method.equals(accessPermission.method);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.getName().equals(((Permission)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeException runtimeException;
        objectInputStream.defaultReadObject();
        try {
            this.init(this.getName());
            return;
        }
        catch (NullPointerException nullPointerException) {
            runtimeException = nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        InvalidObjectException invalidObjectException = new InvalidObjectException(runtimeException.getMessage());
        invalidObjectException.initCause(runtimeException);
        throw invalidObjectException;
    }
}

