/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.core.http;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.mjs.core.http.GDSResponseHandler;
import java.util.HashMap;
import java.util.Map;

public class ContentTypeBaseHandler
implements GDSResponseHandler {
    private Map<String, GDSResponseHandler> handlers = new HashMap<String, GDSResponseHandler>();

    public void setResponseHandler(String mediaType, GDSResponseHandler handler) {
        this.handlers.put(mediaType, handler);
    }

    public void removeResponseHandler(String mediaType) {
        this.handlers.remove(mediaType);
    }

    @Override
    public Object handleResponse(HttpResponse response) {
        GDSResponseHandler handler = null;
        String contentType = (String)response.getHeaders().get("Content-Type");
        if (contentType != null && !contentType.isEmpty()) {
            handler = this.handlers.get(contentType);
        }
        if (handler == null) {
            handler = this.handlers.get("*/*");
        }
        if (handler == null) {
            throw new MathWorksClientException("No handler set for content type " + contentType);
        }
        return handler.handleResponse(response);
    }
}

