/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.RequestContent;
import com.mathworks.webservices.mjs.exception.IllegalNameException;
import com.mathworks.webservices.mjs.exception.NotLoggedInException;
import com.mathworks.webservices.mjs.exception.OperationAbortedException;
import com.mathworks.webservices.mjs.exception.RequestNotSpecifiedException;
import com.mathworks.webservices.mjs.impl.CloudMJSClientImpl;
import com.mathworks.webservices.mjs.model.ProgressReport;
import com.mathworks.webservices.mjs.model.ProgressReporter;
import com.mathworks.webservices.mjs.model.request.CloudBaseRequest;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public abstract class BaseServiceImpl {
    private static final BitSet allowedCharsInPath = new BitSet(256);
    private final CloudMJSClientImpl cloudMJSClient;

    protected BaseServiceImpl(CloudMJSClientImpl cloudMJSClient) {
        this.cloudMJSClient = cloudMJSClient;
    }

    protected CloudMJSClientImpl getCloudMJSClient() {
        return this.cloudMJSClient;
    }

    protected HttpRequest createHttpRequestWithQueueContext(HttpMethodName httpMethodName, String resourcePath, String resourceName, CloudBaseRequest baseRequest) {
        HttpRequest request = this.createHttpRequest(httpMethodName, resourcePath, resourceName, baseRequest);
        String queueUuid = this.getCloudMJSClient().getQueueUuid();
        if (queueUuid != null) {
            request.addParameter("queueUuid", queueUuid);
        }
        return request;
    }

    protected HttpRequest createHttpRequest(HttpMethodName httpMethodName, String resourcePath, String resourceName, CloudBaseRequest baseRequest) {
        HttpRequest request = new HttpRequest(httpMethodName, this.getCloudMJSClient().getEndpoint(), "/service" + this.createPath(resourcePath, resourceName));
        request.addHeader("x-mw-gds-session-id", this.getCloudMJSClient().getSessionId());
        if (baseRequest != null && baseRequest.getClientString() != null) {
            request.setClientString(baseRequest.getClientString());
        }
        return request;
    }

    protected EntityEnclosingRequest createEntityEnclosingRequest_old(ByteArrayOutputStream outputStream, String resourceName, String operation, CloudBaseRequest baseRequest) {
        String queueUuid;
        byte[] content = outputStream.toByteArray();
        RequestContent requestContent = new RequestContent(content, "application/xml");
        EntityEnclosingRequest request = new EntityEnclosingRequest(HttpMethodName.PUT, this.getCloudMJSClient().getEndpoint(), "/service" + resourceName + operation);
        request.setRequestContent(requestContent);
        request.addHeader("x-mw-gds-session-id", this.getCloudMJSClient().getSessionId());
        if (baseRequest != null && baseRequest.getClientString() != null) {
            request.setClientString(baseRequest.getClientString());
        }
        if ((queueUuid = this.getCloudMJSClient().getQueueUuid()) != null) {
            request.addParameter("queueUuid", queueUuid);
        }
        return request;
    }

    protected EntityEnclosingRequest createEntityEnclosingRequest(ByteArrayOutputStream outputStream, String contentType, String resourcePath, String resourceName, CloudBaseRequest baseRequest) {
        byte[] content = outputStream.toByteArray();
        RequestContent requestContent = new RequestContent(content, contentType);
        return this.createEntityEnclosingRequest(requestContent, resourcePath, resourceName, baseRequest);
    }

    protected EntityEnclosingRequest createEntityEnclosingRequest(InputStream content, String contentType, Long contentLength, String resourcePath, String resourceName, CloudBaseRequest baseRequest) {
        RequestContent requestContent = new RequestContent(content, contentLength.longValue(), contentType);
        return this.createEntityEnclosingRequest(requestContent, resourcePath, resourceName, baseRequest);
    }

    private EntityEnclosingRequest createEntityEnclosingRequest(RequestContent requestContent, String resourcePath, String resourceName, CloudBaseRequest baseRequest) {
        String queueUuid;
        EntityEnclosingRequest request = new EntityEnclosingRequest(HttpMethodName.PUT, this.getCloudMJSClient().getEndpoint(), "/service" + this.createPath(resourcePath, resourceName));
        request.setRequestContent(requestContent);
        request.addHeader("x-mw-gds-session-id", this.getCloudMJSClient().getSessionId());
        if (baseRequest != null && baseRequest.getClientString() != null) {
            request.setClientString(baseRequest.getClientString());
        }
        if ((queueUuid = this.getCloudMJSClient().getQueueUuid()) != null) {
            request.addParameter("queueUuid", queueUuid);
        }
        return request;
    }

    protected void basicValidation(CloudBaseRequest request) throws NotLoggedInException, RequestNotSpecifiedException {
        if (this.isEmpty(this.getCloudMJSClient().getSessionId())) {
            throw new NotLoggedInException();
        }
        if (request == null) {
            throw new RequestNotSpecifiedException();
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    protected <T extends ProgressReport> void reportStatus(ProgressReporter<T> progressReporter, T status, String operationName) {
        if (progressReporter != null) {
            try {
                ProgressReporter.ProgressResponse progressResponse = progressReporter.reportStatus(status);
                if (ProgressReporter.ProgressResponse.ABORT.equals((Object)progressResponse)) {
                    throw new OperationAbortedException(operationName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected <T> List<List<T>> subLists(List<T> originalList, int subListSize) {
        int originalSize = originalList.size();
        ArrayList<List<T>> result = new ArrayList<List<T>>(originalSize / subListSize + 1);
        for (int i = 0; i < originalSize; i += subListSize) {
            result.add(originalList.subList(i, Math.min(originalSize, i + subListSize)));
        }
        return result;
    }

    protected void addCriteriaParam(HttpRequest request, int index, String criteriaName, Number value) {
        if (value != null) {
            this.addCriteriaParam(request, index, criteriaName, value.toString());
        }
    }

    protected void addCriteriaParam(HttpRequest request, int index, String criteriaName, String value) {
        if (!this.isEmpty(value)) {
            String key = "criteria[" + index + "][" + criteriaName + "]";
            request.addParameter(key, value);
        }
    }

    private String createPath(String resourcePath, String resourceName) {
        StringBuilder stringBuilder = new StringBuilder(resourcePath);
        if (!this.isEmpty(resourceName)) {
            this.sanitize(resourceName);
            stringBuilder.append("/").append(this.encodeResource(resourceName));
        }
        return stringBuilder.toString();
    }

    private void sanitize(String resourceName) {
        if (resourceName.contains("/")) {
            throw new IllegalNameException("Resource name should not contain /");
        }
    }

    protected String encodeResource(String resource) throws IllegalNameException {
        try {
            String result = URIUtil.encode((String)resource, (BitSet)allowedCharsInPath);
            return result;
        }
        catch (URIException e) {
            throw new IllegalNameException("Resource name " + resource + " is illegal", e);
        }
    }

    static {
        allowedCharsInPath.or(URI.allowed_within_path);
        allowedCharsInPath.clear(37);
        allowedCharsInPath.set(47);
    }
}

