/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Table;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.PlatformInfo;
import java.awt.Point;
import java.awt.Rectangle;

class TableUtils {
    private static final String[] LETTERS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int TREE_INDENT = 24;

    TableUtils() {
    }

    static void insertSorted(int n, IntBuffer intBuffer, boolean bl) {
        int n2;
        if (bl) {
            for (n2 = 0; n2 < intBuffer.length() && intBuffer.getAt(n2) < n; ++n2) {
            }
        } else {
            while (n2 < intBuffer.length() && intBuffer.getAt(n2) > n) {
                ++n2;
            }
        }
        intBuffer.insert(n2, n);
    }

    static int getTreeIndent() {
        return 24;
    }

    static String buildAutoLabel(int n, int n2) {
        String string = null;
        switch (n) {
            case 1: {
                string = "" + n2;
                break;
            }
            case 2: {
                string = "" + (n2 + 1);
                break;
            }
            case 3: {
                string = TableUtils.buildLetterString(n2);
            }
        }
        return string;
    }

    private static String buildLetterString(int n) {
        String string = null;
        if (n >= 0) {
            int n2 = LETTERS.length;
            int n3 = n;
            string = LETTERS[n % n2];
            while (n3 / n2 > 0) {
                n3 = n3 / n2 - 1;
                string = LETTERS[n3 % n2] + string;
            }
        }
        return string;
    }

    protected static int getLastCol(Table table) {
        int n = 0;
        int n2 = table.getData().getWidth();
        if (n2 > 1) {
            int n3 = table.getContentBounds().width - table.getRowOptions().getHeaderWidth();
            int n4 = 1;
            int n5 = table.getColumnWidth(n2 - n4);
            if (n5 >= n3) {
                n = n2 - 1;
            } else {
                while (n4 <= n2 && n5 + table.getColumnWidth(n2 - n4) < n3) {
                    n5 += table.getColumnWidth(n2 - n4);
                    ++n4;
                }
                n = n2 - n4;
            }
        }
        return n;
    }

    protected static int getLastRow(Table table) {
        int n = 0;
        int n2 = table.getData().getHeight();
        if (n2 > 1) {
            int n3 = table.getContentBounds().height - table.getColumnOptions().getHeaderHeight();
            int n4 = 1;
            int n5 = table.getRowHeight(n2 - n4);
            if (n5 >= n3) {
                n = n2 - 1;
            } else {
                while (n4 <= n2 && n5 + table.getRowHeight(n2 - n4) < n3) {
                    n5 += table.getRowHeight(n2 - n4);
                    ++n4;
                }
                n = n2 - n4;
            }
        }
        return n;
    }

    protected static int getSelectionModifier(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 = 1;
        } else if (PlatformInfo.getAppearance() == 0 && (n & 4) != 0) {
            n2 = 2;
        } else if ((n & 2) != 0) {
            n2 = 2;
        }
        return n2;
    }

    protected static boolean isMac() {
        return PlatformInfo.getAppearance() == 0;
    }

    static boolean arrowKeyNav(Table table, int n, int n2, boolean bl) {
        boolean bl2 = false;
        if (!bl && n2 == 0) {
            int n3;
            int n4;
            bl2 = true;
            Point point = table.getActiveCell();
            switch (n) {
                case 38: {
                    n4 = point.x;
                    n3 = point.y == 0 ? 0 : point.y - 1;
                    break;
                }
                case 40: {
                    n4 = point.x;
                    n3 = point.y == table.getData().getHeight() - 1 ? point.y : point.y + 1;
                    break;
                }
                case 37: {
                    n4 = point.x == 0 ? 0 : point.x - 1;
                    n3 = point.y;
                    break;
                }
                case 39: {
                    n4 = point.x == table.getData().getWidth() - 1 ? point.x : point.x + 1;
                    n3 = point.y;
                    break;
                }
                default: {
                    bl2 = false;
                    n3 = 0;
                    n4 = 0;
                }
            }
            if (bl2) {
                table.commitEditingCell();
                table.select(n3, n4);
            }
        }
        return bl2;
    }

    static boolean navToNextCell(Table table, Rectangle[] rectangleArray, Point point, int n, int n2) {
        Rectangle rectangle = null;
        boolean bl = false;
        int n3 = 0;
        if (rectangleArray == null || point == null) {
            return false;
        }
        if (rectangleArray.length == 1) {
            rectangle = rectangleArray[0];
            if (rectangle.width == 1 && rectangle.height == 1) {
                if (n2 > 0) {
                    return TableUtils.arrowKeyNav(table, 39, 0, false);
                }
                if (n2 < 0) {
                    return TableUtils.arrowKeyNav(table, 37, 0, false);
                }
                if (n > 0) {
                    return TableUtils.arrowKeyNav(table, 40, 0, false);
                }
                if (n < 0) {
                    return TableUtils.arrowKeyNav(table, 38, 0, false);
                }
            }
        } else if (rectangleArray.length > 1) {
            for (n3 = 0; n3 < rectangleArray.length; ++n3) {
                rectangle = rectangleArray[n3];
                if (point.x >= rectangle.x && point.x < rectangle.x + rectangle.width && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height) break;
            }
        }
        if (n3 < rectangleArray.length) {
            if (n2 != 0) {
                if ((n2 += point.x) >= rectangle.x + rectangle.width) {
                    n = point.y + 1;
                    if (n == rectangle.y + rectangle.height) {
                        if (++n3 == rectangleArray.length) {
                            n3 = 0;
                        }
                        rectangle = rectangleArray[n3];
                        n = rectangleArray[n3].y;
                    }
                    n2 = rectangle.x;
                } else if (n2 < rectangle.x) {
                    n = point.y - 1;
                    if (n < rectangle.y) {
                        if (--n3 < 0) {
                            n3 = rectangleArray.length - 1;
                        }
                        rectangle = rectangleArray[n3];
                        n = rectangle.y + rectangle.height - 1;
                    }
                    n2 = rectangle.x + rectangle.width - 1;
                } else {
                    n = point.y;
                }
            } else if ((n += point.y) >= rectangle.y + rectangle.height) {
                n2 = point.x + 1;
                if (n2 == rectangle.x + rectangle.width) {
                    if (++n3 == rectangleArray.length) {
                        n3 = 0;
                    }
                    rectangle = rectangleArray[n3];
                    n2 = rectangle.x;
                }
                n = rectangle.y;
            } else if (n < rectangle.y) {
                n2 = point.x - 1;
                if (n2 < rectangle.x) {
                    if (--n3 < 0) {
                        n3 = rectangleArray.length - 1;
                    }
                    rectangle = rectangleArray[n3];
                    n2 = rectangle.x + rectangle.width - 1;
                }
                n = rectangle.y + rectangle.height - 1;
            } else {
                n2 = point.x;
            }
            if (table.getEditingCell().x == -2 || table.getEditingCell().y == -2) {
                table.repaintCells(point.y, point.x, point.y + 1, point.x + 1);
            }
            point.x = n2;
            point.y = n;
            table.commitEditingCell();
            table.repaintCells(n, n2, n + 1, n2 + 1);
            bl = true;
        }
        return bl;
    }
}

