/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.window;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.window.MWWindowActivater;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class FullWindowRegistry {
    private static Vector sWindows = new Vector();

    public static void register(Frame frame) {
        if (!sWindows.contains(frame)) {
            sWindows.addElement(frame);
        }
    }

    public static void register(Dialog dialog) {
        if (!sWindows.contains(dialog)) {
            sWindows.addElement(dialog);
        }
    }

    public static void unregister(Frame frame) {
        if (sWindows.contains(frame)) {
            sWindows.removeElement(frame);
        }
    }

    public static void unregister(Dialog dialog) {
        if (sWindows.contains(dialog)) {
            sWindows.removeElement(dialog);
        }
    }

    public static Enumeration windows() {
        return sWindows.elements();
    }

    public static void main(String[] stringArray) {
        try {
            MWFrame mWFrame = new MWFrame("FullWindowRegistry");
            MWListbox mWListbox = new MWListbox();
            mWListbox.setPreferredTableSize(12, 2);
            MWPanel mWPanel = new MWPanel();
            MWButton mWButton = new MWButton("Refresh");
            mWButton.addActionListener(new DoIt(mWListbox));
            mWPanel.add(mWButton);
            mWFrame.add((Component)new MWLabel("Windows:"), "North");
            mWFrame.add((Component)mWListbox, "Center");
            mWFrame.add((Component)mWPanel, "South");
            mWFrame.addWindowListener(new MWWindowActivater(null));
            mWFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class DoIt
    implements ActionListener {
        private MWListbox fList;

        public DoIt(MWListbox mWListbox) {
            this.fList = mWListbox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fList.removeAllItems();
            Enumeration enumeration = FullWindowRegistry.windows();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof Frame) {
                    this.fList.addItem("Win: " + ((Frame)e).getTitle());
                    continue;
                }
                if (e instanceof Dialog) {
                    this.fList.addItem("Dlg: " + ((Dialog)e).getTitle());
                    continue;
                }
                this.fList.addItem("Unk");
            }
        }
    }
}

